/*
 * Decompiled with CFR 0.152.
 */
package dynamicReg;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.ClientHelper;
import com.gemstone.gemfire.cache.DynamicRegionFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.util.BridgeWriter;
import com.gemstone.gemfire.distributed.DistributedSystem;
import dynamicReg.DynamicRegionBB;
import dynamicReg.DynamicRegionPrms;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.ConfigPrms;
import hydra.DistributedSystemHelper;
import hydra.Log;
import hydra.PoolHelper;
import hydra.ProcessMgr;
import hydra.RegionDescription;
import hydra.RegionHelper;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.Set;
import tx.OpList;
import tx.Operation;
import util.NameFactory;
import util.RandomValues;
import util.TestException;
import util.TestHelper;
import util.ValueHolder;

public class DynamicRegionTest {
    protected static DynamicRegionTest dynamicRegionTest;

    public static synchronized void HydraTask_initBridgeServer() {
        File d = new File("DynamicRegionData" + ProcessMgr.getProcessId());
        d.mkdirs();
        DynamicRegionFactory.get().open(new DynamicRegionFactory.Config(d, null));
        CacheHelper.createCache("bridge");
        int numRoots = TestConfig.tab().intAt(DynamicRegionPrms.numRootRegions);
        int breadth = TestConfig.tab().intAt(DynamicRegionPrms.numSubRegions);
        int depth = TestConfig.tab().intAt(DynamicRegionPrms.regionDepth);
        for (int i = 0; i < numRoots; ++i) {
            String rootName = "root" + (i + 1);
            Region rootRegion = RegionHelper.createRegion(rootName, "bridge");
            Log.getLogWriter().info("Created root region " + rootName);
            DynamicRegionTest.createSubRegions(rootRegion, breadth, depth, "Region");
        }
        BridgeHelper.startBridgeServer("bridge");
    }

    public static synchronized void HydraTask_initialize() {
        if (dynamicRegionTest == null) {
            dynamicRegionTest = new DynamicRegionTest();
            dynamicRegionTest.initialize();
        }
    }

    protected void initialize() {
        if (CacheHelper.getCache() == null) {
            File d = new File("DynamicRegionData" + RemoteTestModule.MyPid);
            d.mkdirs();
            DistributedSystem ds = DistributedSystemHelper.connect();
            DynamicRegionFactory.Config config = ClientHelper.getDynamicRegionConfig(d, RegionHelper.getRegionDescription("edge"), true, true);
            DynamicRegionFactory.get().open(config);
            Cache myCache = CacheHelper.createCache("edge");
            int numRoots = TestConfig.tab().intAt(DynamicRegionPrms.numRootRegions);
            int breadth = TestConfig.tab().intAt(DynamicRegionPrms.numSubRegions);
            int depth = TestConfig.tab().intAt(DynamicRegionPrms.regionDepth);
            for (int i = 0; i < numRoots; ++i) {
                String rootName = "root" + (i + 1);
                Region rootRegion = RegionHelper.createRegion(rootName, "edge");
                Log.getLogWriter().info("Created root region " + rootName);
                DynamicRegionTest.createSubRegions(rootRegion, breadth, depth, "Region");
            }
        }
    }

    public static synchronized void HydraTask_initializeP2P() {
        if (dynamicRegionTest == null) {
            dynamicRegionTest = new DynamicRegionTest();
            dynamicRegionTest.initializeP2P();
        }
    }

    protected void initializeP2P() {
        if (CacheHelper.getCache() == null) {
            File d = new File("DynamicRegionData" + ProcessMgr.getProcessId());
            d.mkdirs();
            DynamicRegionFactory.get().open(new DynamicRegionFactory.Config(d, null));
            Cache myCache = CacheHelper.createCache("cache");
            int numRoots = TestConfig.tab().intAt(DynamicRegionPrms.numRootRegions);
            int breadth = TestConfig.tab().intAt(DynamicRegionPrms.numSubRegions);
            int depth = TestConfig.tab().intAt(DynamicRegionPrms.regionDepth);
            for (int i = 0; i < numRoots; ++i) {
                String rootName = "root" + (i + 1);
                Region rootRegion = RegionHelper.createRegion(rootName, "region");
                Log.getLogWriter().info("Created root region " + rootName);
                DynamicRegionTest.createSubRegions(rootRegion, breadth, depth, "Region");
            }
        }
    }

    public static void HydraTask_initHctClientCacheWithXml() {
        if (dynamicRegionTest == null) {
            dynamicRegionTest = new DynamicRegionTest();
            DynamicRegionTest.initClientCacheWithXml("edge", "edge");
        }
    }

    public static void HydraTask_initClientCacheWithXml() {
        if (dynamicRegionTest == null) {
            dynamicRegionTest = new DynamicRegionTest();
            DynamicRegionTest.initClientCacheWithXml("cache", "region");
        }
    }

    public static void initClientCacheWithXml(String cacheConfig, String regionConfig) {
        String cacheXmlFile = "clientCache_" + RemoteTestModule.MyPid + ".xml";
        DistributedSystem ds = DistributedSystemHelper.connectWithXml(cacheXmlFile);
        File diskDir = new File("DynamicRegionData" + RemoteTestModule.MyPid);
        diskDir.mkdirs();
        DynamicRegionFactory.Config dynamicRegionConfig = null;
        String poolConfig = ConfigPrms.getPoolConfig();
        if (poolConfig != null) {
            String poolName = PoolHelper.getPoolDescription(ConfigPrms.getPoolConfig()).getName();
            dynamicRegionConfig = new DynamicRegionFactory.Config(diskDir, poolName, true, true);
        } else {
            RegionDescription rd = RegionHelper.getRegionDescription(regionConfig);
            BridgeWriter writer = (BridgeWriter)rd.getCacheWriterInstance(true);
            dynamicRegionConfig = new DynamicRegionFactory.Config(diskDir, writer, true, true);
        }
        CacheHelper.generateCacheXmlFile(cacheConfig, dynamicRegionConfig, regionConfig, null, null, poolConfig, cacheXmlFile);
        CacheHelper.createCacheFromXml(cacheXmlFile);
    }

    private static void createSubRegions(Region r, int numChildren, int levelsLeft, String parentName) {
        for (int i = 1; i <= numChildren; ++i) {
            String currentName = parentName + i;
            Region child = null;
            try {
                child = r.createSubregion(currentName, r.getAttributes());
                Log.getLogWriter().info("Created subregion " + TestHelper.regionToString(child, true));
            }
            catch (RegionExistsException e) {
                child = r.getSubregion(currentName);
                Log.getLogWriter().info("Got subregion " + TestHelper.regionToString(child, true));
            }
            catch (TimeoutException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            if (levelsLeft <= 1) continue;
            DynamicRegionTest.createSubRegions(child, numChildren, levelsLeft - 1, currentName);
        }
    }

    private Region createDynamicRegion(String parentName, String drName) {
        Region dr = null;
        try {
            dr = DynamicRegionFactory.get().createDynamicRegion(parentName, drName);
        }
        catch (CacheException ce) {
            throw new TestException(TestHelper.getStackTrace(ce));
        }
        Log.getLogWriter().info("Created dynamic region " + TestHelper.regionToString(dr, true));
        return dr;
    }

    public static synchronized void HydraTask_putData() {
        dynamicRegionTest.putData();
    }

    protected void putData() {
        int numEntries = TestConfig.tab().intAt(DynamicRegionPrms.maxEntries);
        Region aRegion = this.getRandomRegion(true);
        String drName = aRegion.getName() + "_DYNAMIC";
        Log.getLogWriter().info("### creating dynamic region using parent: " + aRegion.getFullPath());
        Log.getLogWriter().info("### dynamic region name will be: " + drName);
        Log.getLogWriter().info("### randomly selected region name: " + aRegion.getName());
        Log.getLogWriter().info("### randomly selected region path: " + aRegion.getFullPath());
        this.createDynamicRegion(aRegion.getFullPath(), drName);
        Cache myCache = CacheHelper.getCache();
        String drPath = aRegion.getFullPath() + "/" + drName;
        Region dynRegion = myCache.getRegion(drPath);
        Log.getLogWriter().info("### creating dynamic region");
        Log.getLogWriter().info("Region is: " + dynRegion.getFullPath());
        OpList opList = new OpList();
        for (int i = 0; i < numEntries; ++i) {
            String name = NameFactory.getNextPositiveObjectName();
            ValueHolder anObj = new ValueHolder(name, new RandomValues());
            try {
                dynRegion.put((Object)name, (Object)anObj);
                Operation op = new Operation(dynRegion.getFullPath(), name, "entry-create", null, anObj);
                opList.add(op);
                continue;
            }
            catch (Exception e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
        DynamicRegionBB.putSingleOpList(opList);
    }

    protected Region getRandomRegion(boolean allowRootRegion) {
        Set rootRegions = CacheHelper.getCache().rootRegions();
        int randInt = TestConfig.tab().getRandGen().nextInt(0, rootRegions.size() - 1);
        Object[] regionList = rootRegions.toArray();
        Region rootRegion = (Region)regionList[randInt];
        Set subregionsSet = rootRegion.subregions(true);
        if (subregionsSet.size() == 0) {
            if (allowRootRegion) {
                return rootRegion;
            }
            return null;
        }
        ArrayList<Object> aList = null;
        try {
            Object[] array = subregionsSet.toArray();
            aList = new ArrayList<Object>(array.length);
            for (int i = 0; i < array.length; ++i) {
                aList.add(array[i]);
            }
        }
        catch (NoSuchElementException e) {
            throw new TestException("Bug 30171 detected: " + TestHelper.getStackTrace(e));
        }
        if (allowRootRegion) {
            aList.add(rootRegion);
        }
        if (aList.size() == 0) {
            return null;
        }
        randInt = TestConfig.tab().getRandGen().nextInt(0, aList.size() - 1);
        Region aRegion = (Region)aList.get(randInt);
        if (aRegion == null) {
            throw new TestException("Bug 30171 detected: aRegion is null");
        }
        return aRegion;
    }

    public static synchronized void HydraTask_validate() {
        if (dynamicRegionTest == null) {
            dynamicRegionTest = new DynamicRegionTest();
        }
        dynamicRegionTest.validate();
    }

    protected void validate() {
        Log.getLogWriter().info("validating...");
        Cache myCache = CacheHelper.getCache();
        OpList opList = DynamicRegionBB.getSingleOpList();
        Log.getLogWriter().info("In validate opList is: " + opList.toString());
        for (int i = 0; i < opList.numOps() - 1; ++i) {
            Operation op = opList.getOperation(i);
            Log.getLogWriter().info("verifying op: " + op.toString());
            String expectedRegionPath = op.getRegionName();
            Object expectedKey = op.getKey();
            Object expectedValue = op.getNewValue();
            try {
                Region r = myCache.getRegion(expectedRegionPath);
                if (r == null) {
                    throw new TestException("Region: " + expectedRegionPath + " not found");
                }
                Object val = r.get(expectedKey);
                if (val == null) {
                    throw new TestException("Region found but value not found for key " + expectedKey);
                }
                if (val.equals(expectedValue)) continue;
                throw new TestException("Region found but value for key " + expectedKey + "is wrong value: " + val);
            }
            catch (Exception e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
    }
}

