/*
 * Decompiled with CFR 0.152.
 */
package durableClients;

import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import durableClients.DurableClientsBB;
import durableClients.DurableClientsTest;
import hct.EventListener;
import hydra.Log;
import java.util.HashMap;

public class EventListenerExpiration
extends EventListener {
    static Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterCreate(EntryEvent event) {
        super.afterCreate(event);
        DurableClientsTest.lastEventReceivedTime = System.currentTimeMillis();
        String key = (String)event.getKey();
        if (key.equals("last_key")) {
            DurableClientsTest.receivedLastKey = true;
            Log.getLogWriter().info("'last_key' received at client");
        }
        Log.getLogWriter().info("Invoking the durable Listener");
        Long value = (Long)event.getNewValue();
        if (value == null) {
            this.throwException("value in afterCreate cannot be null: key = " + key);
        }
        String VmDurableId = InternalDistributedSystem.getAnyInstance().getConfig().getDurableClientId();
        Object object = lock;
        synchronized (object) {
            boolean isDuplicate = false;
            if (value != 0L) {
                isDuplicate = this.validateIncrementByOne(key, value);
            }
            if (!isDuplicate) {
                HashMap<String, Integer> threadMap;
                HashMap map = (HashMap)DurableClientsBB.getBB().getSharedMap().get(VmDurableId);
                if (!map.containsKey(key)) {
                    Log.getLogWriter().info("Putting thread map into the vm for the vm " + VmDurableId + " key" + key);
                    threadMap = new HashMap<String, Integer>();
                    threadMap.put("EVENT No :", new Integer(0));
                    map.put(key, threadMap);
                }
                threadMap = (HashMap<String, Integer>)map.get(key);
                int eventNo = (Integer)threadMap.get("EVENT No :");
                threadMap.put("EVENT No :", new Integer(++eventNo));
                threadMap.put("EVENT SR. No : " + eventNo, (Integer)event.getNewValue());
                threadMap.put(key, (Integer)((Object)value));
                map.put(key, threadMap);
                DurableClientsBB.getBB().getSharedMap().put(VmDurableId, map);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterUpdate(EntryEvent event) {
        super.afterUpdate(event);
        DurableClientsTest.lastEventReceivedTime = System.currentTimeMillis();
        Log.getLogWriter().info("Invoking the durable Listener");
        String key = (String)event.getKey();
        Long newValue = (Long)event.getNewValue();
        if (newValue == null) {
            this.throwException("newValue in afterUpdate cannot be null: key = " + key);
        }
        String VmDurableId = InternalDistributedSystem.getAnyInstance().getConfig().getDurableClientId();
        Object object = lock;
        synchronized (object) {
            boolean isDuplicate = false;
            if (newValue.intValue() != 0) {
                isDuplicate = this.validateIncrementByOne(key, newValue);
            }
            if (!isDuplicate) {
                HashMap<String, Integer> threadMap;
                HashMap map = (HashMap)DurableClientsBB.getBB().getSharedMap().get(VmDurableId);
                if (!map.containsKey(key)) {
                    Log.getLogWriter().info("Putting thread map into the vm for the vm " + VmDurableId + " key" + key);
                    threadMap = new HashMap<String, Integer>();
                    threadMap.put("EVENT No :", new Integer(0));
                    map.put(key, threadMap);
                }
                threadMap = (HashMap<String, Integer>)map.get(key);
                int eventNo = (Integer)threadMap.get("EVENT No :");
                threadMap.put("EVENT No :", new Integer(++eventNo));
                threadMap.put("EVENT SR. No : " + eventNo, (Integer)event.getNewValue());
                threadMap.put(key, (Integer)((Object)newValue));
                map.put(key, threadMap);
                DurableClientsBB.getBB().getSharedMap().put(VmDurableId, map);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterDestroy(EntryEvent event) {
        super.afterDestroy(event);
        DurableClientsTest.lastEventReceivedTime = System.currentTimeMillis();
        Log.getLogWriter().info("Invoking the durable Listener");
        String key = (String)event.getKey();
        Long value = (Long)event.getOldValue();
        String VmDurableId = InternalDistributedSystem.getAnyInstance().getConfig().getDurableClientId();
        Object object = lock;
        synchronized (object) {
            HashMap<String, Integer> threadMap;
            HashMap map = (HashMap)DurableClientsBB.getBB().getSharedMap().get(VmDurableId);
            if (!map.containsKey(key)) {
                Log.getLogWriter().info("Putting thread map into the vm for the vm " + VmDurableId + " key" + key);
                threadMap = new HashMap<String, Integer>();
                threadMap.put("EVENT No :", new Integer(1));
                map.put(key, threadMap);
            }
            threadMap = (HashMap<String, Integer>)map.get(key);
            int eventNo = (Integer)threadMap.get("EVENT No :");
            threadMap.put("EVENT No :", new Integer(++eventNo));
            threadMap.put("EVENT SR. No : " + eventNo, (Integer)event.getNewValue());
            if (value != null) {
                threadMap.put(key, (Integer)((Object)value));
            }
            map.put(key, threadMap);
            DurableClientsBB.getBB().getSharedMap().put(VmDurableId, map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterInvalidate(EntryEvent event) {
        super.afterInvalidate(event);
        DurableClientsTest.lastEventReceivedTime = System.currentTimeMillis();
        Log.getLogWriter().info("Invoking the durable Listener");
        String key = (String)event.getKey();
        Long oldValue = (Long)event.getOldValue();
        if (oldValue == null) {
            this.throwException("oldValue in afterInvalidate cannot be null : key = " + key);
        }
        String VmDurableId = InternalDistributedSystem.getAnyInstance().getConfig().getDurableClientId();
        Object object = lock;
        synchronized (object) {
            HashMap<String, Integer> threadMap;
            HashMap map = (HashMap)DurableClientsBB.getBB().getSharedMap().get(VmDurableId);
            if (!map.containsKey(key)) {
                Log.getLogWriter().info("Putting thread map into the vm for the vm " + VmDurableId + " for key " + key);
                threadMap = new HashMap<String, Integer>();
                threadMap.put("EVENT No :", new Integer(1));
                map.put(key, threadMap);
            }
            threadMap = (HashMap<String, Integer>)map.get(key);
            int eventNo = (Integer)threadMap.get("EVENT No :");
            threadMap.put("EVENT No :", new Integer(++eventNo));
            threadMap.put("EVENT SR. No : " + eventNo, (Integer)event.getNewValue());
            threadMap.put(key, (Integer)((Object)oldValue));
            map.put(key, threadMap);
            DurableClientsBB.getBB().getSharedMap().put(VmDurableId, map);
        }
    }

    private boolean validateIncrementByOne(String key, Long newValue) {
        boolean isDuplicate = false;
        String VmDurableId = InternalDistributedSystem.getAnyInstance().getConfig().getDurableClientId();
        HashMap map = (HashMap)DurableClientsBB.getBB().getSharedMap().get(VmDurableId);
        HashMap threadMap = (HashMap)map.get(key);
        if (threadMap == null) {
            Log.getLogWriter().info("ThreadMap is null for vm " + VmDurableId + " for key " + key);
        } else {
            long diff;
            Long oldValue = (Long)threadMap.get(key);
            if (oldValue == null) {
                this.throwException("oldValue in latestValues cannot be null: key = " + key + " & newVal = " + newValue);
            }
            if ((diff = newValue - oldValue) > 1L) {
                this.throwException("difference expected in newValue and oldValue is 1 or less (duplicates allowed), but is was " + diff + " for key = " + key + " & newVal = " + newValue + ". vm is " + VmDurableId);
            }
            if (diff < 1L) {
                isDuplicate = true;
            }
        }
        return isDuplicate;
    }

    @Override
    public void throwException(String reason) {
        long exceptionNumber = DurableClientsBB.getBB().getSharedCounters().incrementAndRead(DurableClientsBB.NUM_EXCEPTION);
        DurableClientsBB.getBB().getSharedMap().put(new Long(exceptionNumber), reason);
        DurableClientsBB.getBB().getSharedCounters().incrementAndRead(DurableClientsBB.NUM_COMPLETED_EXCEPTION_LOGGING);
    }
}

