/*
 * Decompiled with CFR 0.152.
 */
package durableClients;

import com.gemstone.gemfire.cache.ClientHelper;
import com.gemstone.gemfire.cache.GemFireCache;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import com.gemstone.gemfire.internal.cache.BridgeServerImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.HARegion;
import com.gemstone.gemfire.internal.cache.LocalRegionHelper;
import com.gemstone.gemfire.internal.cache.ha.HAHelper;
import com.gemstone.gemfire.internal.cache.ha.HARegionQueue;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientProxy;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import com.gemstone.gemfire.internal.cache.tier.sockets.HaHelper;
import cq.CQUtil;
import durableClients.DurableClientsBB;
import durableClients.DurableClientsPrms;
import hct.ha.HAClientQueue;
import hct.ha.HAClientQueueBB;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.ClientCacheHelper;
import hydra.ClientRegionHelper;
import hydra.ClientVmInfo;
import hydra.ClientVmMgr;
import hydra.ClientVmNotFoundException;
import hydra.ConfigPrms;
import hydra.DistributedSystemHelper;
import hydra.Log;
import hydra.MasterController;
import hydra.NetworkHelper;
import hydra.Prms;
import hydra.RegionHelper;
import hydra.StopSchedulingTaskOnClientOrder;
import hydra.TestConfig;
import hydra.blackboard.SharedMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import util.TestException;

public class DurableClientsTest {
    protected static final boolean useClientCache = TestConfig.tab().booleanAt(DurableClientsPrms.useClientCache, false);
    protected static final String REGION_NAME = TestConfig.tab().stringAt(DurableClientsPrms.regionName, "Region");
    static long killInterval = TestConfig.tab().intAt(DurableClientsPrms.killInterval, 60000);
    static Random rand = new Random();
    public static final String PARTIAL_LIST = "PARTIAL LIST : ";
    public static final String FULL_LIST = "FULL LIST : ";
    public static final String SLOW_START_TIME = "80000";
    public static volatile boolean receivedLastKey = false;
    public static final int NETDOWN_TIME = 30;
    private static PoolImpl myPool = null;
    public static volatile long lastEventReceivedTime = 0L;

    public static void initCacheServer() {
        if (TestConfig.tab().booleanAt(DurableClientsPrms.isExpirationTest, false)) {
            CacheClientProxy.isSlowStartForTesting = true;
            System.setProperty("slowStartTimeForTesting", SLOW_START_TIME);
            Log.getLogWriter().info("Configuring the test with slowed down dispatcher.");
        }
        CacheHelper.createCache(ConfigPrms.getCacheConfig());
        int numOfRegion = TestConfig.tab().intAt(DurableClientsPrms.numberOfRegions, 1);
        for (int i = 0; i < numOfRegion; ++i) {
            RegionHelper.createRegion(REGION_NAME + i, ConfigPrms.getRegionConfig());
        }
        BridgeHelper.startBridgeServer(ConfigPrms.getBridgeConfig());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initCacheClient() {
        Class<DurableClientsTest> clazz = DurableClientsTest.class;
        synchronized (DurableClientsTest.class) {
            if (DurableClientsTest.getCache() == null) {
                GemFireCache cache = DurableClientsTest.createCache();
                int numOfRegion = TestConfig.tab().intAt(DurableClientsPrms.numberOfRegions, 1);
                for (int i = 0; i < numOfRegion; ++i) {
                    PoolImpl mybw;
                    Region region = DurableClientsTest.createRegion(REGION_NAME + i);
                    myPool = mybw = ClientHelper.getPool(region);
                    Log.getLogWriter().info("The primary server endpoint is " + mybw.getPrimaryName());
                    String VmDurableId = InternalDistributedSystem.getAnyInstance().getConfig().getDurableClientId();
                    Log.getLogWriter().info(" VM Durable Client Id is " + VmDurableId);
                    if (DurableClientsBB.getBB().getSharedMap().containsKey(VmDurableId)) continue;
                    HashMap map = new HashMap();
                    DurableClientsBB.getBB().getSharedMap().put(VmDurableId, map);
                }
                DurableClientsTest.readyForEvents();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initCQClient() {
        Class<HAClientQueue> clazz = HAClientQueue.class;
        synchronized (HAClientQueue.class) {
            if (DurableClientsTest.getCache() == null) {
                GemFireCache cache = DurableClientsTest.createCache();
                CQUtil.initialize();
                CQUtil.initializeCQService(useClientCache);
                int numOfRegion = TestConfig.tab().intAt(DurableClientsPrms.numberOfRegions, 1);
                for (int i = 0; i < numOfRegion; ++i) {
                    PoolImpl mybw;
                    Region region = DurableClientsTest.createRegion(REGION_NAME + i);
                    myPool = mybw = ClientHelper.getPool(region);
                    Log.getLogWriter().info("The primary server endpoint is " + mybw.getPrimaryName());
                    String VmDurableId = InternalDistributedSystem.getAnyInstance().getConfig().getDurableClientId();
                    Log.getLogWriter().info(" VM Durable Client Id is " + VmDurableId);
                    if (!DurableClientsBB.getBB().getSharedMap().containsKey(VmDurableId)) {
                        HashMap map = new HashMap();
                        DurableClientsBB.getBB().getSharedMap().put(VmDurableId, map);
                    }
                    Log.getLogWriter().info("Doing durable cq register");
                    CQUtil.registerDurableCQ(region);
                }
                DurableClientsTest.readyForEvents();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void registerInterest() {
        String registerInterestKeys = TestConfig.tab().stringAt(DurableClientsPrms.registerInterestKeys);
        if (registerInterestKeys.equalsIgnoreCase("allKeys")) {
            DurableClientsTest.registerInterestALL_KEYS();
        } else if (registerInterestKeys.equalsIgnoreCase("partialKeysList")) {
            DurableClientsTest.registerInterestPartial_List();
        } else if (registerInterestKeys.equalsIgnoreCase("fullKeysList")) {
            DurableClientsTest.registerInterestFull_List();
        } else {
            throw new TestException("Test issue - Invalid register interest configuration");
        }
    }

    public static void registerInterestALL_KEYS() {
        Log.getLogWriter().info("Registering interest on all keys");
        int numOfRegion = TestConfig.tab().intAt(DurableClientsPrms.numberOfRegions, 1);
        InterestResultPolicy interestResultPolicy = DurableClientsPrms.getInterestResultPolicy();
        for (int i = 0; i < numOfRegion; ++i) {
            Region region = DurableClientsTest.getRegion(REGION_NAME + i);
            region.registerInterest((Object)"ALL_KEYS", interestResultPolicy, true);
            MasterController.sleepForMs(5000);
        }
    }

    public static void registerInterestPartial_List() {
        Log.getLogWriter().info("Registering interest on partial list of keys");
        int numOfRegion = TestConfig.tab().intAt(DurableClientsPrms.numberOfRegions, 1);
        InterestResultPolicy interestResultPolicy = DurableClientsPrms.getInterestResultPolicy();
        for (int i = 0; i < numOfRegion; ++i) {
            Region region = DurableClientsTest.getRegion(REGION_NAME + i);
            Log.getLogWriter().info("List size is :" + ((List)DurableClientsBB.getBB().getSharedMap().get(PARTIAL_LIST)).size());
            region.registerInterest(DurableClientsBB.getBB().getSharedMap().get(PARTIAL_LIST), interestResultPolicy, true);
            MasterController.sleepForMs(5000);
            if (!TestConfig.tab().booleanAt(DurableClientsPrms.putLastKey, false)) continue;
            region.registerInterest((Object)"last_key", interestResultPolicy, true);
        }
    }

    public static void registerInterestFull_List() {
        Log.getLogWriter().info("Registering interest on full list of keys");
        int numOfRegion = TestConfig.tab().intAt(DurableClientsPrms.numberOfRegions, 1);
        InterestResultPolicy interestResultPolicy = DurableClientsPrms.getInterestResultPolicy();
        for (int i = 0; i < numOfRegion; ++i) {
            Region region = DurableClientsTest.getRegion(REGION_NAME + i);
            Log.getLogWriter().info("List size is :" + ((List)DurableClientsBB.getBB().getSharedMap().get(FULL_LIST)).size());
            region.registerInterest(DurableClientsBB.getBB().getSharedMap().get(FULL_LIST), interestResultPolicy, true);
            MasterController.sleepForMs(5000);
            if (!TestConfig.tab().booleanAt(DurableClientsPrms.putLastKey, false)) continue;
            region.registerInterest((Object)"last_key", interestResultPolicy, true);
        }
    }

    public static void killClient() {
        try {
            MasterController.sleepForMs(5000);
            ClientVmInfo clientVmInfo = ClientVmMgr.stop("Killing the VM", -21, -30);
        }
        catch (ClientVmNotFoundException e) {
            Log.getLogWriter().warning(" Exception while killing client ", (Throwable)e);
        }
    }

    public static void clientNormalShutDown() {
        if (DistributedSystemHelper.getDistributedSystem() != null) {
            DurableClientsTest.closeCache(true);
        }
        DurableClientsTest.initCacheClient();
        DurableClientsTest.registerInterest();
    }

    public static void cqClientNormalShutDown() {
        MasterController.sleepForMs(3000);
        if (DistributedSystemHelper.getDistributedSystem() != null) {
            DurableClientsTest.closeCache(true);
        }
        DurableClientsTest.initCQClient();
    }

    public static void clientNetDown() {
        String remote1 = TestConfig.tab().stringAt(DurableClientsPrms.remoteMachine1);
        String remote2 = TestConfig.tab().stringAt(DurableClientsPrms.remoteMachine2);
        NetworkHelper.printConnectionState();
        NetworkHelper.dropConnectionTwoWay(remote1, remote2);
        Log.getLogWriter().info("Sleeping for 30 Secs");
        MasterController.sleepForMs(30000);
        NetworkHelper.printConnectionState();
        NetworkHelper.restoreConnectionTwoWay(remote2, remote1);
        NetworkHelper.printConnectionState();
    }

    public static void killStableServer() throws ClientVmNotFoundException {
        DurableClientsTest.killServer();
    }

    public static void killServer() throws ClientVmNotFoundException {
        Long lastKill;
        int numOfRegion = TestConfig.tab().intAt(DurableClientsPrms.numberOfRegions, 1) - 1;
        Region region = DurableClientsTest.getRegion(REGION_NAME + numOfRegion);
        Set active = ClientHelper.getActiveServers(region);
        int minServersRequiredAlive = TestConfig.tab().intAt(DurableClientsPrms.minServersRequiredAlive, 3);
        if (active.size() < minServersRequiredAlive) {
            Log.getLogWriter().info("No kill executed , a minimum of " + minServersRequiredAlive + " servers have to be kept alive");
            return;
        }
        long now = System.currentTimeMillis();
        long diff = now - (lastKill = (Long)DurableClientsBB.getBB().getSharedMap().get("lastKillTime"));
        if (diff < killInterval) {
            Log.getLogWriter().info("No kill executed");
            return;
        }
        DurableClientsBB.getBB().getSharedMap().put("lastKillTime", new Long(now));
        List<BridgeHelper.Endpoint> endpoints = BridgeHelper.getEndpoints();
        int index = rand.nextInt(endpoints.size() - 1);
        BridgeHelper.Endpoint endpoint = endpoints.get(index);
        ClientVmInfo target = new ClientVmInfo(endpoint);
        target = ClientVmMgr.stop("Killing random cache server", -21, -31, target);
        Log.getLogWriter().info("Server Killed : " + target);
        int sleepSec = TestConfig.tab().intAt(DurableClientsPrms.restartWaitSec, 1);
        Log.getLogWriter().info("Sleeping for " + sleepSec + " seconds");
        MasterController.sleepForMs(sleepSec * 1000);
        active = ClientHelper.getActiveServers(region);
        ServerLocation server = new ServerLocation(endpoint.getHost(), endpoint.getPort());
        if (active.contains(server)) {
            Log.getLogWriter().info("ERROR: Killed server " + server + " found in Active Server List: " + active);
        }
        ClientVmMgr.start("Restarting the cache server", target);
        int sleepMs = ClientHelper.getRetryInterval(region) + 1000;
        Log.getLogWriter().info("Sleeping for " + sleepMs + " ms");
        MasterController.sleepForMs(sleepMs);
        active = ClientHelper.getActiveServers(region);
        if (active.contains(server)) {
            Log.getLogWriter().info("ERROR: Restarted server " + server + " not in Active Server List" + active);
        }
    }

    public static void putHAStatsInBlackboard() {
        DurableClientsBB.getBB().printSharedMap();
    }

    public static void getConflationStats() {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        Iterator itr = cache.getCacheServers().iterator();
        BridgeServerImpl server = (BridgeServerImpl)itr.next();
        for (CacheClientProxy proxy : server.getAcceptor().getCacheClientNotifier().getClientProxies()) {
            if (!HaHelper.checkPrimary(proxy)) continue;
            ClientProxyMembershipID proxyID = proxy.getProxyID();
            Log.getLogWriter().info("Proxy id : " + proxyID.toString());
            HARegion region = (HARegion)proxy.getHARegion();
            HARegionQueue haRegionQueue = HAHelper.getRegionQueue(region);
            HashMap<String, Long> statMap = new HashMap<String, Long>();
            statMap.put("eventsConflated", new Long(HAHelper.getRegionQueueStats(haRegionQueue).getEventsConflated()));
            Log.getLogWriter().info("Events conflated = " + HAHelper.getRegionQueueStats(haRegionQueue).getEventsConflated());
            Log.getLogWriter().info("Events Queued = " + new Long(HAHelper.getRegionQueueStats(haRegionQueue).getEventsEnqued()));
            DurableClientsBB.getBB().getSharedMap().put(proxyID.toString(), statMap);
            DurableClientsBB.getBB().getSharedCounters().add(DurableClientsBB.NUM_GLOBAL_CONFLATE, HAHelper.getRegionQueueStats(haRegionQueue).getEventsConflated());
        }
    }

    public static void verifyIndividualConflation() {
        ClientProxyMembershipID cpm = myPool.getProxyID();
        String proxyIdStr = cpm.toString();
        Log.getLogWriter().info("Proxy String : " + proxyIdStr);
        HashMap mp = (HashMap)DurableClientsBB.getBB().getSharedMap().get(proxyIdStr);
        Log.getLogWriter().info(mp.toString());
        Long numOfConflated = (Long)mp.get("eventsConflated");
        Log.getLogWriter().info("value of numOfConflated : " + numOfConflated);
        long totalConflation = DurableClientsBB.getBB().getSharedCounters().read(DurableClientsBB.NUM_GLOBAL_CONFLATE);
        Log.getLogWriter().info("Total Conflation : " + totalConflation);
        if (numOfConflated.equals(new Long(0L))) {
            throw new TestException("Expected conflation to happen but has it did not happen");
        }
    }

    public static void verifyNoConflation() {
        ClientProxyMembershipID cpm = myPool.getProxyID();
        String proxyIdStr = cpm.toString();
        Log.getLogWriter().info("Proxy String : " + proxyIdStr);
        HashMap mp = (HashMap)DurableClientsBB.getBB().getSharedMap().get(proxyIdStr);
        Log.getLogWriter().info(mp.toString());
        Long numOfConflated = (Long)mp.get("eventsConflated");
        Log.getLogWriter().info("value of numOfConflated : " + numOfConflated);
        long totalConflation = DurableClientsBB.getBB().getSharedCounters().read(DurableClientsBB.NUM_GLOBAL_CONFLATE);
        Log.getLogWriter().info("Total Conflation : " + totalConflation);
        if (!numOfConflated.equals(new Long(0L))) {
            throw new TestException("Expected no conflation to happen but has " + numOfConflated + " events");
        }
    }

    public static void checkForConflation() {
        long totalConflation = DurableClientsBB.getBB().getSharedCounters().read(DurableClientsBB.NUM_GLOBAL_CONFLATE);
        Log.getLogWriter().info("Total Conflation : " + totalConflation);
        if (totalConflation == 0L) {
            throw new TestException("No conflation done - Test Issue - needs tuning ");
        }
    }

    public static void verifyDataInRegion() {
        DurableClientsTest.checkBlackBoardForException();
        int numOfRegion = TestConfig.tab().intAt(DurableClientsPrms.numberOfRegions, 1);
        for (int i = 0; i < numOfRegion; ++i) {
            Region region = DurableClientsTest.getRegion(REGION_NAME + i);
            Log.getLogWriter().info("Validating the keys of the Region " + region.getFullPath() + " ...");
            if (region.isEmpty()) {
                throw new TestException(" Region has no entries to validate ");
            }
            Iterator iterator = region.entrySet(false).iterator();
            Region.Entry entry = null;
            Object key = null;
            Object value = null;
            while (iterator.hasNext()) {
                entry = (Region.Entry)iterator.next();
                key = entry.getKey();
                value = entry.getValue();
                if (value != null) {
                    if (DurableClientsBB.getBB().getSharedMap().get(key) != null) {
                        if (DurableClientsBB.getBB().getSharedMap().get(key).equals(value)) continue;
                        throw new TestException(" expected value to be " + DurableClientsBB.getBB().getSharedMap().get(key) + " for key " + key + " but is " + value);
                    }
                    throw new TestException(" expected value to be present in the shared map but it is not for key " + key);
                }
                if (DurableClientsBB.getBB().getSharedMap().get(key) == null) continue;
                throw new TestException(" expected value to be null but it is not so for key " + key);
            }
        }
    }

    public static void mentionReferenceInBlackboard() {
        String VmDurableId = InternalDistributedSystem.getAnyInstance().getConfig().getDurableClientId();
        Log.getLogWriter().info("Reference vm is : " + VmDurableId);
        DurableClientsBB.getBB().getSharedMap().put("REFERENCE VM:", VmDurableId);
        DurableClientsBB.getBB().getSharedMap().put("lastKillTime", new Long(0L));
    }

    public static void validateEventsReceived() {
        DurableClientsTest.checkBlackBoardForException();
        DurableClientsBB.getBB().printSharedMap();
        String ReferenceVm = (String)DurableClientsBB.getBB().getSharedMap().get("REFERENCE VM:");
        String VmDurableId = InternalDistributedSystem.getAnyInstance().getConfig().getDurableClientId();
        HashMap currentVmMap = (HashMap)DurableClientsBB.getBB().getSharedMap().get(VmDurableId);
        HashMap referenceMap = (HashMap)DurableClientsBB.getBB().getSharedMap().get(ReferenceVm);
        if (currentVmMap.isEmpty()) {
            throw new TestException(" The map of threads is empty for the Vm " + VmDurableId);
        }
        if (referenceMap.isEmpty()) {
            throw new TestException(" The map of threads is empty for the Reference Vm " + ReferenceVm);
        }
        Iterator iterator = referenceMap.entrySet().iterator();
        Map.Entry entry = null;
        Object key = null;
        Object value = null;
        while (iterator.hasNext()) {
            entry = iterator.next();
            key = entry.getKey();
            value = entry.getValue();
            HashMap referenceThreadMap = value;
            Iterator iterator1 = referenceThreadMap.entrySet().iterator();
            Map.Entry entry1 = null;
            Object key1 = null;
            Object value1 = null;
            while (iterator1.hasNext()) {
                entry1 = iterator1.next();
                key1 = entry1.getKey();
                value1 = entry1.getValue();
                if (!((String)key1).startsWith("EVENT SR. No : ")) continue;
                if (currentVmMap.get(key) == null) {
                    throw new TestException("No event map for the key " + key + " because client didnot receive any events for this key");
                }
                if (((HashMap)currentVmMap.get(key)).get(key1) == null) {
                    throw new TestException("Event not received by the client for the key " + key + " for the event " + key1);
                }
                if (value1.equals(((HashMap)currentVmMap.get(key)).get(key1))) continue;
                throw new TestException(" For the thread " + key + " the event no " + key1 + " has different events");
            }
        }
    }

    public static void checkBlackBoardForException() {
        long exceptionCount = DurableClientsBB.getBB().getSharedCounters().read(DurableClientsBB.NUM_EXCEPTION);
        long exceptionLoggingComplete = DurableClientsBB.getBB().getSharedCounters().read(DurableClientsBB.NUM_COMPLETED_EXCEPTION_LOGGING);
        SharedMap sharedmap = DurableClientsBB.getBB().getSharedMap();
        if (exceptionCount > 0L && (exceptionLoggingComplete > 0L || sharedmap.get(new Long(1L)) != null)) {
            StringBuffer reason = new StringBuffer();
            reason.append("total exceptions = " + exceptionCount);
            reason.append("\n");
            for (long i = 1L; i < exceptionCount + 1L; ++i) {
                reason.append("Reason for exception no. " + i + " : ");
                reason.append(sharedmap.get(new Long(i)));
                reason.append("\n");
            }
            throw new TestException(reason.toString());
        }
    }

    public static void waitForLastKeyReceivedAtClient() {
        long hydraTaskWaitSec = TestConfig.tab().longAt(Prms.maxResultWaitSec);
        long waitTime = 0L;
        long maxWaitTime = 0L;
        waitTime = hydraTaskWaitSec < 300L ? 50L : 100L;
        maxWaitTime = (hydraTaskWaitSec - waitTime) * 1000L;
        Log.getLogWriter().info("Setting the value for last key wait time to " + maxWaitTime + " ms");
        long start = System.currentTimeMillis();
        boolean checkedListnerActive = false;
        while (!receivedLastKey && !checkedListnerActive) {
            if (System.currentTimeMillis() - start > maxWaitTime) {
                long currentTime = System.currentTimeMillis();
                long timeElapsedSinceLastEvent = currentTime - lastEventReceivedTime;
                checkedListnerActive = true;
                if (timeElapsedSinceLastEvent > 20000L) {
                    throw new TestException("last_key was not received in " + maxWaitTime + " milliseconds, and listner is silent (this probably is not a late event arrival issue), could not proceed for further validation");
                }
                Log.getLogWriter().info("Last key not yet received, but listner is still active!. So task will be rescheduled");
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ignore) {
                Log.getLogWriter().info("waitForLastKeyReceivedAtClient : interrupted while waiting for validation");
            }
        }
        if (receivedLastKey) {
            throw new StopSchedulingTaskOnClientOrder("Stopping the task schedule as the last_key received");
        }
        MasterController.sleepForMs(10000);
    }

    public static void toggleHAOverflowFlag() {
        LocalRegionHelper.isHAOverflowFeaturedUsedInPrimaryPutOnShareBB();
    }

    public static void checkHAOverFlowUsedOnPrimary() {
        int status = (int)HAClientQueueBB.getBB().getSharedCounters().read(HAClientQueueBB.HA_OVERFLOW_STATUS);
        if (status == 0) {
            throw new TestException("Test issue : Test need tuning - no overflow happened");
        }
    }

    public static void readyForEvents() {
        if (useClientCache) {
            ClientCacheHelper.getCache().readyForEvents();
        } else {
            CacheHelper.getCache().readyForEvents();
        }
    }

    public static void closeCache(boolean keepAlive) {
        if (useClientCache) {
            ClientCacheHelper.getCache().close(keepAlive);
        } else {
            CacheHelper.getCache().close(keepAlive);
        }
    }

    public static GemFireCache getCache() {
        Object cache = null;
        cache = useClientCache ? ClientCacheHelper.getCache() : CacheHelper.getCache();
        return cache;
    }

    public static GemFireCache createCache() {
        Object cache = null;
        cache = useClientCache ? ClientCacheHelper.createCache(ConfigPrms.getClientCacheConfig()) : CacheHelper.createCache(ConfigPrms.getCacheConfig());
        return cache;
    }

    public static Region createRegion(String regionName) {
        Region region = null;
        region = useClientCache ? ClientRegionHelper.createRegion(regionName, ConfigPrms.getClientRegionConfig()) : RegionHelper.createRegion(regionName, ConfigPrms.getRegionConfig());
        return region;
    }

    private static Region getRegion(String regionName) {
        if (useClientCache) {
            return ClientRegionHelper.getRegion(regionName);
        }
        return RegionHelper.getRegion(regionName);
    }
}

