/*
 * Decompiled with CFR 0.152.
 */
package dunit.tests;

import dunit.GemFireSystem;
import dunit.Host;
import dunit.VM;
import hydra.Log;
import junit.framework.TestCase;

public class DumpInfo
extends TestCase {
    public void testDumpInfo() {
        DumpInfo.dumpInfo();
    }

    public static void dumpInfo() {
        StringBuffer sb = new StringBuffer();
        int hostCount = Host.getHostCount();
        sb.append(hostCount + " hosts:\n");
        for (int i = 0; i < hostCount; ++i) {
            Host host = Host.getHost(i);
            sb.append("  ");
            sb.append(host);
            sb.append('\n');
            int systemCount = host.getSystemCount();
            sb.append("    ");
            sb.append(systemCount);
            sb.append(" systems\n");
            for (int j = 0; j < systemCount; ++j) {
                GemFireSystem system = host.getSystem(j);
                sb.append("      ");
                sb.append(j);
                sb.append(") ");
                sb.append(system);
                sb.append('\n');
            }
            int vmCount = host.getVMCount();
            sb.append("    ");
            sb.append(vmCount);
            sb.append(" vms\n");
            for (int j = 0; j < vmCount; ++j) {
                VM vm = host.getVM(j);
                sb.append("      ");
                sb.append(j);
                sb.append(") ");
                sb.append(vm);
                sb.append('\n');
            }
        }
        Log.getLogWriter().info(sb.toString());
    }
}

