/*
 * Decompiled with CFR 0.152.
 */
package dunit.impl;

import hydra.HostHelper;
import hydra.HydraRuntimeException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;

public class DUnitConfigAntTask
extends Task {
    private File configFile;
    private File btFile;
    private int dunitSites = 0;
    private FileSet tests;
    private int systemCount = 0;
    private String includeFile = null;
    private String logLevel = null;
    private String verboseString = null;
    private String debugJavaGroupsString = null;
    private Path extraLocatorClasspath;
    private Path extraControllerClasspath;
    private Path extraClientClasspath;
    private final List<Param> params = new ArrayList<Param>();
    private JProbe clientJProbe;
    private String[] extraVMArgs = new String[0];
    private boolean useIPv6;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void execute() throws BuildException {
        this.validateConfigurationSettings();
        Project project = this.getProject();
        boolean configFilePathCreated = this.configFile.getParentFile().mkdirs();
        boolean btFilePathCreated = this.btFile.getParentFile().mkdirs();
        String[] filenames = this.tests.getDirectoryScanner(project).getIncludedFiles();
        ArrayList<String> testClasses = new ArrayList<String>();
        if (filenames.length == 0) {
            throw new BuildException("Didn't find any distributed unit tests");
        }
        for (String string : filenames) {
            String string3 = string.substring(0, string.lastIndexOf(46));
            string3 = string3.replace(File.separatorChar, '.');
            this.log("Will generate config for class " + string3, 3);
            testClasses.add(string3);
        }
        ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        try {
            PrintWriter writer;
            this.log("Generating DUnit configuration file " + this.configFile);
            try {
                writer = new PrintWriter((Writer)new FileWriter(this.configFile), true);
            }
            catch (IOException ex) {
                throw new BuildException("While writing to " + this.configFile + ": " + ex);
            }
            writer.println("// This file was generated by " + ((Object)((Object)this)).getClass().getName());
            writer.println("// on " + new Date());
            writer.println("");
            writer.println("INCLUDE " + this.includeFile + ";");
            writer.println();
            writer.println("hydra.Prms-manageLocatorAgents=false;");
            if (this.logLevel != null) {
                writer.println("hydra.GemFirePrms-logLevel = " + this.logLevel + ";");
            }
            ArrayList<String> parameters = new ArrayList<String>();
            parameters.add("-Dp2p.joinTimeout=9000");
            if (this.verboseString != null && Boolean.valueOf(this.verboseString).booleanValue()) {
                parameters.add("-DDistributionManager.VERBOSE=true");
            }
            if (this.debugJavaGroupsString != null && Boolean.valueOf(this.debugJavaGroupsString).booleanValue()) {
                parameters.add("-DJGroups.DEBUG=true");
            }
            if (!parameters.isEmpty() || this.extraVMArgs.length > 0) {
                void var11_27;
                writer.println("\nhydra.VmPrms-extraVMArgs = ");
                String[] stringArray = this.extraVMArgs;
                int n = stringArray.length;
                boolean bl = false;
                while (var11_27 < n) {
                    String extraVmArg = stringArray[var11_27];
                    writer.println("  \"" + extraVmArg + "\"");
                    ++var11_27;
                }
                for (String parameter : parameters) {
                    writer.println("  \"" + parameter + "\"");
                }
                writer.println("  ;");
            }
            if (this.useIPv6) {
                String string;
                System.setProperty("java.net.preferIPv6Addresses", "true");
                try {
                    string = HostHelper.getHostAddress();
                }
                catch (HydraRuntimeException e) {
                    System.err.println("ERROR: " + e.getMessage());
                    throw new Error(e.getMessage());
                }
                writer.println("\nhydra.Prms-useIPv6 = true;");
                writer.println("\nhydra.VmPrms-extraVMArgs += \"-Dgemfire.bind-address=" + string + "\";");
                writer.println("\nhydra.VmPrms-extraVMArgs += \"-Dgemfire.server-bind-address=" + string + "\";");
                writer.println("\nhydra.VmPrms-extraVMArgs += \"-Dgemfire.mcast-address=FF38::1234\";");
                writer.println("\nhydra.VmPrms-extraVMArgs += \"-Dp2p.joinTimeout=9000;");
                writer.println("\nhydra.GemFirePrms-extraLocatorVMArgs += \"-Dgemfire.bind-address=" + string + "\";");
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (this.extraClientClasspath != null) {
                stringBuilder.append("\"").append(this.extraClientClasspath).append("\"");
            }
            if (stringBuilder.length() != 0) {
                if (File.separatorChar == '\\') {
                    for (int index = 0; index < stringBuilder.length(); ++index) {
                        if (stringBuilder.charAt(index) != '\\') continue;
                        stringBuilder.insert(index, '\\');
                        ++index;
                    }
                }
                writer.println("\nhydra.VmPrms-extraClassPaths=" + stringBuilder + ";");
            }
            JProbe.writeToConf(this.clientJProbe, writer);
            writer.println();
            for (Param param : this.params) {
                param.writeToConf(writer);
            }
            writer.println();
            for (String string : testClasses) {
                writer.println("UNITTEST    testClass = " + string + ";");
            }
            writer.flush();
            writer.close();
            try {
                writer = new PrintWriter((Writer)new FileWriter(this.btFile), true);
            }
            catch (IOException ex) {
                throw new BuildException("While writing to " + this.btFile + ": " + ex);
            }
            writer.println("// This file was generated by " + ((Object)((Object)this)).getClass().getName());
            writer.println("// on " + new Date());
            writer.println("");
            writer.println(this.configFile.getAbsolutePath() + " dunitSites=" + this.dunitSites);
            writer.flush();
            writer.close();
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalContextClassLoader);
        }
    }

    private void validateConfigurationSettings() {
        if (this.configFile == null) {
            throw new BuildException("No configuration file specified");
        }
        if (this.btFile == null) {
            throw new BuildException("No battery test file specified");
        }
        if (this.systemCount <= 0) {
            throw new BuildException("No system count specified");
        }
        if (this.includeFile == null) {
            throw new BuildException("No include file specified");
        }
        if (this.tests == null) {
            throw new BuildException("No tests specified");
        }
        if (this.dunitSites == 0) {
            throw new BuildException("You must specify the number of dunitSites");
        }
    }

    private void appendToExtraClasspaths(StringBuilder extraClasspaths, Path classpath) {
        this.appendToExtraClasspaths(extraClasspaths, classpath, 1);
    }

    private void appendToExtraClasspaths(StringBuilder extraClasspaths, Path classpath, int multiplier) {
        int total = this.getDunitSites() * multiplier;
        for (int index = 0; index < total; ++index) {
            extraClasspaths.append(extraClasspaths.length() > 0 ? ", \"" : "\"").append(classpath.toString()).append("\"");
        }
    }

    public void setBtfile(File btFile) {
        this.btFile = btFile;
    }

    public void setConffile(File configFile) {
        this.configFile = configFile;
    }

    public int getDunitSites() {
        return this.dunitSites;
    }

    public void setDunitSites(int sites) {
        this.dunitSites = sites;
    }

    public void setSystemcount(int count) {
        this.systemCount = count;
    }

    public void setIncludefile(String includeFileName) {
        this.includeFile = includeFileName;
    }

    public void setLoglevel(String logLevel) {
        this.logLevel = logLevel;
    }

    public void setVerbose(String verbose) {
        this.verboseString = verbose;
    }

    public void setExtraVMArgs(String arg) {
        this.extraVMArgs = arg.split("[\\s]+");
    }

    public void setUseIPv6(String useIt) {
        if (useIt.equals("true")) {
            this.useIPv6 = true;
        }
    }

    public void setDebugjavagroups(String debug) {
        this.debugJavaGroupsString = debug;
    }

    public Path createExtraClientClasspath() {
        if (this.extraClientClasspath == null) {
            this.extraClientClasspath = new Path(this.getProject());
        }
        return this.extraClientClasspath.createPath();
    }

    public Path createExtraControllerClasspath() {
        if (this.extraControllerClasspath == null) {
            this.extraControllerClasspath = new Path(this.getProject());
        }
        return this.extraControllerClasspath.createPath();
    }

    public Path createExtraLocatorClasspath() {
        if (this.extraLocatorClasspath == null) {
            this.extraLocatorClasspath = new Path(this.getProject());
        }
        return this.extraLocatorClasspath.createPath();
    }

    public JProbe createJprobeclient() {
        JProbe jprobe;
        this.clientJProbe = jprobe = new JProbe();
        return jprobe;
    }

    public Param createParam() {
        Param param = new Param();
        this.params.add(param);
        return param;
    }

    public FileSet createTests() {
        if (this.tests == null) {
            this.tests = new FileSet();
        }
        return this.tests;
    }

    public static class JProbe {
        JProbe() {
        }

        static void writeToConf(JProbe client, PrintWriter writer) {
            if (client == null) {
                return;
            }
            writer.println();
            writer.println("hydra.JProbePrms-names = clientJProbe;");
            writer.println("hydra.JProbePrms-function = performance;");
            writer.println("hydra.JProbePrms-recordFromStart = true;");
            writer.println("hydra.JProbePrms-finalSnapshot   = true;");
            writer.println("hydra.JProbePrms-monitor         = false;");
            writer.println("hydra.JProbePrms-filters =");
            for (String filter : client.getFilters()) {
                writer.println("  " + filter);
            }
            writer.println(";");
            writer.println("hydra.ClientPrms-jprobeNames = clientJProbe;");
            writer.println();
        }

        List<String> getFilters() {
            return Arrays.asList("*.*.*():method");
        }
    }

    public static class Param {
        private String name;
        private String value;

        public void setName(String name) {
            this.name = name;
        }

        public void setValue(String value) {
            this.value = value;
        }

        void writeToConf(PrintWriter pw) throws BuildException {
            if (this.name == null) {
                String s = "Missing param name";
                throw new BuildException(s);
            }
            if (this.value == null) {
                String s = "Missing value for param \"" + this.name + "\"";
                throw new BuildException(s);
            }
            pw.println(this.name + " = " + this.value + ";");
        }
    }
}

