/*
 * Decompiled with CFR 0.152.
 */
package dunit.eclipse;

import com.gemstone.gemfire.internal.FileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.rmi.NotBoundException;
import java.util.Arrays;

public class ProcessManager {
    private int namingPort;
    private Process[] processes;
    private volatile boolean shuttingDown;

    public ProcessManager(int numVMs, int namingPort) {
        this.namingPort = namingPort;
        this.processes = new Process[numVMs];
    }

    public void launchVMs() throws IOException, NotBoundException {
        int debugPort = Integer.getInteger("dunit.debug.port", 0);
        for (int i = 0; i < this.processes.length; ++i) {
            String[] cmd = this.buildJavaCommand(i, this.namingPort, debugPort);
            System.out.println("Executing " + Arrays.asList(cmd));
            File workingDir = new File("dunit", "vm" + i);
            FileUtil.delete((File)workingDir);
            workingDir.mkdirs();
            this.processes[i] = Runtime.getRuntime().exec(cmd, null, workingDir);
            this.linkStreams(i, this.processes[i].getErrorStream(), System.err);
            this.linkStreams(i, this.processes[i].getInputStream(), System.out);
            if (debugPort == 0) continue;
            ++debugPort;
        }
    }

    public void killVMs() {
        this.shuttingDown = true;
        for (int i = 0; i < this.processes.length; ++i) {
            if (this.processes[i] == null) continue;
            this.processes[i].destroy();
        }
    }

    public Process[] getProcesses() {
        return this.processes;
    }

    private void linkStreams(final int vmNum, final InputStream in, final PrintStream out) {
        Thread ioTransport = new Thread(){

            @Override
            public void run() {
                block3: {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                    try {
                        String line = reader.readLine();
                        while (line != null) {
                            out.print("[vm-" + vmNum + "]");
                            out.println(line);
                            line = reader.readLine();
                        }
                    }
                    catch (Exception e) {
                        if (ProcessManager.this.shuttingDown) break block3;
                        out.println("Error transporting IO from child process");
                        e.printStackTrace(out);
                    }
                }
            }
        };
        ioTransport.setDaemon(true);
        ioTransport.start();
    }

    private String[] buildJavaCommand(int vmNum, int namingPort, int debugPort) {
        String suspendVM = System.getProperty("dunit.debug.suspend.vm");
        String suspendDebug = "n";
        if (suspendVM != null && (vmNum + "").equals(suspendVM)) {
            suspendDebug = "y";
        }
        String cmd = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        String classPath = System.getProperty("java.class.path");
        return new String[]{cmd, "-classpath", classPath, "-Dgemfire.DUnitLauncher.RMI_PORT=" + namingPort, "-Dgemfire.DUnitLauncher.VM_NUM=" + vmNum, "-Dgemfire.GraphLoggerImpl.ENABLED_TYPES=all", "-Dgemfire.EntryLogger.TRACK_VALUES=false", "-DDistributionManager.VERBOSE=true", "-DWORKSPACE_DIR=" + new File(".").getAbsolutePath(), "-Djava.library.path=" + System.getProperty("java.library.path"), "-agentlib:jdwp=transport=dt_socket,server=y,suspend=" + suspendDebug + ",address=" + debugPort, "-ea", "-Djava.awt.headless=true", "dunit.eclipse.ChildVM"};
    }
}

