/*
 * Decompiled with CFR 0.152.
 */
package dunit;

import dunit.Host;
import dunit.VM;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class GemFireSystem
implements Serializable {
    private Host host;
    private String systemDirectory;
    private String name;

    GemFireSystem(String name, Host host, String systemDirectory) {
        this.name = name;
        this.host = host;
        this.systemDirectory = systemDirectory;
    }

    public Host getHost() {
        return this.host;
    }

    public String getSystemDirectory() {
        return this.systemDirectory;
    }

    public int getVMCount() {
        return this.getVMs().size();
    }

    public List getVMs() {
        ArrayList<VM> result = new ArrayList<VM>();
        for (int i = 0; i < this.getHost().getVMCount(); ++i) {
            VM vm = this.getHost().getVM(i);
            if (!vm.getSystem().equals(this)) continue;
            result.add(vm);
        }
        return result;
    }

    public VM getVM(int i) {
        List vms = this.getVMs();
        if (i >= vms.size()) {
            this.dumpState();
            throw new IndexOutOfBoundsException("Can't get VM " + i + ", this system has " + vms.size() + " VMs");
        }
        return (VM)vms.get(i);
    }

    private void dumpState() {
        System.err.println(this.toString());
        System.err.println("Host VMs:");
        int i = this.getHost().getVMCount();
        while (--i >= 0) {
            System.err.println("  " + i + ": " + this.getHost().getVM(i));
        }
    }

    public boolean equals(Object o) {
        if (o instanceof GemFireSystem) {
            GemFireSystem other = (GemFireSystem)o;
            return this.host.equals(other.getHost()) && this.systemDirectory.equals(other.getSystemDirectory());
        }
        return false;
    }

    public String toString() {
        return "GemFire System running on " + this.getHost() + " in " + this.getSystemDirectory();
    }
}

