/*
 * Decompiled with CFR 0.152.
 */
package dlock.lockable;

import com.gemstone.gemfire.cache.Region;
import dlock.DLockBlackboard;
import dlock.DLockTestException;
import dlock.Info;
import dlock.lockable.BaseWrapper;
import java.util.HashMap;
import util.CacheUtil;
import util.NameFactory;

public class HashMapWrapper
extends BaseWrapper {
    @Override
    public void createDataInCache(Region region, Object name) {
        HashMap obj = new HashMap();
        CacheUtil.put(region, name, obj);
    }

    @Override
    public void read(Region region, Object name) {
        HashMap obj = (HashMap)CacheUtil.get(region, name);
        this.counters.increment(DLockBlackboard.HashMapReads);
    }

    @Override
    protected Object update(Object obj) {
        String key;
        HashMap newobj = (HashMap)obj;
        String val = key = NameFactory.getNextPositiveObjectName();
        newobj.put(key, val);
        return newobj;
    }

    @Override
    protected void noteUpdate() {
        this.counters.increment(DLockBlackboard.HashMapUpdates);
    }

    @Override
    public void validate(Region region, Info info) {
        HashMap obj = (HashMap)CacheUtil.get(region, info.getName());
        if ((long)obj.size() != info.getUpdates()) {
            throw new DLockTestException("Object data is invalid for " + info.getName() + " with expected count " + info.getUpdates() + ": " + obj);
        }
    }
}

