/*
 * Decompiled with CFR 0.152.
 */
package dlock.lockable;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.Region;
import dlock.DLockBlackboard;
import dlock.DLockPrms;
import dlock.DLockTestException;
import dlock.DLockUtil;
import dlock.Info;
import dlock.Lockable;
import hydra.Log;
import hydra.TestConfig;
import hydra.blackboard.SharedCounters;
import java.io.Serializable;
import util.CacheUtil;

public abstract class BaseWrapper
implements Lockable,
Serializable {
    protected transient SharedCounters counters = DLockBlackboard.getInstance().getSharedCounters();
    protected transient boolean debug = this.log().infoEnabled();
    protected transient boolean debugFine = this.log().fineEnabled();

    @Override
    public abstract void createDataInCache(Region var1, Object var2);

    @Override
    public void lock(Region aRegion, Object name) {
        if (TestConfig.tab().booleanAt(DLockPrms.useEntryLock)) {
            if (this.debug) {
                this.log().info("Getting entry lock on region " + aRegion.getName() + ", key " + name);
            }
            DLockUtil.getEntryLock(aRegion, name);
            if (this.debug) {
                this.log().info("Got entry lock on region " + aRegion.getName() + ", key " + name);
            }
        } else {
            if (this.debug) {
                this.log().info("Getting lock on " + name);
            }
            DLockUtil.getLock(name);
            if (this.debug) {
                this.log().info("Got lock on " + name);
            }
        }
        this.counters.increment(DLockBlackboard.hasLock);
    }

    @Override
    public void unlock(Region aRegion, Object name) {
        if (TestConfig.tab().booleanAt(DLockPrms.useEntryLock)) {
            if (this.debug) {
                this.log().info("Unlocking entry lock on region " + aRegion.getName() + ", key " + name);
            }
            DLockUtil.unlockEntryLock(aRegion, name);
            if (this.debug) {
                this.log().info("Unlocked entry lock on region " + aRegion.getName() + ", key " + name);
            }
        } else {
            if (!DLockUtil.hasLock(name)) {
                throw new DLockTestException("Attempt to unlock unlocked object " + name);
            }
            if (this.debug) {
                this.log().info("Unlocking lock on " + name);
            }
            DLockUtil.unlock(name);
            if (this.debugFine) {
                this.log().fine("Unlocked " + name);
            }
        }
        this.counters.increment(DLockBlackboard.hasNoLock);
    }

    @Override
    public abstract void read(Region var1, Object var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Region region, Object name) {
        if (this.debug) {
            this.log().info("Updating " + name);
        }
        Object newobj = null;
        BaseWrapper baseWrapper = this;
        synchronized (baseWrapper) {
            if (this.debug) {
                this.log().info("Getting " + name);
            }
            Object oldobj = CacheUtil.get(region, name);
            if (this.debugFine) {
                this.log().fine("Got " + name + ": " + oldobj.getClass().getName());
            }
            newobj = this.update(oldobj);
            if (this.debugFine) {
                this.log().fine("New value for " + name + " is " + newobj.getClass().getName());
            }
            CacheUtil.put(region, name, newobj);
            if (this.debug) {
                this.log().info("Updated " + name + ": changed " + oldobj.getClass().getName() + " to " + newobj.getClass().getName());
            }
        }
        this.noteUpdate();
    }

    protected abstract Object update(Object var1);

    protected abstract void noteUpdate();

    @Override
    public abstract void validate(Region var1, Info var2);

    public String toString(Region region, Object name) {
        StringBuffer buf = new StringBuffer(200);
        buf.append(region.getName() + ":" + name).append(" = ").append(CacheUtil.get(region, name));
        return buf.toString();
    }

    protected LogWriter log() {
        return Log.getLogWriter();
    }
}

