/*
 * Decompiled with CFR 0.152.
 */
package dlock.lockable;

import com.gemstone.gemfire.cache.Region;
import dlock.DLockBlackboard;
import dlock.DLockTestException;
import dlock.Info;
import dlock.lockable.BaseWrapper;
import dlock.lockable.Counter;
import util.CacheUtil;

public class ArrayOfObjectWrapper
extends BaseWrapper {
    @Override
    public void createDataInCache(Region region, Object name) {
        Object[] obj = new Object[100];
        for (int i = 0; i < 100; ++i) {
            obj[i] = new Counter();
        }
        CacheUtil.put(region, name, obj);
    }

    @Override
    public void read(Region region, Object name) {
        Object[] obj = (Object[])CacheUtil.get(region, name);
        this.counters.increment(DLockBlackboard.ArrayOfObjectReads);
    }

    @Override
    protected Object update(Object obj) {
        Object[] newobj = (Object[])obj;
        for (int i = 0; i < newobj.length; ++i) {
            ((Counter)newobj[i]).increment();
        }
        return newobj;
    }

    @Override
    protected void noteUpdate() {
        this.counters.increment(DLockBlackboard.ArrayOfObjectUpdates);
    }

    @Override
    public void validate(Region region, Info info) {
        Object[] obj = (Object[])CacheUtil.get(region, info.getName());
        for (int i = 0; i < obj.length; ++i) {
            if ((long)((Counter)obj[i]).value() == info.getUpdates()) continue;
            throw new DLockTestException("Object data is invalid for " + info.getName() + " with expected count " + info.getUpdates() + ": " + obj);
        }
    }
}

