/*
 * Decompiled with CFR 0.152.
 */
package dlock;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import dlock.BasicDLockClient;
import dlock.DLockBlackboard;
import dlock.DLockPrms;
import dlock.DLockTestException;
import hydra.ClientVmMgr;
import hydra.ClientVmNotFoundException;
import hydra.ConfigHashtable;
import hydra.DistributedConnectionMgr;
import hydra.GsRandom;
import hydra.Log;
import hydra.TestConfig;
import hydra.blackboard.SharedCounters;
import java.util.concurrent.locks.Lock;
import util.CacheUtil;
import util.TestException;

public class GrantorTest {
    private static Region TheRegion;
    public static final String ROOT_REGION_NAME = "DLockRegion";

    public static void becomeGrantorTask() {
        GrantorTest testInstance = new GrantorTest();
        testInstance.becomeGrantorTaskWork();
    }

    private void becomeGrantorTaskWork() {
        if (CacheUtil.getCache() == null) {
            BasicDLockClient.createCacheTask();
        }
        if ((TheRegion = CacheUtil.getCache().getRegion(ROOT_REGION_NAME)) == null) {
            throw new TestException("becomeGrantorTask failed to get region");
        }
        int sleepMs = 2000;
        try {
            if (sleepMs > 0) {
                Thread.sleep(sleepMs);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (((DistributedRegion)TheRegion).getLockService().isLockGrantor()) {
            GrantorTest.log().info("becomeLockGrantor...I am already the lock grantor");
        } else {
            GrantorTest.log().info("becomeLockGrantor...I am not already the LockGrantor, request becomeLockGrantor");
            TheRegion.becomeLockGrantor();
        }
        if (((DistributedRegion)TheRegion).getLockService().isLockGrantor()) {
            GrantorTest.log().info("becomeLockGrantor...I am the lock grantor");
        } else {
            GrantorTest.log().info("becomeLockGrantor...I am not the LockGrantor");
        }
    }

    public static void crashGrantorTask() throws ClientVmNotFoundException {
        GrantorTest testInstance = new GrantorTest();
        testInstance.crashGrantorTaskWork();
    }

    private void crashGrantorTaskWork() throws ClientVmNotFoundException {
        int crashGrantorPercent = GrantorTest.tab().intAt(DLockPrms.crashGrantorPercent);
        int crashViaKillPercent = GrantorTest.tab().intAt(DLockPrms.crashViaKillPercent);
        GrantorTest.log().info("### Determining whether to crash grantor...");
        GsRandom randGen = new GsRandom();
        if (randGen.nextInt(1, 100) <= crashGrantorPercent) {
            this.becomeGrantorTaskWork();
            if (randGen.nextInt(1, 100) <= crashViaKillPercent) {
                ClientVmMgr.stopAsync("Crashing grantor via kill", -21, -32);
            } else {
                GrantorTest.log().info("Crashing grantor via disconnect");
                DistributedConnectionMgr.disconnect();
                BasicDLockClient.closeCacheTask();
            }
        }
    }

    public static void countGrantorsTask() {
        GrantorTest testInstance = new GrantorTest();
        testInstance.countGrantors();
    }

    private void countGrantors() {
        if (CacheUtil.getCache() == null) {
            BasicDLockClient.createCacheTask();
        }
        if ((TheRegion = CacheUtil.getCache().getRegion(ROOT_REGION_NAME)) == null) {
            throw new TestException("countGrantorTask failed to get region");
        }
        GrantorTest.log().info("counting lock grantors");
        if (((DistributedRegion)TheRegion).getLockService().isLockGrantor()) {
            GrantorTest.log().info("is Lock Grant ... incrementing count");
            DLockBlackboard bb = DLockBlackboard.getInstance();
            SharedCounters sc = bb.getSharedCounters();
            sc.increment(DLockBlackboard.NumGrantors);
        }
    }

    public static void validateTask() {
        DLockBlackboard bb = DLockBlackboard.getInstance();
        SharedCounters sc = bb.getSharedCounters();
        int numGrantors = (int)sc.read(DLockBlackboard.NumGrantors);
        if (numGrantors > 1) {
            String s = "ValidateTask failed.  Expected 1 Grantor, but found: " + numGrantors;
            throw new DLockTestException(s);
        }
    }

    public static void forceGrantorSelectionTask() {
        GrantorTest testInstance = new GrantorTest();
        testInstance.forceGrantorSelectionTaskWork();
    }

    private void forceGrantorSelectionTaskWork() {
        if (CacheUtil.getCache() == null) {
            BasicDLockClient.createCacheTask();
        }
        if ((TheRegion = CacheUtil.getCache().getRegion(ROOT_REGION_NAME)) == null) {
            throw new TestException("forceGrantorSelectionTask failed to get Regoin");
        }
        Lock lock = TheRegion.getDistributedLock((Object)"forceGrantorSelectionTaskWork");
        lock.lock();
        lock.unlock();
    }

    protected static LogWriter log() {
        return Log.getLogWriter();
    }

    protected static ConfigHashtable tab() {
        return TestConfig.tab();
    }
}

