/*
 * Decompiled with CFR 0.152.
 */
package diskReg;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.DiskStoreFactory;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import diskReg.DiskRegBB;
import diskReg.DiskRegListener;
import diskReg.DiskRegLoader;
import diskReg.DiskRegPrms;
import diskReg.DiskRegRecoveryTest;
import hydra.CacheHelper;
import hydra.ConfigPrms;
import hydra.DiskStoreHelper;
import hydra.Log;
import hydra.RegionDescription;
import hydra.RegionHelper;
import hydra.RemoteTestModule;
import hydra.StopSchedulingTaskOnClientOrder;
import hydra.TestConfig;
import java.io.File;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import util.BaseValueHolder;
import util.CacheBB;
import util.CacheUtil;
import util.NameBB;
import util.NameFactory;
import util.RandomValues;
import util.RegionDefinition;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;
import util.Validator;
import util.ValueHolder;

public abstract class DiskRegTest
implements Serializable {
    public static DiskRegTest testInstance;
    protected static RegionAttributes attr;
    protected static String regionConfig;
    protected static final String REGION_NAME = "diskRegion";
    protected static final int KEY_LENGTH = 20;
    protected static final int NO_DISK = 1;
    protected static final int DISK_FOR_OVRFLW = 2;
    protected static final int DISK_FOR_PERSIST = 3;
    protected static final int DISK_FOR_OVRFLW_PERSIST = 4;
    protected static final int ADD_OPERATION = 1;
    protected static final int UPDATE_OPERATION = 2;
    protected static final int INVALIDATE_OPERATION = 3;
    protected static final int DESTROY_OPERATION = 4;
    protected static final int READ_OPERATION = 5;
    protected static final int LOCAL_INVALIDATE_OPERATION = 6;
    protected static final int LOCAL_DESTROY_OPERATION = 7;
    protected static final int PUT_IF_ABSENT = 8;
    protected static final int REPLACE = 9;
    protected static final int REMOVE = 10;
    protected int lowerThreshold;
    protected int upperThreshold;
    protected Region aRegion;
    protected RandomValues randomValues;
    protected int regionKind;
    protected int numVMs;
    protected boolean persistBackup;
    protected int evictionLimit;
    protected long numDiskDirs;
    protected String lruKind;
    protected boolean isReplicated;
    protected static String spaceKey;

    protected void initialize() {
        if (!(this instanceof DiskRegRecoveryTest)) {
            boolean useComplexObject = TestConfig.tab().booleanAt(DiskRegPrms.useComplexObject);
            DiskRegBB.getBB().getSharedMap().put("useComplexObject", new Boolean(useComplexObject));
            this.randomValues = new RandomValues();
        }
        this.numVMs = TestHelper.getNumVMs();
        CacheHelper.createCache(ConfigPrms.getCacheConfig());
        regionConfig = (String)DiskRegBB.getBB().getSharedMap().get(DiskRegBB.REGION_CONFIG_NAME);
        attr = RegionHelper.getRegionAttributes(regionConfig);
        AttributesFactory attrFact = RegionHelper.getAttributesFactory(regionConfig);
        boolean useBackupDiskDirs = TestConfig.tasktab().booleanAt(DiskRegPrms.useBackupDiskDirs, TestConfig.tab().booleanAt(DiskRegPrms.useBackupDiskDirs, false));
        if (useBackupDiskDirs) {
            String dirListKey = new String(RemoteTestModule.getMyClientName() + "_" + DiskRegBB.BACKUP_DIR_LIST);
            File[] diskDirArr = new File[((File[])DiskRegBB.getBB().getSharedMap().get(dirListKey)).length];
            diskDirArr = (File[])DiskRegBB.getBB().getSharedMap().get(dirListKey);
            Log.getLogWriter().info("In HydraTask_recoveryEndTask: got BACKUP_DIR_LIST from BB " + diskDirArr + " with key = " + dirListKey);
            if (diskDirArr != null) {
                DiskStoreFactory dsFactory = DiskStoreHelper.getDiskStoreFactory(attr.getDiskStoreName());
                Log.getLogWriter().info("Setting disk dirs to " + diskDirArr);
                dsFactory.setDiskDirs(diskDirArr);
                attrFact.setDiskStoreName(attr.getDiskStoreName());
                dsFactory.create(attr.getDiskStoreName());
            }
        } else {
            DiskStoreFactory dsFactory = DiskStoreHelper.getDiskStoreFactory(attr.getDiskStoreName());
            DiskStore ds = dsFactory.create(attr.getDiskStoreName());
            if (ds.getDiskDirs() != null) {
                String dirListKey = new String(RemoteTestModule.getMyClientName() + "_" + DiskRegBB.BACKUP_DIR_LIST);
                DiskRegBB.getBB().getSharedMap().put(dirListKey, ds.getDiskDirs());
                Log.getLogWriter().info("put BACKUP_DIR_LIST to DiskRegBB sharedMap " + ds.getDiskDirs() + " with key = " + dirListKey);
            }
        }
        attr = attrFact.create();
        RegionDescription reg = RegionHelper.getRegionDescription(regionConfig);
        String regionName = reg.getRegionName();
        this.aRegion = CacheHelper.getCache().createRegion(regionName, attr);
        Log.getLogWriter().info("A region with the following attributes is created:-" + attr.toString());
        this.persistBackup = false;
        this.persistBackup = attr.getDataPolicy().isPersistentReplicate();
        this.evictionLimit = 0;
        try {
            this.evictionLimit = attr.getEvictionAttributes().getMaximum();
        }
        catch (Exception e) {
            this.evictionLimit = (int)this.aRegion.getCache().getResourceManager().getEvictionHeapPercentage();
        }
        this.numDiskDirs = 0L;
        this.numDiskDirs = DiskStoreHelper.getDiskStore(attr.getDiskStoreName()).getDiskDirs().length;
        this.regionKind = this.persistBackup ? (this.evictionLimit <= 0 ? 3 : 4) : (this.evictionLimit <= 0 ? 1 : 2);
        this.isReplicated = false;
        if (attr.getDataPolicy().withPersistence()) {
            this.isReplicated = true;
        }
    }

    public static void HydraTask_doEntryOperations() {
        long timeToRunSec = TestConfig.tab().intAt(TestHelperPrms.minTaskGranularitySec);
        long timeToRunMS = timeToRunSec * 1000L;
        int endTestOnNumKeysInRegion = TestConfig.tab().intAt(DiskRegPrms.endTestOnNumKeysInRegion, -1);
        Log.getLogWriter().info("In HydraTask_doEntryOperations for " + timeToRunSec + " seconds, endTestOnNumKeysInRegion is " + endTestOnNumKeysInRegion);
        long startTime = System.currentTimeMillis();
        do {
            testInstance.doEntryOperations();
        } while (System.currentTimeMillis() - startTime < timeToRunMS);
        Log.getLogWriter().info("In HydraTask_doEntryOperations, done running for " + timeToRunSec + " seconds");
        if (endTestOnNumKeysInRegion > -1) {
            int numKeys = DiskRegTest.testInstance.aRegion.keySet().size();
            Log.getLogWriter().info("Current numKeys is " + numKeys + ", endTestOnNumKeysInRegion is " + endTestOnNumKeysInRegion);
            if (numKeys >= endTestOnNumKeysInRegion) {
                throw new StopSchedulingTaskOnClientOrder("Workload based test has " + numKeys + " keys in region, endTestOnNumKeysInRegion is " + endTestOnNumKeysInRegion);
            }
        }
    }

    protected void doEntryOperations() {
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        long startTime = System.currentTimeMillis();
        this.lowerThreshold = TestConfig.tab().intAt(DiskRegPrms.lowerThreshold, -1);
        this.upperThreshold = TestConfig.tab().intAt(DiskRegPrms.upperThreshold, Integer.MAX_VALUE);
        do {
            DiskRegTest.checkForEventError();
            int whichOp = this.getOperation(DiskRegPrms.entryOperations);
            int size = this.aRegion.size();
            if (size >= this.upperThreshold) {
                whichOp = this.getOperation(DiskRegPrms.upperThresholdOperations);
            } else if (size <= this.lowerThreshold) {
                whichOp = this.getOperation(DiskRegPrms.lowerThresholdOperations);
            }
            switch (whichOp) {
                case 1: {
                    this.addEntry();
                    break;
                }
                case 3: {
                    this.invalidateEntry(false);
                    break;
                }
                case 4: {
                    this.destroyEntry(false);
                    break;
                }
                case 2: {
                    this.updateEntry();
                    break;
                }
                case 5: {
                    this.readEntry();
                    break;
                }
                case 6: {
                    this.invalidateEntry(true);
                    break;
                }
                case 7: {
                    this.destroyEntry(true);
                    break;
                }
                case 8: {
                    this.putIfAbsent();
                    break;
                }
                case 9: {
                    this.replace();
                    break;
                }
                case 10: {
                    this.remove();
                    break;
                }
                default: {
                    throw new TestException("Unknown operation " + whichOp);
                }
            }
        } while (System.currentTimeMillis() - startTime < minTaskGranularityMS);
    }

    protected void addEntries() {
        long timeToRunSec = TestConfig.tab().intAt(TestHelperPrms.minTaskGranularitySec);
        long timeToRunMS = timeToRunSec * 1000L;
        Log.getLogWriter().info("In addEntries, adding for " + timeToRunSec + " seconds");
        long startTime = System.currentTimeMillis();
        do {
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                this.putIfAbsent();
                continue;
            }
            this.addEntry();
        } while (System.currentTimeMillis() - startTime < timeToRunMS);
        Log.getLogWriter().info("In addEntries, done running for " + timeToRunSec + " seconds");
    }

    protected Object[] addEntry() {
        Object key = this.getNewKey();
        Object value = null;
        boolean useCacheLoader = this.useCacheLoader();
        if (useCacheLoader) {
            String aStr = key + " in " + REGION_NAME;
            Log.getLogWriter().info("Getting " + aStr);
            value = this.aRegion.get(key);
            Log.getLogWriter().info("Done getting " + aStr);
        } else {
            value = this.getNewValue(key);
            String aStr = "\"" + key + "\" with value " + TestHelper.toString(value) + " in " + REGION_NAME;
            Log.getLogWriter().info("Putting " + aStr);
            this.aRegion.put(key, value);
            Log.getLogWriter().info("Done putting " + aStr);
        }
        DiskRegTest.checkForEventError();
        return new Object[]{key, value, new Boolean(useCacheLoader)};
    }

    protected Object[] putIfAbsent() {
        Object key = this.getNewKey();
        Object value = null;
        value = this.getNewValue(key);
        String aStr = "\"" + key + "\" with value " + TestHelper.toString(value) + " in " + REGION_NAME;
        Log.getLogWriter().info("executing putIfAbsent " + aStr);
        Object oldVal = this.aRegion.putIfAbsent(key, value);
        Log.getLogWriter().info("putIfAbsent " + aStr + " returns " + oldVal);
        DiskRegTest.checkForEventError();
        return new Object[]{key, value, new Boolean(false)};
    }

    protected void invalidateEntry(boolean isLocalInvalidate) {
        Object key = this.getOldOrRecentKey();
        if (key == null) {
            Log.getLogWriter().info("invalidateEntry: Unable to get key from region");
            return;
        }
        try {
            if (isLocalInvalidate) {
                Log.getLogWriter().info("invalidateEntry: local invalidate for " + key);
                this.aRegion.localInvalidate(key);
                Log.getLogWriter().info("invalidateEntry: done with local invalidate for " + key);
            } else {
                Log.getLogWriter().info("invalidateEntry: invalidating key " + key);
                this.aRegion.invalidate(key);
                Log.getLogWriter().info("invalidateEntry: done invalidating key " + key);
            }
        }
        catch (EntryNotFoundException e) {
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
            return;
        }
    }

    protected void destroyEntry(boolean isLocalDestroy) {
        Object key = this.getOldOrRecentKey();
        if (key == null) {
            Log.getLogWriter().info("destroyEntry: Unable to get key from region");
            return;
        }
        try {
            if (isLocalDestroy) {
                Log.getLogWriter().info("destroyObject: local destroy for " + key);
                this.aRegion.localDestroy(key);
                Log.getLogWriter().info("destroyObject: done with local destroy for " + key);
            } else {
                Log.getLogWriter().info("destroyObject: destroying key " + key);
                this.aRegion.destroy(key);
                Log.getLogWriter().info("destroyObject: done destroying key " + key);
            }
        }
        catch (EntryNotFoundException e) {
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
            return;
        }
    }

    protected void remove() {
        Object key = this.getOldOrRecentKey();
        if (key == null) {
            Log.getLogWriter().info("remove: Unable to get key from region");
            return;
        }
        try {
            Log.getLogWriter().info("remove: removing key " + key);
            boolean removed = this.aRegion.remove(key, this.aRegion.get(key));
            Log.getLogWriter().info("remove " + key + " returned " + removed);
        }
        catch (EntryNotFoundException e) {
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
            return;
        }
    }

    protected void updateEntry() {
        Object key = this.getOldOrRecentKey();
        if (key == null) {
            Log.getLogWriter().info("updateEntry: Unable to get key from region");
            return;
        }
        Log.getLogWriter().info("In updateEntry, getting value for key " + key);
        Object anObj = this.aRegion.get(key);
        Log.getLogWriter().info("In updateEntry, done getting value for key " + key);
        Object newObj = this.getUpdateObject((String)key);
        Log.getLogWriter().info("updateEntry: replacing key " + key + " with " + TestHelper.toString(newObj) + "; old value is " + TestHelper.toString(anObj));
        this.aRegion.put(key, newObj);
        Log.getLogWriter().info("Done with call to put (update)");
    }

    protected void replace() {
        Object key = this.getOldOrRecentKey();
        if (key == null) {
            Log.getLogWriter().info("replace: Unable to get key from region");
            return;
        }
        Log.getLogWriter().info("In replace, getting value for key " + key);
        Object anObj = this.aRegion.get(key);
        Log.getLogWriter().info("In replace, done getting value for key " + key);
        Object newObj = this.getUpdateObject((String)key);
        Log.getLogWriter().info("replace: replacing key " + key + " with " + TestHelper.toString(newObj) + "; old value is " + TestHelper.toString(anObj));
        this.aRegion.replace(key, newObj);
        Log.getLogWriter().info("Done with call to replace");
    }

    protected void readEntry() {
        int RANGE = 50;
        this.randomGet(50);
    }

    protected Object[] randomGet(int range) {
        Object key = this.getPreviousKey(range);
        if (key == null) {
            return null;
        }
        boolean containsKeyBeforeGet = this.aRegion.containsKey(key);
        String aStr = key + " in " + REGION_NAME;
        Log.getLogWriter().info("Getting previous key " + aStr);
        Object value = this.aRegion.get(key);
        Log.getLogWriter().info("Done getting " + aStr);
        return new Object[]{key, value, new Boolean(containsKeyBeforeGet)};
    }

    public Object getNewKey() {
        String key = DiskRegTest.getFixedLengthKeyForName(NameFactory.getNextPositiveObjectName());
        return key;
    }

    public Object getNewValue(Object key) {
        if (((Boolean)DiskRegBB.getBB().getSharedMap().get("useComplexObject")).booleanValue()) {
            return new ValueHolder((String)key, this.randomValues);
        }
        return this.randomValues.getRandomObjectGraph();
    }

    public CacheListener getEventListener() {
        return new DiskRegListener();
    }

    public Object getPreviousKey(int range) {
        long currentNameCounter = NameFactory.getPositiveNameCounter();
        if (currentNameCounter <= 0L) {
            return null;
        }
        long lowEnd = currentNameCounter - (long)range;
        if (lowEnd <= 0L) {
            lowEnd = 1L;
        }
        long previousNameCounter = TestConfig.tab().getRandGen().nextLong(lowEnd, currentNameCounter);
        return DiskRegTest.getFixedLengthKeyForName(NameFactory.getObjectNameForCounter(previousNameCounter));
    }

    protected static void checkForEventError() {
        TestHelper.checkForEventError(DiskRegBB.getBB());
    }

    protected CacheLoader getCacheLoader() {
        return new DiskRegLoader();
    }

    protected static String getFixedLengthKeyForName(String name) {
        StringBuffer sb = new StringBuffer(spaceKey);
        sb.replace(0, name.length(), name);
        if (sb.length() != 20) {
            throw new TestException("Expected key to be length 20, but it is " + TestHelper.toString(sb));
        }
        return sb.toString();
    }

    public String toVerboseString() {
        StringBuffer aStr = new StringBuffer();
        aStr.append("Test instance " + super.toString() + "\n");
        aStr.append("     persistBackup: " + this.persistBackup + "\n");
        aStr.append("     evictionLimit: " + this.evictionLimit + "\n");
        aStr.append("     numDiskDirs: " + this.numDiskDirs + "\n");
        aStr.append("     regionKind: " + this.regionKindToString(this.regionKind) + "\n");
        aStr.append("     lruKind: " + this.lruKind + "\n");
        return aStr.toString();
    }

    protected String regionKindToString(int kind) {
        switch (kind) {
            case 1: {
                return "No disk";
            }
            case 2: {
                return "Disk for overflow";
            }
            case 3: {
                return "Disk for persistence";
            }
            case 4: {
                return "Disk for overflow and persistence";
            }
        }
        throw new TestException("unknown region kind " + kind);
    }

    protected int getOperation(Long whichPrm) {
        long limit = 60000L;
        long startTime = System.currentTimeMillis();
        int op = 0;
        do {
            String operation;
            if ((operation = TestConfig.tab().stringAt(whichPrm)).equals("add")) {
                op = 1;
            } else if (operation.equals("update")) {
                op = 2;
            } else if (operation.equals("invalidate")) {
                op = 3;
            } else if (operation.equals("destroy")) {
                op = 4;
            } else if (operation.equals("read")) {
                op = 5;
            } else if (operation.equals("localInvalidate")) {
                op = 6;
            } else if (operation.equals("localDestroy")) {
                op = 7;
            } else if (operation.equalsIgnoreCase("putIfAbsent")) {
                op = 8;
            } else if (operation.equalsIgnoreCase("replace")) {
                op = 9;
            } else if (operation.equalsIgnoreCase("remove")) {
                op = 10;
            } else {
                throw new TestException("Unknown operation: " + operation);
            }
            if (System.currentTimeMillis() - startTime <= limit) continue;
            throw new TestException("Could not find an operation in " + limit + " millis; disallowLocalEntryOps is " + true + "; check that the operations list has allowable choices");
        } while (this.isReplicated && (op == 6 || op == 7));
        return op;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Object getOldOrRecentKey() {
        int RANGE = 50;
        Object key = null;
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            Log.getLogWriter().info("Getting key by iteration...");
            Set aSet = this.aRegion.keys();
            if (aSet.size() == 0) {
                Log.getLogWriter().info("No keys in region");
                return null;
            }
            Iterator it = aSet.iterator();
            if (!it.hasNext()) {
                Log.getLogWriter().info("Unable to get key from region");
                return null;
            }
            key = it.next();
        } else {
            Log.getLogWriter().info("Getting recent key...");
            key = this.getPreviousKey(50);
            if (key == null) {
                Log.getLogWriter().info("Unable to get key from region");
                return null;
            }
        }
        Log.getLogWriter().info("Returning key from getOldOrRecentKey " + key);
        return key;
    }

    protected Object getUpdateObject(String key) {
        boolean useComplexObject = (Boolean)DiskRegBB.getBB().getSharedMap().get("useComplexObject");
        if (useComplexObject) {
            BaseValueHolder anObj = (BaseValueHolder)this.aRegion.get((Object)key);
            BaseValueHolder newObj = anObj == null ? new ValueHolder(key, this.randomValues) : anObj.getAlternateValueHolder(this.randomValues);
            return newObj;
        }
        return this.getNewValue(key);
    }

    protected static void removeDiskRegionFiles() {
        FilenameFilter dirFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                File aFile = new File(name);
                return aFile.isDirectory();
            }
        };
        FilenameFilter htreeFileFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".lg") || name.endsWith(".db");
            }
        };
        String currDirStr = System.getProperty("user.dir");
        File currDir = new File(currDirStr);
        File[] dirList = currDir.listFiles(dirFilter);
        for (int i = 0; i < dirList.length; ++i) {
            File aDir = dirList[i];
            File[] htreeFileList = aDir.listFiles(htreeFileFilter);
            for (int j = 0; j < htreeFileList.length; ++j) {
                File htreeFile = htreeFileList[j];
                Log.getLogWriter().info(htreeFile.getAbsolutePath() + " is " + htreeFile.length() + " bytes");
                boolean result = htreeFile.delete();
                if (result) {
                    Log.getLogWriter().info("Removed " + htreeFile.getAbsolutePath());
                    continue;
                }
                Log.getLogWriter().info("Was unable to remove " + htreeFile.getAbsolutePath());
            }
        }
    }

    public static void HydraTask_endTask() {
        DiskRegTest.removeDiskRegionFiles();
        CacheHelper.createCache(ConfigPrms.getCacheConfig());
        NameBB.getBB().printSharedCounters();
        DiskRegBB.getBB().printSharedMap();
        DiskRegBB.getBB().printSharedCounters();
        DiskRegTest.checkForEventError();
    }

    protected static Region setupForRecovery(String regionName) {
        CacheUtil.createCache();
        NameBB.getBB().printSharedCounters();
        DiskRegBB.getBB().printSharedMap();
        DiskRegBB.getBB().printSharedCounters();
        DiskRegTest.checkForEventError();
        String dirListKey = new String(RemoteTestModule.getMyClientName() + "_" + DiskRegBB.BACKUP_DIR_LIST);
        ArrayList diskDirList = (ArrayList)DiskRegBB.getBB().getSharedMap().get(dirListKey);
        Log.getLogWriter().fine("In HydraTask_recoveryEndTask: got BACKUP_DIR_LIST from BB " + diskDirList + " with key = " + dirListKey);
        if (diskDirList == null) {
            Log.getLogWriter().info("There is no backup directory for this VM to attach to");
            return null;
        }
        RegionDefinition regDef = RegionDefinition.createRegionDefinition();
        regDef.setPersistBackup(true);
        regDef.setDiskDirList(diskDirList);
        regDef.setNumDiskDirs(diskDirList.size());
        regDef.setEviction("overflowToDisk");
        regDef.setEvictionLimit(10);
        Region aRegion = regDef.createRootRegion(CacheUtil.getCache(), regionName, null, null, null);
        return aRegion;
    }

    public static void HydraTask_mirrorKeysEndTask() {
        Region aRegion = DiskRegTest.setupForRecovery("mirrorTestRegion");
        if (aRegion == null) {
            return;
        }
        Validator val = new Validator();
        if (RemoteTestModule.getMyClientName().equals("negativeClient")) {
            val.setContainsKeyCategory(1);
        } else if (RemoteTestModule.getMyClientName().equals("positiveClient")) {
            val.setContainsKeyCategory(0);
        } else {
            val.setContainsKeyCategory(2);
        }
        val.setContainsValueForKeyCategory(3);
        val.setDoGetStrategy(4);
        val.setValueShouldBeNull(7);
        val.setStableKeys(true);
        val.setWaitForContainsKey(false);
        val.setWaitForContainsValueForKey(false);
        val.setThrowOnFirstError(false);
        val.setBlackboard(CacheBB.getBB());
        Object[] objArr = val.validateRegionContents(aRegion);
        int numKeys = (Integer)objArr[0];
        int numValues = (Integer)objArr[1];
        Log.getLogWriter().info("Validated " + numKeys + " entries");
    }

    public boolean useCacheLoader() {
        if (DiskRegBB.fixUseCacheLoader()) {
            return DiskRegBB.useCacheLoader();
        }
        return TestConfig.tab().booleanAt(DiskRegPrms.useCacheLoader);
    }

    static {
        spaceKey = null;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 20; ++i) {
            sb.append(" ");
        }
        spaceKey = sb.toString();
    }
}

