/*
 * Decompiled with CFR 0.152.
 */
package deltagii;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.cache.DiskRegion;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.InitialImageOperation;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.TombstoneService;
import com.gemstone.gemfire.pdx.PdxInstance;
import deltagii.DeltaGIIBB;
import deltagii.DeltaGIIPrms;
import hydra.BridgeHelper;
import hydra.BridgePrms;
import hydra.CacheHelper;
import hydra.ClientVmMgr;
import hydra.ClientVmNotFoundException;
import hydra.ConfigPrms;
import hydra.DiskStoreDescription;
import hydra.DistributedSystemBlackboard;
import hydra.DistributedSystemHelper;
import hydra.GatewayHubBlackboard;
import hydra.GatewayHubHelper;
import hydra.HydraSubthread;
import hydra.HydraThreadLocal;
import hydra.Log;
import hydra.MasterController;
import hydra.PoolDescription;
import hydra.ProcessMgr;
import hydra.RegionDescription;
import hydra.RegionHelper;
import hydra.RemoteTestModule;
import hydra.StopSchedulingOrder;
import hydra.StopSchedulingTaskOnClientOrder;
import hydra.TestConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import parReg.ParRegUtil;
import pdx.PdxTest;
import util.BaseValueHolder;
import util.NameBB;
import util.NameFactory;
import util.RandomValues;
import util.StopStartPrms;
import util.StopStartVMs;
import util.SummaryLogListener;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;
import util.VHDataSerializable;
import util.VHDataSerializableInstantiator;
import util.VHDataSerializer;
import util.ValueHolder;

public class DeltaGIITest {
    public static DeltaGIITest testInstance = null;
    private boolean isBridgeConfiguration;
    private boolean isBridgeClient;
    private RandomValues randomValues = new RandomValues();
    private boolean uniqueKeys = true;
    static Cache theCache = null;
    static Region theRegion = null;
    protected static HydraThreadLocal threadIsPaused = new HydraThreadLocal();
    protected static final String VMID = "vmid_";
    protected static final int ENTRY_ADD_OPERATION = 1;
    protected static final int ENTRY_DESTROY_OPERATION = 2;
    protected static final int ENTRY_INVALIDATE_OPERATION = 3;
    protected static final int ENTRY_LOCAL_DESTROY_OPERATION = 4;
    protected static final int ENTRY_LOCAL_INVALIDATE_OPERATION = 5;
    protected static final int ENTRY_UPDATE_OPERATION = 6;
    protected static final int ENTRY_GET_OPERATION = 7;
    protected static final int ENTRY_GET_NEW_OPERATION = 8;
    protected static final int ENTRY_PUTALL_OPERATION = 9;
    protected static final int CACHE_OPERATIONS = 10;
    protected static final int PUTS_FOR_KEY_ORDER_POLICY = 11;
    protected static final int CLEAR_REGION = 12;
    protected static final String getCallbackPrefix = "Get originated in pid ";
    protected static final String createCallbackPrefix = "Create event originated in pid ";
    protected static final String updateCallbackPrefix = "Update event originated in pid ";
    protected static final String invalidateCallbackPrefix = "Invalidate event originated in pid ";
    protected static final String destroyCallbackPrefix = "Destroy event originated in pid ";
    public static Object killSyncObject = new Object();

    public static synchronized void HydraTask_createLocator() throws Throwable {
        DistributedSystemHelper.createLocator();
    }

    public static synchronized void HydraTask_startLocatorAndDS() throws Throwable {
        DistributedSystemHelper.startLocatorAndDS();
    }

    public static void HydraTask_createGatewayHub() {
        String hubConfig = ConfigPrms.getGatewayHubConfig();
        Log.getLogWriter().info("Creating gateway hub with hub config: " + hubConfig);
        GatewayHubHelper.createGatewayHub(hubConfig);
    }

    public static void HydraTask_addGatewayHub() {
        String gatewayConfig = ConfigPrms.getGatewayConfig();
        Log.getLogWriter().info("Adding gateway with gateway config: " + gatewayConfig);
        GatewayHubHelper.addGateways(gatewayConfig);
    }

    public static void HydraTask_startGatewayHub() {
        Log.getLogWriter().info("Starting gateway hub");
        GatewayHubHelper.startGatewayHub();
    }

    public static void HydraTask_stopGatewayHub() {
        GatewayHubHelper.stopGatewayHub();
        GatewayHubBlackboard.getInstance().getSharedMap().clear();
        DistributedSystemBlackboard.getInstance().getSharedMap().clear();
    }

    public static synchronized void HydraTask_initialize() throws Throwable {
        PdxTest.initClassLoader();
        if (testInstance == null) {
            testInstance = new DeltaGIITest();
            testInstance.initializeInstance();
            testInstance.initializeRegion(ConfigPrms.getRegionConfig());
            if (DeltaGIITest.testInstance.isBridgeConfiguration) {
                DeltaGIITest.testInstance.isBridgeClient = false;
                BridgeHelper.startBridgeServer("bridge");
            }
        }
        testInstance.initializeInstancePerThread();
    }

    public static synchronized void HydraTask_initializeClient() throws Throwable {
        if (testInstance == null) {
            testInstance = new DeltaGIITest();
            testInstance.initializeInstance();
            testInstance.initializeRegion(ConfigPrms.getRegionConfig());
            if (DeltaGIITest.testInstance.isBridgeConfiguration) {
                DeltaGIITest.testInstance.isBridgeClient = true;
                Log.getLogWriter().info("Calling registerInterest for all keys, result interest policy KEYS_VALUES for region " + theRegion.getFullPath());
                theRegion.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.KEYS_VALUES);
                Log.getLogWriter().info("Done calling registerInterest for all keys, result interest policy KEYS_VALUES, " + theRegion.getFullPath() + " size is " + theRegion.size());
            }
        }
        testInstance.initializeInstancePerThread();
    }

    private void initializeRegion(String regionConfig) {
        String key = VMID + RemoteTestModule.getMyVmid();
        String xmlFileName = key + ".xml";
        File xmlFile = new File(xmlFileName);
        if (!xmlFile.exists()) {
            String cacheConfig = ConfigPrms.getCacheConfig();
            theCache = CacheHelper.createCache(cacheConfig);
            PoolDescription pd = RegionHelper.getRegionDescription(regionConfig).getPoolDescription();
            DiskStoreDescription dsd = RegionHelper.getRegionDescription(regionConfig).getDiskStoreDescription();
            String diskStoreName = null;
            if (dsd != null) {
                diskStoreName = dsd.getName();
            }
            Log.getLogWriter().info("About to generate xml, diskStoreName is " + diskStoreName);
            if (pd != null) {
                CacheHelper.generateCacheXmlFile(cacheConfig, null, regionConfig, null, null, pd.getName(), diskStoreName, null, xmlFileName);
            } else {
                CacheHelper.generateCacheXmlFile(cacheConfig, null, regionConfig, null, null, null, diskStoreName, null, xmlFileName);
            }
            CacheHelper.closeCache();
        }
        if ((theCache = CacheHelper.createCacheFromXml(xmlFileName)) == null) {
            throw new TestException("Unexpected null cache after creating with xmlFile " + xmlFileName);
        }
        RegionDescription rd = RegionHelper.getRegionDescription(regionConfig);
        theRegion = theCache.getRegion(rd.getRegionName());
        if (theRegion == null) {
            throw new TestException("Unexpected null region after creating with xmlFile " + xmlFileName);
        }
        Log.getLogWriter().info("Finished creating " + TestHelper.regionToString(theRegion, true) + " using " + xmlFile);
    }

    private void initializeInstance() {
        String giiStatePrm;
        this.isBridgeConfiguration = TestConfig.tab().vecAt(BridgePrms.names, null) != null;
        this.uniqueKeys = DeltaGIIPrms.getUseUniqueKeys();
        Log.getLogWriter().info("useUniqueKeys = " + this.uniqueKeys);
        if (DeltaGIIPrms.getRegisterSerializer()) {
            Log.getLogWriter().info("Registering " + VHDataSerializer.class.getName());
            DataSerializer.register(VHDataSerializer.class);
        }
        if ((giiStatePrm = TestConfig.tasktab().stringAt(DeltaGIIPrms.giiState, null)) != null) {
            DeltaGIIBB.getBB().getSharedMap().put("giiStatePrm", giiStatePrm);
            this.setupGetInitialImageTestCallbacks(giiStatePrm);
        }
    }

    private void initializeInstancePerThread() {
        threadIsPaused.set(new Boolean(false));
        int thisThreadID = RemoteTestModule.getCurrentThread().getThreadId();
        String mapKey = "uniqueKeyIndexForThread_" + thisThreadID;
        Object mapValue = DeltaGIIBB.getBB().getSharedMap().get(mapKey);
        if (mapValue == null) {
            DeltaGIIBB.getBB().getSharedMap().put(mapKey, thisThreadID);
        }
    }

    public void setupGetInitialImageTestCallbacks(String giiStatePrm) {
        Log.getLogWriter().info("Invoking setGIITestHook(" + giiStatePrm + ")");
        InitialImageOperation.GIITestHookType type = DeltaGIIPrms.getGIITestHookType(giiStatePrm);
        RegionDescription rd = RegionHelper.getRegionDescription(ConfigPrms.getRegionConfig());
        String regionName = rd.getRegionName();
        class GetInitialImageTestCallback
        extends InitialImageOperation.GIITestHook {
            public GetInitialImageTestCallback(InitialImageOperation.GIITestHookType type, String region_name) {
                super(type, region_name);
            }

            public void reset() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                long giiCallbackInvocations;
                Log.getLogWriter().info("Invoked the testhook run() method (See setupGetInitialImageTestCallbacks())");
                long executeKill = DeltaGIIBB.getBB().getSharedCounters().read(DeltaGIIBB.executeKill);
                if (executeKill == 1L && (giiCallbackInvocations = DeltaGIIBB.getBB().getSharedCounters().incrementAndRead(DeltaGIIBB.giiCallbackInvoked)) == 1L) {
                    Object object = killSyncObject;
                    synchronized (object) {
                        Log.getLogWriter().info("Notifying killSyncObject of deltagii");
                        killSyncObject.notify();
                    }
                    MasterController.sleepForMs(30000);
                }
            }
        }
        InitialImageOperation.setGIITestHook((InitialImageOperation.GIITestHook)new GetInitialImageTestCallback(type, regionName));
        Log.getLogWriter().info("Invoked setGIITestHook(" + giiStatePrm + " for " + regionName + ")");
    }

    public static void HydraTask_load() {
        testInstance.load();
    }

    private void load() {
        boolean allAddsCompleted = false;
        int finalKeyIndex = DeltaGIIPrms.numEntriesToLoad();
        Log.getLogWriter().info("Adding to region until biggest key has index " + finalKeyIndex);
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        long startTime = System.currentTimeMillis();
        int numCreated = 0;
        long nameCounter = 0L;
        while (System.currentTimeMillis() - startTime < minTaskGranularityMS && !allAddsCompleted) {
            String key = NameFactory.getNextPositiveObjectName();
            nameCounter = NameFactory.getCounterForName(key);
            ++numCreated;
            if (nameCounter <= (long)finalKeyIndex) {
                theRegion.put((Object)key, this.getValueForKey(key));
                continue;
            }
            allAddsCompleted = true;
        }
        if (allAddsCompleted) {
            throw new StopSchedulingTaskOnClientOrder("Put " + finalKeyIndex + " entries in " + theRegion.getName());
        }
        Log.getLogWriter().info("Created " + numCreated + " entries per region so far this task; number remaining to create " + ((long)finalKeyIndex - nameCounter));
    }

    public static void HydraTask_resetUniqueKeyIndex() {
        DeltaGIITest.resetUniqueKeyIndex();
    }

    public static void resetUniqueKeyIndex() {
        int myThreadId;
        long max = NameBB.getBB().getSharedCounters().read(NameBB.POSITIVE_NAME_COUNTER);
        int incValue = TestHelper.getNumThreads();
        int myKeyIndexValue = myThreadId = RemoteTestModule.getCurrentThread().getThreadId();
        while ((long)myKeyIndexValue < max) {
            myKeyIndexValue += incValue;
        }
        Log.getLogWriter().info("Setting this threads uniqueKeyIndex to " + myKeyIndexValue);
        DeltaGIIBB.getBB().getSharedMap().put("uniqueKeyIndexForThread_" + myThreadId, myKeyIndexValue);
    }

    public static void HydraTask_giiProvider() throws Throwable {
        if (testInstance == null) {
            DeltaGIIBB.getBB().getSharedCounters().increment(DeltaGIIBB.pausing);
            MasterController.sleepForMs(30000);
            throw new StopSchedulingOrder("Num provider executions is " + DeltaGIIBB.getBB().getSharedCounters().read(DeltaGIIBB.executionNumber));
        }
        testInstance.giiProvider();
    }

    private void giiProvider() throws Exception {
        Log.getLogWriter().info("deltaGiiProvider  starts ...");
        DeltaGIITest.logExecutionNumber();
        DeltaGIITest.checkForLastIteration();
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        Log.getLogWriter().info("Provider is sleeping for " + minTaskGranularityMS + " ms to allow other vms to do random ops...");
        MasterController.sleepForMs((int)minTaskGranularityMS);
        Log.getLogWriter().info("Provider is pausing...");
        DeltaGIIBB.getBB().getSharedCounters().increment(DeltaGIIBB.pausing);
        int numProviderThreads = TestConfig.getInstance().getThreadGroup("providerThreads").getTotalThreads();
        int numRequesterThreads = TestConfig.getInstance().getThreadGroup("requesterThreads").getTotalThreads();
        TestHelper.waitForCounter(DeltaGIIBB.getBB(), "DeltaGIIBB.pausing", DeltaGIIBB.pausing, numProviderThreads + numRequesterThreads, true, -1L, 2000L);
        SummaryLogListener.waitForSilence(30L, 1000L);
        long leader = DeltaGIIBB.getBB().getSharedCounters().incrementAndRead(DeltaGIIBB.leader);
        Log.getLogWriter().info("Provider is leader: " + leader);
        if (leader == 1L) {
            List requesterVMs = StopStartVMs.getAllVMs();
            requesterVMs = StopStartVMs.getMatchVMs(requesterVMs, "requester");
            ArrayList<String> stopModesList = new ArrayList<String>();
            for (Object vmInfo : requesterVMs) {
                stopModesList.add(TestConfig.tab().stringAt(StopStartPrms.stopModes));
            }
            Log.getLogWriter().info("Provider is stopping the requesters: " + requesterVMs);
            StopStartVMs.stopVMs(requesterVMs, stopModesList);
            DeltaGIIBB.getBB().getSharedCounters().zero(DeltaGIIBB.pausing);
            DeltaGIIBB.getBB().getSharedCounters().zero(DeltaGIIBB.writeSnapshot);
            DeltaGIIBB.getBB().getSharedCounters().zero(DeltaGIIBB.snapshotWritten);
            DeltaGIIBB.getBB().getSharedCounters().zero(DeltaGIIBB.clears);
            DeltaGIIBB.getBB().getSharedCounters().zero(DeltaGIIBB.doneVerifying);
            if (DeltaGIIPrms.providerDoesOps()) {
                Log.getLogWriter().info("Provider is executing providerOperations while requester vms are offline. Ops:" + DeltaGIIPrms.getProviderOperations());
                this.doOperations(DeltaGIIPrms.providerOperations, 10000L);
                Log.getLogWriter().info("Provider is done executing providerOperations while requester vms are offline. Ops:" + DeltaGIIPrms.getProviderOperations());
            }
            Log.getLogWriter().info("Provider is writing the snapshot");
            this.writeSnapshot();
            if (DeltaGIIPrms.doTombstoneGC()) {
                String regionName = theRegion.getName();
                if (theRegion.getAttributes().getDataPolicy().withPartitioning()) {
                    regionName = "partition-" + regionName;
                }
                TombstoneService ts = ((GemFireCacheImpl)theCache).getTombstoneService();
                int tombstoneCnt = DeltaGIITest.getStat_tombstones(regionName);
                Log.getLogWriter().info("Provider is attempting to GC tombstones. Before tombstoneCnt=" + tombstoneCnt);
                boolean result = ts.forceBatchExpirationForTests(tombstoneCnt);
                Log.getLogWriter().info("Provider is finished GCing tombstones. After tombstoneCnt=" + DeltaGIITest.getStat_tombstones(regionName) + " result=" + result);
            }
            List targetVMs = StopStartVMs.getAllVMs();
            targetVMs.removeAll(StopStartVMs.getMatchVMs(targetVMs, "provider"));
            DeltaGIIBB.getBB().getSharedCounters().increment(DeltaGIIBB.executeKill);
            DeltaGIITest.startCallbackMonitor();
            Log.getLogWriter().info("Provider is starting the requesters: " + targetVMs);
            StopStartVMs.startVMs(targetVMs);
            long counter = DeltaGIIBB.getBB().getSharedCounters().read(DeltaGIIBB.timeToStop);
            if (counter >= 1L) {
                throw new StopSchedulingOrder("It's time to stop the test, Provider execution number is " + DeltaGIIBB.getBB().getSharedCounters().read(DeltaGIIBB.executionNumber));
            }
            DeltaGIIBB.getBB().getSharedCounters().zero(DeltaGIIBB.leader);
        } else {
            DeltaGIITest.startCallbackMonitor();
            MasterController.sleepForMs(30000);
        }
    }

    private static void startCallbackMonitor() {
        Thread killThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Log.getLogWriter().info("startCallbackMonitor spawning HydraSubthread to wait on killSyncObject");
                String giiStatePrm = (String)DeltaGIIBB.getBB().getSharedMap().get("giiStatePrm");
                Object object = killSyncObject;
                synchronized (object) {
                    try {
                        Log.getLogWriter().info("killThread waiting on killSyncObject for giiStatePrm = " + giiStatePrm);
                        killSyncObject.wait();
                    }
                    catch (InterruptedException e) {
                        Log.getLogWriter().info("killThread interrupted: VM not killed");
                    }
                }
                Log.getLogWriter().info("product invoked GetInitialImageTestCallback, mean killing and restarting this VM ...");
                try {
                    ClientVmMgr.stopAsync("product invoked GetInitialImageTestCallback, killing this vm", -21, -30);
                }
                catch (ClientVmNotFoundException e) {
                    throw new TestException("Unexpected Exception " + e + " caught while attempting to recycle vm " + TestHelper.getStackTrace(e));
                }
            }
        }, "Test Callback Monitor");
        killThread = new HydraSubthread(killThread);
        killThread.start();
    }

    public static void HydraTask_giiRequester() throws Throwable {
        if (testInstance == null) {
            DeltaGIITest.startCallbackMonitor();
            DeltaGIITest.HydraTask_initialize();
            DeltaGIITest.HydraTask_verifyFromSnapshotAndSync();
            DeltaGIITest.HydraTask_verifyDeltaGII();
        }
        testInstance.giiRequester();
    }

    private void giiRequester() throws Exception {
        long pausing = DeltaGIIBB.getBB().getSharedCounters().read(DeltaGIIBB.pausing);
        Log.getLogWriter().info("deltaGiiRequester starts ... pausing=" + pausing);
        if (pausing > 0L) {
            if (((Boolean)threadIsPaused.get()).booleanValue()) {
                Log.getLogWriter().info("Requester thread has paused");
            } else {
                String regionName = theRegion.getName();
                if (theRegion.getAttributes().getDataPolicy().withPartitioning()) {
                    regionName = "partition-" + regionName;
                }
                int tombstoneCnt = DeltaGIITest.getStat_tombstones(regionName);
                String key = "tombstoneCount_thr" + RemoteTestModule.getCurrentThread().getThreadId();
                Log.getLogWriter().info("Requester thread is pausing, saving tombstone count: setting '" + key + "', to " + tombstoneCnt);
                threadIsPaused.set(new Boolean(true));
                DeltaGIIBB.getBB().getSharedMap().put(key, tombstoneCnt);
                DeltaGIIBB.getBB().getSharedCounters().increment(DeltaGIIBB.pausing);
            }
            MasterController.sleepForMs(5000);
        } else {
            long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
            long minTaskGranularityMS = minTaskGranularitySec * 1000L;
            Log.getLogWriter().info("Requester thread is gonna do operations...");
            this.doOperations(minTaskGranularityMS);
        }
    }

    public static synchronized void HydraTask_giiNewMember() throws Exception {
        if (testInstance == null) {
            ClientVmMgr.stop("Killing self (newMember): test restarts this VM on demand", -21, -31);
        } else {
            testInstance.giiNewMember();
        }
    }

    private void giiNewMember() throws Exception {
        Log.getLogWriter().info("giiNewMember starts ...");
        testInstance.initializeInstancePerThread();
        long pausing = DeltaGIIBB.getBB().getSharedCounters().read(DeltaGIIBB.pausing);
        if (pausing > 0L) {
            if (((Boolean)threadIsPaused.get()).booleanValue()) {
                Log.getLogWriter().info("Thread has paused");
            } else {
                Log.getLogWriter().info("This thread is pausing");
                threadIsPaused.set(new Boolean(true));
                DeltaGIIBB.getBB().getSharedCounters().increment(DeltaGIIBB.pausing);
            }
            MasterController.sleepForMs(5000);
        } else {
            MasterController.sleepForMs(30000);
        }
    }

    public static void HydraTask_writeSnapshot() {
        testInstance.writeSnapshot();
    }

    protected void writeSnapshot() {
        Log.getLogWriter().info("Preparing to write snapshot for " + theRegion.getName());
        HashMap regionSnapshot = new HashMap();
        for (Object key : theRegion.keySet()) {
            Object value = null;
            if (theRegion.containsValueForKey(key)) {
                value = theRegion.get(key);
            }
            if (value instanceof BaseValueHolder) {
                regionSnapshot.put(key, ((BaseValueHolder)value).myValue);
                continue;
            }
            if (value instanceof PdxInstance) {
                BaseValueHolder vh = PdxTest.toValueHolder(value);
                regionSnapshot.put(key, vh.myValue);
                continue;
            }
            regionSnapshot.put(key, value);
        }
        Log.getLogWriter().info("Region snapshot for " + theRegion.getFullPath() + " is size " + regionSnapshot.size() + " and contains keys " + regionSnapshot.keySet());
        DeltaGIIBB.getBB().getSharedMap().put("regionSnapshotKey", regionSnapshot);
        Log.getLogWriter().info("vm_" + RemoteTestModule.getMyVmid() + " wrote snapshot for " + theRegion.getName() + " into blackboard at key " + "regionSnapshotKey");
    }

    public static void HydraTask_verifyFromSnapshotAndSync() {
        PdxTest.initClassLoader();
        testInstance.verifyFromSnapshot();
        DeltaGIIBB.getBB().getSharedCounters().increment(DeltaGIIBB.doneVerifying);
        TestHelper.waitForCounter(DeltaGIIBB.getBB(), "DeltaGIIBB.doneVerifying", DeltaGIIBB.doneVerifying, RemoteTestModule.getCurrentThread().getCurrentTask().getTotalThreads(), true, -1L, 2000L);
    }

    public static void HydraTask_verifyFromSnapshot() {
        PdxTest.initClassLoader();
        testInstance.verifyFromSnapshot();
    }

    protected void verifyFromSnapshot() {
        Map regionSnapshot = (Map)DeltaGIIBB.getBB().getSharedMap().get("regionSnapshotKey");
        this.verifyFromSnapshot(theRegion, regionSnapshot);
    }

    public void verifyFromSnapshot(Region theRegion, Map regionSnapshot) {
        StringBuffer errStr = new StringBuffer();
        int snapshotSize = regionSnapshot.size();
        int regionSize = theRegion.size();
        long startVerifyTime = System.currentTimeMillis();
        Log.getLogWriter().info("Verifying " + theRegion.getFullPath() + " of size " + theRegion.size() + " against snapshot containing " + regionSnapshot.size() + " entries...");
        if (snapshotSize != regionSize) {
            ((LocalRegion)theRegion).dumpBackingMap();
            errStr.append("Expected region " + theRegion.getFullPath() + " to be size " + snapshotSize + ", but it is " + regionSize + "\n");
        }
        for (Object key : regionSnapshot.keySet()) {
            try {
                ParRegUtil.verifyContainsKey(theRegion, key, true);
            }
            catch (TestException e) {
                errStr.append(e.getMessage() + "\n");
            }
            boolean containsValueForKey = theRegion.containsValueForKey(key);
            Object expectedValue = regionSnapshot.get(key);
            try {
                ParRegUtil.verifyContainsValueForKey(theRegion, key, expectedValue != null);
            }
            catch (TestException e) {
                errStr.append(e.getMessage() + "\n");
            }
            if (!containsValueForKey) continue;
            try {
                Object actualValue = theRegion.get(key);
                if (actualValue instanceof BaseValueHolder) {
                    ParRegUtil.verifyMyValue(key, expectedValue, actualValue, ParRegUtil.EQUAL);
                    continue;
                }
                if (actualValue instanceof PdxInstance) {
                    actualValue = PdxTest.toValueHolder(actualValue);
                    ParRegUtil.verifyMyValue(key, expectedValue, actualValue, ParRegUtil.EQUAL);
                    continue;
                }
                if (actualValue instanceof byte[] && expectedValue instanceof byte[]) {
                    byte[] actual = (byte[])actualValue;
                    byte[] expected = (byte[])expectedValue;
                    if (actual.length == expected.length) continue;
                    throw new TestException("Expected value for key " + key + " to be " + TestHelper.toString(expectedValue) + ", but it is " + TestHelper.toString(actualValue));
                }
                throw new TestException("Expected value for key " + key + " to be " + TestHelper.toString(expectedValue) + ", but it is " + TestHelper.toString(actualValue));
            }
            catch (TestException e) {
                errStr.append(e.getMessage() + "\n");
            }
        }
        HashSet theRegionKeySet = new HashSet(theRegion.keySet());
        Set snapshotKeySet = regionSnapshot.keySet();
        theRegionKeySet.removeAll(snapshotKeySet);
        if (theRegionKeySet.size() != 0) {
            errStr.append("Found the following unexpected keys in " + theRegion.getFullPath() + ": " + theRegionKeySet + "\n");
        }
        if (errStr.length() > 0) {
            throw new TestException(errStr.toString());
        }
        Log.getLogWriter().info("Done verifying " + theRegion.getFullPath() + " from snapshot containing " + snapshotSize + " entries, verification took " + (System.currentTimeMillis() - startVerifyTime) + "ms");
    }

    public static void HydraTask_verifyPR() {
        StringBuffer aStr = new StringBuffer();
        if (theRegion.getAttributes().getDataPolicy().withPartitioning()) {
            int redundantCopies = theRegion.getAttributes().getPartitionAttributes().getRedundantCopies();
            Log.getLogWriter().info("Verifying PR " + theRegion.getFullPath() + " with " + redundantCopies + " redundantCopies");
            try {
                ParRegUtil.verifyPRMetaData(theRegion);
            }
            catch (Exception e) {
                aStr.append(TestHelper.getStackTrace(e) + "\n");
            }
            catch (TestException e) {
                aStr.append(TestHelper.getStackTrace(e) + "\n");
            }
            try {
                ParRegUtil.verifyPrimaries(theRegion, redundantCopies);
            }
            catch (Exception e) {
                aStr.append(e.toString() + "\n");
            }
            try {
                ParRegUtil.verifyBucketCopies(theRegion, redundantCopies);
            }
            catch (Exception e) {
                aStr.append(e.toString() + "\n");
            }
            catch (TestException e) {
                aStr.append(e.toString() + "\n");
            }
            if (aStr.length() > 0) {
                throw new TestException(aStr.toString());
            }
            Log.getLogWriter().info("Done verifying PR internal consistency for " + theRegion.getFullPath());
        }
    }

    public static void HydraTask_doOperations() throws Exception {
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        testInstance.doOperations(minTaskGranularityMS);
    }

    protected void doOperations(long msToRun) throws Exception {
        testInstance.doOperations(DeltaGIIPrms.operations, msToRun);
    }

    protected void doOperations(Long opsPrm, long msToRun) throws Exception {
        Log.getLogWriter().info("In doOperations, running for " + msToRun + " milliseconds");
        long startTime = System.currentTimeMillis();
        int numOps = 0;
        do {
            try {
                int whichOp = this.getOperation(opsPrm, theRegion);
                switch (whichOp) {
                    case 1: {
                        this.addEntry(theRegion);
                        break;
                    }
                    case 3: {
                        this.invalidateEntry(theRegion, false);
                        break;
                    }
                    case 2: {
                        this.destroyEntry(theRegion, false);
                        break;
                    }
                    case 6: {
                        this.updateEntry(theRegion);
                        break;
                    }
                    case 7: {
                        this.getExistingKey(theRegion);
                        break;
                    }
                    case 8: {
                        this.getNewKey(theRegion);
                        break;
                    }
                    case 5: {
                        this.invalidateEntry(theRegion, true);
                        break;
                    }
                    case 4: {
                        this.destroyEntry(theRegion, true);
                        break;
                    }
                    case 9: {
                        this.putAll(theRegion);
                        break;
                    }
                    case 12: {
                        theRegion = this.clearRegion();
                        break;
                    }
                    default: {
                        throw new TestException("Unknown operation " + whichOp);
                    }
                }
                Log.getLogWriter().info("Completed op " + ++numOps + " for this task");
            }
            catch (EntryExistsException e) {
                if (this.uniqueKeys) {
                    throw new TestException(TestHelper.getStackTrace(e));
                }
                Log.getLogWriter().info("Caught " + (Object)((Object)e) + ", expected with multiple writers (uniqueKeys==false), continuing test");
            }
            catch (EntryNotFoundException e) {
                if (this.uniqueKeys) {
                    boolean allowENFE = false;
                    long stoppingVMs = DeltaGIIBB.getBB().getSharedCounters().read(DeltaGIIBB.stoppingVMs);
                    if (stoppingVMs > 0L) {
                        allowENFE = true;
                        Log.getLogWriter().info("Caught " + (Object)((Object)e) + ", expected with HA, continuing test");
                    } else {
                        long clearRegion = DeltaGIIBB.getBB().getSharedCounters().read(DeltaGIIBB.clears);
                        if (clearRegion > 0L && this.isClearedRegion(theRegion)) {
                            allowENFE = true;
                            Log.getLogWriter().info("Caught " + (Object)((Object)e) + ", due to concurrent clear on " + theRegion.getFullPath() + ", continuing test");
                        }
                    }
                    if (allowENFE) continue;
                    throw new TestException(TestHelper.getStackTrace(e));
                }
                Log.getLogWriter().info("Caught " + (Object)((Object)e) + ", expected with multiple writers (uniqueKeys==false), continuing test");
            }
            catch (Exception e) {
                throw e;
            }
        } while (System.currentTimeMillis() - startTime < msToRun);
        Log.getLogWriter().info("Done in doOperations");
    }

    protected int getOperation(Long opsPrm, Region theRegion) {
        Long upperThresholdOpsPrm = DeltaGIIPrms.upperThresholdOperations;
        Long lowerThresholdOpsPrm = DeltaGIIPrms.lowerThresholdOperations;
        int upperThreshold = DeltaGIIPrms.getUpperThreshold();
        int lowerThreshold = DeltaGIIPrms.getLowerThreshold();
        if (this.isBridgeClient) {
            opsPrm = DeltaGIIPrms.clientOperations;
            upperThresholdOpsPrm = DeltaGIIPrms.upperThresholdClientOperations;
            lowerThresholdOpsPrm = DeltaGIIPrms.lowerThresholdClientOperations;
            upperThreshold = DeltaGIIPrms.getUpperThresholdClient();
            lowerThreshold = DeltaGIIPrms.getLowerThresholdClient();
        }
        if (opsPrm != DeltaGIIPrms.providerOperations) {
            int size = theRegion.size();
            if (size >= upperThreshold) {
                return this.getOperation(upperThresholdOpsPrm);
            }
            if (size <= lowerThreshold) {
                return this.getOperation(lowerThresholdOpsPrm);
            }
        }
        return this.getOperation(opsPrm);
    }

    protected int getOperation(Long whichPrm) {
        int op = 0;
        String operation = TestConfig.tab().stringAt(whichPrm);
        if (operation.equals("add")) {
            op = 1;
        } else if (operation.equals("update")) {
            op = 6;
        } else if (operation.equals("invalidate")) {
            op = 3;
        } else if (operation.equals("destroy")) {
            op = 2;
        } else if (operation.equals("get")) {
            op = 7;
        } else if (operation.equals("getNew")) {
            op = 8;
        } else if (operation.equals("localInvalidate")) {
            op = 5;
        } else if (operation.equals("localDestroy")) {
            op = 4;
        } else if (operation.equals("putAll")) {
            op = 9;
        } else if (operation.equals("cacheOperations")) {
            op = 10;
        } else if (operation.equals("clear")) {
            op = 12;
        } else {
            throw new TestException("Unknown entry operation: " + operation);
        }
        return op;
    }

    protected void getExistingKey(Region theRegion) {
        Object key = this.obtainExistingKey(theRegion);
        if (key == null) {
            Log.getLogWriter().info("No keys available in " + theRegion.getFullPath() + ", cannot do get on existing key");
            return;
        }
        Log.getLogWriter().info("Getting existing key " + key + " from region " + theRegion.getFullPath());
        Object result = theRegion.get(key);
        Log.getLogWriter().info("Done getting existing key " + key + ", returned value " + result);
    }

    protected Object addEntry(Region theRegion) {
        Object key = this.obtainNewKey();
        this.addEntry(theRegion, key);
        return key;
    }

    protected void addEntry(Region theRegion, Object key) {
        Object anObj = this.getValueForKey(key);
        String callback = createCallbackPrefix + ProcessMgr.getProcessId();
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                Log.getLogWriter().info("addEntry: calling create for key " + key + ", object " + TestHelper.toString(anObj) + " cacheWriterParam is " + callback + ", region is " + theRegion.getFullPath());
                theRegion.create(key, anObj, (Object)callback);
                Log.getLogWriter().info("addEntry: done creating key " + key);
            } else {
                Log.getLogWriter().info("addEntry: calling create for key " + key + ", object " + TestHelper.toString(anObj) + ", region is " + theRegion.getFullPath());
                theRegion.create(key, anObj);
                Log.getLogWriter().info("addEntry: done creating key " + key);
            }
        } else {
            Object returnVal = null;
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                Log.getLogWriter().info("addEntry: calling put for key " + key + ", object " + TestHelper.toString(anObj) + " callback is " + callback + ", region is " + theRegion.getFullPath());
                returnVal = theRegion.put(key, anObj, (Object)callback);
                Log.getLogWriter().info("addEntry: done putting key " + key + ", returnVal is " + returnVal);
            } else {
                Log.getLogWriter().info("addEntry: calling put for key " + key + ", object " + TestHelper.toString(anObj) + ", region is " + theRegion.getFullPath());
                returnVal = theRegion.put(key, anObj);
                Log.getLogWriter().info("addEntry: done putting key " + key + ", returnVal is " + returnVal);
            }
        }
    }

    protected void putAll(Region theRegion) {
        Map mapToPut = this.getPutAllMap(theRegion);
        Log.getLogWriter().info("putAll: calling putAll with map of " + mapToPut.size() + " entries, region is " + theRegion.getFullPath());
        theRegion.putAll(mapToPut);
        Log.getLogWriter().info("putAll: done calling putAll with map of " + mapToPut.size() + " entries");
    }

    protected Map getPutAllMap(Region theRegion) {
        int numPutAllNewKeys = DeltaGIIPrms.getNumPutAllNewKeys();
        HashMap<Object, Object> mapToPut = new HashMap<Object, Object>();
        StringBuffer newKeys = new StringBuffer();
        for (int i = 1; i <= numPutAllNewKeys; ++i) {
            Object key = this.obtainNewKey();
            Object anObj = this.getValueForKey(key);
            mapToPut.put(key, anObj);
            newKeys.append(key + " ");
            if (i % 10 != 0) continue;
            newKeys.append("\n");
        }
        int numPutAllExistingKeys = TestConfig.tab().intAt(DeltaGIIPrms.numPutAllExistingKeys);
        List<String> existingKeysList = this.obtainExistingKeys(theRegion, numPutAllExistingKeys);
        StringBuffer existingKeys = new StringBuffer();
        int count = 0;
        for (String key : existingKeysList) {
            Object anObj = this.getUpdateObject(theRegion, key);
            mapToPut.put(key, anObj);
            existingKeys.append(key + " ");
            if (++count % 10 != 0) continue;
            existingKeys.append("\n");
        }
        Log.getLogWriter().info(theRegion.getFullPath() + " size is " + theRegion.size() + ", map to use as argument to putAll is " + mapToPut.getClass().getName() + " containing " + numPutAllNewKeys + " new keys and " + numPutAllExistingKeys + " existing keys (updates); total map size is " + mapToPut.size() + "\nnew keys are: " + newKeys + "\nexisting keys are: " + existingKeys);
        return mapToPut;
    }

    protected void invalidateEntry(Region theRegion, boolean isLocalInvalidate) {
        Object key = this.obtainExistingKey(theRegion);
        if (key == null) {
            Log.getLogWriter().info("invalidateEntry: No keys in region " + theRegion.getFullPath());
            return;
        }
        this.invalidateEntry(theRegion, key, isLocalInvalidate);
    }

    protected void invalidateEntry(Region theRegion, Object key, boolean isLocalInvalidate) {
        String callback = invalidateCallbackPrefix + ProcessMgr.getProcessId();
        if (isLocalInvalidate) {
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                Log.getLogWriter().info("invalidateEntry: local invalidate for " + key + " callback is " + callback + ", region is " + theRegion.getFullPath());
                theRegion.localInvalidate(key, (Object)callback);
                Log.getLogWriter().info("invalidateEntry: done with local invalidate for " + key);
            } else {
                Log.getLogWriter().info("invalidateEntry: local invalidate for " + key + ", region is " + theRegion.getFullPath());
                theRegion.localInvalidate(key);
                Log.getLogWriter().info("invalidateEntry: done with local invalidate for " + key);
            }
        } else if (TestConfig.tab().getRandGen().nextBoolean()) {
            Log.getLogWriter().info("invalidateEntry: invalidating key " + key + " callback is " + callback + ", region is " + theRegion.getFullPath());
            theRegion.invalidate(key, (Object)callback);
            Log.getLogWriter().info("invalidateEntry: done invalidating key " + key);
        } else {
            Log.getLogWriter().info("invalidateEntry: invalidating key " + key + ", theRegion is " + theRegion.getFullPath());
            theRegion.invalidate(key);
            Log.getLogWriter().info("invalidateEntry: done invalidating key " + key);
        }
    }

    protected void destroyEntry(Region theRegion, boolean isLocalDestroy) {
        Object key = this.obtainExistingKey(theRegion);
        if (key == null) {
            Log.getLogWriter().info("destroyEntry: No keys in region " + theRegion.getFullPath());
            return;
        }
        this.destroyEntry(theRegion, key, isLocalDestroy);
    }

    protected void destroyEntry(Region theRegion, Object key, boolean isLocalDestroy) {
        String callback = destroyCallbackPrefix + ProcessMgr.getProcessId();
        if (isLocalDestroy) {
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                Log.getLogWriter().info("destroyEntry: local destroy for " + key + " callback is " + callback + ", region is " + theRegion.getFullPath());
                theRegion.localDestroy(key, (Object)callback);
                Log.getLogWriter().info("destroyEntry: done with local destroy for " + key);
            } else {
                Log.getLogWriter().info("destroyEntry: local destroy for " + key + ", region is " + theRegion.getFullPath());
                theRegion.localDestroy(key);
                Log.getLogWriter().info("destroyEntry: done with local destroy for " + key);
            }
        } else if (TestConfig.tab().getRandGen().nextBoolean()) {
            Log.getLogWriter().info("destroyEntry: destroying key " + key + " callback is " + callback + ", region is " + theRegion.getFullPath());
            theRegion.destroy(key, (Object)callback);
            Log.getLogWriter().info("destroyEntry: done destroying key " + key);
        } else {
            Log.getLogWriter().info("destroyEntry: destroying key " + key + ", region is " + theRegion.getFullPath());
            theRegion.destroy(key);
            Log.getLogWriter().info("destroyEntry: done destroying key " + key);
        }
    }

    protected void updateEntry(Region theRegion) {
        Object key = this.obtainExistingKey(theRegion);
        if (key == null) {
            Log.getLogWriter().info("updateEntry: No keys in region " + theRegion.getFullPath());
            return;
        }
        this.updateEntry(theRegion, key);
    }

    protected void updateEntry(Region theRegion, Object key) {
        Object anObj = this.getUpdateObject(theRegion, (String)key);
        String callback = updateCallbackPrefix + ProcessMgr.getProcessId();
        Object returnVal = null;
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            Log.getLogWriter().info("updateEntry: replacing key " + key + " with " + TestHelper.toString(anObj) + ", callback is " + callback + ", region is " + theRegion.getFullPath());
            returnVal = theRegion.put(key, anObj, (Object)callback);
            Log.getLogWriter().info("Done with call to put (update), returnVal is " + returnVal);
        } else {
            Log.getLogWriter().info("updateEntry: replacing key " + key + " with " + TestHelper.toString(anObj) + ", region is " + theRegion.getFullPath());
            returnVal = theRegion.put(key, anObj, (Object)false);
            Log.getLogWriter().info("Done with call to put (update), returnVal is " + returnVal);
        }
    }

    protected void getNewKey(Region theRegion) {
        Object key = this.obtainNewKey();
        this.getThisNewKey(theRegion, key);
    }

    protected void getThisNewKey(Region theRegion, Object key) {
        Object anObj;
        String callback = getCallbackPrefix + ProcessMgr.getProcessId();
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            Log.getLogWriter().info("getNewKey: getting new key " + key + ", callback is " + callback + ", region is " + theRegion.getFullPath());
            anObj = theRegion.get(key, (Object)callback);
        } else {
            Log.getLogWriter().info("getNewKey: getting new key " + key + ", region is " + theRegion.getFullPath());
            anObj = theRegion.get(key);
        }
        Log.getLogWriter().info("getNewKey: done getting value for new key " + key + ": " + TestHelper.toString(anObj));
    }

    protected Object obtainExistingKey(Region theRegion) {
        if (theRegion.size() == 0) {
            return null;
        }
        Object[] keyArr = theRegion.keySet().toArray();
        int myTid = RemoteTestModule.getCurrentThread().getThreadId();
        int numThreads = TestHelper.getNumThreads();
        for (Object key : keyArr) {
            if (this.uniqueKeys) {
                long keyIndex = NameFactory.getCounterForName(key);
                if (keyIndex % (long)numThreads != (long)myTid) continue;
                return key;
            }
            return key;
        }
        return null;
    }

    protected List<String> obtainExistingKeys(Region theRegion, int numToObtain) {
        ArrayList<String> aList = new ArrayList<String>();
        if (theRegion.size() == 0) {
            return aList;
        }
        Object[] keyArr = theRegion.keySet().toArray();
        int myTid = RemoteTestModule.getCurrentThread().getThreadId();
        int numThreads = TestHelper.getNumThreads();
        for (Object key : keyArr) {
            if (this.uniqueKeys) {
                long keyIndex = NameFactory.getCounterForName(key);
                if (keyIndex % (long)numThreads != (long)myTid) continue;
                aList.add((String)key);
                if (aList.size() != numToObtain) continue;
                return aList;
            }
            aList.add((String)key);
            if (aList.size() != numToObtain) continue;
            return aList;
        }
        return aList;
    }

    protected Region clearRegion() {
        long numClears = DeltaGIIBB.getBB().getSharedCounters().incrementAndRead(DeltaGIIBB.clears);
        if (numClears == 1L) {
            if (theRegion != null) {
                String fullPathName = theRegion.getFullPath();
                DeltaGIIBB.getBB().addToClearedRegionList(fullPathName);
                Log.getLogWriter().info("Starting clearRegion on " + fullPathName);
                theRegion.clear();
                Log.getLogWriter().info("Completed clearRegion on " + fullPathName);
            } else {
                Log.getLogWriter().info("clearRegion invoked, but there are no non-PartitionedRegions in this test");
            }
        }
        return theRegion;
    }

    protected boolean isClearedRegion(Region theRegion) {
        boolean cleared = false;
        Set clearedRegions = (Set)DeltaGIIBB.getBB().getSharedMap().get("clearedRegionFullPaths");
        if (clearedRegions != null && clearedRegions.contains(theRegion.getFullPath())) {
            cleared = true;
        }
        return cleared;
    }

    protected Object obtainNewKey() {
        if (this.uniqueKeys) {
            int thisThreadID = RemoteTestModule.getCurrentThread().getThreadId();
            int anInt = (Integer)DeltaGIIBB.getBB().getSharedMap().get("uniqueKeyIndexForThread_" + thisThreadID);
            DeltaGIIBB.getBB().getSharedMap().put("uniqueKeyIndexForThread_" + thisThreadID, anInt += TestHelper.getNumThreads());
            NameBB.getBB().getSharedCounters().setIfLarger(NameBB.POSITIVE_NAME_COUNTER, anInt);
            return NameFactory.getObjectNameForCounter(anInt);
        }
        return NameFactory.getNextPositiveObjectName();
    }

    private Object getValueForKey(Object key) {
        String valueClassName = DeltaGIIPrms.getValueClassName();
        BaseValueHolder vh = null;
        if (valueClassName.equals(ValueHolder.class.getName())) {
            vh = new ValueHolder((String)key, this.randomValues);
        } else if (valueClassName.equals(VHDataSerializable.class.getName())) {
            vh = new VHDataSerializable((String)key, this.randomValues);
        } else if (valueClassName.equals(VHDataSerializableInstantiator.class.getName())) {
            vh = new VHDataSerializableInstantiator((String)key, this.randomValues);
        } else {
            if (valueClassName.equals("util.PdxVersionedValueHolder") || valueClassName.equals("util.VersionedValueHolder")) {
                vh = PdxTest.getVersionedValueHolder(valueClassName, (String)key, this.randomValues);
                return vh;
            }
            throw new TestException("Test does not support DeltaGIIPrms.valueClassName " + valueClassName);
        }
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            Object anObj = vh.extraObject;
            if (anObj == null) {
                throw new TestException("Test config problem: ValueHolder does not have extraObj");
            }
            return anObj;
        }
        return vh;
    }

    protected Object getUpdateObject(Region r, String key) {
        Object anObj = r.get((Object)key);
        Object newObj = null;
        newObj = anObj == null || !(anObj instanceof BaseValueHolder) ? this.getValueForKey(key) : ((BaseValueHolder)anObj).getAlternateValueHolder(this.randomValues);
        if (newObj instanceof BaseValueHolder && TestConfig.tab().getRandGen().nextBoolean()) {
            return ((BaseValueHolder)newObj).extraObject;
        }
        return newObj;
    }

    public static int getStat_tombstones(String regionName) {
        String regionStatName = "RegionStats-" + regionName;
        Log.getLogWriter().info("getStat_tombstones regionStatName=" + regionStatName);
        DistributedSystem statFactory = DistributedSystemHelper.getDistributedSystem();
        while (statFactory == null) {
            statFactory = DistributedSystemHelper.getDistributedSystem();
        }
        Statistics[] regionStats = statFactory.findStatisticsByTextId(regionStatName);
        while (regionStats.length == 0) {
            regionStats = statFactory.findStatisticsByTextId(regionStatName);
        }
        int tombstones = regionStats[0].getInt("tombstones");
        Log.getLogWriter().info("getStat_tombstones tombstones=" + tombstones);
        return tombstones;
    }

    protected static long logExecutionNumber() {
        long exeNum = DeltaGIIBB.getBB().getSharedCounters().incrementAndRead(DeltaGIIBB.executionNumber);
        Log.getLogWriter().info("Beginning task with execution number " + exeNum);
        return exeNum;
    }

    protected static void checkForLastIteration() {
        long numExecutions = DeltaGIIBB.getBB().getSharedCounters().read(DeltaGIIBB.executionNumber);
        if (numExecutions == (long)DeltaGIIPrms.numExecutions()) {
            Log.getLogWriter().info("This is the last iteration of this task, numExecutions = " + numExecutions);
            DeltaGIIBB.getBB().getSharedCounters().increment(DeltaGIIBB.timeToStop);
        }
    }

    public static void HydraTask_verifyDeltaGII() {
        boolean expectDeltaGII = DeltaGIIPrms.expectDeltaGII();
        Log.getLogWriter().info("HydraTask_verifyDeltaGII-expectDeltaGII(from Conf)=" + expectDeltaGII);
        String giiStatePrm = (String)DeltaGIIBB.getBB().getSharedMap().get("giiStatePrm");
        if (giiStatePrm != null) {
            expectDeltaGII = giiStatePrm.equalsIgnoreCase("BeforeRequestRVV") || giiStatePrm.equalsIgnoreCase("AfterRequestRVV") || giiStatePrm.equalsIgnoreCase("AfterCalculatedUnfinishedOps") || giiStatePrm.equalsIgnoreCase("BeforeSavedReceivedRVV") || giiStatePrm.equalsIgnoreCase("AfterSentImageRequest") || giiStatePrm.equalsIgnoreCase("AfterSentImageReply");
        }
        Log.getLogWriter().info("HydraTask_verifyDeltaGII-expectDeltaGII(after giiStatePrm)=" + expectDeltaGII + ". giiStatePrm=" + giiStatePrm);
        testInstance.verifyDeltaGII(expectDeltaGII);
    }

    private void verifyDeltaGII(boolean expectDeltaGII) {
        String regionName = theRegion.getName();
        if (theRegion.getAttributes().getDataPolicy().withPartitioning()) {
            regionName = "partition-" + regionName;
        }
        if (DeltaGIIPrms.doTombstoneGC()) {
            String mapKey = "tombstoneCount_thr" + RemoteTestModule.getCurrentThread().getThreadId();
            int beforeTombstones = (Integer)DeltaGIIBB.getBB().getSharedMap().get(mapKey);
            int tombstones = DeltaGIITest.getStat_tombstones(regionName);
            if (tombstones >= beforeTombstones) {
                throw new TestException("Expected tombstone expiration in restarted vm (before recycle tombstone count was " + beforeTombstones + " after restart, tombstone count was " + tombstones + ")");
            }
            Log.getLogWriter().info("After restart, requester vm has expected tombstones (before recycle tombstone count was " + beforeTombstones + " after restart, tombstone count was " + tombstones + ")");
        }
        StringBuffer aStr = new StringBuffer("verifyDeltaGII invoked with expectDeltaGII = " + expectDeltaGII + ". ");
        DiskRegion diskRegion = ((LocalRegion)theRegion).getDiskRegion();
        if (diskRegion != null && diskRegion.getStats().getRemoteInitializations() == 0) {
            aStr.append(regionName + " was recovered from disk (Remote Initializations = " + diskRegion.getStats().getRemoteInitializations() + ").");
        } else {
            int giisCompleted = TestHelper.getStat_getInitialImagesCompleted(regionName);
            int deltaGiisCompleted = TestHelper.getStat_deltaGetInitialImagesCompleted(regionName);
            if (expectDeltaGII && deltaGiisCompleted == 0 || !expectDeltaGII && deltaGiisCompleted == 1) {
                throw new TestException("Did not perform expected type of GII. expectDeltaGII = " + expectDeltaGII + " for region " + theRegion.getFullPath() + " GIIsCompleted = " + giisCompleted + " DeltaGIIsCompleted = " + deltaGiisCompleted);
            }
            aStr.append(regionName + " Remote Initialization (GII): GIIsCompleted = " + giisCompleted + " DeltaGIIsCompleted = " + deltaGiisCompleted + ".");
        }
        Log.getLogWriter().info(aStr.toString());
    }
}

