/*
 * Decompiled with CFR 0.152.
 */
package delta;

import com.gemstone.gemfire.DeltaTestImpl;
import com.gemstone.gemfire.internal.cache.LocalRegionHelper;
import delta.DeltaDurableClientValidationListener;
import delta.DeltaPropagationBB;
import hydra.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import util.TestException;

public class Validator {
    public static long createCount = 0L;
    public static long updateCount = 0L;
    public static long invalidateCount = 0L;
    public static long destroyCount = 0L;
    public static long createDeltaCount = 0L;
    public static long updateDeltaCount = 0L;
    public static long createNonDeltaCount = 0L;
    public static long updateNonDeltaCount = 0L;
    public static HashMap keyToMap = new HashMap();

    public static void validateOpCountsForOld() {
        long createCountFromBB = DeltaPropagationBB.getBB().getSharedCounters().read(DeltaPropagationBB.NUM_NON_DELTA_CREATE);
        long updateCountFromBB = DeltaPropagationBB.getBB().getSharedCounters().read(DeltaPropagationBB.NUM_NON_DELTA_UPDATE);
        long lastKeyCreateCount = DeltaPropagationBB.getBB().getSharedCounters().read(DeltaPropagationBB.NUM_CREATE);
        Log.getLogWriter().info(" createCountFromBB " + (createCountFromBB + lastKeyCreateCount) + " createCount " + createNonDeltaCount);
        Log.getLogWriter().info(" updateCountFromBB " + updateCountFromBB + " updateCount " + updateNonDeltaCount);
        long diff = createCountFromBB + lastKeyCreateCount - createNonDeltaCount;
        if (diff != 0L) {
            throw new TestException(diff + " creates not received by client");
        }
        diff = updateCountFromBB - updateNonDeltaCount;
        if (diff != 0L) {
            throw new TestException(diff + " updates not received by client");
        }
    }

    public static void validateOpCountsForCurr() {
        long updateCountFromBB = DeltaPropagationBB.getBB().getSharedCounters().read(DeltaPropagationBB.NUM_DELTA_UPDATE);
        long updateNonDeltaFromBB = DeltaPropagationBB.getBB().getSharedCounters().read(DeltaPropagationBB.NUM_UPDATE);
        long updateNonDelta = DeltaPropagationBB.getBB().getSharedCounters().read(DeltaPropagationBB.NUM_NON_DELTA_UPDATE);
        long createDeltaFromBB = DeltaPropagationBB.getBB().getSharedCounters().read(DeltaPropagationBB.NUM_DELTA_CREATE);
        long create = DeltaPropagationBB.getBB().getSharedCounters().read(DeltaPropagationBB.NUM_CREATE);
        long createNonDelta = DeltaPropagationBB.getBB().getSharedCounters().read(DeltaPropagationBB.NUM_NON_DELTA_CREATE);
        Log.getLogWriter().info(" createCountFromBB " + (create + createDeltaFromBB + createNonDelta) + " createCount " + createCount);
        Log.getLogWriter().info(" updateCountFromBB " + (updateCountFromBB + updateNonDeltaFromBB + updateNonDelta) + " updateCount " + updateCount);
        long diff = create + createDeltaFromBB + createNonDelta - createCount;
        if (diff != 0L) {
            throw new TestException(diff + " creates not received by client");
        }
        diff = updateCountFromBB + updateNonDeltaFromBB + updateNonDelta - updateCount;
        if (diff != 0L) {
            throw new TestException(diff + " updates not received by client");
        }
        Validator.validateToAndFromDeltaCount();
    }

    public static void validateDataReceivedCacheLessClient() {
        long updateCountFromBB = DeltaPropagationBB.getBB().getSharedCounters().read(DeltaPropagationBB.NUM_DELTA_UPDATE);
        long updateNonDeltaFromBB = DeltaPropagationBB.getBB().getSharedCounters().read(DeltaPropagationBB.NUM_UPDATE);
        long updateNonDelta = DeltaPropagationBB.getBB().getSharedCounters().read(DeltaPropagationBB.NUM_NON_DELTA_UPDATE);
        long createDeltaFromBB = DeltaPropagationBB.getBB().getSharedCounters().read(DeltaPropagationBB.NUM_DELTA_CREATE);
        long create = DeltaPropagationBB.getBB().getSharedCounters().read(DeltaPropagationBB.NUM_CREATE);
        long createNonDelta = DeltaPropagationBB.getBB().getSharedCounters().read(DeltaPropagationBB.NUM_NON_DELTA_CREATE);
        Log.getLogWriter().info("createDeltaFromBB " + createDeltaFromBB + "createNonDelta " + createNonDelta + "create " + create + "updateCountFromBB " + updateCountFromBB + "updateNonDelta " + updateNonDelta + "updateNonDeltaFromBB " + updateNonDeltaFromBB + "create+1 " + (updateCount + updateCount));
        long diff = createDeltaFromBB + createNonDelta + create + updateCountFromBB + updateNonDelta + updateNonDeltaFromBB - (createCount + updateCount);
        if (diff != 0L) {
            throw new TestException(diff + " creates not received by client");
        }
    }

    public static void validateDeltaFeature() {
        if (!DeltaTestImpl.deltaFeatureUsed().booleanValue()) {
            throw new TestException("Delta feature not used");
        }
    }

    public static void validateFromDeltaFeature() {
        if (!DeltaTestImpl.fromDeltaFeatureUsed().booleanValue()) {
            throw new TestException("FromDelta feature not used");
        }
    }

    public static void validateToDeltaFeature() {
        if (!DeltaTestImpl.toDeltaFeatureUsed().booleanValue()) {
            throw new TestException("ToDelta feature not used");
        }
    }

    public static String checkBlackBoardForException() {
        long exceptionCount = DeltaPropagationBB.getBB().getSharedCounters().read(DeltaPropagationBB.NUM_EXCEPTION);
        if (exceptionCount > 0L) {
            StringBuffer reason = new StringBuffer();
            reason.append("\n");
            int reasonCount = 0;
            Map reasonMap = DeltaPropagationBB.getBB().getSharedMap().getMap();
            Set reasonEntrySet = reasonMap.entrySet();
            for (Map.Entry reasonEntry : reasonEntrySet) {
                Object reasonKey = reasonEntry.getKey();
                if (!(reasonKey instanceof String) || !((String)reasonKey).startsWith("CLIENT_")) continue;
                ArrayList reasonArray = (ArrayList)reasonEntry.getValue();
                reason.append(reasonKey + "\n");
                for (int i = 0; i < reasonArray.size(); ++i) {
                    reason.append("Reason for exception no. " + ++reasonCount + " : ");
                    reason.append(reasonArray.get(i));
                    reason.append("\n");
                }
            }
            return reason.toString();
        }
        return null;
    }

    public static void validateOpCountsForNoFailover() {
        long createCountFromBB = DeltaPropagationBB.getBB().getSharedCounters().read(DeltaPropagationBB.NUM_CREATE);
        long updateCountFromBB = DeltaPropagationBB.getBB().getSharedCounters().read(DeltaPropagationBB.NUM_UPDATE);
        long invalidateCountFromBB = DeltaPropagationBB.getBB().getSharedCounters().read(DeltaPropagationBB.NUM_INVALIDATE);
        long destroyCountFromBB = DeltaPropagationBB.getBB().getSharedCounters().read(DeltaPropagationBB.NUM_DESTROY);
        Log.getLogWriter().info(" createCountFromBB " + createCountFromBB + " createCount " + createCount);
        Log.getLogWriter().info(" updateCountFromBB " + updateCountFromBB + " updateCount " + updateCount);
        Log.getLogWriter().info(" invalidateCountFromBB " + invalidateCountFromBB + " invalidateCount " + invalidateCount);
        Log.getLogWriter().info(" destroyCountFromBB " + destroyCountFromBB + " destroyCount " + destroyCount);
        long diff = createCountFromBB - createCount;
        if (diff != 0L) {
            throw new TestException(diff + " creates not received by client");
        }
        diff = updateCountFromBB - updateCount;
        if (diff != 0L) {
            throw new TestException(diff + " updates not received by client");
        }
        diff = invalidateCountFromBB - invalidateCount;
        if (diff != 0L) {
            throw new TestException(diff + " invalidates not received by client");
        }
        diff = destroyCountFromBB - destroyCount;
        if (diff != 0L) {
            throw new TestException(diff + " destroys not received by client");
        }
        Validator.validateToAndFromDeltaCount();
    }

    public static void validateOpCountsForFailover() {
        long createCountFromBB = DeltaPropagationBB.getBB().getSharedCounters().read(DeltaPropagationBB.NUM_CREATE);
        long updateCountFromBB = DeltaPropagationBB.getBB().getSharedCounters().read(DeltaPropagationBB.NUM_UPDATE);
        long invalidateCountFromBB = DeltaPropagationBB.getBB().getSharedCounters().read(DeltaPropagationBB.NUM_INVALIDATE);
        long destroyCountFromBB = DeltaPropagationBB.getBB().getSharedCounters().read(DeltaPropagationBB.NUM_DESTROY);
        long diff = createCountFromBB - createCount;
        boolean validationFailed = false;
        StringBuffer failureMsg = new StringBuffer();
        if (diff != 0L) {
            validationFailed = true;
            failureMsg.append(diff + " creates not received by client \n");
        }
        if ((diff = updateCountFromBB - updateCount) != 0L) {
            validationFailed = true;
            failureMsg.append(diff + " updates not received by client \n");
        }
        if ((diff = invalidateCountFromBB - invalidateCount) != 0L) {
            validationFailed = true;
            failureMsg.append(diff + " invalidates not received by client \n");
        }
        if ((diff = destroyCountFromBB - destroyCount) != 0L) {
            validationFailed = true;
            failureMsg.append(diff + " destroys not received by client \n");
        }
        if (validationFailed) {
            throw new TestException(failureMsg.toString());
        }
        Validator.validateToAndFromDeltaCount();
    }

    public static void validateOpCounts() {
        long createCountFromBB = DeltaPropagationBB.getBB().getSharedCounters().read(DeltaPropagationBB.NUM_CREATE);
        long updateCountFromBB = DeltaPropagationBB.getBB().getSharedCounters().read(DeltaPropagationBB.NUM_UPDATE);
        long invalidateCountFromBB = DeltaPropagationBB.getBB().getSharedCounters().read(DeltaPropagationBB.NUM_INVALIDATE);
        long destroyCountFromBB = DeltaPropagationBB.getBB().getSharedCounters().read(DeltaPropagationBB.NUM_DESTROY);
        long diff = createCountFromBB - createCount;
        boolean validationFailed = false;
        StringBuffer failureMsg = new StringBuffer();
        if (diff != 0L) {
            validationFailed = true;
            failureMsg.append("Expected : " + createCountFromBB + "create events from feeder should be received by the client, but actual number of create events received by the client are :" + createCount + "\n");
        }
        if ((diff = updateCountFromBB - updateCount) != 0L) {
            validationFailed = true;
            failureMsg.append("Expected : " + updateCountFromBB + "update events from feeder should be received by the client, but actual number of update events received by the client are :" + updateCount + "\n");
        }
        if ((diff = invalidateCountFromBB - invalidateCount) != 0L) {
            validationFailed = true;
            failureMsg.append("Expected : " + invalidateCountFromBB + "invalidate events from feeder should be received by the client, but actual number of invalidate events received by the client are :" + invalidateCount + "\n");
        }
        if ((diff = destroyCountFromBB - destroyCount) != 0L) {
            validationFailed = true;
            failureMsg.append("Expected : " + destroyCountFromBB + "destroy events from feeder should be received by the client, but actual number of destroy events received by the client are :" + destroyCount + "\n");
        }
        if (validationFailed) {
            throw new TestException(failureMsg.toString());
        }
    }

    public static void validateOpCountsForDefaultClient() {
        Validator.validateOpCounts();
        Validator.validateToAndFromDeltaCount();
    }

    public static void validateOpCountForEmptyClient() {
        Validator.validateOpCounts();
        if (keyToMap.isEmpty()) {
            throw new TestException("keyToMap : " + keyToMap.isEmpty() + " object do not have entries to verify");
        }
        for (String key : keyToMap.keySet()) {
            Long obj1 = (Long)keyToMap.get(key);
            if (obj1 == null) continue;
            Log.getLogWriter().info("key :" + key + " fromDeltaFromEdge: " + obj1);
            if (obj1 != 0L) {
                throw new TestException("For a client with dataPolicy empty,fromDeltaInvocations expected to be zero, but found fromDeltaInvocations for a key :" + key + " are " + obj1);
            }
            Log.getLogWriter().info(" Validation succeeded....For a client with dataPolicy empty,fromDeltaInvocations expected to be zero and found fromDeltaInvocations for a key :" + key + " are " + obj1);
        }
    }

    public static void validateToAndFromDeltaCount() {
        Map shM = DeltaPropagationBB.getBB().getSharedMap().getMap();
        if (shM.isEmpty() || keyToMap.isEmpty()) {
            throw new TestException("ShM :" + shM.isEmpty() + " keyToMap : " + keyToMap.isEmpty() + " object donot have entries to verify");
        }
        for (String key : keyToMap.keySet()) {
            Long obj1 = (Long)keyToMap.get(key);
            Long obj2 = (Long)shM.get(key);
            if (obj1 == null || obj2 == null) continue;
            Log.getLogWriter().info("key :" + key + " fromDeltaFromEdge: " + obj1 + " toDeltaFromFeeder " + obj2);
            if (obj1.longValue() == obj2.longValue()) continue;
            throw new TestException("For key :" + key + " : difference in toDeltaCounter and fromDeltaCounter is :  " + (obj2 - obj1));
        }
    }

    public static void validateOverflow() {
        LocalRegionHelper.isOverflowUsedOnBridge();
    }

    public static void validateToAndFromDeltaCountForDurable() {
        HashMap keyValue = (HashMap)DeltaDurableClientValidationListener.durableKeyMap;
        Map shM = DeltaPropagationBB.getBB().getSharedMap().getMap();
        if (shM.isEmpty() || keyValue.isEmpty()) {
            throw new TestException("ShM :" + shM.isEmpty() + " keyValue : " + keyValue.isEmpty() + " object donot have entries to verify");
        }
        for (String key : keyValue.keySet()) {
            if (!key.contains("#")) continue;
            String[] keyObj = key.split("#");
            DeltaDurableClientValidationListener.CounterHolder obj2 = (DeltaDurableClientValidationListener.CounterHolder)keyValue.get(key);
            Long obj1 = (Long)shM.get(keyObj[0]);
            if (obj1 == null || obj2 == null) continue;
            Log.getLogWriter().info("key :" + key + " DurableCounter[fromDeltaCounter, fullObjectCounter] : " + obj2 + " keyObj :" + keyObj[0] + " toDeltaFromFeeder " + obj1);
            if (obj1 <= obj2.getTotalSum()) continue;
            throw new TestException(" For key :" + key + " : difference in toDeltaCounter and fromDeltaCounter is : " + (obj2.getTotalSum() - obj1));
        }
    }
}

