/*
 * Decompiled with CFR 0.152.
 */
package delta;

import com.gemstone.gemfire.cache.CacheEvent;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.RegionEvent;
import delta.DeltaObject;
import delta.DeltaObserver;
import delta.DeltaPropagationBB;
import delta.DeltaTest;
import diskReg.DiskRegUtil;
import hydra.Log;
import java.util.Properties;
import util.AbstractListener;

public class DeltaTestListener
extends AbstractListener
implements CacheListener,
Declarable {
    public void afterCreate(EntryEvent event) {
        boolean objLivesInThisVM = DiskRegUtil.getValueInVM(event.getRegion(), event.getKey()) != null;
        this.logCall("afterCreate", (CacheEvent)event);
        DeltaTest.logPRMembers(event.getRegion(), event.getKey());
        Object valueInVM = DiskRegUtil.getValueInVM(event.getRegion(), event.getKey());
        if (valueInVM instanceof DeltaObject && objLivesInThisVM) {
            DeltaObserver.addReference((DeltaObject)valueInVM);
        } else {
            Log.getLogWriter().info("Current valueInVM is null, so not saving reference");
        }
        Log.getLogWriter().info("NUM_CREATE is now " + DeltaPropagationBB.getBB().getSharedCounters().incrementAndRead(DeltaPropagationBB.NUM_CREATE));
    }

    public void afterDestroy(EntryEvent event) {
        this.logCall("afterDestroy", (CacheEvent)event);
        DeltaObserver.nullReference(event.getKey());
    }

    public void afterInvalidate(EntryEvent event) {
        this.logCall("afterInvalidate", (CacheEvent)event);
        DeltaObserver.nullReference(event.getKey());
    }

    public void afterRegionDestroy(RegionEvent event) {
        this.logCall("afterRegionDestroy", (CacheEvent)event);
    }

    public void afterRegionInvalidate(RegionEvent event) {
        this.logCall("afterRegionInvalidate", (CacheEvent)event);
    }

    public void afterUpdate(EntryEvent event) {
        this.logCall("afterUpdate", (CacheEvent)event);
        Log.getLogWriter().info("NUM_UPDATE is now " + DeltaPropagationBB.getBB().getSharedCounters().incrementAndRead(DeltaPropagationBB.NUM_UPDATE));
        Object anObj = event.getNewValue();
        if (anObj instanceof DeltaObject) {
            DeltaObserver.addReference((DeltaObject)anObj);
        }
    }

    public void close() {
        this.logCall("close", null);
    }

    public void afterRegionClear(RegionEvent event) {
        this.logCall("afterRegionClear", (CacheEvent)event);
    }

    public void afterRegionCreate(RegionEvent event) {
        this.logCall("afterRegionCreate", (CacheEvent)event);
    }

    public void afterRegionLive(RegionEvent event) {
        this.logCall("afterRegionLive", (CacheEvent)event);
    }

    public void init(Properties prop) {
        this.logCall("init(Properties)", null);
    }
}

