/*
 * Decompiled with CFR 0.152.
 */
package cq.statistics;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.query.CqAttributes;
import com.gemstone.gemfire.cache.query.CqAttributesFactory;
import com.gemstone.gemfire.cache.query.CqClosedException;
import com.gemstone.gemfire.cache.query.CqException;
import com.gemstone.gemfire.cache.query.CqListener;
import com.gemstone.gemfire.cache.query.CqQuery;
import com.gemstone.gemfire.cache.query.CqServiceStatistics;
import com.gemstone.gemfire.cache.query.CqStatistics;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.cq.dunit.CqQueryTestListener;
import com.gemstone.gemfire.cache.query.data.Portfolio;
import com.gemstone.gemfire.cache.query.internal.CqQueryImpl;
import com.gemstone.gemfire.cache.query.internal.CqQueryVsdStats;
import com.gemstone.gemfire.cache.query.internal.CqService;
import com.gemstone.gemfire.cache.query.internal.CqServiceVsdStats;
import com.gemstone.gemfire.cache.query.internal.DefaultQueryService;
import cq.CQTest;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.Log;
import hydra.RemoteTestModule;
import java.util.HashMap;
import java.util.Map;
import util.TestException;

public class CQStatisticsTest
extends CQTest {
    static final int pauseSecs = 20;
    public static final String[] cqs = new String[]{"p.ID > 0", "p.ID = 2", "p.ID < 5 and p.status='active'", "p.description = NULL", "p.ID > 0 and p.status='active'"};
    static final String CQUERY_NAME_PREFIX = "CQuery_";
    static final String CQUERY_PREFIX = "SELECT ALL * FROM /testRegion p where ";
    public static final String KEY = "key-";

    public static Map generateQueries(Region region) {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        for (int i = 0; i < cqs.length; ++i) {
            queryMap.put(CQUERY_NAME_PREFIX + i, CQUERY_PREFIX + cqs[i]);
        }
        return queryMap;
    }

    public static synchronized void HydraTask_initializeBridgeServer() {
        if (testInstance == null) {
            testInstance = new CQStatisticsTest();
            testInstance.initializeInstance();
            CQStatisticsTest.testInstance.aRegion = testInstance.initializeRegion("serverRegion");
            BridgeHelper.startBridgeServer("bridge");
            CQStatisticsTest.testInstance.isBridgeClient = false;
        }
        CQStatisticsTest.testInstance.uniqueKeyIndex.set(new Integer(RemoteTestModule.getCurrentThread().getThreadId()));
    }

    public static synchronized void HydraTask_initializeClient() {
        if (testInstance == null) {
            testInstance = new CQStatisticsTest();
            testInstance.initializeInstance();
            CQStatisticsTest.testInstance.aRegion = testInstance.initializeRegion("clientRegion");
            if (CQStatisticsTest.testInstance.isBridgeConfiguration) {
                CQStatisticsTest.testInstance.isBridgeClient = true;
                CQTest.registerInterest(CQStatisticsTest.testInstance.aRegion);
                if (CQsOn) {
                    testInstance.initializeQueryService();
                    CQStatisticsTest.testInstance.queryMap = CQStatisticsTest.generateQueries(CQStatisticsTest.testInstance.aRegion);
                } else {
                    Log.getLogWriter().info("Not creating CQs because CQUtilPrms.CQsOn is " + CQsOn);
                }
            }
        }
        CQStatisticsTest.testInstance.uniqueKeyIndex.set(new Integer(RemoteTestModule.getCurrentThread().getThreadId()));
    }

    private void validateCQStats(String cqName, int creates, int updates, int deletes, int totalEvents, int cqListenerInvocations) {
        QueryService qService = null;
        try {
            qService = CacheHelper.getCache().getQueryService();
        }
        catch (Exception cqe) {
            cqe.printStackTrace();
            throw new TestException("Failed to get query service.");
        }
        CqService cqService = null;
        try {
            cqService = ((DefaultQueryService)qService).getCqService();
        }
        catch (CqException e) {
            e.printStackTrace();
            throw new TestException("Failed to get CqService, CQ : " + cqName);
        }
        CqQuery cQuery = cqService.getCq(cqName);
        if (cQuery == null) {
            throw new TestException("Failed to get CqQuery for CQ : " + cqName);
        }
        CqStatistics cqStats = cQuery.getStatistics();
        CqQueryVsdStats cqVsdStats = ((CqQueryImpl)cQuery).getVsdStats();
        if (cqStats == null || cqVsdStats == null) {
            throw new TestException("Failed to get CqQuery Stats for CQ : " + cqName);
        }
        Log.getLogWriter().info("#### CQ stats for " + cQuery.getName() + ":  Events Total: " + cqStats.numEvents() + " Events Created: " + cqStats.numInserts() + " Events Updated: " + cqStats.numUpdates() + " Events Deleted: " + cqStats.numDeletes() + " CQ Listener invocations: " + cqVsdStats.getNumCqListenerInvocations() + " Initial results time (nano sec): " + cqVsdStats.getCqInitialResultsTime());
        if ((long)totalEvents != cqStats.numEvents()) {
            throw new TestException("Total Event Count mismatch Expected: " + totalEvents + " From statistics " + cqStats.numEvents());
        }
        if ((long)creates != cqStats.numInserts()) {
            throw new TestException("Create Event mismatch Expected: " + creates + " From statistics " + cqStats.numInserts());
        }
        if ((long)updates != cqStats.numUpdates()) {
            throw new TestException("Update Event mismatch Expected: " + updates + " From statistics " + cqStats.numUpdates());
        }
        if ((long)deletes != cqStats.numDeletes()) {
            throw new TestException("Delete Event mismatch Expected: " + deletes + " From statistics " + cqStats.numDeletes());
        }
        if ((long)cqListenerInvocations != cqVsdStats.getNumCqListenerInvocations()) {
            throw new TestException("CQ Listener invocations mismatch Expected: " + cqListenerInvocations + " From statistics " + cqVsdStats.getNumCqListenerInvocations());
        }
    }

    private void validateCQServiceStats(int created, int activated, int stopped, int closed, int cqsOnClient, int cqsOnRegion, int clientsWithCqs) {
        QueryService qService = null;
        qService = CacheHelper.getCache().getQueryService();
        CqServiceStatistics cqServiceStats = null;
        cqServiceStats = qService.getCqStatistics();
        CqServiceVsdStats cqServiceVsdStats = null;
        try {
            cqServiceVsdStats = ((DefaultQueryService)qService).getCqService().stats;
        }
        catch (CqException e) {
            e.printStackTrace();
        }
        if (cqServiceStats == null) {
            throw new TestException("Failed to get CQ Service Stats");
        }
        Log.getLogWriter().info("#### CQ Service stats:  CQs created: " + cqServiceStats.numCqsCreated() + " CQs active: " + cqServiceStats.numCqsActive() + " CQs stopped: " + cqServiceStats.numCqsStopped() + " CQs closed: " + cqServiceStats.numCqsClosed() + " CQs on Client: " + cqServiceStats.numCqsOnClient() + " CQs on region " + CQStatisticsTest.testInstance.aRegion.getName() + " : " + cqServiceVsdStats.numCqsOnRegion(CQStatisticsTest.testInstance.aRegion.getName()) + " Clients with CQs: " + cqServiceVsdStats.getNumClientsWithCqs());
        if ((long)created != cqServiceStats.numCqsCreated()) {
            throw new TestException("Number of CQs created mismatch Expected: " + created + " From statistics " + cqServiceStats.numCqsCreated());
        }
        if ((long)activated != cqServiceStats.numCqsActive()) {
            throw new TestException("Number of CQs activated mismatch Expected: " + activated + " From statistics " + cqServiceStats.numCqsActive());
        }
        if ((long)stopped != cqServiceStats.numCqsStopped()) {
            throw new TestException("Number of CQs stopped mismatch Expected: " + stopped + " From statistics " + cqServiceStats.numCqsStopped());
        }
        if ((long)closed != cqServiceStats.numCqsClosed()) {
            throw new TestException("Number of CQs closed mismatch Expected: " + closed + " From statistics " + cqServiceStats.numCqsClosed());
        }
        if ((long)cqsOnClient != cqServiceStats.numCqsOnClient()) {
            throw new TestException("Number of CQs on client mismatch Expected: " + cqsOnClient + " From statistics " + cqServiceStats.numCqsOnClient());
        }
        if ((long)cqsOnRegion != cqServiceVsdStats.numCqsOnRegion(CQStatisticsTest.testInstance.aRegion.getFullPath())) {
            throw new TestException("Number of CQs on region " + CQStatisticsTest.testInstance.aRegion.getFullPath() + " mismatch  Expected: " + cqsOnRegion + " From statistics " + cqServiceVsdStats.numCqsOnRegion(CQStatisticsTest.testInstance.aRegion.getFullPath()));
        }
        if ((long)clientsWithCqs != cqServiceVsdStats.getNumClientsWithCqs()) {
            throw new TestException("Clints with CQs mismatch Expected: " + clientsWithCqs + " From statistics " + cqServiceVsdStats.getNumClientsWithCqs());
        }
    }

    private void verifyStatistics_SingleQuery() {
        this.validateCQServiceStats(0, 0, 0, 0, 0, 0, 0);
        this.pause();
        this.createCQ("CQuery_0", CQUERY_PREFIX + cqs[0]);
        this.validateCQServiceStats(1, 0, 1, 0, 1, 1, 0);
        this.pause();
        this.createValues(10000);
        this.pause();
        this.executeCQ("CQuery_0");
        this.pause();
        this.validateCQServiceStats(1, 1, 0, 0, 1, 1, 0);
        this.pause();
        this.validateCQStats("CQuery_0", 0, 0, 0, 0, 0);
        this.pause();
        this.createValues(20000);
        this.pause();
        this.validateCQStats("CQuery_0", 10000, 10000, 0, 20000, 20000);
        this.pause();
        this.deleteValues(10000);
        this.pause();
        this.validateCQStats("CQuery_0", 10000, 10000, 10000, 30000, 30000);
        this.pause();
        this.stopCQ("CQuery_0");
        this.pause();
        this.validateCQServiceStats(1, 0, 1, 0, 1, 1, 0);
        this.pause();
        this.closeCQ("CQuery_0");
        this.pause();
        this.validateCQServiceStats(1, 0, 0, 1, 0, 0, 0);
    }

    private void verifyStatistics() {
        int i;
        this.validateCQServiceStats(0, 0, 0, 0, 0, 0, 0);
        this.pause();
        for (i = 0; i < cqs.length; ++i) {
            this.createCQ(CQUERY_NAME_PREFIX + i, CQUERY_PREFIX + cqs[i]);
        }
        this.validateCQServiceStats(cqs.length, 0, cqs.length, 0, cqs.length, cqs.length, 0);
        this.pause();
        this.createValues(10000);
        this.pause();
        for (i = 0; i < cqs.length; ++i) {
            this.executeCQ(CQUERY_NAME_PREFIX + i);
        }
        this.pause();
        this.validateCQServiceStats(cqs.length, cqs.length, 0, 0, cqs.length, cqs.length, 0);
        this.pause();
        for (i = 0; i < cqs.length; ++i) {
            this.validateCQStats(CQUERY_NAME_PREFIX + i, 0, 0, 0, 0, 0);
        }
        this.pause();
        this.createValues(20000);
        this.pause();
        block17: for (i = 0; i < cqs.length; ++i) {
            switch (i) {
                case 0: {
                    this.validateCQStats(CQUERY_NAME_PREFIX + i, 10000, 10000, 0, 20000, 20000);
                    continue block17;
                }
                case 1: {
                    this.validateCQStats(CQUERY_NAME_PREFIX + i, 0, 1, 0, 1, 1);
                    continue block17;
                }
                case 2: {
                    this.validateCQStats(CQUERY_NAME_PREFIX + i, 0, 2, 0, 2, 2);
                    continue block17;
                }
                case 3: {
                    this.validateCQStats(CQUERY_NAME_PREFIX + i, 5000, 5000, 0, 10000, 10000);
                    continue block17;
                }
                case 4: {
                    this.validateCQStats(CQUERY_NAME_PREFIX + i, 5000, 5000, 0, 10000, 10000);
                }
            }
        }
        this.pause();
        this.deleteValues(10000);
        this.pause();
        this.validateCQStats("CQuery_0", 10000, 10000, 10000, 30000, 30000);
        block18: for (i = 0; i < cqs.length; ++i) {
            switch (i) {
                case 0: {
                    this.validateCQStats(CQUERY_NAME_PREFIX + i, 10000, 10000, 10000, 30000, 30000);
                    continue block18;
                }
                case 1: {
                    this.validateCQStats(CQUERY_NAME_PREFIX + i, 0, 1, 1, 2, 2);
                    continue block18;
                }
                case 2: {
                    this.validateCQStats(CQUERY_NAME_PREFIX + i, 0, 2, 2, 4, 4);
                    continue block18;
                }
                case 3: {
                    this.validateCQStats(CQUERY_NAME_PREFIX + i, 5000, 5000, 5000, 15000, 15000);
                    continue block18;
                }
                case 4: {
                    this.validateCQStats(CQUERY_NAME_PREFIX + i, 5000, 5000, 5000, 15000, 15000);
                }
            }
        }
        this.pause();
        for (i = 0; i < cqs.length; ++i) {
            this.stopCQ(CQUERY_NAME_PREFIX + i);
        }
        this.pause();
        this.validateCQServiceStats(cqs.length, 0, cqs.length, 0, cqs.length, cqs.length, 0);
        this.pause();
        for (i = 0; i < cqs.length; ++i) {
            this.closeCQ(CQUERY_NAME_PREFIX + i);
        }
        this.pause();
        this.validateCQServiceStats(cqs.length, 0, 0, cqs.length, 0, 0, 0);
    }

    public static void HydraTask_verifyCqStatistics() throws Exception {
        ((CQStatisticsTest)testInstance).verifyStatistics();
    }

    private void pause() {
        try {
            Thread.sleep(20000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void createValues(int size) {
        Region region1 = CQStatisticsTest.testInstance.aRegion;
        for (int i = 1; i <= size; ++i) {
            region1.put((Object)(KEY + i), (Object)new Portfolio(i));
        }
        Log.getLogWriter().info("### Number of Entries in Region :" + region1.keys().size());
    }

    public void deleteValues(int size) {
        Region region1 = CQStatisticsTest.testInstance.aRegion;
        for (int i = 1; i <= size; ++i) {
            region1.destroy((Object)(KEY + i));
        }
        Log.getLogWriter().info("### Number of Entries in Region :" + region1.keys().size());
    }

    public void executeCQ(String cqName) {
        QueryService cqService = null;
        CqQuery cq1 = null;
        cqService = CacheHelper.getCache().getQueryService();
        try {
            cq1 = cqService.getCq(cqName);
            if (cq1 == null) {
                Log.getLogWriter().info("Failed to get CqQuery object for CQ name: " + cqName);
                throw new TestException("Could not get cq with name " + cqName);
            }
            Log.getLogWriter().info("Obtained CQ, CQ name: " + cq1.getName());
            cq1.execute();
        }
        catch (Exception ex) {
            Log.getLogWriter().info("CqService is :" + cqService);
            Log.getLogWriter().error((Throwable)ex);
            AssertionError err = new AssertionError((Object)("Failed to execute  CQ " + cqName));
            ((Throwable)((Object)err)).initCause(ex);
            throw err;
        }
    }

    public void createCQ(String cqName, String queryStr) {
        Log.getLogWriter().info("### Create CQ. ###" + cqName);
        QueryService cqService = null;
        cqService = CacheHelper.getCache().getQueryService();
        CqAttributesFactory cqf = new CqAttributesFactory();
        CqListener[] cqListeners = new CqListener[]{new CqQueryTestListener(Log.getLogWriter())};
        cqf.initCqListeners(cqListeners);
        CqAttributes cqa = cqf.create();
        try {
            CqQuery cqQuery = cqService.newCq(cqName, queryStr, cqa);
        }
        catch (Exception ex) {
            AssertionError err = new AssertionError((Object)("Failed to create CQ " + cqName + " . "));
            ((Throwable)((Object)err)).initCause(ex);
            Log.getLogWriter().info("CqService is :" + cqService, (Throwable)((Object)err));
            throw err;
        }
    }

    public void stopCQ(String cqName) {
        QueryService cqService = null;
        cqService = CacheHelper.getCache().getQueryService();
        CqQuery cq1 = null;
        cq1 = cqService.getCq(cqName);
        try {
            cq1.stop();
        }
        catch (CqClosedException e) {
            throw new TestException(e.getMessage());
        }
        catch (CqException e) {
            throw new TestException(e.getMessage());
        }
    }

    public void closeCQ(String cqName) {
        QueryService cqService = null;
        cqService = CacheHelper.getCache().getQueryService();
        CqQuery cq1 = null;
        cq1 = cqService.getCq(cqName);
        try {
            cq1.close();
        }
        catch (CqClosedException e) {
            throw new TestException(e.getMessage());
        }
        catch (CqException e) {
            throw new TestException(e.getMessage());
        }
    }
}

