/*
 * Decompiled with CFR 0.152.
 */
package cq.newWan.serial;

import com.gemstone.gemfire.cache.CacheEvent;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventCallbackArgument;
import hydra.DistributedSystemHelper;
import hydra.GatewaySenderHelper;
import hydra.Log;
import java.util.Set;
import newWan.WANBlackboard;
import util.QueryObject;
import util.SilenceListener;
import util.SilenceListenerBB;

public class WANCQCacheListener
extends SilenceListener {
    @Override
    public void afterUpdate(EntryEvent event) {
        GatewaySenderEventCallbackArgument callback;
        SilenceListenerBB.getBB().getSharedCounters().setIfLarger(SilenceListenerBB.lastEventTime, System.currentTimeMillis());
        Long oldValue = ((QueryObject)event.getOldValue()).aLong;
        Long newValue = ((QueryObject)event.getNewValue()).aLong;
        if (newValue - oldValue < 1L) {
            String err = new String("Expected aLong in newValue should be greated than aLong in oldValue, but found smaller with the difference of " + (newValue - oldValue) + " \n" + this.toString("afterUpdate", (CacheEvent)event));
            WANBlackboard.throwException(err);
        } else if (newValue - oldValue > 1L && (callback = (GatewaySenderEventCallbackArgument)((EntryEventImpl)event).getRawCallbackArgument()) != null) {
            Set<GatewaySender> senders;
            Integer dsId = DistributedSystemHelper.getDistributedSystemId();
            if (callback.getOriginatingDSId() != -1 && dsId.intValue() == callback.getOriginatingDSId()) {
                String err = new String("Event Loopback issue detected. Event's originatingDSId is same as localDSID which is " + dsId + ".\n" + this.toString("afterUpdate", (CacheEvent)event));
                WANBlackboard.throwException(err);
            }
            if ((senders = GatewaySenderHelper.getGatewaySenders()) == null || senders.size() == 0) {
                String err = new String("Possible test issue, No gateway sender found. \n" + this.toString("afterUpdate", (CacheEvent)event));
                WANBlackboard.throwException(err);
            } else {
                GatewaySender sender = senders.iterator().next();
                if (sender.isBatchConflationEnabled()) {
                    Log.getLogWriter().info("Difference between aLong in newValue and aLong in oldValue is more than 1. Sender isBatchedConflationEnabled is true and this is expected in this situation. " + event);
                } else {
                    String err = new String("Difference between aLong in newValue and aLong in oldValue should not be more than 1, but found " + (newValue - oldValue) + ". This is not expected as Gateway sender isBatchedConflationEnabled=false. " + this.toString("afterUpdate", (CacheEvent)event));
                    WANBlackboard.throwException(err);
                }
            }
        }
    }
}

