/*
 * Decompiled with CFR 0.152.
 */
package cq;

import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.query.CqEvent;
import com.gemstone.gemfire.cache.query.CqListener;
import cq.ListenerBB;
import cq.ListenerTest;
import hydra.Log;
import hydra.Prms;
import hydra.TestConfig;
import hydra.blackboard.SharedMap;
import java.util.Properties;
import util.AbstractListener;
import util.TestException;
import util.TestHelper;

public class MultiListener
extends AbstractListener
implements CqListener,
Declarable {
    private boolean isCarefulValidation;
    private String name = "MultiListener";

    public MultiListener() {
        this.isCarefulValidation = TestConfig.tab().booleanAt(Prms.serialExecution, true);
    }

    public MultiListener(String name) {
        this.name = name;
        this.isCarefulValidation = TestConfig.tab().booleanAt(Prms.serialExecution);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void onEvent(CqEvent event) {
        try {
            this.logCQEvent("onEvent", event);
            this.updateBB(event);
        }
        catch (Exception e) {
            String s = "cq.MultiListener.onEvent() caught Exception " + e + " " + TestHelper.getStackTrace(e);
            this.throwException(s);
        }
    }

    public void onError(CqEvent event) {
        try {
            this.logCQEvent("onError", event);
        }
        catch (Exception e) {
            String s = "cq.MultiListener.onError() caught Exception for key = " + event.getKey() + " and throwable " + event.getThrowable().toString() + " " + TestHelper.getStackTrace(e);
            this.throwException(s);
        }
    }

    public void close() {
        this.logCall("close", null);
    }

    private void updateBB(CqEvent event) {
        if (!this.isCarefulValidation) {
            return;
        }
        if (ListenerTest.targetVm) {
            String key = ListenerBB.InvokedListeners + "_" + event.getCq().getName();
            String invokedList = (String)ListenerBB.getBB().getSharedMap().get(key);
            StringBuffer invoked = new StringBuffer(invokedList);
            invoked.append(this.name + ":");
            ListenerBB.getBB().getSharedMap().put(key, invoked.toString());
            ListenerBB.getBB().getSharedCounters().increment(ListenerBB.NUM_LISTENER_INVOCATIONS);
        }
    }

    protected void throwException(String errStr) {
        SharedMap aMap = ListenerBB.getBB().getSharedMap();
        aMap.put(TestHelper.EVENT_ERROR_KEY, errStr);
        Log.getLogWriter().info(errStr);
        throw new TestException(errStr);
    }

    public void init(Properties prop) {
        this.logCall("init(Properties)", null);
    }
}

