/*
 * Decompiled with CFR 0.152.
 */
package cq;

import com.gemstone.gemfire.cache.query.IndexExistsException;
import com.gemstone.gemfire.cache.query.IndexNameConflictException;
import com.gemstone.gemfire.cache.query.QueryException;
import cq.CQUtilPrms;
import cq.ConcCQAndOpsTest;
import cq.IndexTest;
import hydra.Log;
import hydra.TestConfig;
import mapregion.MapPrms;
import util.TestException;

public class ConcCQAndOpsIndexTest
extends ConcCQAndOpsTest {
    protected static ConcCQAndOpsIndexTest concCQAndOpsIndexTest;
    protected boolean createQtyIndex;
    protected boolean createMktValueIndex;

    public static synchronized void HydraTask_initialize() {
        if (concCQAndOpsIndexTest == null) {
            concCQAndOpsIndexTest = new ConcCQAndOpsIndexTest();
            concCQAndOpsIndexTest.initialize();
        }
    }

    @Override
    protected void createIndex() {
        int i;
        this.createQtyIndex = TestConfig.tab().booleanAt(CQUtilPrms.createQtyIndex, false);
        this.createMktValueIndex = TestConfig.tab().booleanAt(CQUtilPrms.createMktValueIndex, false);
        IndexTest indexTest = new IndexTest();
        String[] regionNames = MapPrms.getRegionNames();
        if (this.createQtyIndex) {
            for (i = 0; i < regionNames.length; ++i) {
                try {
                    indexTest.createQtyIndex(regionNames[i]);
                    continue;
                }
                catch (IndexNameConflictException e) {
                    Log.getLogWriter().info("Caught expected IndexNameConflictException, continuing tests");
                    continue;
                }
                catch (IndexExistsException e) {
                    Log.getLogWriter().info("Caught expected IndexExistsException, continuing tests");
                    continue;
                }
                catch (QueryException e) {
                    throw new TestException("Could not create Index " + e.getStackTrace());
                }
            }
        }
        if (this.createMktValueIndex) {
            for (i = 0; i < regionNames.length; ++i) {
                try {
                    indexTest.createMktValueIndex(regionNames[i]);
                    continue;
                }
                catch (IndexNameConflictException e) {
                    Log.getLogWriter().info("Caught expected IndexNameConflictException, continuing tests");
                    continue;
                }
                catch (IndexExistsException e) {
                    Log.getLogWriter().info("Caught expected IndexExistsException, continuing tests");
                    continue;
                }
                catch (QueryException e) {
                    throw new TestException("Could not create Index " + e.getStackTrace());
                }
            }
        }
    }
}

