/*
 * Decompiled with CFR 0.152.
 */
package cq;

import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.query.CqEvent;
import com.gemstone.gemfire.cache.query.SelectResults;
import hydra.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import util.QueryObject;
import util.TestException;

public class CQHistory {
    private String cqName = null;
    private SelectResults sr = null;
    private List eventList = new ArrayList();

    public CQHistory(String cqNameArg) {
        this.cqName = cqNameArg;
    }

    public void addEvent(CqEvent anEvent) {
        this.eventList.add(anEvent);
    }

    public void setSelectResults(SelectResults srArg) {
        this.sr = srArg;
    }

    public List getEvents() {
        return this.eventList;
    }

    public String getCqName() {
        return this.cqName;
    }

    public SelectResults getSelectResults() {
        return this.sr;
    }

    public String toString() {
        int i;
        StringBuffer aStr = new StringBuffer();
        List srList = this.sr.asList();
        aStr.append("CQHistory for " + this.cqName + ", SelectResults is size " + srList.size() + " as follows\n");
        for (i = 0; i < srList.size(); ++i) {
            aStr.append(srList.get(i) + "\n");
        }
        aStr.append("Event history is size " + this.eventList.size() + " as follows\n");
        for (i = 0; i < this.eventList.size(); ++i) {
            CqEvent cqEvent = (CqEvent)this.eventList.get(i);
            QueryObject qo = (QueryObject)cqEvent.getNewValue();
            aStr.append(qo + ", qo.extra = " + (qo == null ? null : qo.extra) + "\n");
        }
        return aStr.toString();
    }

    public Map getCombinedResults() {
        Object key2;
        Log.getLogWriter().info("Combining SelectResults and event history for " + this);
        HashMap<Object, Object> combinedMap = new HashMap<Object, Object>();
        List srList = this.sr.asList();
        Log.getLogWriter().info("Processing " + srList.size() + " elements of SelectResults:");
        for (int i = 0; i < srList.size(); ++i) {
            Object value = srList.get(i);
            QueryObject qo = (QueryObject)value;
            key2 = qo.extra;
            combinedMap.put(key2, value);
            Log.getLogWriter().info("Adding to combined map from srList: " + key2 + " " + value);
        }
        HashSet<Object> keysOfCQEventsSet = new HashSet<Object>();
        for (int i = 0; i < this.eventList.size(); ++i) {
            CqEvent event = (CqEvent)this.eventList.get(i);
            key2 = event.getKey();
            Operation op = event.getQueryOperation();
            if (keysOfCQEventsSet.contains(key2)) {
                throw new TestException("Received two cq events for " + key2 + ", but expected 1; second event is " + event);
            }
            keysOfCQEventsSet.add(key2);
            if (op.isCreate()) {
                Log.getLogWriter().info("Adding to combined map (create event): " + event.getKey() + " " + event.getNewValue() + " event is " + event);
                Object object = combinedMap.put(event.getKey(), event.getNewValue());
                continue;
            }
            if (op.isDestroy() || op.isInvalidate()) {
                if (!combinedMap.containsKey(event.getKey())) continue;
                combinedMap.remove(event.getKey());
                Log.getLogWriter().info("Removing from combined map (destroy or invalidate): " + event.getKey() + " event is " + event);
                continue;
            }
            if (op.isUpdate()) {
                combinedMap.put(event.getKey(), event.getNewValue());
                Log.getLogWriter().info("Updating combined map (update event): " + event.getKey() + " " + event.getNewValue() + " event is " + event);
                continue;
            }
            throw new TestException("Test problem: Unknown operation " + op);
        }
        StringBuffer aStr = new StringBuffer();
        aStr.append("CombinedMap is size " + combinedMap.size() + "\n");
        for (Object key2 : combinedMap.keySet()) {
            aStr.append(key2 + " " + combinedMap.get(key2) + "\n");
        }
        Log.getLogWriter().info(aStr.toString());
        return combinedMap;
    }
}

