/*
 * Decompiled with CFR 0.152.
 */
package cq;

import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.query.CqEvent;
import com.gemstone.gemfire.cache.query.CqListener;
import cq.CQTest;
import cq.CQUtilBB;
import hydra.Log;
import hydra.ProcessMgr;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import pdx.PdxTestVersionHelper;
import util.AbstractListener;
import util.QueryObject;
import util.TestException;
import util.TestHelper;

public class CQGatherListener
extends AbstractListener
implements CqListener {
    private static Map globalGatherMap = Collections.synchronizedMap(new HashMap());
    private static final String ErrorKey = "ErrorKey";

    public static Map getGatherMap(String cqName) {
        HashMap aMap = (HashMap)globalGatherMap.get(cqName);
        if (aMap == null) {
            aMap = new HashMap();
            globalGatherMap.put(cqName, aMap);
        }
        return aMap;
    }

    public static void resetGatherMap(String cqName) {
        globalGatherMap.put(cqName, new HashMap());
    }

    public static void checkForError() {
        String errStr = (String)CQUtilBB.getBB().getSharedMap().get(ErrorKey);
        if (errStr != null) {
            throw new TestException("Error occurred in CQGatherListener: " + errStr);
        }
    }

    public void onError(CqEvent aCqEvent) {
        String listenerStr = this.toString("onError", aCqEvent);
        Log.getLogWriter().info(listenerStr);
        CQUtilBB.getBB().getSharedMap().put(ErrorKey, listenerStr);
    }

    public void onEvent(CqEvent event) {
        CQUtilBB.getBB().getSharedCounters().setIfLarger(CQUtilBB.lastEventTime, System.currentTimeMillis());
        String eventStr = this.logCQEventAsSummary("onEvent", event);
        String cqName = event.getCq().getName();
        String queryStr = event.getCq().getQueryString();
        Object newValue = event.getNewValue();
        newValue = PdxTestVersionHelper.toBaseObject(newValue);
        if (newValue != null && !(newValue instanceof QueryObject)) {
            String errStr = "Validation failure in pid " + ProcessMgr.getProcessId() + " CqEvent was invoked, but getNewValue() returned unexpected " + newValue + " " + eventStr + ", query " + cqName + ", " + CQTest.getReadableQueryString(queryStr);
            Log.getLogWriter().info(errStr);
            CQUtilBB.getBB().getSharedMap().put(ErrorKey, errStr);
            return;
        }
        HashMap<Object, Object> gatherMap = (HashMap<Object, Object>)globalGatherMap.get(cqName);
        if (gatherMap == null) {
            gatherMap = new HashMap<Object, Object>();
        }
        boolean newValueShouldSatisfyQuery = true;
        Operation op = event.getQueryOperation();
        if (op.equals(Operation.CREATE)) {
            gatherMap.put(event.getKey(), newValue);
            newValueShouldSatisfyQuery = true;
        } else if (op.equals(Operation.DESTROY)) {
            gatherMap.remove(event.getKey());
            newValueShouldSatisfyQuery = false;
        } else if (op.equals(Operation.INVALIDATE)) {
            gatherMap.put(event.getKey(), null);
            newValueShouldSatisfyQuery = true;
        } else if (op.equals(Operation.UPDATE)) {
            gatherMap.put(event.getKey(), newValue);
            newValueShouldSatisfyQuery = true;
        }
        globalGatherMap.put(cqName, gatherMap);
        QueryObject qo = (QueryObject)newValue;
        boolean satisfied = CQTest.satisfiesQuery(queryStr, qo);
        if (newValueShouldSatisfyQuery) {
            if (!satisfied) {
                String errStr = "Validation failure in pid " + ProcessMgr.getProcessId() + " CQGatherListener, " + eventStr + ", query " + cqName + ", " + CQTest.getReadableQueryString(queryStr) + " is not satisfied by " + qo.toStringFull();
                Log.getLogWriter().info(errStr);
                CQUtilBB.getBB().getSharedMap().put(ErrorKey, errStr);
            }
        } else if (satisfied) {
            String errStr = "Validation failure in pid " + ProcessMgr.getProcessId() + " CQGatherListener, " + eventStr + ", query " + cqName + ", " + CQTest.getReadableQueryString(queryStr) + " is satisfied by " + qo.toStringFull() + " but it should not be";
            Log.getLogWriter().info(errStr);
            CQUtilBB.getBB().getSharedMap().put(ErrorKey, errStr);
        }
    }

    public void close() {
        Log.getLogWriter().info("Invoked CQGatherListener.close()");
    }

    public static void waitForSilence(long desiredSilenceSec, long sleepMS) {
        Log.getLogWriter().info("Waiting for a period of silence for " + desiredSilenceSec + " seconds...");
        long desiredSilenceMS = desiredSilenceSec * 1000L;
        long silenceStartTime = System.currentTimeMillis();
        long currentTime = System.currentTimeMillis();
        long lastEventTime = CQUtilBB.getBB().getSharedCounters().read(CQUtilBB.lastEventTime);
        while (currentTime - silenceStartTime < desiredSilenceMS) {
            try {
                Thread.sleep(sleepMS);
            }
            catch (InterruptedException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            lastEventTime = CQUtilBB.getBB().getSharedCounters().read(CQUtilBB.lastEventTime);
            if (lastEventTime > silenceStartTime) {
                silenceStartTime = lastEventTime;
            }
            currentTime = System.currentTimeMillis();
        }
        long duration = currentTime - silenceStartTime;
        Log.getLogWriter().info("Done waiting, CQs have been silent for " + duration + " ms");
    }
}

