/*
 * Decompiled with CFR 0.152.
 */
package container.app.phonedirectory.remoting.rmi;

import container.app.lang.support.DestroyVisitor;
import container.app.phonedirectory.service.PhoneDirectoryService;
import container.app.phonedirectory.service.factory.PhoneDirectoryServiceFactory;
import container.app.remoting.rmi.AbstractRmiServiceExporter;
import container.app.util.StringUtils;
import container.app.util.Sys;
import java.io.IOException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Scanner;

public class PhoneDirectoryServiceExporter
extends AbstractRmiServiceExporter {
    public static final String SERVICE_NAME = "phoneDirectoryService";
    private volatile PhoneDirectoryService service;

    @Override
    protected int getRegistryPort() {
        return Integer.getInteger("gemfire.container-tests.rmi-registry.port", super.getRegistryPort());
    }

    @Override
    protected String getServiceNameForBinding() {
        return SERVICE_NAME;
    }

    @Override
    protected Remote exportRemoteObject() throws RemoteException {
        this.service = PhoneDirectoryServiceFactory.getPhoneDirectoryService();
        return UnicastRemoteObject.exportObject((Remote)this.service, 0);
    }

    protected void promptForUserInput() throws IOException {
        Sys.out("Enter 'exit' to stop the Phone Directory Service and 'show' to list available services!", new Object[0]);
        Scanner in = new Scanner(System.in);
        String input = null;
        do {
            if ("show".equalsIgnoreCase(input = StringUtils.trim(in.nextLine()))) {
                this.showAvailableServices();
                continue;
            }
            Sys.out("({0}) is not a valid command; Please enter 'exit' or 'show'.", input);
        } while (!"exit".equalsIgnoreCase(input));
    }

    @Override
    public void stop() throws Exception {
        this.service.accept(new DestroyVisitor());
        this.service = null;
        super.stop();
    }

    public static void main(String[] args) throws Exception {
        PhoneDirectoryServiceExporter exporter = null;
        try {
            exporter = new PhoneDirectoryServiceExporter();
            exporter.run();
            exporter.promptForUserInput();
        }
        catch (Exception e) {
            Sys.err(e);
        }
        finally {
            if (exporter != null) {
                Sys.out("Stopping the Phone Directory Service...", new Object[0]);
                exporter.stop();
            }
        }
    }
}

