/*
 * Decompiled with CFR 0.152.
 */
package container.app.phonedirectory.domain;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import container.app.domain.AbstractDomainObject;
import container.app.lang.Visitor;
import container.app.phonedirectory.domain.Address;
import container.app.phonedirectory.domain.Person;
import container.app.phonedirectory.domain.PhoneNumber;
import container.app.util.Assert;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class PhoneDirectoryEntry
extends AbstractDomainObject
implements DataSerializable {
    private static final long serialVersionUID = 1010101L;
    private Address address;
    private Person person;
    private PhoneNumber phoneNumber;

    public PhoneDirectoryEntry() {
    }

    public PhoneDirectoryEntry(Person person, Address address) {
        this(person, address, null);
    }

    public PhoneDirectoryEntry(Person person, PhoneNumber phoneNumber) {
        this(person, null, phoneNumber);
    }

    public PhoneDirectoryEntry(Person person, Address address, PhoneNumber phoneNumber) {
        this.setPerson(person);
        this.address = address;
        this.phoneNumber = phoneNumber;
    }

    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public Person getPerson() {
        return this.person;
    }

    public final void setPerson(Person person) {
        Assert.notNull(person, "The Person for the Phone Directory Entry cannot be null!", new Object[0]);
        this.person = person;
    }

    public PhoneNumber getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(PhoneNumber phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeObject((Object)this.getPerson(), (DataOutput)out);
        DataSerializer.writeObject((Object)this.getAddress(), (DataOutput)out);
        DataSerializer.writeObject((Object)this.getPhoneNumber(), (DataOutput)out);
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.person = (Person)DataSerializer.readObject((DataInput)in);
        this.address = (Address)DataSerializer.readObject((DataInput)in);
        this.phoneNumber = (PhoneNumber)DataSerializer.readObject((DataInput)in);
    }

    @Override
    public void accept(Visitor visitor) {
        super.accept(visitor);
        this.getPerson().accept(visitor);
        if (this.getAddress() != null) {
            this.getAddress().accept(visitor);
        }
        if (this.getPhoneNumber() != null) {
            this.getPhoneNumber().accept(visitor);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PhoneDirectoryEntry)) {
            return false;
        }
        PhoneDirectoryEntry that = (PhoneDirectoryEntry)obj;
        return this.getPerson().equals(that.getPerson());
    }

    public int hashCode() {
        int hashValue = 17;
        hashValue = 37 * hashValue + this.getPerson().hashCode();
        return hashValue;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(this.getClass().getName());
        buffer.append("{person = ").append(this.getPerson());
        buffer.append(", address = ").append(this.getAddress());
        buffer.append(", phoneNumber = ").append(this.getPhoneNumber());
        buffer.append("}");
        return buffer.toString();
    }
}

