/*
 * Decompiled with CFR 0.152.
 */
package container;

import container.AbstractPhoneDirectoryServiceTestCase;
import container.app.phonedirectory.domain.Address;
import container.app.phonedirectory.domain.Person;
import container.app.phonedirectory.domain.PhoneDirectoryEntry;
import container.app.phonedirectory.domain.PhoneNumber;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;

public class PhoneDirectoryServiceTest
extends AbstractPhoneDirectoryServiceTestCase {
    public PhoneDirectoryServiceTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(PhoneDirectoryServiceTest.class);
        return new AbstractPhoneDirectoryServiceTestCase.PhoneDirectoryServiceCacheTestSetup((Test)suite);
    }

    public void testFromCacheToApp() throws Exception {
        Person expectedPerson = this.createPerson("Jon", "Doe");
        Address expectedAddress = this.createAddress("100 Main St", "Portland", "OR", "97205");
        PhoneNumber expectedPhoneNumber = this.createPhoneNumber("503", "555", "1234");
        PhoneDirectoryEntry expectedEntry = this.createPhoneDirectoryEntry(expectedPerson, expectedAddress, expectedPhoneNumber);
        PhoneDirectoryServiceTest.getRegion().put((Object)"jon doe", (Object)expectedEntry);
        PhoneDirectoryEntry actualEntry = PhoneDirectoryServiceTest.getPhoneDirectoryService().getEntry(expectedPerson);
        Assert.assertNotNull((Object)actualEntry);
        PhoneDirectoryServiceTest.assertEquals(expectedEntry, actualEntry);
    }

    public void testFromAppToCache() throws Exception {
        Person expectedPerson = this.createPerson("Jane", "Doe");
        Address expectedAddress = this.createAddress("1221 Yamhill", "Portland", "OR", "97205");
        PhoneNumber expectedPhoneNumber = this.createPhoneNumber("503", "555", "9876");
        PhoneDirectoryEntry expectedEntry = this.createPhoneDirectoryEntry(expectedPerson, expectedAddress, expectedPhoneNumber);
        PhoneDirectoryServiceTest.getPhoneDirectoryService().add(expectedPerson, expectedAddress, expectedPhoneNumber);
        PhoneDirectoryEntry actualEntry = (PhoneDirectoryEntry)PhoneDirectoryServiceTest.getRegion().get((Object)"jane doe");
        Assert.assertNotNull((Object)actualEntry);
        PhoneDirectoryServiceTest.assertEquals(expectedEntry, actualEntry);
    }
}

