/*
 * Decompiled with CFR 0.152.
 */
package connPool;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.client.ClientCache;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.ClientCacheHelper;
import hydra.ClientRegionHelper;
import hydra.DistributedSystemHelper;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.PoolDescription;
import hydra.RegionHelper;
import hydra.RemoteTestModule;

public class ConnPoolTest {
    protected static ConnPoolTest testInstance;
    protected static final String VmIDStr = "VmId_";

    public static synchronized void HydraTask_createLocator() {
        DistributedSystemHelper.createLocator();
    }

    public static synchronized void HydraTask_startLocator() {
        DistributedSystemHelper.startLocatorAndAdminDS();
    }

    public static synchronized void HydraTask_initializeClient() {
        if (testInstance == null) {
            testInstance = new ConnPoolTest();
            testInstance.initializeRegion("clientRegion");
        }
    }

    public static synchronized void HydraTask_initializeServer() {
        if (testInstance == null) {
            testInstance = new ConnPoolTest();
            testInstance.initializeRegion("dataStoreRegion");
            BridgeHelper.startBridgeServer("bridge");
        }
    }

    protected void initializeRegion(String regDescriptName) {
        block4: {
            CacheHelper.createCache("cache1");
            String key = VmIDStr + RemoteTestModule.getMyVmid();
            String xmlFile = key + ".xml";
            try {
                PoolDescription poolDescr = RegionHelper.getRegionDescription(regDescriptName).getPoolDescription();
                if (poolDescr != null) {
                    CacheHelper.generateCacheXmlFile("cache1", regDescriptName, null, poolDescr.getName(), xmlFile);
                } else {
                    CacheHelper.generateCacheXmlFile("cache1", regDescriptName, xmlFile);
                }
            }
            catch (HydraRuntimeException e) {
                String errStr = e.toString();
                if (errStr.indexOf("Cache XML file was already created") >= 0) break block4;
                throw e;
            }
        }
        RegionHelper.createRegion(regDescriptName);
    }

    public static synchronized void HydraTask_initializeClientCache() {
        if (testInstance == null) {
            testInstance = new ConnPoolTest();
            testInstance.initializeClientCache("clientCache", "clientRegion");
        }
    }

    protected void initializeClientCache(String cacheConfig, String regionConfig) {
        block2: {
            ClientCache c = ClientCacheHelper.createCache(cacheConfig);
            String key = VmIDStr + RemoteTestModule.getMyVmid();
            String xmlFile = key + ".xml";
            try {
                ClientCacheHelper.generateCacheXmlFile(cacheConfig, regionConfig, xmlFile);
            }
            catch (HydraRuntimeException e) {
                String errStr = e.toString();
                if (errStr.indexOf("Cache XML file was already created") >= 0) break block2;
                throw e;
            }
        }
        Region r = ClientRegionHelper.createRegion(regionConfig);
        RegionAttributes ratts = r.getAttributes();
        Log.getLogWriter().info("Created region " + r.getName() + " with attributes " + RegionHelper.regionAttributesToString(ratts));
    }
}

