/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.sequence.gemfire;

import com.gemstone.sequence.LineMapper;
import com.gemstone.sequence.gemfire.DefaultLineMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HydraLineMapper
implements LineMapper {
    private static final Pattern VM_NAME_PATTERN = Pattern.compile("(vm_\\d+).*_(\\d+)(_end)?\\.log");
    private static final Pattern DISK_DIR_PATTERN = Pattern.compile("vm_(\\d+).*_disk_1");
    private final Map<String, String> processIdToVMName = new HashMap<String, String>();
    private final DefaultLineMapper defaultMapper = new DefaultLineMapper();

    public HydraLineMapper(File[] graphFiles) {
        Matcher matcher;
        String[] files;
        File firstFile = graphFiles[0];
        File directory = firstFile.getParentFile();
        if (directory == null || !new File(directory, "latest.prop").exists()) {
            directory = new File(".");
        }
        for (String file : files = directory.list()) {
            matcher = VM_NAME_PATTERN.matcher(file);
            if (!matcher.matches()) continue;
            this.processIdToVMName.put(matcher.group(2), matcher.group(1));
        }
        for (String file : files) {
            String storeId;
            matcher = DISK_DIR_PATTERN.matcher(file);
            if (!matcher.matches() || (storeId = this.getDiskStoreId(file)) == null) continue;
            this.processIdToVMName.put(storeId, "disk_" + matcher.group(1));
        }
    }

    private String getDiskStoreId(String diskStoreDir) {
        String[] files;
        File dir = new File(diskStoreDir);
        for (String fileName : files = dir.list()) {
            if (!fileName.endsWith(".if")) continue;
            try {
                return this.getDiskStoreIdFromInitFile(dir, fileName);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDiskStoreIdFromInitFile(File dir, String fileName) throws FileNotFoundException, IOException {
        try (FileInputStream fis = new FileInputStream(new File(dir, fileName));){
            byte[] bytes = new byte[17];
            fis.read(bytes);
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            buffer.get();
            long least = buffer.getLong();
            long most = buffer.getLong();
            UUID id = new UUID(most, least);
            String string = id.toString();
            return string;
        }
    }

    @Override
    public String getShortNameForLine(String lineName) {
        String name = this.defaultMapper.getShortNameForLine(lineName);
        if (this.processIdToVMName.containsKey(name)) {
            return this.processIdToVMName.get(name);
        }
        return name;
    }

    public static boolean isInHydraRun(File[] graphFiles) {
        if (graphFiles.length == 0) {
            return false;
        }
        File firstFile = graphFiles[0];
        File parentFile = firstFile.getParentFile();
        for (File file : graphFiles) {
            if (parentFile == null && file.getParentFile() == null) {
                return true;
            }
            if (parentFile != null && file.getParentFile() != null && file.getParentFile().equals(parentFile)) continue;
            return false;
        }
        return new File(parentFile, "latest.prop").exists() || new File("latest.prop").exists();
    }
}

