/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.sequence;

import com.gemstone.sequence.LifelineState;
import com.gemstone.sequence.StateColorMap;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

public class Lifeline {
    private List<LifelineState> states;
    private final String name;
    private final Comparable diagramName;
    private int x;
    private int width;

    public String getName() {
        return this.name;
    }

    public int getX() {
        return this.x;
    }

    public int getWidth() {
        return this.width;
    }

    public void addState(LifelineState state) {
        this.states.add(state);
    }

    public Lifeline(Comparable diagramName, String name) {
        this.name = name;
        this.states = new ArrayList<LifelineState>();
        this.diagramName = diagramName;
    }

    public void resize(int x, int lineWidth, long Ybase, double Yscale) {
        for (LifelineState state : this.states) {
            state.resize(Yscale, Ybase);
        }
        this.x = x;
        this.width = lineWidth;
    }

    public void paint(Graphics2D g, StateColorMap colorMap) {
        Rectangle boundary = g.getClipBounds();
        if ((double)this.x > boundary.getMaxX() || (double)(this.x + this.width) < boundary.getMinX()) {
            return;
        }
        for (LifelineState state : this.states) {
            state.paint(g, colorMap);
        }
    }

    public List<LifelineState> getStates() {
        return this.states;
    }

    public LifelineState getStateAt(int y) {
        for (LifelineState state : this.states) {
            if (state.getStartY() >= y || state.getStartY() + state.getHeight() <= y) continue;
            return state;
        }
        return null;
    }

    public Comparable getDiagramName() {
        return this.diagramName;
    }
}

