/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.distributed.internal.membership.NetView;
import com.gemstone.gemfire.distributed.internal.membership.jgroup.JGroupMember;
import com.gemstone.gemfire.distributed.internal.membership.jgroup.JGroupMembershipManager;
import com.gemstone.gemfire.distributed.internal.membership.jgroup.MembershipManagerHelper;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Header;
import com.gemstone.org.jgroups.JChannel;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.protocols.GemFireTimeSync;
import com.gemstone.org.jgroups.stack.IpAddress;
import com.gemstone.org.jgroups.stack.ProtocolStack;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.VM;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;

public class CacheTimeSlowDownDUnitTest
extends DistributedTestCase {
    public CacheTimeSlowDownDUnitTest(String name) {
        super(name);
    }

    public void testCacheClockSlowDownUsingTimeTask() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        CacheTimeSlowDownDUnitTest.disconnectAllFromDS();
        int port = CacheTimeSlowDownDUnitTest.getDUnitLocatorPort();
        final long joinTimeOffset = (Long)vm0.invoke(new SerializableCallable("Check join time offset"){

            public Object call() throws CacheException {
                InternalDistributedSystem system = CacheTimeSlowDownDUnitTest.this.getSystem();
                Cache cache = CacheFactory.create((DistributedSystem)system);
                DistributionManager dm = (DistributionManager)system.getDistributionManager();
                dm.setDMTestHook((DistributionManager.DMTestHook)new DistManagerTestHook());
                return dm.getCacheTimeOffset();
            }
        });
        VM locator = Host.getLocator();
        locator.invoke(new CacheSerializableRunnable("Send custom time sync message"){

            @Override
            public void run2() {
                InternalDistributedSystem system = InternalDistributedSystem.getAnyInstance();
                JGroupMembershipManager jgmm = MembershipManagerHelper.getMembershipManager((DistributedSystem)system);
                JChannel jchannel = MembershipManagerHelper.getJChannel((DistributedSystem)system);
                JGroupMember locMem = system.getDistributedMember().getNetMember();
                if (jchannel != null && jchannel.isConnected()) {
                    ProtocolStack pstack = jchannel.getProtocolStack();
                    GemFireTimeSync gts = (GemFireTimeSync)pstack.findProtocol("GemFireTimeSync");
                    NetView nw = jgmm.getView();
                    IpAddress memAdd = null;
                    for (Object member : nw) {
                        InternalDistributedMember iMem = (InternalDistributedMember)member;
                        JGroupMember netMem = iMem.getNetMember();
                        if (netMem.equals((Object)locMem)) continue;
                        memAdd = netMem.getAddress();
                    }
                    Message offsetMessage = new Message();
                    offsetMessage.setDest(memAdd);
                    offsetMessage.isHighPriority = true;
                    offsetMessage.putHeader("GemFireTimeSync", (Header)new GemFireTimeSync.GFTimeSyncHeader(0L, 2, joinTimeOffset - 19L));
                    gts.passDown(new Event(1, (Object)offsetMessage));
                    DistributedTestCase.getLogWriter().info("Sent a GemfireTimeSync message to apply lower offset: " + (joinTimeOffset - 19L) + "ms");
                }
            }
        });
        long newTimeOffset = (Long)vm0.invoke(new SerializableCallable("Verify timer task and final offset"){

            public Object call() throws CacheException {
                InternalDistributedSystem system = CacheTimeSlowDownDUnitTest.this.getSystem();
                DistributionManager dm = (DistributionManager)system.getDistributionManager();
                DistributionManager.DMTestHook testHook = dm.getTestHook();
                TestCase.assertNotNull((Object)testHook);
                while (testHook.getInformation((Object)"TimerTaskCancelled") == null) {
                    DistributedTestCase.pause(100);
                }
                boolean isCancelled = (Boolean)testHook.getInformation((Object)"TimerTaskCancelled");
                List cacheTimes = (List)testHook.getInformation((Object)"CacheTime");
                List awaitedTimes = (List)testHook.getInformation((Object)"AwaitedTime");
                TestCase.assertTrue((boolean)isCancelled);
                TestCase.assertEquals((int)cacheTimes.size(), (int)awaitedTimes.size());
                for (int i = 0; i < cacheTimes.size() - 1; ++i) {
                    TestCase.assertTrue(((Long)cacheTimes.get(i) - (Long)awaitedTimes.get(i) >= 0L ? 1 : 0) != 0);
                }
                dm.setDMTestHook(null);
                return dm.getCacheTimeOffset();
            }
        });
        CacheTimeSlowDownDUnitTest.assertEquals((long)(joinTimeOffset - 19L), (long)newTimeOffset);
    }

    public class DistManagerTestHook
    implements DistributionManager.DMTestHook {
        Map info = new HashMap();

        public void suspendAtBreakPoint(int breakPoint) {
            switch (breakPoint) {
                case 1: {
                    if (this.info.get("CacheTime") == null) {
                        this.info.put("CacheTime", new ArrayList());
                    }
                    if (this.info.get("AwaitedTime") != null) break;
                    this.info.put("AwaitedTime", new ArrayList());
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
            }
        }

        public void addInformation(Object key, Object value) {
            String sKey = (String)key;
            if ("CacheTime".equals(key)) {
                List cacheTimes = (List)this.info.get(key);
                cacheTimes.add(value);
            } else if ("AwaitedTime".equals(key)) {
                List awaitedTimes = (List)this.info.get(key);
                awaitedTimes.add(value);
            } else {
                this.info.put(key, value);
            }
        }

        public Object getInformation(Object key) {
            return this.info.get(key);
        }
    }
}

