/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.security;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.query.CqAttributesFactory;
import com.gemstone.gemfire.cache.query.CqException;
import com.gemstone.gemfire.cache.query.CqQuery;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.PoolManagerImpl;
import com.gemstone.gemfire.security.AuthenticationFailedException;
import com.gemstone.gemfire.security.AuthenticationRequiredException;
import com.gemstone.gemfire.security.ClientAuthorizationTestBase;
import com.gemstone.gemfire.security.GemFireSecurityException;
import com.gemstone.gemfire.security.SecurityTestUtil;
import dunit.Host;
import dunit.VM;
import hydra.Log;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import security.CredentialGenerator;

public class MultiuserAPIDUnitTest
extends ClientAuthorizationTestBase {
    private VM server1 = null;
    private VM server2 = null;
    private VM client1 = null;
    private VM client2 = null;
    private static final String[] serverExpectedExceptions = new String[]{AuthenticationRequiredException.class.getName(), AuthenticationFailedException.class.getName(), GemFireSecurityException.class.getName(), ClassNotFoundException.class.getName(), IOException.class.getName(), SSLException.class.getName(), SSLHandshakeException.class.getName()};
    private static final String[] clientExpectedExceptions = new String[]{AuthenticationRequiredException.class.getName(), AuthenticationFailedException.class.getName(), SSLHandshakeException.class.getName()};

    public MultiuserAPIDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        this.server1 = host.getVM(0);
        this.server2 = host.getVM(1);
        this.client1 = host.getVM(2);
        this.client2 = host.getVM(3);
        this.server1.invoke(SecurityTestUtil.class, "registerExpectedExceptions", new Object[]{serverExpectedExceptions});
        this.server2.invoke(SecurityTestUtil.class, "registerExpectedExceptions", new Object[]{serverExpectedExceptions});
        this.client1.invoke(SecurityTestUtil.class, "registerExpectedExceptions", new Object[]{clientExpectedExceptions});
        this.client2.invoke(SecurityTestUtil.class, "registerExpectedExceptions", new Object[]{clientExpectedExceptions});
    }

    public static Integer createCacheServer(Object dsPort, Object locatorString, Object authenticator, Object extraProps, Object javaProps) {
        Properties authProps = extraProps == null ? new Properties() : (Properties)extraProps;
        if (authenticator != null) {
            authProps.setProperty("security-client-authenticator", authenticator.toString());
        }
        return SecurityTestUtil.createCacheServer(authProps, javaProps, (Integer)dsPort, (String)locatorString, null, new Integer(0));
    }

    private static void createCacheClient(Object authInit, Properties authProps, Properties javaProps, Integer[] ports, Object numConnections, Boolean multiUserMode, Integer expectedResult) {
        String authInitStr = authInit == null ? null : authInit.toString();
        SecurityTestUtil.createCacheClient(authInitStr, authProps, javaProps, ports, numConnections, multiUserMode.toString(), expectedResult);
    }

    public static void createCacheClient(Object authInit, Object authProps, Object javaProps, Integer port1, Integer port2, Object numConnections, Boolean multiUserMode, Integer expectedResult) {
        MultiuserAPIDUnitTest.createCacheClient(authInit, (Properties)authProps, (Properties)javaProps, new Integer[]{port1, port2}, numConnections, multiUserMode, expectedResult);
    }

    public static void registerAllInterest() {
        Region region = SecurityTestUtil.getCache().getRegion("AuthRegion");
        MultiuserAPIDUnitTest.assertNotNull((Object)region);
        region.registerInterestRegex(".*");
    }

    private void setUpVMs(CredentialGenerator gen, Boolean multiUser) {
        Properties extraProps = gen.getSystemProperties();
        Properties javaProps = gen.getJavaProperties();
        String authenticator = gen.getAuthenticator();
        String authInit = gen.getAuthInit();
        MultiuserAPIDUnitTest.getLogWriter().info("testValidCredentials: Using scheme: " + gen.classCode());
        MultiuserAPIDUnitTest.getLogWriter().info("testValidCredentials: Using authenticator: " + authenticator);
        MultiuserAPIDUnitTest.getLogWriter().info("testValidCredentials: Using authinit: " + authInit);
        Integer locPort1 = SecurityTestUtil.getLocatorPort();
        Integer locPort2 = SecurityTestUtil.getLocatorPort();
        String locString = SecurityTestUtil.getLocatorString();
        Integer port1 = (Integer)this.server1.invoke(MultiuserAPIDUnitTest.class, "createCacheServer", new Object[]{locPort1, locString, authenticator, extraProps, javaProps});
        Integer port2 = (Integer)this.server2.invoke(MultiuserAPIDUnitTest.class, "createCacheServer", new Object[]{locPort2, locString, authenticator, extraProps, javaProps});
        Properties credentials1 = gen.getValidCredentials(1);
        Properties javaProps1 = gen.getJavaProperties();
        MultiuserAPIDUnitTest.getLogWriter().info("testValidCredentials: For first client credentials: " + credentials1 + " : " + javaProps1);
        Properties credentials2 = gen.getValidCredentials(2);
        Properties javaProps2 = gen.getJavaProperties();
        MultiuserAPIDUnitTest.getLogWriter().info("testValidCredentials: For second client credentials: " + credentials2 + " : " + javaProps2);
        this.client1.invoke(MultiuserAPIDUnitTest.class, "createCacheClient", new Object[]{authInit, credentials1, javaProps1, port1, port2, null, multiUser, new Integer(0)});
    }

    public void testSingleUserUnsupportedAPIs() {
        Iterator iter = SecurityTestUtil.getAllGenerators().iterator();
        while (iter.hasNext()) {
            this.setUpVMs((CredentialGenerator)iter.next(), Boolean.FALSE);
            this.client1.invoke(MultiuserAPIDUnitTest.class, "verifyDisallowedOps", new Object[]{Boolean.FALSE});
        }
    }

    public void testMultiUserUnsupportedAPIs() {
        Iterator iter = SecurityTestUtil.getAllGenerators().iterator();
        while (iter.hasNext()) {
            this.setUpVMs((CredentialGenerator)iter.next(), Boolean.TRUE);
            this.client1.invoke(MultiuserAPIDUnitTest.class, "verifyDisallowedOps", new Object[]{Boolean.TRUE});
        }
    }

    public static void verifyDisallowedOps(Boolean multiuserMode) {
        String op = "unknown";
        boolean success = false;
        if (!multiuserMode.booleanValue()) {
            success = false;
            try {
                op = "Pool.createSecureUserCache()";
                GemFireCacheImpl.getInstance().createAuthenticatedView(new Properties(), "testPool");
            }
            catch (IllegalStateException uoe) {
                Log.getLogWriter().info(op + ": Got expected exception: " + uoe);
                success = true;
            }
            catch (Exception e) {
                MultiuserAPIDUnitTest.fail("Got unexpected exception while doing " + op, e);
            }
            if (!success) {
                MultiuserAPIDUnitTest.fail((String)("Did not get exception while doing " + op));
            }
        } else {
            Region realRegion = GemFireCacheImpl.getInstance().getRegion("AuthRegion");
            Region proxyRegion = SecurityTestUtil.proxyCaches[0].getRegion("AuthRegion");
            Pool pool = PoolManagerImpl.getPMI().find("testPool");
            for (int i = 0; i <= 27; ++i) {
                success = false;
                try {
                    switch (i) {
                        case 0: {
                            op = "Region.create()";
                            realRegion.create((Object)"key", (Object)"value");
                            break;
                        }
                        case 1: {
                            op = "Region.put()";
                            realRegion.put((Object)"key", (Object)"value");
                            break;
                        }
                        case 2: {
                            op = "Region.get()";
                            realRegion.get((Object)"key");
                            break;
                        }
                        case 3: {
                            op = "Region.containsKeyOnServer()";
                            realRegion.containsKeyOnServer((Object)"key");
                            break;
                        }
                        case 4: {
                            op = "Region.remove()";
                            realRegion.remove((Object)"key");
                            break;
                        }
                        case 5: {
                            op = "Region.destroy()";
                            realRegion.destroy((Object)"key");
                            break;
                        }
                        case 6: {
                            op = "Region.destroyRegion()";
                            realRegion.destroyRegion();
                            break;
                        }
                        case 7: {
                            op = "Region.registerInterest()";
                            realRegion.registerInterest((Object)"key");
                            break;
                        }
                        case 8: {
                            op = "Region.clear()";
                            realRegion.clear();
                            break;
                        }
                        case 9: {
                            op = "ProxyRegion.createSubregion()";
                            proxyRegion.createSubregion("subregion", null);
                            break;
                        }
                        case 10: {
                            op = "ProxyRegion.forceRolling()";
                            proxyRegion.forceRolling();
                            break;
                        }
                        case 11: {
                            op = "ProxyRegion.getAttributesMutator()";
                            proxyRegion.getAttributesMutator();
                            break;
                        }
                        case 12: {
                            op = "ProxyRegion.registerInterest()";
                            proxyRegion.registerInterest((Object)"key");
                            break;
                        }
                        case 13: {
                            op = "ProxyRegion.loadSnapshot()";
                            proxyRegion.loadSnapshot(null);
                            break;
                        }
                        case 14: {
                            op = "ProxyRegion.saveSnapshot()";
                            proxyRegion.saveSnapshot(null);
                            break;
                        }
                        case 15: {
                            op = "ProxyRegion.setUserAttribute()";
                            proxyRegion.setUserAttribute(null);
                            break;
                        }
                        case 16: {
                            op = "ProxyRegion.unregisterInterestRegex()";
                            proxyRegion.unregisterInterestRegex("*");
                            break;
                        }
                        case 17: {
                            op = "FunctionService.onRegion()";
                            FunctionService.onRegion((Region)realRegion);
                            break;
                        }
                        case 18: {
                            op = "FunctionService.onServer(pool)";
                            FunctionService.onServer((Pool)pool);
                            break;
                        }
                        case 19: {
                            op = "FunctionService.onServers(pool)";
                            FunctionService.onServers((Pool)pool);
                            break;
                        }
                        case 20: {
                            op = "QueryService.newQuery.execute()";
                            Query query = pool.getQueryService().newQuery("SELECT * FROM /AuthRegion");
                            query.execute();
                            break;
                        }
                        case 21: {
                            op = "QueryService.newCq.execute()";
                            CqQuery cqQuery = pool.getQueryService().newCq("SELECT * FROM /AuthRegion", new CqAttributesFactory().create());
                            try {
                                cqQuery.execute();
                                break;
                            }
                            catch (CqException ce) {
                                throw (Exception)ce.getCause();
                            }
                        }
                        case 22: {
                            op = "QueryService.newCq.executeWithInitialResults()";
                            CqQuery cqQuery = pool.getQueryService().newCq("SELECT * FROM /AuthRegion", new CqAttributesFactory().create());
                            try {
                                cqQuery.executeWithInitialResults();
                                break;
                            }
                            catch (CqException ce) {
                                throw (Exception)ce.getCause();
                            }
                        }
                        case 23: {
                            op = "ProxyQueryService().getIndexes()";
                            SecurityTestUtil.proxyCaches[0].getQueryService().getIndexes(null);
                            break;
                        }
                        case 24: {
                            op = "ProxyQueryService().createIndex()";
                            SecurityTestUtil.proxyCaches[0].getQueryService().createIndex(null, null, null);
                            break;
                        }
                        case 25: {
                            op = "ProxyQueryService().removeIndexes()";
                            SecurityTestUtil.proxyCaches[0].getQueryService().removeIndexes();
                            break;
                        }
                        case 26: {
                            op = "ProxyRegion.localDestroy()";
                            proxyRegion.localDestroy((Object)"key");
                            break;
                        }
                        case 27: {
                            op = "ProxyRegion.localInvalidate()";
                            proxyRegion.localInvalidate((Object)"key");
                            break;
                        }
                        default: {
                            MultiuserAPIDUnitTest.fail((String)("Unknown op code: " + i));
                            break;
                        }
                    }
                }
                catch (UnsupportedOperationException uoe) {
                    Log.getLogWriter().info(op + ": Got expected exception: " + uoe);
                    success = true;
                }
                catch (Exception e) {
                    MultiuserAPIDUnitTest.fail("Got unexpected exception while doing " + op, e);
                }
                if (success) continue;
                MultiuserAPIDUnitTest.fail((String)("Did not get exception while doing " + op));
            }
        }
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        this.client1.invoke(SecurityTestUtil.class, "closeCache");
        this.client2.invoke(SecurityTestUtil.class, "closeCache");
        this.server1.invoke(SecurityTestUtil.class, "closeCache");
        this.server2.invoke(SecurityTestUtil.class, "closeCache");
    }
}

