/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.security;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.operations.OperationContext;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.execute.PRClientServerTestBase;
import com.gemstone.gemfire.internal.cache.functions.TestFunction;
import com.gemstone.gemfire.security.ClientAuthorizationTestBase;
import com.gemstone.gemfire.security.SecurityTestUtil;
import dunit.Host;
import java.util.Properties;
import security.AuthzCredentialGenerator;
import security.CredentialGenerator;

public class ClientMultiUserAuthzDUnitTest
extends ClientAuthorizationTestBase {
    public ClientMultiUserAuthzDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        server1 = host.getVM(0);
        server2 = host.getVM(1);
        client1 = host.getVM(2);
        client2 = host.getVM(3);
        server1.invoke(SecurityTestUtil.class, "registerExpectedExceptions", new Object[]{serverExpectedExceptions});
        server2.invoke(SecurityTestUtil.class, "registerExpectedExceptions", new Object[]{serverExpectedExceptions});
        client2.invoke(SecurityTestUtil.class, "registerExpectedExceptions", new Object[]{clientExpectedExceptions});
        SecurityTestUtil.registerExpectedExceptions(clientExpectedExceptions);
    }

    public void testOps1() throws Exception {
        for (AuthzCredentialGenerator gen : this.getAllGeneratorCombos()) {
            CredentialGenerator cGen = gen.getCredentialGenerator();
            Properties extraAuthProps = cGen.getSystemProperties();
            Properties javaProps = cGen.getJavaProperties();
            Properties extraAuthzProps = gen.getSystemProperties();
            String authenticator = cGen.getAuthenticator();
            String authInit = cGen.getAuthInit();
            String accessor = gen.getAuthorizationCallback();
            ClientMultiUserAuthzDUnitTest.getLogWriter().info("testOps1: Using authinit: " + authInit);
            ClientMultiUserAuthzDUnitTest.getLogWriter().info("testOps1: Using authenticator: " + authenticator);
            ClientMultiUserAuthzDUnitTest.getLogWriter().info("testOps1: Using accessor: " + accessor);
            Properties serverProps = ClientMultiUserAuthzDUnitTest.buildProperties(authenticator, accessor, false, extraAuthProps, extraAuthzProps);
            Integer port1 = AvailablePort.getRandomAvailablePort((int)0);
            Integer port2 = AvailablePort.getRandomAvailablePort((int)0);
            server1.invoke(ClientAuthorizationTestBase.class, "createCacheServer", new Object[]{SecurityTestUtil.getMcastPort(), port1, serverProps, javaProps});
            server2.invoke(ClientAuthorizationTestBase.class, "createCacheServer", new Object[]{SecurityTestUtil.getMcastPort(), port2, serverProps, javaProps});
            if (!this.prepareClientsForOps(gen, cGen, new OperationContext.OperationCode[]{OperationContext.OperationCode.PUT, OperationContext.OperationCode.PUT}, new OperationContext.OperationCode[]{OperationContext.OperationCode.GET, OperationContext.OperationCode.GET}, javaProps, authInit, port1, port2)) continue;
            this.verifyPutsGets();
            if (!this.prepareClientsForOps(gen, cGen, new OperationContext.OperationCode[]{OperationContext.OperationCode.PUT, OperationContext.OperationCode.CONTAINS_KEY}, new OperationContext.OperationCode[]{OperationContext.OperationCode.DESTROY, OperationContext.OperationCode.DESTROY}, javaProps, authInit, port1, port2)) continue;
            this.verifyContainsKeyDestroys();
            if (!this.prepareClientsForOps(gen, cGen, new OperationContext.OperationCode[]{OperationContext.OperationCode.PUT, OperationContext.OperationCode.CONTAINS_KEY}, new OperationContext.OperationCode[]{OperationContext.OperationCode.INVALIDATE, OperationContext.OperationCode.INVALIDATE}, javaProps, authInit, port1, port2)) continue;
            this.verifyContainsKeyInvalidates();
            if (!this.prepareClientsForOps(gen, cGen, new OperationContext.OperationCode[]{OperationContext.OperationCode.GET, OperationContext.OperationCode.GET}, new OperationContext.OperationCode[]{OperationContext.OperationCode.REGION_DESTROY, OperationContext.OperationCode.REGION_DESTROY}, javaProps, authInit, port1, port2)) continue;
            this.verifyGetAllRegionDestroys();
        }
    }

    private boolean prepareClientsForOps(AuthzCredentialGenerator gen, CredentialGenerator cGen, OperationContext.OperationCode[] client1OpCodes, OperationContext.OperationCode[] client2OpCodes, Properties javaProps, String authInit, Integer port1, Integer port2) {
        return this.prepareClientsForOps(gen, cGen, client1OpCodes, client2OpCodes, javaProps, authInit, port1, port2, Boolean.TRUE, Boolean.FALSE);
    }

    private boolean prepareClientsForOps(AuthzCredentialGenerator gen, CredentialGenerator cGen, OperationContext.OperationCode[] client1OpCodes, OperationContext.OperationCode[] client2OpCodes, Properties javaProps, String authInit, Integer port1, Integer port2, Boolean bothClientsInMultiuserMode, Boolean allowOp) {
        Properties[] client1Credentials = new Properties[]{gen.getAllowedCredentials(client1OpCodes, new String[]{"AuthRegion"}, 1), gen.getDisallowedCredentials(new OperationContext.OperationCode[]{client1OpCodes[1]}, new String[]{"AuthRegion"}, 1)};
        if (client1Credentials[0] == null || client1Credentials[0].size() == 0) {
            ClientMultiUserAuthzDUnitTest.getLogWriter().info("testOps1: Unable to obtain valid credentials with " + client1OpCodes[0].toString() + " permission; skipping this combination.");
            return false;
        }
        if (client1Credentials[1] == null || client1Credentials[1].size() == 0) {
            ClientMultiUserAuthzDUnitTest.getLogWriter().info("testOps1: Unable to obtain valid credentials with no " + client1OpCodes[0].toString() + " permission; skipping this combination.");
            return false;
        }
        javaProps = cGen.getJavaProperties();
        ClientMultiUserAuthzDUnitTest.getLogWriter().info("testOps1: For first client credentials: " + client1Credentials[0] + "\n" + client1Credentials[1]);
        client1.invoke(SecurityTestUtil.class, "createCacheClientForMultiUserMode", new Object[]{2, authInit, client1Credentials, javaProps, new Integer[]{port1, port2}, null, Boolean.FALSE, 0});
        Properties[] client2Credentials = new Properties[]{gen.getAllowedCredentials(client2OpCodes, new String[]{"AuthRegion"}, 2), gen.getDisallowedCredentials(client2OpCodes, new String[]{"AuthRegion"}, 9)};
        if (client2Credentials[0] == null || client2Credentials[0].size() == 0) {
            ClientMultiUserAuthzDUnitTest.getLogWriter().info("testOps1: Unable to obtain valid credentials with " + client2OpCodes[0].toString() + " permission; skipping this combination.");
            return false;
        }
        if (client2Credentials[1] == null || client2Credentials[1].size() == 0) {
            ClientMultiUserAuthzDUnitTest.getLogWriter().info("testOps1: Unable to obtain valid credentials with no " + client2OpCodes[0].toString() + " permission; skipping this combination.");
            return false;
        }
        javaProps = cGen.getJavaProperties();
        ClientMultiUserAuthzDUnitTest.getLogWriter().info("testOps1: For second client credentials: " + client2Credentials[0] + "\n" + client2Credentials[1]);
        if (bothClientsInMultiuserMode.booleanValue()) {
            client2.invoke(SecurityTestUtil.class, "createCacheClientForMultiUserMode", new Object[]{2, authInit, client2Credentials, javaProps, new Integer[]{port1, port2}, null, Boolean.FALSE, 0});
        } else {
            int credentialsIndex = allowOp != false ? 0 : 1;
            client2.invoke(SecurityTestUtil.class, "createCacheClient", new Object[]{authInit, client2Credentials[credentialsIndex], javaProps, new Integer[]{port1, port2}, null, Boolean.FALSE, "false", 0});
        }
        return true;
    }

    private void verifyPutsGets() throws Exception {
        this.verifyPutsGets(true, false);
    }

    private void verifyPutsGets(Boolean isMultiuser, Boolean opAllowed) throws Exception {
        client1.invoke(SecurityTestUtil.class, "doMultiUserPuts", new Object[]{2, 2, new Integer[]{0, 4}});
        if (isMultiuser.booleanValue()) {
            client2.invoke(SecurityTestUtil.class, "doMultiUserGets", new Object[]{2, 2, new Integer[]{0, 4}});
        } else {
            int expectedResult = opAllowed != false ? 0 : 4;
            client2.invoke(SecurityTestUtil.class, "doMultiUserGets", new Object[]{1, 1, new Integer[]{expectedResult}});
        }
    }

    private void verifyContainsKeyDestroys() throws Exception {
        this.verifyContainsKeyDestroys(true, false);
    }

    private void verifyContainsKeyDestroys(Boolean isMultiuser, Boolean opAllowed) throws Exception {
        client1.invoke(SecurityTestUtil.class, "doMultiUserPuts", new Object[]{2, 2, new Integer[]{0, 0}});
        client1.invoke(SecurityTestUtil.class, "doMultiUserContainsKeys", new Object[]{1, 2, new Integer[]{0, 4}, new Boolean[]{Boolean.TRUE, Boolean.FALSE}});
        if (isMultiuser.booleanValue()) {
            client2.invoke(SecurityTestUtil.class, "doMultiUserDestroys", new Object[]{2, 2, new Integer[]{0, 4}});
        } else {
            int expectedResult = opAllowed != false ? 0 : 4;
            client2.invoke(SecurityTestUtil.class, "doMultiUserDestroys", new Object[]{1, 1, new Integer[]{expectedResult}});
        }
    }

    private void verifyContainsKeyInvalidates() throws Exception {
        this.verifyContainsKeyInvalidates(true, false);
    }

    private void verifyContainsKeyInvalidates(Boolean isMultiuser, Boolean opAllowed) throws Exception {
        client1.invoke(SecurityTestUtil.class, "doMultiUserPuts", new Object[]{2, 2, new Integer[]{0, 0}});
        client1.invoke(SecurityTestUtil.class, "doMultiUserContainsKeys", new Object[]{1, 2, new Integer[]{0, 4}, new Boolean[]{Boolean.TRUE, Boolean.FALSE}});
        if (isMultiuser.booleanValue()) {
            client2.invoke(SecurityTestUtil.class, "doMultiUserInvalidates", new Object[]{2, 2, new Integer[]{0, 4}});
        } else {
            int expectedResult = opAllowed != false ? 0 : 4;
            client2.invoke(SecurityTestUtil.class, "doMultiUserInvalidates", new Object[]{1, 1, new Integer[]{expectedResult}});
        }
    }

    private void verifyGetAllRegionDestroys() {
        server1.invoke(ClientMultiUserAuthzDUnitTest.class, "doPuts");
        client1.invoke(SecurityTestUtil.class, "doMultiUserGetAll", new Object[]{2, new Integer[]{0, 4}});
        client2.invoke(SecurityTestUtil.class, "doMultiUserRegionDestroys", new Object[]{2, new Integer[]{0, 4}});
    }

    public static void doPuts() {
        Region region = GemFireCacheImpl.getInstance().getRegion("AuthRegion");
        region.put((Object)"key1", (Object)"value1");
        region.put((Object)"key2", (Object)"value2");
    }

    public void testOps2() throws Exception {
        for (AuthzCredentialGenerator gen : this.getAllGeneratorCombos()) {
            CredentialGenerator cGen = gen.getCredentialGenerator();
            Properties extraAuthProps = cGen.getSystemProperties();
            Properties javaProps = cGen.getJavaProperties();
            Properties extraAuthzProps = gen.getSystemProperties();
            String authenticator = cGen.getAuthenticator();
            String authInit = cGen.getAuthInit();
            String accessor = gen.getAuthorizationCallback();
            ClientMultiUserAuthzDUnitTest.getLogWriter().info("testOps2: Using authinit: " + authInit);
            ClientMultiUserAuthzDUnitTest.getLogWriter().info("testOps2: Using authenticator: " + authenticator);
            ClientMultiUserAuthzDUnitTest.getLogWriter().info("testOps2: Using accessor: " + accessor);
            Properties serverProps = ClientMultiUserAuthzDUnitTest.buildProperties(authenticator, accessor, false, extraAuthProps, extraAuthzProps);
            Integer port1 = AvailablePort.getRandomAvailablePort((int)0);
            Integer port2 = AvailablePort.getRandomAvailablePort((int)0);
            server1.invoke(ClientAuthorizationTestBase.class, "createCacheServer", new Object[]{SecurityTestUtil.getMcastPort(), port1, serverProps, javaProps});
            server2.invoke(ClientAuthorizationTestBase.class, "createCacheServer", new Object[]{SecurityTestUtil.getMcastPort(), port2, serverProps, javaProps});
            Properties[] client1Credentials = new Properties[]{gen.getAllowedCredentials(new OperationContext.OperationCode[]{OperationContext.OperationCode.PUT, OperationContext.OperationCode.QUERY}, new String[]{"AuthRegion"}, 1), gen.getDisallowedCredentials(new OperationContext.OperationCode[]{OperationContext.OperationCode.QUERY}, new String[]{"AuthRegion"}, 1)};
            if (client1Credentials[0] == null || client1Credentials[0].size() == 0) {
                ClientMultiUserAuthzDUnitTest.getLogWriter().info("testOps2: Unable to obtain valid credentials with QUERY permission; skipping this combination.");
                continue;
            }
            if (client1Credentials[1] == null || client1Credentials[1].size() == 0) {
                ClientMultiUserAuthzDUnitTest.getLogWriter().info("testOps2: Unable to obtain valid credentials with no QUERY permission; skipping this combination.");
                continue;
            }
            javaProps = cGen.getJavaProperties();
            ClientMultiUserAuthzDUnitTest.getLogWriter().info("testOps2: For first client credentials: " + client1Credentials[0] + "\n" + client1Credentials[1]);
            client1.invoke(SecurityTestUtil.class, "createCacheClientForMultiUserMode", new Object[]{2, authInit, client1Credentials, javaProps, new Integer[]{port1, port2}, null, Boolean.FALSE, 0});
            Properties[] client2Credentials = new Properties[]{gen.getAllowedCredentials(new OperationContext.OperationCode[]{OperationContext.OperationCode.EXECUTE_FUNCTION}, new String[]{"AuthRegion"}, 2), gen.getDisallowedCredentials(new OperationContext.OperationCode[]{OperationContext.OperationCode.EXECUTE_FUNCTION}, new String[]{"AuthRegion"}, 9)};
            if (client2Credentials[0] == null || client2Credentials[0].size() == 0) {
                ClientMultiUserAuthzDUnitTest.getLogWriter().info("testOps2: Unable to obtain valid credentials with EXECUTE_FUNCTION permission; skipping this combination.");
                continue;
            }
            if (client2Credentials[1] == null || client2Credentials[1].size() == 0) {
                ClientMultiUserAuthzDUnitTest.getLogWriter().info("testOps2: Unable to obtain valid credentials with no EXECUTE_FUNCTION permission; skipping this combination.");
                continue;
            }
            javaProps = cGen.getJavaProperties();
            ClientMultiUserAuthzDUnitTest.getLogWriter().info("testOps2: For second client credentials: " + client2Credentials[0] + "\n" + client2Credentials[1]);
            client2.invoke(SecurityTestUtil.class, "createCacheClientForMultiUserMode", new Object[]{2, authInit, client2Credentials, javaProps, new Integer[]{port1, port2}, null, Boolean.FALSE, 0});
            TestFunction function = new TestFunction(true, "TestFunction1");
            server1.invoke(PRClientServerTestBase.class, "registerFunction", new Object[]{function});
            server2.invoke(PRClientServerTestBase.class, "registerFunction", new Object[]{function});
            client1.invoke(SecurityTestUtil.class, "doMultiUserPuts", new Object[]{4, 2, new Integer[]{0, 4}});
            client1.invoke(SecurityTestUtil.class, "doMultiUserQueries", new Object[]{2, new Integer[]{0, 4}, 4});
            client1.invoke(SecurityTestUtil.class, "doMultiUserQueryExecute", new Object[]{2, new Integer[]{0, 4}, 4});
            client2.invoke(SecurityTestUtil.class, "doMultiUserFE", new Object[]{2, function, new Integer[]{0, 4}, new Object[]{null, null}, Boolean.FALSE});
            server1.invoke(SecurityTestUtil.class, "closeCache");
            Thread.sleep(2000L);
            client1.invoke(SecurityTestUtil.class, "doMultiUserPuts", new Object[]{4, 2, new Integer[]{0, 4}});
            client1.invoke(SecurityTestUtil.class, "doMultiUserQueries", new Object[]{2, new Integer[]{0, 4}, 4});
            client1.invoke(SecurityTestUtil.class, "doMultiUserQueryExecute", new Object[]{2, new Integer[]{0, 4}, 4});
            client2.invoke(SecurityTestUtil.class, "doMultiUserFE", new Object[]{2, function, new Integer[]{0, 4}, new Object[]{null, null}, Boolean.TRUE});
        }
    }

    public void testOpsWithClientsInDifferentModes() throws Exception {
        for (AuthzCredentialGenerator gen : this.getAllGeneratorCombos()) {
            CredentialGenerator cGen = gen.getCredentialGenerator();
            Properties extraAuthProps = cGen.getSystemProperties();
            Properties javaProps = cGen.getJavaProperties();
            Properties extraAuthzProps = gen.getSystemProperties();
            String authenticator = cGen.getAuthenticator();
            String authInit = cGen.getAuthInit();
            String accessor = gen.getAuthorizationCallback();
            ClientMultiUserAuthzDUnitTest.getLogWriter().info("testOpsWithClientsInDifferentModes: Using authinit: " + authInit);
            ClientMultiUserAuthzDUnitTest.getLogWriter().info("testOpsWithClientsInDifferentModes: Using authenticator: " + authenticator);
            ClientMultiUserAuthzDUnitTest.getLogWriter().info("testOpsWithClientsInDifferentModes: Using accessor: " + accessor);
            Properties serverProps = ClientMultiUserAuthzDUnitTest.buildProperties(authenticator, accessor, false, extraAuthProps, extraAuthzProps);
            Integer port1 = AvailablePort.getRandomAvailablePort((int)0);
            Integer port2 = AvailablePort.getRandomAvailablePort((int)0);
            server1.invoke(ClientAuthorizationTestBase.class, "createCacheServer", new Object[]{SecurityTestUtil.getMcastPort(), port1, serverProps, javaProps});
            server2.invoke(ClientAuthorizationTestBase.class, "createCacheServer", new Object[]{SecurityTestUtil.getMcastPort(), port2, serverProps, javaProps});
            if (!this.prepareClientsForOps(gen, cGen, new OperationContext.OperationCode[]{OperationContext.OperationCode.PUT, OperationContext.OperationCode.PUT}, new OperationContext.OperationCode[]{OperationContext.OperationCode.GET, OperationContext.OperationCode.GET}, javaProps, authInit, port1, port2, Boolean.FALSE, Boolean.TRUE)) continue;
            this.verifyPutsGets(false, true);
            if (!this.prepareClientsForOps(gen, cGen, new OperationContext.OperationCode[]{OperationContext.OperationCode.PUT, OperationContext.OperationCode.CONTAINS_KEY}, new OperationContext.OperationCode[]{OperationContext.OperationCode.DESTROY, OperationContext.OperationCode.DESTROY}, javaProps, authInit, port1, port2, Boolean.FALSE, Boolean.FALSE)) continue;
            this.verifyContainsKeyDestroys(false, false);
        }
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        client1.invoke(SecurityTestUtil.class, "closeCache");
        client2.invoke(SecurityTestUtil.class, "closeCache");
        SecurityTestUtil.closeCache();
        server1.invoke(SecurityTestUtil.class, "closeCache");
        server2.invoke(SecurityTestUtil.class, "closeCache");
    }
}

