/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.pdx;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.GatewayConfigurationException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.cache.util.GatewayHub;
import com.gemstone.gemfire.cache.util.GatewayQueueAttributes;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.HeapDataOutputStream;
import com.gemstone.gemfire.internal.shared.Version;
import com.gemstone.gemfire.pdx.PdxInitializationException;
import com.gemstone.gemfire.pdx.SimpleClass;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.RMIException;
import dunit.SerializableCallable;
import dunit.VM;
import java.io.DataOutput;
import java.util.Properties;
import junit.framework.TestCase;

public class PDXWanDUnitTest
extends CacheTestCase {
    public PDXWanDUnitTest(String name) {
        super(name);
    }

    public void testWANMatchingIds() {
        block2: {
            Host host = Host.getHost(0);
            VM vm0 = host.getVM(0);
            VM vm1 = host.getVM(1);
            this.createSystem(vm0, "1");
            int port0 = AvailablePortHelper.getRandomAvailableTCPPortOnVM(vm0);
            this.createRegion(vm0);
            this.createWANReceiver(vm0, port0);
            try {
                this.createSystem(vm1, "1");
                this.createWANSender(vm1, port0);
                this.createRegion(vm1);
                this.putInRegion(vm1, "ping", 1);
                PDXWanDUnitTest.fail((String)"Should have received an exception");
            }
            catch (RMIException e) {
                if (e.getCause() instanceof GatewayConfigurationException) break block2;
                throw e;
            }
        }
    }

    public void testWANDifferentIds() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        this.createSystem(vm0, "1");
        int port0 = AvailablePortHelper.getRandomAvailableTCPPortOnVM(vm0);
        this.createRegion(vm0);
        this.createWANReceiver(vm0, port0);
        this.createSystem(vm1, "2");
        this.createWANSender(vm1, port0);
        this.createRegion(vm1);
        this.putInRegion(vm1, "ping", 1);
        this.waitForValue(vm0, "ping", 1);
    }

    public void testWANProgationTypeDefinedFirst() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        this.createSystem(vm0, "1");
        int port0 = AvailablePortHelper.getRandomAvailableTCPPortOnVM(vm0);
        this.createRegion(vm0);
        this.createWANReceiver(vm0, port0);
        this.createSystem(vm1, "2");
        this.createRegion(vm1);
        this.serializeOnVM(vm1, 1);
        this.createWANSender(vm1, port0);
        this.putInRegion(vm1, "ping", 1);
        this.waitForValue(vm0, "ping", 1);
    }

    public void testWANProgationTypeWasPersisted() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        this.createSystem(vm1, "2");
        this.createRegion(vm1);
        this.serializeOnVM(vm1, 1);
        this.closeCache(vm1);
        this.createSystem(vm0, "1");
        int port0 = AvailablePortHelper.getRandomAvailableTCPPortOnVM(vm0);
        this.createRegion(vm0);
        this.createWANReceiver(vm0, port0);
        this.createSystem(vm1, "2");
        this.createRegion(vm1);
        this.createWANSender(vm1, port0);
        this.putInRegion(vm1, "ping", 1);
        this.waitForValue(vm0, "ping", 1);
    }

    public void testWANUnspecifiedIds() {
        block5: {
            int port0;
            VM vm0;
            block4: {
                Host host = Host.getHost(0);
                vm0 = host.getVM(0);
                VM vm1 = host.getVM(1);
                this.createSystem(vm0, "-1");
                port0 = AvailablePortHelper.getRandomAvailableTCPPortOnVM(vm0);
                this.createWANReceiver(vm0, port0);
                this.createRegion(vm0);
                try {
                    this.serializeOnVM(vm0, 1, null);
                    PDXWanDUnitTest.fail((String)"should have received an exception");
                }
                catch (RMIException e) {
                    if (e.getCause() instanceof PdxInitializationException) break block4;
                    throw e;
                }
            }
            this.closeCache(vm0);
            this.createRegion(vm0);
            this.serializeOnVM(vm0, 1, null);
            try {
                port0 = AvailablePortHelper.getRandomAvailableTCPPortOnVM(vm0);
                this.createWANReceiver(vm0, port0);
                PDXWanDUnitTest.fail((String)"should have received an exception");
            }
            catch (RMIException e) {
                if (e.getCause() instanceof PdxInitializationException) break block5;
                throw e;
            }
        }
    }

    private void closeCache(VM vm) {
        SerializableCallable createSystem = new SerializableCallable(){

            public Object call() throws Exception {
                CacheTestCase.closeCache();
                return null;
            }
        };
        vm.invoke(createSystem);
    }

    private void createSystem(VM vm, final String dsId) {
        SerializableCallable createSystem = new SerializableCallable(){

            public Object call() throws Exception {
                Properties props = new Properties();
                props.setProperty("distributed-system-id", dsId);
                props.setProperty("locators", "");
                PDXWanDUnitTest.this.getSystem(props);
                CacheFactory cf = new CacheFactory();
                cf.setPdxPersistent(true);
                PDXWanDUnitTest.this.getCache(cf);
                return null;
            }
        };
        vm.invoke(createSystem);
    }

    private void createRegion(VM vm) {
        SerializableCallable createSystem = new SerializableCallable(){

            public Object call() throws Exception {
                Cache cache = PDXWanDUnitTest.this.getCache();
                Region region1 = cache.createRegionFactory(RegionShortcut.REPLICATE).setEnableGateway(true).create("region");
                return null;
            }
        };
        vm.invoke(createSystem);
    }

    private void createWANReceiver(VM vm, final int wanPort) {
        SerializableCallable createSystem = new SerializableCallable(){

            public Object call() throws Exception {
                Cache cache = PDXWanDUnitTest.this.getCache();
                GatewayHub hub = cache.addGatewayHub("myId", wanPort);
                hub.start();
                return null;
            }
        };
        vm.invoke(createSystem);
    }

    private void createWANSender(VM vm, final int wanPort) {
        SerializableCallable createSystem = new SerializableCallable(){

            public Object call() throws Exception {
                Cache cache = PDXWanDUnitTest.this.getCache();
                GatewayHub hub = cache.addGatewayHub("myId", -1);
                Gateway gateway = hub.addGateway("g1");
                gateway.setQueueAttributes(new GatewayQueueAttributes(null, 10, 2, 1000, false, false, 5));
                gateway.addEndpoint("myid", "localhost", wanPort);
                hub.start();
                gateway.start();
                return null;
            }
        };
        vm.invoke(createSystem);
    }

    private void serializeOnVM(VM vm, final int value) {
        SerializableCallable createSystem = new SerializableCallable(){

            public Object call() throws Exception {
                PDXWanDUnitTest.this.getCache();
                DataSerializer.writeObject((Object)new SimpleClass(value, (byte)value), (DataOutput)new HeapDataOutputStream(Version.CURRENT));
                return null;
            }
        };
        vm.invoke(createSystem);
    }

    private void serializeOnVM(VM vm, final int value, final SimpleClass.SimpleEnum enumVal) {
        SerializableCallable createSystem = new SerializableCallable(){

            public Object call() throws Exception {
                PDXWanDUnitTest.this.getCache();
                DataSerializer.writeObject((Object)new SimpleClass(value, (byte)value, enumVal), (DataOutput)new HeapDataOutputStream(Version.CURRENT));
                return null;
            }
        };
        vm.invoke(createSystem);
    }

    private void putInRegion(VM vm, final Object key, final int value) {
        SerializableCallable createSystem = new SerializableCallable(){

            public Object call() throws Exception {
                Cache cache = PDXWanDUnitTest.this.getCache();
                Region region1 = cache.getRegion("region");
                region1.put(key, (Object)new SimpleClass(value, (byte)value));
                return null;
            }
        };
        vm.invoke(createSystem);
    }

    public void waitForValue(VM vm, final String key, final int value) {
        SerializableCallable createSystem = new SerializableCallable(){

            public Object call() throws Exception {
                Cache cache = PDXWanDUnitTest.this.getCache();
                final Region region1 = cache.getRegion("region");
                DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

                    @Override
                    public String description() {
                        return "Didn't receive update over the WAN";
                    }

                    @Override
                    public boolean done() {
                        return region1.get((Object)key) != null;
                    }
                }, 30000L, 100L, true);
                TestCase.assertEquals((Object)new SimpleClass(value, (byte)value), (Object)region1.get((Object)key));
                return null;
            }
        };
        vm.invoke(createSystem);
    }
}

