/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.pulse;

import com.gemstone.gemfire.cache.query.cq.dunit.CqQueryDUnitTest;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.management.DistributedSystemMXBean;
import com.gemstone.gemfire.management.ManagementService;
import com.gemstone.gemfire.management.ManagementTestBase;
import dunit.DistributedTestCase;
import dunit.VM;

public class TestServerDUnitTest
extends ManagementTestBase {
    private static final long serialVersionUID = 1L;
    protected CqQueryDUnitTest cqDUnitTest = new CqQueryDUnitTest("CqDataDUnitTest");

    public TestServerDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
    }

    public static int getNumOfServersFromMBean() {
        DistributedTestCase.WaitCriterion waitCriteria = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                ManagementService service = ManagementTestBase.getManagementService();
                DistributedSystemMXBean bean = service.getDistributedSystemMXBean();
                return bean != null && bean.listCacheServers().length > 0;
            }

            @Override
            public String description() {
                return "wait for getDistributedSystemMXBean to complete and get results";
            }
        };
        TestServerDUnitTest.waitForCriterion(waitCriteria, 120000L, 3000L, true);
        DistributedSystemMXBean bean = TestServerDUnitTest.getManagementService().getDistributedSystemMXBean();
        TestServerDUnitTest.assertNotNull((Object)bean);
        return bean.listCacheServers().length;
    }

    public void testNumOfServersDUnitTest() throws Exception {
        this.initManagement(false);
        VM server = (VM)managedNodeList.get(1);
        int serverPort = AvailablePortHelper.getRandomAvailableTCPPort();
        this.cqDUnitTest.createServer(server, serverPort);
        int serverCount = ((Number)managingNode.invoke(TestServerDUnitTest.class, "getNumOfServersFromMBean")).intValue();
        TestServerDUnitTest.getLogWriter().info("TestServerDUnitTest serverCount =" + serverCount);
        this.cqDUnitTest.closeServer(server);
        TestServerDUnitTest.assertEquals((int)1, (int)serverCount);
    }

    public void verifyStatistics() {
    }

    public void invokeOperations() {
    }
}

