/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.commands;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.FixedPartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.cli.remote.CommandProcessor;
import com.gemstone.gemfire.management.internal.cli.util.CommandStringBuilder;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class MemberCommandsDUnitTest
extends CacheTestCase {
    private static final long serialVersionUID = 1L;
    private static final Map<String, String> EMPTY_ENV = Collections.emptyMap();
    private static final String REGION1 = "region1";
    private static final String REGION2 = "region2";
    private static final String REGION3 = "region3";
    private static final String SUBREGION1A = "subregion1A";
    private static final String SUBREGION1B = "subregion1B";
    private static final String SUBREGION1C = "subregion1C";
    private static final String PR1 = "PartitionedRegion1";
    private static final String PR2 = "ParitionedRegion2";

    public MemberCommandsDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
    }

    private Properties createProperties(String name, String groups) {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("log-level", "info");
        props.setProperty("statistic-sampling-enabled", "true");
        props.setProperty("enable-time-statistics", "true");
        props.setProperty("name", name);
        props.setProperty("groups", groups);
        return props;
    }

    private void createRegionsWithSubRegions() {
        Cache cache = this.getCache();
        RegionFactory dataRegionFactory = cache.createRegionFactory(RegionShortcut.REPLICATE);
        dataRegionFactory.setConcurrencyLevel(3);
        Region region1 = dataRegionFactory.create(REGION1);
        region1.createSubregion(SUBREGION1C, region1.getAttributes());
        Region subregion2 = region1.createSubregion(SUBREGION1A, region1.getAttributes());
        subregion2.createSubregion(SUBREGION1B, subregion2.getAttributes());
        dataRegionFactory.create(REGION2);
        dataRegionFactory.create(REGION3);
    }

    private void createPartitionedRegion1() {
        Cache cache = this.getCache();
        RegionFactory dataRegionFactory = cache.createRegionFactory(RegionShortcut.PARTITION);
        dataRegionFactory.create(PR1);
    }

    private void createPartitionedRegion(String regionName) {
        Cache cache = this.getCache();
        RegionFactory dataRegionFactory = cache.createRegionFactory(RegionShortcut.PARTITION);
        dataRegionFactory.setConcurrencyLevel(4);
        EvictionAttributes ea = EvictionAttributes.createLIFOEntryAttributes((int)100, (EvictionAction)EvictionAction.LOCAL_DESTROY);
        dataRegionFactory.setEvictionAttributes(ea);
        dataRegionFactory.setEnableAsyncConflation(true);
        FixedPartitionAttributes fpa = FixedPartitionAttributes.createFixedPartition((String)"Par1", (boolean)true);
        PartitionAttributes pa = new PartitionAttributesFactory().setLocalMaxMemory(100).setRecoveryDelay(2L).setTotalMaxMemory(200L).setRedundantCopies(1).addFixedPartitionAttributes(fpa).create();
        dataRegionFactory.setPartitionAttributes(pa);
        dataRegionFactory.create(regionName);
    }

    private void createLocalRegion() {
        Cache cache = this.getCache();
        RegionFactory dataRegionFactory = cache.createRegionFactory(RegionShortcut.LOCAL);
        dataRegionFactory.create("LocalRegion");
    }

    private void setupSystem() throws IOException {
        MemberCommandsDUnitTest.disconnectAllFromDS();
        Host host = Host.getHost(0);
        VM[] servers = new VM[]{host.getVM(0), host.getVM(1)};
        Properties propsMe = this.createProperties("me", "G1");
        final Properties propsServer1 = this.createProperties("Server1", "G1");
        final Properties propsServer2 = this.createProperties("Server2", "G2");
        this.getSystem(propsMe);
        Cache cache = this.getCache();
        RegionFactory dataRegionFactory = cache.createRegionFactory(RegionShortcut.REPLICATE_PROXY);
        dataRegionFactory.setConcurrencyLevel(5);
        Region region1 = dataRegionFactory.create(REGION1);
        servers[1].invoke(new SerializableRunnable("Create cache for server1"){

            @Override
            public void run() {
                MemberCommandsDUnitTest.this.getSystem(propsServer2);
                MemberCommandsDUnitTest.this.createRegionsWithSubRegions();
                MemberCommandsDUnitTest.this.createLocalRegion();
                MemberCommandsDUnitTest.this.createPartitionedRegion("ParReg1");
            }
        });
        servers[0].invoke(new SerializableRunnable("Create cache for server0"){

            @Override
            public void run() {
                MemberCommandsDUnitTest.this.getSystem(propsServer1);
                MemberCommandsDUnitTest.this.createRegionsWithSubRegions();
                MemberCommandsDUnitTest.this.createLocalRegion();
            }
        });
    }

    private Properties createProperties(Host host, int locatorPort) {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", MemberCommandsDUnitTest.getServerHostName(host) + "[" + locatorPort + "]");
        props.setProperty("log-level", "info");
        props.setProperty("statistic-sampling-enabled", "true");
        props.setProperty("enable-time-statistics", "true");
        props.put("enable-network-partition-detection", "true");
        return props;
    }

    private void createCache(Properties props) {
        this.getSystem(props);
        Cache cache = this.getCache();
    }

    public void testListMemberAll() throws IOException, ClassNotFoundException {
        this.setupSystem();
        CommandProcessor commandProcessor = new CommandProcessor();
        Result result = commandProcessor.createCommandStatement("list members", EMPTY_ENV).process();
        MemberCommandsDUnitTest.getLogWriter().info("#SB" + this.getResultAsString(result));
        MemberCommandsDUnitTest.assertEquals((boolean)true, (boolean)result.getStatus().equals((Object)Result.Status.OK));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testListMemberWithNoCache() throws IOException, ClassNotFoundException {
        Host host = Host.getHost(0);
        VM[] servers = new VM[]{host.getVM(0), host.getVM(1)};
        int[] openPorts = AvailablePortHelper.getRandomAvailableTCPPorts(1);
        File logFile = new File(this.getUniqueName() + "-locator" + openPorts[0] + ".log");
        Locator locator = Locator.startLocator((int)openPorts[0], (File)logFile);
        try {
            Properties props = this.createProperties(host, openPorts[0]);
            CommandProcessor commandProcessor = new CommandProcessor();
            Result result = commandProcessor.createCommandStatement("list members", EMPTY_ENV).process();
            MemberCommandsDUnitTest.getLogWriter().info("#SB" + this.getResultAsString(result));
            MemberCommandsDUnitTest.assertEquals((boolean)true, (boolean)result.getStatus().equals((Object)Result.Status.ERROR));
        }
        finally {
            locator.stop();
        }
    }

    public void testListMemberWithGroups() throws IOException, ClassNotFoundException {
        this.setupSystem();
        CommandProcessor commandProcessor = new CommandProcessor();
        CommandStringBuilder csb = new CommandStringBuilder("list members");
        csb.addOption("group", "G1");
        Result result = commandProcessor.createCommandStatement(csb.toString(), EMPTY_ENV).process();
        MemberCommandsDUnitTest.getLogWriter().info("#SB" + this.getResultAsString(result));
        MemberCommandsDUnitTest.assertEquals((boolean)true, (boolean)result.getStatus().equals((Object)Result.Status.OK));
    }

    public void testDescribeMember() throws IOException, ClassNotFoundException {
        this.setupSystem();
        CommandProcessor commandProcessor = new CommandProcessor();
        GemFireCacheImpl cache = (GemFireCacheImpl)CacheFactory.getAnyInstance();
        Set members = cache.getDistributedSystem().getAllOtherMembers();
        for (DistributedMember member : members) {
            Result result = commandProcessor.createCommandStatement("describe member --name=" + member.getId(), EMPTY_ENV).process();
            MemberCommandsDUnitTest.assertEquals((boolean)true, (boolean)result.getStatus().equals((Object)Result.Status.OK));
            MemberCommandsDUnitTest.getLogWriter().info("#SB" + this.getResultAsString(result));
        }
    }

    private String getResultAsString(Result result) {
        StringBuilder sb = new StringBuilder();
        while (result.hasNextLine()) {
            sb.append(result.nextLine());
        }
        return sb.toString();
    }
}

