/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.commands;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.query.Index;
import com.gemstone.gemfire.cache.query.IndexStatistics;
import com.gemstone.gemfire.cache.query.IndexType;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.internal.lang.MutableIdentifiable;
import com.gemstone.gemfire.internal.lang.ObjectUtils;
import com.gemstone.gemfire.internal.lang.StringUtils;
import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.cli.commands.CliCommandTestBase;
import com.gemstone.gemfire.management.internal.cli.domain.IndexDetails;
import com.gemstone.gemfire.management.internal.cli.result.CommandResult;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import junit.framework.TestCase;

public class ListIndexCommandDUnitTest
extends CliCommandTestBase {
    protected static final int DEFAULT_REGION_INITIAL_CAPACITY = 10000;
    private final AtomicLong idGenerator = new AtomicLong(0L);

    protected static String toString(Result result) {
        assert (result != null) : "The Result object from the command execution cannot be null!";
        StringBuilder buffer = new StringBuilder(System.getProperty("line.separator"));
        while (result.hasNextLine()) {
            buffer.append(result.nextLine());
            buffer.append(System.getProperty("line.separator"));
        }
        return buffer.toString();
    }

    public ListIndexCommandDUnitTest(String testName) {
        super(testName);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.createDefaultSetup(null);
        this.setupGemFire();
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
    }

    protected Index createIndex(String name, String indexedExpression, String fromClause) {
        return this.createIndex(name, IndexType.FUNCTIONAL, indexedExpression, fromClause);
    }

    protected Index createIndex(String name, IndexType type, String indexedExpression, String fromClause) {
        return new IndexAdapter(name, type, indexedExpression, fromClause);
    }

    protected Peer createPeer(VM vm, Properties distributedSystemProperties, RegionDefinition ... regions) {
        Peer peer = new Peer(vm, distributedSystemProperties);
        peer.add(regions);
        return peer;
    }

    protected RegionDefinition createRegionDefinition(String regionName, Class<?> keyConstraint, Class<?> valueConstraint, Index ... indexes) {
        RegionDefinition regionDefinition = new RegionDefinition(regionName, keyConstraint, valueConstraint);
        regionDefinition.add(indexes);
        return regionDefinition;
    }

    protected void setupGemFire() throws Exception {
        Host host = Host.getHost(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        Peer peer1 = this.createPeer(vm1, this.createDistributedSystemProperties("consumerServer"), this.createRegionDefinition("consumers", Long.class, Consumer.class, this.createIndex("cidIdx", IndexType.PRIMARY_KEY, "id", "/consumers"), this.createIndex("cnameIdx", "name", "/consumers")));
        Peer peer2 = this.createPeer(vm2, this.createDistributedSystemProperties("producerServer"), this.createRegionDefinition("producers", Long.class, Producer.class, this.createIndex("pidIdx", "id", "/producers")));
        this.createRegionWithIndexes(peer1);
        this.createRegionWithIndexes(peer2);
        this.loadConsumerData(peer1, 10000);
        this.loadProducerData(peer2, 10000);
    }

    protected Properties createDistributedSystemProperties(String gemfireName) {
        Properties distributedSystemProperties = new Properties();
        distributedSystemProperties.setProperty("log-level", ListIndexCommandDUnitTest.getDUnitLogLevel());
        distributedSystemProperties.setProperty("name", gemfireName);
        return distributedSystemProperties;
    }

    protected void createRegionWithIndexes(final Peer peer) {
        peer.run(new SerializableRunnable(String.format("Creating Regions with Indexes on GemFire peer (%1$s).", peer.getName())){

            @Override
            public void run() {
                ListIndexCommandDUnitTest.this.getSystem(peer.getConfiguration());
                Cache cache = ListIndexCommandDUnitTest.this.getCache();
                RegionFactory regionFactory = cache.createRegionFactory();
                for (RegionDefinition regionDefinition : peer) {
                    regionFactory.setDataPolicy(DataPolicy.REPLICATE);
                    regionFactory.setIndexMaintenanceSynchronous(true);
                    regionFactory.setInitialCapacity(10000);
                    regionFactory.setKeyConstraint(regionDefinition.getKeyConstraint());
                    regionFactory.setScope(Scope.DISTRIBUTED_NO_ACK);
                    regionFactory.setStatisticsEnabled(true);
                    regionFactory.setValueConstraint(regionDefinition.getValueConstraint());
                    Region region = regionFactory.create(regionDefinition.getRegionName());
                    String indexName = null;
                    try {
                        for (Index index : regionDefinition) {
                            indexName = index.getName();
                            if (IndexType.PRIMARY_KEY.equals(index.getType())) {
                                cache.getQueryService().createKeyIndex(indexName, index.getIndexedExpression(), region.getFullPath());
                                continue;
                            }
                            cache.getQueryService().createIndex(indexName, index.getIndexedExpression(), region.getFullPath());
                        }
                    }
                    catch (Exception e) {
                        DistributedTestCase.getLogWriter().error(String.format("Error occurred creating Index (%1$s) on Region (%2$s) - (%3$s)", indexName, region.getFullPath(), e.getMessage()));
                    }
                }
            }
        });
    }

    protected void loadConsumerData(Peer peer, final int operationsTotal) {
        peer.run(new SerializableRunnable("Load /consumers Region with data"){

            @Override
            public void run() {
                Cache cache = ListIndexCommandDUnitTest.this.getCache();
                Region consumerRegion = cache.getRegion("/consumers");
                Random random = new Random(System.currentTimeMillis());
                int count = 0;
                ArrayList<Proxy> proxies = new ArrayList<Proxy>();
                block4: while (count++ < operationsTotal) {
                    Consumer consumer;
                    switch (CrudOperation.values()[random.nextInt(CrudOperation.values().length)]) {
                        case RETRIEVE: {
                            Proxy proxy;
                            if (!proxies.isEmpty()) {
                                proxy = (Proxy)proxies.get(random.nextInt(proxies.size()));
                                consumer = (Consumer)ListIndexCommandDUnitTest.this.query(consumerRegion, "id = " + proxy.getId() + "l");
                                proxy.setUnitsSnapshot(consumer.getUnits());
                                continue block4;
                            }
                        }
                        case UPDATE: {
                            if (proxies.isEmpty()) break;
                            Proxy proxy = (Proxy)proxies.get(random.nextInt(proxies.size()));
                            consumer = (Consumer)ListIndexCommandDUnitTest.this.query(consumerRegion, "Name = " + proxy.getName());
                            consumer.consume();
                            continue block4;
                        }
                    }
                    consumer = new Consumer(ListIndexCommandDUnitTest.this.idGenerator.incrementAndGet());
                    proxies.add(new Proxy(consumer));
                    consumerRegion.put(consumer.getId(), (Object)consumer);
                    TestCase.assertTrue((boolean)consumerRegion.containsKey(consumer.getId()));
                    TestCase.assertTrue((boolean)consumerRegion.containsValueForKey(consumer.getId()));
                    TestCase.assertSame((Object)consumer, (Object)consumerRegion.get(consumer.getId()));
                }
            }
        });
    }

    protected void loadProducerData(Peer peer, final int operationsTotal) {
        peer.run(new SerializableRunnable("Load /producers Region with data"){

            @Override
            public void run() {
                Cache cache = ListIndexCommandDUnitTest.this.getCache();
                Region producerRegion = cache.getRegion("/producers");
                Random random = new Random(System.currentTimeMillis());
                int count = 0;
                ArrayList<Proxy> proxies = new ArrayList<Proxy>();
                block4: while (count++ < operationsTotal) {
                    Producer producer;
                    switch (CrudOperation.values()[random.nextInt(CrudOperation.values().length)]) {
                        case RETRIEVE: {
                            Proxy proxy;
                            if (!proxies.isEmpty()) {
                                proxy = (Proxy)proxies.get(random.nextInt(proxies.size()));
                                producer = (Producer)ListIndexCommandDUnitTest.this.query(producerRegion, "Id = " + proxy.getId());
                                proxy.setUnitsSnapshot(producer.getUnits());
                                continue block4;
                            }
                        }
                        case UPDATE: {
                            if (proxies.isEmpty()) break;
                            Proxy proxy = (Proxy)proxies.get(random.nextInt(proxies.size()));
                            producer = (Producer)ListIndexCommandDUnitTest.this.query(producerRegion, "Id = " + proxy.getId());
                            producer.produce();
                            continue block4;
                        }
                    }
                    producer = new Producer(ListIndexCommandDUnitTest.this.idGenerator.incrementAndGet());
                    proxies.add(new Proxy(producer));
                    producerRegion.put(producer.getId(), (Object)producer);
                    TestCase.assertTrue((boolean)producerRegion.containsKey(producer.getId()));
                    TestCase.assertTrue((boolean)producerRegion.containsValueForKey(producer.getId()));
                    TestCase.assertSame((Object)producer, (Object)producerRegion.get(producer.getId()));
                }
            }
        });
    }

    protected <T extends Comparable<T>, B extends AbstractBean<T>> B query(Cache cache, String queryString) {
        try {
            ListIndexCommandDUnitTest.getLogWriter().info(String.format("Running Query (%1$s) in GemFire...", queryString));
            SelectResults results = (SelectResults)cache.getQueryService().newQuery(queryString).execute();
            ListIndexCommandDUnitTest.getLogWriter().info(String.format("Running Query (%1$s) in GemFire returned (%2$d) result(s).", queryString, results.size()));
            return (B)(results.iterator().hasNext() ? (AbstractBean)results.iterator().next() : null);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("An error occurred running Query (%1$s)!", queryString), e);
        }
    }

    protected <T extends Comparable<T>, B extends AbstractBean<T>> B query(Region<T, B> region, String queryPredicate) {
        try {
            ListIndexCommandDUnitTest.getLogWriter().info(String.format("Running Query (%1$s) on Region (%2$s)...", queryPredicate, region.getFullPath()));
            SelectResults results = region.query(queryPredicate);
            ListIndexCommandDUnitTest.getLogWriter().info(String.format("Running Query (%1$s) on Region (%2$s) returned (%3$d) result(s).", queryPredicate, region.getFullPath(), results.size()));
            return (B)(results.iterator().hasNext() ? (AbstractBean)results.iterator().next() : null);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("An error occurred running Query (%1$s) on Region (%2$s)!", queryPredicate, region.getFullPath()), e);
        }
    }

    public void testListIndex() throws Exception {
        CommandResult result = this.executeCommand("list indexes --with-stats");
        ListIndexCommandDUnitTest.assertNotNull((Object)result);
        ListIndexCommandDUnitTest.getLogWriter().info(ListIndexCommandDUnitTest.toString((Result)result));
        ListIndexCommandDUnitTest.assertEquals((Object)Result.Status.OK, (Object)result.getStatus());
    }

    protected static enum CrudOperation {
        CREATE,
        RETRIEVE,
        UPDATE,
        DELETE;

    }

    public static class Proxy
    extends AbstractBean<Long> {
        private final AbstractBean<Long> bean;
        private int unitsSnapshot;

        public Proxy(AbstractBean<Long> bean) {
            assert (bean != null) : "The bean to proxy cannot be null!";
            this.bean = bean;
        }

        public AbstractBean<Long> getBean() {
            return this.bean;
        }

        @Override
        public Long getId() {
            return this.getBean().getId();
        }

        @Override
        public String getName() {
            return this.getBean().getName();
        }

        public int getUnitsSnapshot() {
            return this.unitsSnapshot;
        }

        public void setUnitsSnapshot(int unitsSnapshot) {
            this.unitsSnapshot = unitsSnapshot;
        }
    }

    public static class Producer
    extends AbstractBean<Long> {
        private volatile int units;

        public Producer() {
        }

        public Producer(Long id) {
            super(id);
        }

        public int getUnits() {
            return this.units;
        }

        public int produce() {
            return ++this.units;
        }
    }

    public static class Consumer
    extends AbstractBean<Long> {
        private volatile int units;

        public Consumer() {
        }

        public Consumer(Long id) {
            super(id);
        }

        public int getUnits() {
            return this.units;
        }

        public int consume() {
            return ++this.units;
        }
    }

    protected static abstract class AbstractBean<T extends Comparable<T>>
    implements MutableIdentifiable<T>,
    Serializable {
        private T id;
        private String name;

        public AbstractBean() {
        }

        public AbstractBean(T id) {
            this.id = id;
        }

        public T getId() {
            return this.id;
        }

        public void setId(T id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!this.getClass().isInstance(obj)) {
                return false;
            }
            AbstractBean bean = (AbstractBean)obj;
            return ObjectUtils.equals(this.getId(), bean.getId());
        }

        public int hashCode() {
            int hashValue = 17;
            hashValue = 37 * hashValue + ObjectUtils.hashCode(this.getId());
            return hashValue;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder(this.getClass().getSimpleName());
            buffer.append(" {id = ").append(this.getId());
            buffer.append(", name = ").append(this.getName());
            buffer.append("}");
            return buffer.toString();
        }
    }

    protected static class RegionDefinition
    implements Iterable<Index>,
    Serializable {
        private final Class<?> keyConstraint;
        private final Class<?> valueConstraint;
        private final Set<Index> indexes = new HashSet<Index>();
        private final String regionName;

        protected RegionDefinition(String regionName, Class<?> keyConstraint, Class<?> valueConstraint) {
            assert (!StringUtils.isBlank((String)regionName)) : "The name of the Region must be specified!";
            this.regionName = regionName;
            this.keyConstraint = (Class)ObjectUtils.defaultIfNull((Object[])new Class[]{keyConstraint, Object.class});
            this.valueConstraint = (Class)ObjectUtils.defaultIfNull((Object[])new Class[]{valueConstraint, Object.class});
        }

        public String getRegionName() {
            return this.regionName;
        }

        public Class<?> getKeyConstraint() {
            return this.keyConstraint;
        }

        public Class<?> getValueConstraint() {
            return this.valueConstraint;
        }

        public boolean add(Index ... indexes) {
            return indexes != null && this.indexes.addAll(Arrays.asList(indexes));
        }

        @Override
        public Iterator<Index> iterator() {
            return Collections.unmodifiableSet(this.indexes).iterator();
        }

        public boolean remove(Index ... indexes) {
            return indexes != null && this.indexes.removeAll(Arrays.asList(indexes));
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof RegionDefinition)) {
                return false;
            }
            RegionDefinition that = (RegionDefinition)obj;
            return ObjectUtils.equals((Object)this.getRegionName(), (Object)that.getRegionName());
        }

        public int hashCode() {
            int hashValue = 17;
            hashValue = 37 * hashValue + ObjectUtils.hashCode((Object)this.getRegionName());
            return hashValue;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder(this.getClass().getSimpleName());
            buffer.append(" {regionName = ").append(this.getRegionName());
            buffer.append(", keyConstraint = ").append(this.getKeyConstraint());
            buffer.append(", valueConstraint = ").append(this.getValueConstraint());
            buffer.append("}");
            return buffer.toString();
        }
    }

    protected static class IndexAdapter
    implements Index,
    Serializable {
        private final IndexDetails.IndexType type;
        private final String fromClause;
        private final String indexedExpression;
        private final String name;

        protected IndexAdapter(String name, String indexedExpression, String fromClause) {
            this(name, IndexType.FUNCTIONAL, indexedExpression, fromClause);
        }

        protected IndexAdapter(String name, IndexType type, String indexedExpression, String fromClause) {
            assert (name != null) : "The name of the Index cannot be null!";
            assert (indexedExpression != null) : String.format("The expression to index for Index (%1$s) cannot be null!", name);
            assert (fromClause != null) : String.format("The from clause for Index (%1$s) cannot be null!", name);
            this.type = (IndexDetails.IndexType)ObjectUtils.defaultIfNull((Object[])new IndexDetails.IndexType[]{IndexDetails.IndexType.valueOf((IndexType)type), IndexDetails.IndexType.FUNCTIONAL});
            this.name = name;
            this.indexedExpression = indexedExpression;
            this.fromClause = fromClause;
        }

        public String getName() {
            return this.name;
        }

        public String getFromClause() {
            return this.fromClause;
        }

        public String getCanonicalizedFromClause() {
            return this.fromClause;
        }

        public String getIndexedExpression() {
            return this.indexedExpression;
        }

        public String getCanonicalizedIndexedExpression() {
            return this.indexedExpression;
        }

        public String getProjectionAttributes() {
            throw new UnsupportedOperationException("Not Implemented!");
        }

        public String getCanonicalizedProjectionAttributes() {
            throw new UnsupportedOperationException("Not Implemented!");
        }

        public Region<?, ?> getRegion() {
            throw new UnsupportedOperationException("Not Implemented!");
        }

        public IndexStatistics getStatistics() {
            throw new UnsupportedOperationException("Not Implemented!");
        }

        public IndexType getType() {
            return this.type.getType();
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder(this.getClass().getSimpleName());
            buffer.append(" {indexName = ").append(this.getName());
            buffer.append(", indexType = ").append(this.getType());
            buffer.append(", indexedExpression = ").append(this.getIndexedExpression());
            buffer.append(", fromClause = ").append(this.getFromClause());
            buffer.append("}");
            return buffer.toString();
        }
    }

    protected static class Peer
    implements Iterable<RegionDefinition>,
    Serializable {
        private final Properties distributedSystemProperties;
        private final Set<RegionDefinition> regions = new HashSet<RegionDefinition>();
        private final VM vm;

        public Peer(VM vm, Properties distributedSystemProperties) {
            assert (distributedSystemProperties != null) : "The GemFire Distributed System configuration properties cannot be null!";
            this.distributedSystemProperties = distributedSystemProperties;
            this.vm = vm;
        }

        public Properties getConfiguration() {
            return this.distributedSystemProperties;
        }

        public String getName() {
            return this.getConfiguration().getProperty("name");
        }

        public VM getVm() {
            return this.vm;
        }

        public boolean add(RegionDefinition ... regionDefinitions) {
            return regionDefinitions != null && this.regions.addAll(Arrays.asList(regionDefinitions));
        }

        @Override
        public Iterator<RegionDefinition> iterator() {
            return Collections.unmodifiableSet(this.regions).iterator();
        }

        public boolean remove(RegionDefinition ... regionDefinitions) {
            return regionDefinitions != null && this.regions.removeAll(Arrays.asList(regionDefinitions));
        }

        public void run(Runnable runnable) {
            if (this.getVm() == null) {
                runnable.run();
            } else {
                this.getVm().invoke(runnable);
            }
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder(this.getClass().getSimpleName());
            buffer.append(" {configuration = ").append(this.getConfiguration());
            buffer.append(", name = ").append(this.getName());
            buffer.append(", pid = ").append(this.getVm().getPid());
            buffer.append("}");
            return buffer.toString();
        }
    }
}

