/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.commands;

import com.gemstone.gemfire.distributed.AbstractLauncher;
import com.gemstone.gemfire.distributed.LocatorLauncher;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.lang.ObjectUtils;
import com.gemstone.gemfire.internal.lang.StringUtils;
import com.gemstone.gemfire.internal.process.ProcessType;
import com.gemstone.gemfire.internal.util.IOUtils;
import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.cli.commands.CliCommandTestBase;
import com.gemstone.gemfire.management.internal.cli.i18n.CliStrings;
import com.gemstone.gemfire.management.internal.cli.result.CommandResult;
import dunit.DistributedTestCase;
import dunit.Host;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.QueryExp;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class LauncherLifecycleCommandsDUnitTest
extends CliCommandTestBase {
    public LauncherLifecycleCommandsDUnitTest(String testName) {
        super(testName);
    }

    protected static String getMemberId(int jmxManagerPort, String memberName) throws Exception {
        return LauncherLifecycleCommandsDUnitTest.getMemberId(InetAddress.getLocalHost().getHostName(), jmxManagerPort, memberName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getMemberId(String jmxManagerHost, int jmxManagerPort, String memberName) throws Exception {
        String string;
        JMXConnector connector = null;
        try {
            connector = JMXConnectorFactory.connect(new JMXServiceURL(String.format("service:jmx:rmi://%1$s/jndi/rmi://%1$s:%2$d/jmxrmi", jmxManagerHost, jmxManagerPort)));
            MBeanServerConnection connection = connector.getMBeanServerConnection();
            ObjectName objectNamePattern = ObjectName.getInstance("GemFire:type=Member,*");
            QueryExp query = Query.eq(Query.attr("Name"), Query.value(memberName));
            Set<ObjectName> objectNames = connection.queryNames(objectNamePattern, query);
            LauncherLifecycleCommandsDUnitTest.assertNotNull(objectNames);
            LauncherLifecycleCommandsDUnitTest.assertEquals((int)1, (int)objectNames.size());
            ObjectName objectName = objectNames.iterator().next();
            string = ObjectUtils.toString((Object)connection.getAttribute(objectName, "Id"));
        }
        catch (Throwable throwable) {
            IOUtils.close(connector);
            throw throwable;
        }
        IOUtils.close((Closeable)connector);
        return string;
    }

    protected static void assertStatus(LocatorLauncher.LocatorState expectedStatus, LocatorLauncher.LocatorState actualStatus) {
        LauncherLifecycleCommandsDUnitTest.assertEquals((Object)expectedStatus.getStatus(), (Object)actualStatus.getStatus());
        LauncherLifecycleCommandsDUnitTest.assertEquals((Object)expectedStatus.getTimestamp(), (Object)actualStatus.getTimestamp());
        LauncherLifecycleCommandsDUnitTest.assertEquals((String)expectedStatus.getServiceLocation(), (String)actualStatus.getServiceLocation());
        LauncherLifecycleCommandsDUnitTest.assertTrue((boolean)ObjectUtils.equalsIgnoreNull((Object)expectedStatus.getPid(), (Object)actualStatus.getPid()));
        LauncherLifecycleCommandsDUnitTest.assertEquals((Object)expectedStatus.getUptime(), (Object)actualStatus.getUptime());
        LauncherLifecycleCommandsDUnitTest.assertEquals((String)expectedStatus.getWorkingDirectory(), (String)actualStatus.getWorkingDirectory());
        LauncherLifecycleCommandsDUnitTest.assertEquals((Object)expectedStatus.getJvmArguments(), (Object)actualStatus.getJvmArguments());
        LauncherLifecycleCommandsDUnitTest.assertEquals((String)expectedStatus.getClasspath(), (String)actualStatus.getClasspath());
        LauncherLifecycleCommandsDUnitTest.assertEquals((String)expectedStatus.getGemFireVersion(), (String)actualStatus.getGemFireVersion());
        LauncherLifecycleCommandsDUnitTest.assertEquals((String)expectedStatus.getJavaVersion(), (String)actualStatus.getJavaVersion());
    }

    protected static String serviceStateStatusStringNormalized(AbstractLauncher.ServiceState state) {
        return LauncherLifecycleCommandsDUnitTest.serviceStateStatusStringNormalized(state.toString());
    }

    protected static String serviceStateStatusStringNormalized(String locatorStatus) {
        LauncherLifecycleCommandsDUnitTest.assertNotNull((Object)locatorStatus);
        LauncherLifecycleCommandsDUnitTest.assertTrue((String)("locatorStatus is missing Uptime: " + locatorStatus), (boolean)locatorStatus.contains("Uptime"));
        LauncherLifecycleCommandsDUnitTest.assertTrue((String)("locatorStatus is missing Uptime: " + locatorStatus), (boolean)locatorStatus.contains("JVM Arguments"));
        StringBuilder buffer = new StringBuilder();
        buffer.append(locatorStatus.substring(0, locatorStatus.indexOf("Uptime")));
        buffer.append(locatorStatus.substring(locatorStatus.indexOf("JVM Arguments")));
        return buffer.toString().trim();
    }

    protected static AbstractLauncher.Status stopLocator(File workingDirectory) {
        return LauncherLifecycleCommandsDUnitTest.stopLocator(IOUtils.tryGetCanonicalPathElseGetAbsolutePath((File)workingDirectory));
    }

    protected static AbstractLauncher.Status stopLocator(String workingDirectory) {
        return new LocatorLauncher.Builder().setCommand(LocatorLauncher.Command.STOP).setWorkingDirectory(workingDirectory).build().stop().getStatus();
    }

    protected static String toString(Result result) {
        assert (result != null) : "The Result object from the command execution cannot be null!";
        StringBuilder buffer = new StringBuilder(StringUtils.LINE_SEPARATOR);
        while (result.hasNextLine()) {
            buffer.append(result.nextLine());
            buffer.append(StringUtils.LINE_SEPARATOR);
        }
        return buffer.toString();
    }

    protected static void writePid(File pidFile, int pid) throws IOException {
        LauncherLifecycleCommandsDUnitTest.assertTrue((String)"The PID file must actually exist!", (pidFile != null && pidFile.isFile() ? 1 : 0) != 0);
        FileWriter writer = new FileWriter(pidFile, false);
        writer.write(String.valueOf(pid));
        writer.write("\n");
        writer.flush();
        IOUtils.close((Closeable)writer);
    }

    public void testStartLocatorCapturesOutputOnError() throws IOException {
        int locatorPort = AvailablePortHelper.getRandomAvailableTCPPort();
        String pathname = this.getClass().getSimpleName() + "_" + testName;
        File workingDirectory = new File(pathname);
        workingDirectory.mkdir();
        LauncherLifecycleCommandsDUnitTest.assertTrue((boolean)workingDirectory.isDirectory());
        File pidFile = new File(workingDirectory, ProcessType.LOCATOR.getPidFileName());
        pidFile.createNewFile();
        int readPid = Host.getHost(0).getVM(3).getPid();
        LauncherLifecycleCommandsDUnitTest.writePid(pidFile, readPid);
        pidFile.deleteOnExit();
        LauncherLifecycleCommandsDUnitTest.assertTrue((boolean)pidFile.isFile());
        CommandResult result = this.executeCommand("start locator --name=" + pathname + " --dir=" + pathname + " --port=" + locatorPort + " --J=-Dgemfire.jmx-manager-http-port=0 --J=-Dgemfire.jmx-manager-port=" + AvailablePortHelper.getRandomAvailableTCPPort());
        LauncherLifecycleCommandsDUnitTest.assertNotNull((Object)result);
        LauncherLifecycleCommandsDUnitTest.assertEquals((Object)Result.Status.ERROR, (Object)result.getStatus());
        String resultString = LauncherLifecycleCommandsDUnitTest.toString((Result)result);
        LauncherLifecycleCommandsDUnitTest.assertTrue((String)resultString, (boolean)resultString.contains("Exception in thread \"main\" java.lang.RuntimeException: A PID file already exists and a Locator may be running in " + IOUtils.tryGetCanonicalFileElseGetAbsoluteFile((File)workingDirectory)));
        LauncherLifecycleCommandsDUnitTest.assertTrue((String)resultString, (boolean)resultString.contains("Caused by: com.gemstone.gemfire.internal.process.FileAlreadyExistsException: Pid file already exists: " + IOUtils.tryGetCanonicalFileElseGetAbsoluteFile((File)pidFile)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStartLocatorWithRelativeDirectory() {
        int locatorPort = AvailablePortHelper.getRandomAvailableTCPPort();
        String pathname = this.getClass().getSimpleName() + "_" + testName;
        File workingDirectory = new File(pathname);
        workingDirectory.mkdir();
        LauncherLifecycleCommandsDUnitTest.assertTrue((boolean)workingDirectory.isDirectory());
        try {
            CommandResult result = this.executeCommand("start locator --name=" + pathname + " --dir=" + pathname + " --port=" + locatorPort + " --force=true --J=-Dgemfire.jmx-manager-http-port=0 --J=-Dgemfire.jmx-manager-port=" + AvailablePortHelper.getRandomAvailableTCPPort());
            LauncherLifecycleCommandsDUnitTest.assertNotNull((Object)result);
            LauncherLifecycleCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)result.getStatus());
            String locatorOutput = LauncherLifecycleCommandsDUnitTest.toString((Result)result);
            LauncherLifecycleCommandsDUnitTest.assertNotNull((Object)locatorOutput);
            LauncherLifecycleCommandsDUnitTest.assertTrue((String)("Locator output was: " + locatorOutput), (boolean)locatorOutput.contains("Locator in " + IOUtils.tryGetCanonicalFileElseGetAbsoluteFile((File)workingDirectory)));
        }
        finally {
            LauncherLifecycleCommandsDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)LauncherLifecycleCommandsDUnitTest.stopLocator(workingDirectory));
        }
    }

    public void testStatusLocatorUsingMemberNameIDWhenGfshIsNotConnected() {
        CommandResult result = this.executeCommand("status locator --name=" + testName);
        LauncherLifecycleCommandsDUnitTest.assertEquals((Object)Result.Status.ERROR, (Object)result.getStatus());
        LauncherLifecycleCommandsDUnitTest.assertEquals((String)CliStrings.format((String)"Gfsh must be connected in order to get the status of a {0} by member name or ID.", (Object)"Locator"), (String)StringUtils.trim((String)LauncherLifecycleCommandsDUnitTest.toString((Result)result)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStatusLocatorUsingMemberName() {
        int[] ports = AvailablePortHelper.getRandomAvailableTCPPorts(2);
        int jmxManagerPort = ports[0];
        int locatorPort = ports[1];
        String pathname = this.getClass().getSimpleName() + "_" + testName;
        File workingDirectory = new File(pathname);
        workingDirectory.mkdir();
        LauncherLifecycleCommandsDUnitTest.assertTrue((boolean)workingDirectory.isDirectory());
        try {
            CommandResult result = this.executeCommand("start locator --name=" + pathname + " --dir=" + pathname + " --port=" + locatorPort + " --force=true --J=-Dgemfire.jmx-manager-http-port=0 --J=-Dgemfire.jmx-manager-port=" + jmxManagerPort);
            LauncherLifecycleCommandsDUnitTest.assertNotNull((Object)result);
            LauncherLifecycleCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)result.getStatus());
            LocatorLauncher locatorLauncher = new LocatorLauncher.Builder().setCommand(LocatorLauncher.Command.STATUS).setBindAddress(null).setPort(Integer.valueOf(locatorPort)).setWorkingDirectory(workingDirectory.getPath()).build();
            LauncherLifecycleCommandsDUnitTest.assertNotNull((Object)locatorLauncher);
            LocatorLauncher.LocatorState expectedLocatorState = locatorLauncher.waitOnStatusResponse(60L, 10L, TimeUnit.SECONDS);
            LauncherLifecycleCommandsDUnitTest.assertNotNull((Object)expectedLocatorState);
            LauncherLifecycleCommandsDUnitTest.assertEquals((Object)AbstractLauncher.Status.ONLINE, (Object)expectedLocatorState.getStatus());
            result = this.executeCommand("connect --locator=localhost[" + locatorPort + "]");
            LauncherLifecycleCommandsDUnitTest.assertNotNull((Object)result);
            LauncherLifecycleCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)result.getStatus());
            result = this.executeCommand("status locator --name=invalidLocatorMemberName");
            LauncherLifecycleCommandsDUnitTest.assertNotNull((Object)result);
            LauncherLifecycleCommandsDUnitTest.assertEquals((Object)Result.Status.ERROR, (Object)result.getStatus());
            LauncherLifecycleCommandsDUnitTest.assertEquals((String)CliStrings.format((String)"No Locator with member name or ID {0} could be found.", (Object)"invalidLocatorMemberName"), (String)StringUtils.trim((String)LauncherLifecycleCommandsDUnitTest.toString((Result)result)));
            result = this.executeCommand("status locator --name=" + pathname);
            LauncherLifecycleCommandsDUnitTest.assertNotNull((Object)result);
            LauncherLifecycleCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)result.getStatus());
            LauncherLifecycleCommandsDUnitTest.assertEquals((String)LauncherLifecycleCommandsDUnitTest.serviceStateStatusStringNormalized((AbstractLauncher.ServiceState)expectedLocatorState), (String)LauncherLifecycleCommandsDUnitTest.serviceStateStatusStringNormalized(LauncherLifecycleCommandsDUnitTest.toString((Result)result)));
        }
        finally {
            LauncherLifecycleCommandsDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)LauncherLifecycleCommandsDUnitTest.stopLocator(workingDirectory));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStatusLocatorUsingMemberId() throws Exception {
        int[] ports = AvailablePortHelper.getRandomAvailableTCPPorts(2);
        int jmxManagerPort = ports[0];
        int locatorPort = ports[1];
        String pathname = this.getClass().getSimpleName() + "_" + testName;
        File workingDirectory = new File(pathname);
        workingDirectory.mkdir();
        LauncherLifecycleCommandsDUnitTest.assertTrue((boolean)workingDirectory.isDirectory());
        try {
            CommandResult result = this.executeCommand("start locator --name=" + pathname + " --dir=" + pathname + " --port=" + locatorPort + " --force=true --J=-Dgemfire.jmx-manager-http-port=0 --J=-Dgemfire.jmx-manager-port=" + jmxManagerPort);
            LauncherLifecycleCommandsDUnitTest.assertNotNull((Object)result);
            LauncherLifecycleCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)result.getStatus());
            LocatorLauncher locatorLauncher = new LocatorLauncher.Builder().setCommand(LocatorLauncher.Command.STATUS).setBindAddress(null).setPort(Integer.valueOf(locatorPort)).setWorkingDirectory(workingDirectory.getPath()).build();
            LauncherLifecycleCommandsDUnitTest.assertNotNull((Object)locatorLauncher);
            LocatorLauncher.LocatorState expectedLocatorState = locatorLauncher.waitOnStatusResponse(60L, 10L, TimeUnit.SECONDS);
            LauncherLifecycleCommandsDUnitTest.assertNotNull((Object)expectedLocatorState);
            LauncherLifecycleCommandsDUnitTest.assertEquals((Object)AbstractLauncher.Status.ONLINE, (Object)expectedLocatorState.getStatus());
            result = this.executeCommand("connect --locator=localhost[" + locatorPort + "]");
            LauncherLifecycleCommandsDUnitTest.assertNotNull((Object)result);
            LauncherLifecycleCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)result.getStatus());
            String memberId = LauncherLifecycleCommandsDUnitTest.getMemberId(jmxManagerPort, pathname);
            result = this.executeCommand("status locator --name=" + memberId);
            LauncherLifecycleCommandsDUnitTest.assertNotNull((Object)result);
            LauncherLifecycleCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)result.getStatus());
            LauncherLifecycleCommandsDUnitTest.assertEquals((String)LauncherLifecycleCommandsDUnitTest.serviceStateStatusStringNormalized((AbstractLauncher.ServiceState)expectedLocatorState), (String)LauncherLifecycleCommandsDUnitTest.serviceStateStatusStringNormalized(LauncherLifecycleCommandsDUnitTest.toString((Result)result)));
        }
        finally {
            LauncherLifecycleCommandsDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)LauncherLifecycleCommandsDUnitTest.stopLocator(workingDirectory));
        }
    }

    public void testStopLocatorUsingMemberNameIDWhenGfshIsNotConnected() {
        CommandResult result = this.executeCommand("stop locator --name=" + testName);
        LauncherLifecycleCommandsDUnitTest.assertNotNull((Object)result);
        LauncherLifecycleCommandsDUnitTest.assertEquals((Object)Result.Status.ERROR, (Object)result.getStatus());
        LauncherLifecycleCommandsDUnitTest.assertEquals((String)CliStrings.format((String)"Gfsh must be connected in order to stop a {0} by member name or ID.", (Object)"Locator"), (String)StringUtils.trim((String)LauncherLifecycleCommandsDUnitTest.toString((Result)result)));
    }

    public void BUG46760WORKAROUNDtestStopLocatorUsingMemberName() {
        int[] ports = AvailablePortHelper.getRandomAvailableTCPPorts(2);
        int jmxManagerPort = ports[0];
        int locatorPort = ports[1];
        String pathname = this.getClass().getSimpleName() + "_" + testName;
        File workingDirectory = new File(pathname);
        workingDirectory.mkdir();
        LauncherLifecycleCommandsDUnitTest.assertTrue((boolean)workingDirectory.isDirectory());
        CommandResult result = this.executeCommand("start locator --name=" + pathname + " --dir=" + pathname + " --port=" + locatorPort + " --force=true --J=-Dgemfire.jmx-manager-http-port=0 --J=-Dgemfire.jmx-manager-port=" + jmxManagerPort);
        LauncherLifecycleCommandsDUnitTest.assertNotNull((Object)result);
        LauncherLifecycleCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)result.getStatus());
        final LocatorLauncher locatorLauncher = new LocatorLauncher.Builder().setCommand(LocatorLauncher.Command.STOP).setBindAddress(null).setPort(Integer.valueOf(locatorPort)).setWorkingDirectory(workingDirectory.getPath()).build();
        LauncherLifecycleCommandsDUnitTest.assertNotNull((Object)locatorLauncher);
        LocatorLauncher.LocatorState locatorStatus = locatorLauncher.waitOnStatusResponse(60L, 10L, TimeUnit.SECONDS);
        LauncherLifecycleCommandsDUnitTest.assertNotNull((Object)locatorStatus);
        LauncherLifecycleCommandsDUnitTest.assertEquals((Object)AbstractLauncher.Status.ONLINE, (Object)locatorStatus.getStatus());
        result = this.executeCommand("connect --locator=localhost[" + locatorPort + "]");
        LauncherLifecycleCommandsDUnitTest.assertNotNull((Object)result);
        LauncherLifecycleCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)result.getStatus());
        result = this.executeCommand("stop locator --name=invalidLocatorMemberName");
        LauncherLifecycleCommandsDUnitTest.assertNotNull((Object)result);
        LauncherLifecycleCommandsDUnitTest.assertEquals((Object)Result.Status.ERROR, (Object)result.getStatus());
        LauncherLifecycleCommandsDUnitTest.assertEquals((String)CliStrings.format((String)"No Locator with member name or ID {0} could be found.", (Object)"invalidLocatorMemberName"), (String)StringUtils.trim((String)LauncherLifecycleCommandsDUnitTest.toString((Result)result)));
        locatorStatus = locatorLauncher.status();
        LauncherLifecycleCommandsDUnitTest.assertNotNull((Object)locatorStatus);
        LauncherLifecycleCommandsDUnitTest.assertEquals((Object)AbstractLauncher.Status.ONLINE, (Object)locatorStatus.getStatus());
        result = this.executeCommand("stop locator --name=" + pathname);
        LauncherLifecycleCommandsDUnitTest.assertNotNull((Object)result);
        LauncherLifecycleCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)result.getStatus());
        DistributedTestCase.WaitCriterion waitCriteria = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                LocatorLauncher.LocatorState locatorStatus = locatorLauncher.status();
                return locatorStatus != null && AbstractLauncher.Status.NOT_RESPONDING.equals((Object)locatorStatus.getStatus());
            }

            @Override
            public String description() {
                return "wait for the Locator to stop";
            }
        };
        LauncherLifecycleCommandsDUnitTest.waitForCriterion(waitCriteria, 15000L, 5000L, true);
        locatorStatus = locatorLauncher.status();
        LauncherLifecycleCommandsDUnitTest.assertNotNull((Object)locatorStatus);
        LauncherLifecycleCommandsDUnitTest.assertEquals((Object)AbstractLauncher.Status.NOT_RESPONDING, (Object)locatorStatus.getStatus());
    }

    public void BUG46760WORKAROUNDtestStopLocatorUsingMemberId() throws Exception {
        int[] ports = AvailablePortHelper.getRandomAvailableTCPPorts(2);
        int jmxManagerPort = ports[0];
        int locatorPort = ports[1];
        String pathname = this.getClass().getSimpleName() + "_" + testName;
        File workingDirectory = new File(pathname);
        workingDirectory.mkdir();
        LauncherLifecycleCommandsDUnitTest.assertTrue((boolean)workingDirectory.isDirectory());
        CommandResult result = this.executeCommand("start locator --name=" + pathname + " --dir=" + pathname + " --port=" + locatorPort + " --force=true --J=-Dgemfire.jmx-manager-http-port=0 --J=-Dgemfire.jmx-manager-port=" + jmxManagerPort);
        LauncherLifecycleCommandsDUnitTest.assertNotNull((Object)result);
        LauncherLifecycleCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)result.getStatus());
        final LocatorLauncher locatorLauncher = new LocatorLauncher.Builder().setCommand(LocatorLauncher.Command.STOP).setBindAddress(null).setPort(Integer.valueOf(locatorPort)).setWorkingDirectory(workingDirectory.getPath()).build();
        LauncherLifecycleCommandsDUnitTest.assertNotNull((Object)locatorLauncher);
        LocatorLauncher.LocatorState locatorStatus = locatorLauncher.waitOnStatusResponse(60L, 10L, TimeUnit.SECONDS);
        LauncherLifecycleCommandsDUnitTest.assertNotNull((Object)locatorStatus);
        LauncherLifecycleCommandsDUnitTest.assertEquals((Object)AbstractLauncher.Status.ONLINE, (Object)locatorStatus.getStatus());
        result = this.executeCommand("connect --locator=localhost[" + locatorPort + "]");
        LauncherLifecycleCommandsDUnitTest.assertNotNull((Object)result);
        LauncherLifecycleCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)result.getStatus());
        String memberId = LauncherLifecycleCommandsDUnitTest.getMemberId(jmxManagerPort, pathname);
        result = this.executeCommand("stop locator --name=" + memberId);
        LauncherLifecycleCommandsDUnitTest.assertNotNull((Object)result);
        LauncherLifecycleCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)result.getStatus());
        DistributedTestCase.WaitCriterion waitCriteria = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                LocatorLauncher.LocatorState locatorStatus = locatorLauncher.status();
                return locatorStatus != null && AbstractLauncher.Status.NOT_RESPONDING.equals((Object)locatorStatus.getStatus());
            }

            @Override
            public String description() {
                return "wait for the Locator to stop";
            }
        };
        LauncherLifecycleCommandsDUnitTest.waitForCriterion(waitCriteria, 15000L, 5000L, true);
        locatorStatus = locatorLauncher.status();
        LauncherLifecycleCommandsDUnitTest.assertNotNull((Object)locatorStatus);
        LauncherLifecycleCommandsDUnitTest.assertEquals((Object)AbstractLauncher.Status.NOT_RESPONDING, (Object)locatorStatus.getStatus());
    }
}

