/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.commands;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DiskStoreFactory;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.cli.commands.CliCommandTestBase;
import com.gemstone.gemfire.management.internal.cli.domain.Stock;
import com.gemstone.gemfire.management.internal.cli.i18n.CliStrings;
import com.gemstone.gemfire.management.internal.cli.result.CommandResult;
import com.gemstone.gemfire.management.internal.cli.util.CommandStringBuilder;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.VM;
import java.io.File;
import java.util.Properties;

public class IndexCommandsDUnitTest
extends CliCommandTestBase {
    private static final long serialVersionUID = 1L;
    private static final String VM1Name = "VM1";
    private static final String group1 = "G1";
    private static final String indexName = "Id1";
    private static final String parRegPersName = "ParRegPers";
    private static final String repRegPersName = "RepRegPer";

    public IndexCommandsDUnitTest(String name) {
        super(name);
    }

    private Region<?, ?> createParReg(String regionName, Cache cache, Class keyConstraint, Class valueConstraint) {
        RegionFactory regionFactory = cache.createRegionFactory();
        regionFactory.setDataPolicy(DataPolicy.PARTITION);
        regionFactory.setKeyConstraint(keyConstraint);
        regionFactory.setValueConstraint(valueConstraint);
        return regionFactory.create(regionName);
    }

    private Region<?, ?> createParRegWithPersistence(String regionName, String diskStoreName, String diskDirName) {
        Cache cache = this.getCache();
        File diskStoreDirFile = new File(diskDirName);
        diskStoreDirFile.deleteOnExit();
        if (!diskStoreDirFile.exists()) {
            diskStoreDirFile.mkdirs();
        }
        DiskStoreFactory diskStoreFactory = cache.createDiskStoreFactory();
        diskStoreFactory.setDiskDirs(new File[]{diskStoreDirFile});
        diskStoreFactory.setMaxOplogSize(1L);
        diskStoreFactory.setAllowForceCompaction(true);
        diskStoreFactory.setAutoCompact(false);
        diskStoreFactory.create(diskStoreName);
        EvictionAttributes ea = EvictionAttributes.createLRUEntryAttributes((int)1, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK);
        RegionFactory regionFactory = cache.createRegionFactory();
        regionFactory.setDiskStoreName(diskStoreName);
        regionFactory.setDiskSynchronous(true);
        regionFactory.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
        regionFactory.setEvictionAttributes(ea);
        return regionFactory.create(regionName);
    }

    private Region<?, ?> createRepRegWithPersistence(String regionName, String diskStoreName, String diskDirName) {
        Cache cache = this.getCache();
        File diskStoreDirFile = new File(diskDirName);
        diskStoreDirFile.deleteOnExit();
        if (!diskStoreDirFile.exists()) {
            diskStoreDirFile.mkdirs();
        }
        DiskStoreFactory diskStoreFactory = cache.createDiskStoreFactory();
        diskStoreFactory.setDiskDirs(new File[]{diskStoreDirFile});
        diskStoreFactory.setMaxOplogSize(1L);
        diskStoreFactory.setAllowForceCompaction(true);
        diskStoreFactory.setAutoCompact(false);
        diskStoreFactory.create(diskStoreName);
        EvictionAttributes ea = EvictionAttributes.createLRUEntryAttributes((int)1, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK);
        RegionFactory regionFactory = cache.createRegionFactory();
        regionFactory.setDiskStoreName(diskStoreName);
        regionFactory.setDiskSynchronous(true);
        regionFactory.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
        regionFactory.setEvictionAttributes(ea);
        return regionFactory.create(regionName);
    }

    public void testCreateKeyIndexOnRegionWithPersistence() {
        this.setupSystemPersist();
        CommandStringBuilder csb = new CommandStringBuilder("create index");
        csb.addOption("name", "id1");
        csb.addOption("expression", "ty");
        csb.addOption("region", "/ParRegPers");
        csb.addOption("type", "key");
        String commandString = csb.toString();
        this.writeToLog("Command String :\n ", commandString);
        CommandResult commandResult = this.executeCommand(commandString);
        String resultAsString = this.commandResultToString(commandResult);
        this.writeToLog("Command Result :\n", resultAsString);
        IndexCommandsDUnitTest.assertTrue((boolean)Result.Status.OK.equals((Object)commandResult.getStatus()));
        csb = new CommandStringBuilder("create index");
        csb.addOption("name", "id2");
        csb.addOption("expression", "ee");
        csb.addOption("region", "/RepRegPer");
        csb.addOption("type", "key");
        commandString = csb.toString();
        this.writeToLog("Command String :\n ", commandString);
        commandResult = this.executeCommand(commandString);
        resultAsString = this.commandResultToString(commandResult);
        this.writeToLog("Command Result :\n", resultAsString);
        IndexCommandsDUnitTest.assertTrue((boolean)Result.Status.OK.equals((Object)commandResult.getStatus()));
    }

    public void testCreateAndDestroyIndex() {
        this.setupSystem();
        CommandStringBuilder csb = new CommandStringBuilder("create index");
        csb.addOption("name", indexName);
        csb.addOption("expression", "key");
        csb.addOption("region", "/StocksParReg");
        String commandString = csb.toString();
        this.writeToLog("Command String :\n ", commandString);
        CommandResult commandResult = this.executeCommand(commandString);
        String resultAsString = this.commandResultToString(commandResult);
        this.writeToLog("testCreateAndDestroyIndex", resultAsString);
        IndexCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)commandResult.getStatus());
        csb = new CommandStringBuilder("list indexes");
        commandString = csb.toString();
        commandResult = this.executeCommand(commandString);
        resultAsString = this.commandResultToString(commandResult);
        IndexCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)commandResult.getStatus());
        IndexCommandsDUnitTest.assertTrue((boolean)resultAsString.contains(indexName));
        csb = new CommandStringBuilder("destroy index");
        csb.addOption("name", indexName);
        csb.addOption("region", "/StocksParReg");
        commandString = csb.toString();
        this.writeToLog("Command String :\n ", commandString);
        commandResult = this.executeCommand(commandString);
        resultAsString = this.commandResultToString(commandResult);
        this.writeToLog("testCreateAndDestroyIndex", resultAsString);
        IndexCommandsDUnitTest.assertEquals((Object)commandResult.getStatus(), (Object)Result.Status.OK);
        commandResult = this.executeCommand("list indexes");
        resultAsString = this.commandResultToString(commandResult);
        IndexCommandsDUnitTest.assertEquals((Object)commandResult.getStatus(), (Object)Result.Status.OK);
        IndexCommandsDUnitTest.assertFalse((boolean)resultAsString.contains(indexName));
    }

    public void testCreateAndDestroyIndexOnMember() {
        this.setupSystem();
        CommandStringBuilder csb = new CommandStringBuilder("create index");
        csb.addOption("name", indexName);
        csb.addOption("expression", "key");
        csb.addOption("region", "/StocksParReg");
        csb.addOption("member", VM1Name);
        csb.addOption("type", "key");
        String commandString = csb.toString();
        CommandResult commandResult = this.executeCommand(commandString);
        String resultAsString = this.commandResultToString(commandResult);
        this.writeToLog("Command String :\n ", commandString);
        this.writeToLog("testCreateAndDestroyIndexOnMember", resultAsString);
        IndexCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)commandResult.getStatus());
        csb = new CommandStringBuilder("list indexes");
        commandString = csb.toString();
        commandResult = this.executeCommand(commandString);
        resultAsString = this.commandResultToString(commandResult);
        this.writeToLog("Command String :\n ", commandString);
        this.writeToLog("testCreateAndDestroyIndexOnMember", resultAsString);
        IndexCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)commandResult.getStatus());
        IndexCommandsDUnitTest.assertTrue((boolean)resultAsString.contains(indexName));
        IndexCommandsDUnitTest.assertTrue((boolean)resultAsString.contains(VM1Name));
        csb = new CommandStringBuilder("destroy index");
        csb.addOption("name", indexName);
        csb.addOption("region", "/StocksParReg");
        csb.addOption("member", VM1Name);
        commandString = csb.toString();
        commandResult = this.executeCommand(commandString);
        resultAsString = this.commandResultToString(commandResult);
        this.writeToLog("Command String :\n ", commandString);
        this.writeToLog("testCreateAndDestroyIndexOnMember", resultAsString);
        IndexCommandsDUnitTest.assertEquals((Object)commandResult.getStatus(), (Object)Result.Status.OK);
        commandResult = this.executeCommand("list indexes");
        resultAsString = this.commandResultToString(commandResult);
        this.writeToLog("Command String :\n ", commandString);
        this.writeToLog("testCreateAndDestroyIndexOnMember", resultAsString);
        IndexCommandsDUnitTest.assertEquals((Object)commandResult.getStatus(), (Object)Result.Status.OK);
        IndexCommandsDUnitTest.assertFalse((boolean)resultAsString.contains(VM1Name));
    }

    public void testCreateAndDestroyIndexOnGroup() {
        this.setupSystem();
        CommandStringBuilder csb = new CommandStringBuilder("create index");
        csb.addOption("name", indexName);
        csb.addOption("expression", "key");
        csb.addOption("region", "/StocksParReg");
        csb.addOption("type", "hash");
        csb.addOption("group", group1);
        String commandString = csb.toString();
        CommandResult commandResult = this.executeCommand(commandString);
        String resultAsString = this.commandResultToString(commandResult);
        this.writeToLog("Command String :\n ", commandString);
        this.writeToLog("testCreateAndDestroyIndexOnGroup", resultAsString);
        IndexCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)commandResult.getStatus());
        csb = new CommandStringBuilder("list indexes");
        commandString = csb.toString();
        commandResult = this.executeCommand(commandString);
        resultAsString = this.commandResultToString(commandResult);
        IndexCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)commandResult.getStatus());
        IndexCommandsDUnitTest.assertEquals((boolean)true, (boolean)resultAsString.contains(indexName));
        IndexCommandsDUnitTest.assertEquals((boolean)true, (boolean)resultAsString.contains(VM1Name));
        csb = new CommandStringBuilder("destroy index");
        csb.addOption("name", indexName);
        csb.addOption("region", "/StocksParReg");
        csb.addOption("group", group1);
        commandString = csb.toString();
        commandResult = this.executeCommand(commandString);
        resultAsString = this.commandResultToString(commandResult);
        this.writeToLog("Command String :\n ", commandString);
        this.writeToLog("testCreateAndDestroyIndexOnGroup", resultAsString);
        IndexCommandsDUnitTest.assertEquals((Object)commandResult.getStatus(), (Object)Result.Status.OK);
        commandResult = this.executeCommand("list indexes");
        resultAsString = this.commandResultToString(commandResult);
        IndexCommandsDUnitTest.assertEquals((Object)commandResult.getStatus(), (Object)Result.Status.OK);
        IndexCommandsDUnitTest.assertFalse((boolean)resultAsString.contains(VM1Name));
        if (resultAsString.contains(indexName)) {
            csb = new CommandStringBuilder("destroy index");
            csb.addOption("name", indexName);
            csb.addOption("region", "/StocksParReg");
            commandString = csb.toString();
            commandResult = this.executeCommand(commandString);
            resultAsString = this.commandResultToString(commandResult);
            IndexCommandsDUnitTest.assertEquals((Object)commandResult.getStatus(), (Object)Result.Status.OK);
            commandResult = this.executeCommand("list indexes");
            resultAsString = this.commandResultToString(commandResult);
            this.writeToLog("Command String :\n ", commandString);
            this.writeToLog("testCreateAndDestroyIndexOnGroup", resultAsString);
            IndexCommandsDUnitTest.assertEquals((Object)commandResult.getStatus(), (Object)Result.Status.OK);
            IndexCommandsDUnitTest.assertFalse((boolean)resultAsString.contains(indexName));
            IndexCommandsDUnitTest.assertTrue((boolean)resultAsString.contains("No Indexes Found"));
        }
    }

    public void testCreateAndDestroyIndexWithIncorrectInput() {
        this.setupSystem();
        CommandStringBuilder csb = new CommandStringBuilder("create index");
        csb.addOption("name", indexName);
        csb.addOption("expression", "key");
        csb.addOption("region", "/StocksParReg");
        csb.addOption("type", "hash");
        String commandString = csb.toString();
        CommandResult commandResult = this.executeCommand(commandString);
        String resultAsString = this.commandResultToString(commandResult);
        IndexCommandsDUnitTest.assertEquals((Object)commandResult.getStatus(), (Object)Result.Status.OK);
        csb = new CommandStringBuilder("create index");
        csb.addOption("name", indexName);
        csb.addOption("expression", "key");
        csb.addOption("region", "/StocksParReg");
        csb.addOption("type", "hash");
        commandString = csb.toString();
        commandResult = this.executeCommand(commandString);
        resultAsString = this.commandResultToString(commandResult);
        IndexCommandsDUnitTest.assertTrue((boolean)commandResult.getStatus().equals((Object)Result.Status.ERROR));
        this.writeToLog("Command String :\n ", commandString);
        this.writeToLog("testCreateAndDestroyIndexWithIncorrectInput", resultAsString);
        csb = new CommandStringBuilder("create index");
        csb.addOption("name", indexName);
        csb.addOption("expression", "key");
        csb.addOption("region", "/StocsParReg");
        csb.addOption("type", "hash");
        commandString = csb.toString();
        commandResult = this.executeCommand(commandString);
        resultAsString = this.commandResultToString(commandResult);
        this.writeToLog("Command String :\n ", commandString);
        this.writeToLog("testCreateAndDestroyIndexWithIncorrectInput", resultAsString);
        IndexCommandsDUnitTest.assertTrue((boolean)commandResult.getStatus().equals((Object)Result.Status.ERROR));
        csb = new CommandStringBuilder("create index");
        csb.addOption("name", "Id2");
        csb.addOption("expression", "rey");
        csb.addOption("region", "/StocksParReg");
        csb.addOption("type", "hash");
        commandString = csb.toString();
        commandResult = this.executeCommand(commandString);
        resultAsString = this.commandResultToString(commandResult);
        this.writeToLog("Command String :\n ", commandString);
        this.writeToLog("testCreateAndDestroyIndexWithIncorrectInput", resultAsString);
        IndexCommandsDUnitTest.assertTrue((boolean)commandResult.getStatus().equals((Object)Result.Status.ERROR));
        csb = new CommandStringBuilder("create index");
        csb.addOption("name", indexName);
        csb.addOption("expression", "key");
        csb.addOption("region", "/StocksParReg");
        csb.addOption("type", "bash");
        commandString = csb.toString();
        commandResult = this.executeCommand(commandString);
        resultAsString = this.commandResultToString(commandResult);
        this.writeToLog("Command String :\n ", commandString);
        this.writeToLog("testCreateAndDestroyIndexWithIncorrectInput", resultAsString);
        IndexCommandsDUnitTest.assertTrue((boolean)resultAsString.contains("Invalid index type,value must be one of the following: range, key or hash."));
        IndexCommandsDUnitTest.assertTrue((boolean)commandResult.getStatus().equals((Object)Result.Status.ERROR));
        csb = new CommandStringBuilder("destroy index");
        csb.addOption("name", "Id2");
        commandString = csb.toString();
        commandResult = this.executeCommand(commandString);
        resultAsString = this.commandResultToString(commandResult);
        this.writeToLog("Command String :\n ", commandString);
        this.writeToLog("testCreateAndDestroyIndexWithIncorrectInput", resultAsString);
        IndexCommandsDUnitTest.assertTrue((boolean)commandResult.getStatus().equals((Object)Result.Status.ERROR));
        IndexCommandsDUnitTest.assertTrue((boolean)resultAsString.contains(CliStrings.format((String)"Index named \"{0}\" not found", (Object)"Id2")));
        csb = new CommandStringBuilder("destroy index");
        csb.addOption("name", indexName);
        csb.addOption("region", "Region");
        commandString = csb.toString();
        commandResult = this.executeCommand(commandString);
        resultAsString = this.commandResultToString(commandResult);
        this.writeToLog("Command String :\n ", commandString);
        this.writeToLog("testCreateAndDestroyIndexWithIncorrectInput", resultAsString);
        IndexCommandsDUnitTest.assertTrue((boolean)commandResult.getStatus().equals((Object)Result.Status.ERROR));
        IndexCommandsDUnitTest.assertTrue((boolean)resultAsString.contains(CliStrings.format((String)"Region \"{0}\" not found", (Object)"Region")));
        csb = new CommandStringBuilder("destroy index");
        csb.addOption("name", indexName);
        csb.addOption("region", "Region");
        csb.addOption("member", "wrongOne");
        commandString = csb.toString();
        commandResult = this.executeCommand(commandString);
        resultAsString = this.commandResultToString(commandResult);
        this.writeToLog("Command String :\n ", commandString);
        this.writeToLog("testCreateAndDestroyIndexWithIncorrectInput", resultAsString);
        IndexCommandsDUnitTest.assertTrue((boolean)commandResult.getStatus().equals((Object)Result.Status.ERROR));
        csb = new CommandStringBuilder("destroy index");
        commandString = csb.toString();
        commandResult = this.executeCommand(commandString);
        resultAsString = this.commandResultToString(commandResult);
        this.writeToLog("Command String :\n ", commandString);
        this.writeToLog("testCreateAndDestroyIndexWithIncorrectInput", resultAsString);
        IndexCommandsDUnitTest.assertTrue((boolean)commandResult.getStatus().equals((Object)Result.Status.ERROR));
    }

    public void testDestroyIndexWithoutIndexName() {
        this.setupSystem();
        CommandStringBuilder csb = new CommandStringBuilder("create index");
        csb.addOption("name", indexName);
        csb.addOption("expression", "key");
        csb.addOption("region", "/StocksParReg");
        csb.addOption("type", "hash");
        String commandString = csb.toString();
        CommandResult commandResult = this.executeCommand(commandString);
        String resultAsString = this.commandResultToString(commandResult);
        IndexCommandsDUnitTest.assertEquals((Object)commandResult.getStatus(), (Object)Result.Status.OK);
        csb = new CommandStringBuilder("list indexes");
        commandString = csb.toString();
        commandResult = this.executeCommand(commandString);
        resultAsString = this.commandResultToString(commandResult);
        IndexCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)commandResult.getStatus());
        IndexCommandsDUnitTest.assertEquals((boolean)true, (boolean)resultAsString.contains(indexName));
        IndexCommandsDUnitTest.assertEquals((boolean)true, (boolean)resultAsString.contains(VM1Name));
        csb = new CommandStringBuilder("destroy index");
        csb.addOption("group", group1);
        commandString = csb.toString();
        commandResult = this.executeCommand(commandString);
        resultAsString = this.commandResultToString(commandResult);
        IndexCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)commandResult.getStatus());
        csb = new CommandStringBuilder("list indexes");
        commandString = csb.toString();
        commandResult = this.executeCommand(commandString);
        resultAsString = this.commandResultToString(commandResult);
        IndexCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)commandResult.getStatus());
        csb = new CommandStringBuilder("create index");
        csb.addOption("name", indexName);
        csb.addOption("expression", "key");
        csb.addOption("region", "/StocksParReg");
        csb.addOption("type", "hash");
        commandString = csb.toString();
        commandResult = this.executeCommand(commandString);
        resultAsString = this.commandResultToString(commandResult);
        IndexCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)commandResult.getStatus());
        csb = new CommandStringBuilder("destroy index");
        csb.addOption("region", "StocksParReg");
        commandString = csb.toString();
        commandResult = this.executeCommand(commandString);
        resultAsString = this.commandResultToString(commandResult);
        IndexCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)commandResult.getStatus());
        csb = new CommandStringBuilder("list indexes");
        commandString = csb.toString();
        commandResult = this.executeCommand(commandString);
        resultAsString = this.commandResultToString(commandResult);
        IndexCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)commandResult.getStatus());
        IndexCommandsDUnitTest.assertTrue((boolean)resultAsString.contains("No Indexes Found"));
    }

    private void writeToLog(String text, String resultAsString) {
        IndexCommandsDUnitTest.getLogWriter().info(testName + "\n");
        IndexCommandsDUnitTest.getLogWriter().info(resultAsString);
    }

    private void setupSystem() {
        IndexCommandsDUnitTest.disconnectAllFromDS();
        this.createDefaultSetup(null);
        String parRegName = "StocksParReg";
        VM manager = Host.getHost(0).getVM(0);
        VM vm1 = Host.getHost(0).getVM(1);
        manager.invoke(new SerializableCallable(){

            public Object call() {
                Region parReg = IndexCommandsDUnitTest.this.createParReg("StocksParReg", IndexCommandsDUnitTest.this.getCache(), String.class, Stock.class);
                parReg.put((Object)"VMW", (Object)new Stock("VMW", 98.0));
                return parReg.put((Object)"APPL", (Object)new Stock("APPL", 600.0));
            }
        });
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Properties props = new Properties();
                props.setProperty("name", IndexCommandsDUnitTest.VM1Name);
                props.setProperty("groups", IndexCommandsDUnitTest.group1);
                IndexCommandsDUnitTest.this.getSystem(props);
                Region parReg = IndexCommandsDUnitTest.this.createParReg("StocksParReg", IndexCommandsDUnitTest.this.getCache(), String.class, Stock.class);
                parReg.put((Object)"MSFT", (Object)new Stock("MSFT", 27.0));
                return parReg.put((Object)"GOOG", (Object)new Stock("GOOG", 540.0));
            }
        });
    }

    private void setupSystemPersist() {
        IndexCommandsDUnitTest.disconnectAllFromDS();
        this.createDefaultSetup(null);
        String parRegName = "StocksParReg";
        VM manager = Host.getHost(0).getVM(0);
        VM vm1 = Host.getHost(0).getVM(1);
        manager.invoke(new SerializableCallable(){

            public Object call() {
                Region parReg = IndexCommandsDUnitTest.this.createParReg("StocksParReg", IndexCommandsDUnitTest.this.getCache(), String.class, Stock.class);
                parReg.put((Object)"VMW", (Object)new Stock("VMW", 98.0));
                Region parRegPers = IndexCommandsDUnitTest.this.createParRegWithPersistence(IndexCommandsDUnitTest.parRegPersName, "testCreateIndexDiskstore1", "testCreateIndexDiskDir1");
                Region repRegPers = IndexCommandsDUnitTest.this.createRepRegWithPersistence(IndexCommandsDUnitTest.repRegPersName, "testCreateIndexDiskstore1", "testCreateIndexDiskDir1");
                return parReg.put((Object)"APPL", (Object)new Stock("APPL", 600.0));
            }
        });
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Properties props = new Properties();
                props.setProperty("name", IndexCommandsDUnitTest.VM1Name);
                props.setProperty("groups", IndexCommandsDUnitTest.group1);
                IndexCommandsDUnitTest.this.getSystem(props);
                Region parReg = IndexCommandsDUnitTest.this.createParReg("StocksParReg", IndexCommandsDUnitTest.this.getCache(), String.class, Stock.class);
                parReg.put((Object)"MSFT", (Object)new Stock("MSFT", 27.0));
                Region parRegPers = IndexCommandsDUnitTest.this.createParRegWithPersistence(IndexCommandsDUnitTest.parRegPersName, "testCreateIndexDiskstore2", "testCreateIndexDiskDir2");
                Region repRegPers = IndexCommandsDUnitTest.this.createRepRegWithPersistence(IndexCommandsDUnitTest.repRegPersName, "testCreateIndexDiskstore2", "testCreateIndexDiskDir2");
                return parReg.put((Object)"GOOG", (Object)new Stock("GOOG", 540.0));
            }
        });
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
    }
}

