/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.commands;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.query.QueryInvalidException;
import com.gemstone.gemfire.cache.query.data.Portfolio;
import com.gemstone.gemfire.cache.query.internal.CompiledValue;
import com.gemstone.gemfire.cache.query.internal.QCompiler;
import com.gemstone.gemfire.management.DistributedRegionMXBean;
import com.gemstone.gemfire.management.ManagementService;
import com.gemstone.gemfire.management.ManagerMXBean;
import com.gemstone.gemfire.management.MemberMXBean;
import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.cli.commands.CliCommandTestBase;
import com.gemstone.gemfire.management.internal.cli.commands.DataCommands;
import com.gemstone.gemfire.management.internal.cli.domain.DataCommandRequest;
import com.gemstone.gemfire.management.internal.cli.dto.Key1;
import com.gemstone.gemfire.management.internal.cli.dto.Value1;
import com.gemstone.gemfire.management.internal.cli.dto.Value2;
import com.gemstone.gemfire.management.internal.cli.json.GfJsonArray;
import com.gemstone.gemfire.management.internal.cli.json.GfJsonException;
import com.gemstone.gemfire.management.internal.cli.result.CommandResult;
import com.gemstone.gemfire.management.internal.cli.result.CompositeResultData;
import com.gemstone.gemfire.management.internal.cli.result.TabularResultData;
import com.gemstone.gemfire.management.internal.cli.util.CommandStringBuilder;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import hydra.GsRandom;
import hydra.Log;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import junit.framework.TestCase;
import management.cli.TestableGfsh;
import management.util.HydraUtil;

public class GemfireDataCommandsDUnitTest
extends CliCommandTestBase {
    private static final long serialVersionUID = 1L;
    private static final String REGION_NAME = "FunctionCommandsReplicatedRegion";
    private static final String REBALANCE_REGION_NAME = "GemfireDataCommandsDUnitTestRegion";
    private static final String REBALANCE_REGION2_NAME = "GemfireDataCommandsDUnitTestRegion2";
    private static final String DATA_REGION_NAME = "GemfireDataCommandsTestRegion";
    private static final String DATA_REGION_NAME_VM1 = "GemfireDataCommandsTestRegion_Vm1";
    private static final String DATA_REGION_NAME_VM2 = "GemfireDataCommandsTestRegion_Vm2";
    private static final String DATA_REGION_NAME_PATH = "/GemfireDataCommandsTestRegion";
    private static final String DATA_REGION_NAME_VM1_PATH = "/GemfireDataCommandsTestRegion_Vm1";
    private static final String DATA_REGION_NAME_VM2_PATH = "/GemfireDataCommandsTestRegion_Vm2";
    private static final String DATA_PAR_REGION_NAME = "GemfireDataCommandsTestParRegion";
    private static final String DATA_PAR_REGION_NAME_VM1 = "GemfireDataCommandsTestParRegion_Vm1";
    private static final String DATA_PAR_REGION_NAME_VM2 = "GemfireDataCommandsTestParRegion_Vm2";
    private static final String DATA_PAR_REGION_NAME_PATH = "/GemfireDataCommandsTestParRegion";
    private static final String DATA_PAR_REGION_NAME_VM1_PATH = "/GemfireDataCommandsTestParRegion_Vm1";
    private static final String DATA_PAR_REGION_NAME_VM2_PATH = "/GemfireDataCommandsTestParRegion_Vm2";
    private static final String DATA_REGION_NAME_CHILD_1 = "ChildRegionRegion1";
    private static final String DATA_REGION_NAME_CHILD_1_PATH = "/GemfireDataCommandsTestRegion/ChildRegionRegion1";
    private static final String DATA_REGION_NAME_CHILD_1_2 = "ChildRegionRegion12";
    private static final String DATA_REGION_NAME_CHILD_1_2_PATH = "/GemfireDataCommandsTestRegion/ChildRegionRegion1/ChildRegionRegion12";
    private static final String keyTemplate = "('id':'?','name':'name?')";
    private static final String valueTemplate = "('stateName':'State?','population':?1,'capitalCity':'capital?','areaInSqKm':?2)";
    static final int COUNT = 50;
    SerializableRunnable checkRegionMBeans = new SerializableRunnable(){

        @Override
        public void run() {
            DistributedTestCase.WaitCriterion waitForMaangerMBean = new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    ManagementService service = ManagementService.getManagementService((Cache)GemfireDataCommandsDUnitTest.this.getCache());
                    DistributedRegionMXBean bean = service.getDistributedRegionMXBean("/GemfireDataCommandsDUnitTestRegion");
                    if (bean == null) {
                        Log.getLogWriter().info("Still probing for checkRegionMBeans ManagerMBean");
                        return false;
                    }
                    return bean.getMemberCount() > 0 && service.getDistributedSystemMXBean().listRegions().length > 0;
                }

                @Override
                public String description() {
                    return "Probing for testRebalanceCommandForSimulateWithNoMember ManagerMBean";
                }
            };
            DistributedTestCase.waitForCriterion(waitForMaangerMBean, 120000L, 2000L, true);
            DistributedRegionMXBean bean = ManagementService.getManagementService((Cache)GemfireDataCommandsDUnitTest.this.getCache()).getDistributedRegionMXBean("/GemfireDataCommandsDUnitTestRegion");
            TestCase.assertNotNull((Object)bean);
        }
    };

    public GemfireDataCommandsDUnitTest(String name) {
        super(name);
    }

    public static String getMemberId() {
        Cache cache = new GemfireDataCommandsDUnitTest("test").getCache();
        return cache.getDistributedSystem().getDistributedMember().getId();
    }

    void setupForGetPutRemoveLocateEntry(String testName) {
        VM vm1 = Host.getHost(0).getVM(1);
        VM vm2 = Host.getHost(0).getVM(2);
        Properties props = new Properties();
        props.setProperty("name", testName + "Manager");
        TestableGfsh gfsh = this.createDefaultSetup(props);
        GemfireDataCommandsDUnitTest.assertNotNull((Object)gfsh);
        GemfireDataCommandsDUnitTest.assertEquals((boolean)true, (boolean)gfsh.isConnectedAndReady());
        vm1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = GemfireDataCommandsDUnitTest.this.getCache();
                RegionFactory regionFactory = cache.createRegionFactory(RegionShortcut.REPLICATE);
                Region dataRegion = regionFactory.create(GemfireDataCommandsDUnitTest.DATA_REGION_NAME);
                TestCase.assertNotNull((Object)dataRegion);
                Log.getLogWriter().info("Created Region " + dataRegion);
                dataRegion = dataRegion.createSubregion(GemfireDataCommandsDUnitTest.DATA_REGION_NAME_CHILD_1, dataRegion.getAttributes());
                TestCase.assertNotNull((Object)dataRegion);
                Log.getLogWriter().info("Created Region " + dataRegion);
                dataRegion = dataRegion.createSubregion(GemfireDataCommandsDUnitTest.DATA_REGION_NAME_CHILD_1_2, dataRegion.getAttributes());
                TestCase.assertNotNull((Object)dataRegion);
                Log.getLogWriter().info("Created Region " + dataRegion);
                dataRegion = regionFactory.create(GemfireDataCommandsDUnitTest.DATA_REGION_NAME_VM1);
                TestCase.assertNotNull((Object)dataRegion);
                Log.getLogWriter().info("Created Region " + dataRegion);
                PartitionAttributes partitionAttrs = new PartitionAttributesFactory().setRedundantCopies(2).create();
                RegionFactory partitionRegionFactory = cache.createRegionFactory(RegionShortcut.PARTITION);
                partitionRegionFactory.setPartitionAttributes(partitionAttrs);
                Region dataParRegion = partitionRegionFactory.create(GemfireDataCommandsDUnitTest.DATA_PAR_REGION_NAME);
                TestCase.assertNotNull((Object)dataParRegion);
                Log.getLogWriter().info("Created Region " + dataParRegion);
                dataParRegion = partitionRegionFactory.create(GemfireDataCommandsDUnitTest.DATA_PAR_REGION_NAME_VM1);
                TestCase.assertNotNull((Object)dataParRegion);
                Log.getLogWriter().info("Created Region " + dataParRegion);
            }
        });
        vm2.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = GemfireDataCommandsDUnitTest.this.getCache();
                RegionFactory regionFactory = cache.createRegionFactory(RegionShortcut.REPLICATE);
                Region dataRegion = regionFactory.create(GemfireDataCommandsDUnitTest.DATA_REGION_NAME);
                TestCase.assertNotNull((Object)dataRegion);
                Log.getLogWriter().info("Created Region " + dataRegion);
                dataRegion = dataRegion.createSubregion(GemfireDataCommandsDUnitTest.DATA_REGION_NAME_CHILD_1, dataRegion.getAttributes());
                TestCase.assertNotNull((Object)dataRegion);
                Log.getLogWriter().info("Created Region " + dataRegion);
                dataRegion = dataRegion.createSubregion(GemfireDataCommandsDUnitTest.DATA_REGION_NAME_CHILD_1_2, dataRegion.getAttributes());
                TestCase.assertNotNull((Object)dataRegion);
                Log.getLogWriter().info("Created Region " + dataRegion);
                dataRegion = regionFactory.create(GemfireDataCommandsDUnitTest.DATA_REGION_NAME_VM2);
                TestCase.assertNotNull((Object)dataRegion);
                Log.getLogWriter().info("Created Region " + dataRegion);
                PartitionAttributes partitionAttrs = new PartitionAttributesFactory().setRedundantCopies(2).create();
                RegionFactory partitionRegionFactory = cache.createRegionFactory(RegionShortcut.PARTITION);
                partitionRegionFactory.setPartitionAttributes(partitionAttrs);
                Region dataParRegion = partitionRegionFactory.create(GemfireDataCommandsDUnitTest.DATA_PAR_REGION_NAME);
                TestCase.assertNotNull((Object)dataParRegion);
                Log.getLogWriter().info("Created Region " + dataParRegion);
                dataParRegion = partitionRegionFactory.create(GemfireDataCommandsDUnitTest.DATA_PAR_REGION_NAME_VM2);
                TestCase.assertNotNull((Object)dataParRegion);
                Log.getLogWriter().info("Created Region " + dataParRegion);
            }
        });
        String vm1MemberId = (String)vm1.invoke(GemfireDataCommandsDUnitTest.class, "getMemberId");
        String vm2MemberId = (String)vm2.invoke(GemfireDataCommandsDUnitTest.class, "getMemberId");
        Log.getLogWriter().info("Vm1 ID : " + vm1MemberId);
        Log.getLogWriter().info("Vm2 ID : " + vm2MemberId);
        VM manager = Host.getHost(0).getVM(0);
        SerializableRunnable checkRegionMBeans = new SerializableRunnable(){

            @Override
            public void run() {
                String[] regions;
                Cache cache = GemfireDataCommandsDUnitTest.this.getCache();
                final ManagementService service = ManagementService.getManagementService((Cache)cache);
                DistributedTestCase.WaitCriterion waitForMaangerMBean = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        ManagerMXBean bean1 = service.getManagerMXBean();
                        DistributedRegionMXBean bean2 = service.getDistributedRegionMXBean(GemfireDataCommandsDUnitTest.DATA_REGION_NAME_PATH);
                        if (bean1 == null) {
                            Log.getLogWriter().info("Still probing for ManagerMBean");
                            return false;
                        }
                        Log.getLogWriter().info("Still probing for DistributedRegionMXBean=" + bean2);
                        return bean2 != null;
                    }

                    @Override
                    public String description() {
                        return "Probing for ManagerMBean";
                    }
                };
                DistributedTestCase.waitForCriterion(waitForMaangerMBean, 30000L, 2000L, true);
                TestCase.assertNotNull((Object)service.getMemberMXBean());
                TestCase.assertNotNull((Object)service.getManagerMXBean());
                DistributedRegionMXBean bean = service.getDistributedRegionMXBean(GemfireDataCommandsDUnitTest.DATA_REGION_NAME_PATH);
                TestCase.assertNotNull((Object)bean);
                DistributedTestCase.WaitCriterion waitForRegionMBeans = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        DistributedRegionMXBean[] beans = new DistributedRegionMXBean[]{service.getDistributedRegionMXBean(GemfireDataCommandsDUnitTest.DATA_REGION_NAME_PATH), service.getDistributedRegionMXBean(GemfireDataCommandsDUnitTest.DATA_REGION_NAME_VM1_PATH), service.getDistributedRegionMXBean(GemfireDataCommandsDUnitTest.DATA_REGION_NAME_VM2_PATH), service.getDistributedRegionMXBean(GemfireDataCommandsDUnitTest.DATA_PAR_REGION_NAME_PATH), service.getDistributedRegionMXBean(GemfireDataCommandsDUnitTest.DATA_PAR_REGION_NAME_VM1_PATH), service.getDistributedRegionMXBean(GemfireDataCommandsDUnitTest.DATA_PAR_REGION_NAME_VM2_PATH)};
                        boolean flag = true;
                        for (DistributedRegionMXBean b : beans) {
                            if (b != null) continue;
                            flag = false;
                            break;
                        }
                        if (!flag) {
                            Log.getLogWriter().info("Still probing for regionMbeans /GemfireDataCommandsTestRegion=" + beans[0] + " " + GemfireDataCommandsDUnitTest.DATA_REGION_NAME_VM1_PATH + "=" + beans[1] + " " + GemfireDataCommandsDUnitTest.DATA_REGION_NAME_VM2_PATH + "=" + beans[2] + " " + GemfireDataCommandsDUnitTest.DATA_PAR_REGION_NAME_PATH + "=" + beans[3] + " " + GemfireDataCommandsDUnitTest.DATA_PAR_REGION_NAME_VM1_PATH + "=" + beans[4] + " " + GemfireDataCommandsDUnitTest.DATA_PAR_REGION_NAME_VM2_PATH + "=" + beans[5] + " ");
                            return false;
                        }
                        Log.getLogWriter().info("Probing complete for regionMbeans /GemfireDataCommandsTestRegion=" + beans[0] + " " + GemfireDataCommandsDUnitTest.DATA_REGION_NAME_VM1_PATH + "=" + beans[1] + " " + GemfireDataCommandsDUnitTest.DATA_REGION_NAME_VM2_PATH + "=" + beans[2] + " " + GemfireDataCommandsDUnitTest.DATA_PAR_REGION_NAME_PATH + "=" + beans[3] + " " + GemfireDataCommandsDUnitTest.DATA_PAR_REGION_NAME_VM1_PATH + "=" + beans[4] + " " + GemfireDataCommandsDUnitTest.DATA_PAR_REGION_NAME_VM2_PATH + "=" + beans[5] + " ");
                        return true;
                    }

                    @Override
                    public String description() {
                        return "Probing for regionMbeans";
                    }
                };
                DistributedTestCase.waitForCriterion(waitForRegionMBeans, 30000L, 2000L, true);
                for (String region : regions = new String[]{GemfireDataCommandsDUnitTest.DATA_REGION_NAME_PATH, GemfireDataCommandsDUnitTest.DATA_REGION_NAME_VM1_PATH, GemfireDataCommandsDUnitTest.DATA_REGION_NAME_VM2_PATH, GemfireDataCommandsDUnitTest.DATA_PAR_REGION_NAME_PATH, GemfireDataCommandsDUnitTest.DATA_PAR_REGION_NAME_VM1_PATH, GemfireDataCommandsDUnitTest.DATA_PAR_REGION_NAME_VM2_PATH}) {
                    bean = service.getDistributedRegionMXBean(region);
                    TestCase.assertNotNull((Object)bean);
                    String[] membersName = bean.getMembers();
                    Log.getLogWriter().info("Members Array for region " + region + " : " + HydraUtil.ObjectToString(membersName));
                    if (bean.getMemberCount() >= 1) continue;
                    TestCase.fail((String)"Even after waiting mbean reports number of member hosting region /GemfireDataCommandsTestRegion_Vm1 is less than one");
                }
            }
        };
        manager.invoke(checkRegionMBeans);
    }

    void setupForSelect() {
        this.setupForGetPutRemoveLocateEntry("setupForSelect");
        VM vm1 = Host.getHost(0).getVM(1);
        VM vm2 = Host.getHost(0).getVM(2);
        this.executeCommand("set variable --name=APP_FETCH_SIZE --value=50");
        vm1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                int j;
                String[] regions;
                Cache cache = CacheFactory.getAnyInstance();
                for (String r : regions = new String[]{GemfireDataCommandsDUnitTest.DATA_PAR_REGION_NAME_PATH, GemfireDataCommandsDUnitTest.DATA_PAR_REGION_NAME_VM1_PATH, GemfireDataCommandsDUnitTest.DATA_REGION_NAME_CHILD_1_PATH, GemfireDataCommandsDUnitTest.DATA_REGION_NAME_CHILD_1_2_PATH}) {
                    Region dataRegion = cache.getRegion(r);
                    for (int j2 = 0; j2 < 10; ++j2) {
                        dataRegion.put((Object)new Integer(j2), (Object)new Portfolio(j2));
                    }
                }
                Region dataRegion = cache.getRegion(GemfireDataCommandsDUnitTest.DATA_REGION_NAME_PATH);
                for (j = 0; j < 10; ++j) {
                    dataRegion.put((Object)new Integer(j), (Object)new Value1(j));
                }
                dataRegion = cache.getRegion(GemfireDataCommandsDUnitTest.DATA_REGION_NAME_VM1_PATH);
                for (j = 0; j < 10; ++j) {
                    dataRegion.put((Object)new Integer(j), (Object)new Value1WithValue2(j));
                }
            }
        });
        vm2.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                String[] regions;
                Cache cache = CacheFactory.getAnyInstance();
                for (String r : regions = new String[]{GemfireDataCommandsDUnitTest.DATA_REGION_NAME_VM2_PATH, GemfireDataCommandsDUnitTest.DATA_PAR_REGION_NAME_VM2_PATH}) {
                    Region dataRegion = cache.getRegion(r);
                    for (int j = 0; j < 10; ++j) {
                        dataRegion.put((Object)new Integer(j), (Object)new Portfolio(j));
                    }
                }
            }
        });
    }

    private void doQueryRegionsAssociatedMembers(String queryTemplate, int expectedMembers, boolean returnAll, String ... regions) {
        Cache cache = CacheFactory.getAnyInstance();
        String query = queryTemplate;
        int i = 1;
        for (String r : regions) {
            query = query.replace("?" + i, r);
            ++i;
        }
        Log.getLogWriter().info("Checking members for query : " + query);
        QCompiler compiler = new QCompiler(cache.getLoggerI18n());
        Set regionsInQuery = null;
        try {
            CompiledValue compiledQuery = compiler.compileQuery(query);
            HashSet regionSet = new HashSet();
            compiledQuery.getRegionsInQuery(regionSet, null);
            regionsInQuery = Collections.unmodifiableSet(regionSet);
            Log.getLogWriter().info("Region in query : " + regionsInQuery);
            if (regionsInQuery.size() > 0) {
                Set members = DataCommands.getQueryRegionsAssociatedMembers(regionsInQuery, (Cache)cache, (boolean)returnAll);
                Log.getLogWriter().info("Members for Region in query : " + members);
                if (expectedMembers != -1) {
                    GemfireDataCommandsDUnitTest.assertNotNull((Object)members);
                    GemfireDataCommandsDUnitTest.assertEquals((int)expectedMembers, (int)members.size());
                } else {
                    GemfireDataCommandsDUnitTest.assertEquals((int)0, (int)members.size());
                }
            } else {
                GemfireDataCommandsDUnitTest.assertEquals((int)-1, (int)expectedMembers);
            }
        }
        catch (QueryInvalidException qe) {
            GemfireDataCommandsDUnitTest.fail("Invalid Query", qe);
        }
    }

    public void doTestGetRegionAssociatedMembersForSelect() {
        VM manager = Host.getHost(0).getVM(0);
        String queryTemplate1 = "select * from ?1, ?2 ";
        manager.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                GemfireDataCommandsDUnitTest.this.doQueryRegionsAssociatedMembers("select * from ?1, ?2 ", 0, true, new String[]{GemfireDataCommandsDUnitTest.DATA_REGION_NAME_VM1_PATH, GemfireDataCommandsDUnitTest.DATA_REGION_NAME_VM2_PATH});
                GemfireDataCommandsDUnitTest.this.doQueryRegionsAssociatedMembers("select * from ?1, ?2 ", 2, true, new String[]{GemfireDataCommandsDUnitTest.DATA_REGION_NAME_PATH, GemfireDataCommandsDUnitTest.DATA_REGION_NAME_CHILD_1_PATH});
                GemfireDataCommandsDUnitTest.this.doQueryRegionsAssociatedMembers("select * from ?1, ?2 ", 1, false, new String[]{GemfireDataCommandsDUnitTest.DATA_REGION_NAME_PATH, GemfireDataCommandsDUnitTest.DATA_REGION_NAME_CHILD_1_PATH});
                GemfireDataCommandsDUnitTest.this.doQueryRegionsAssociatedMembers("select * from ?1, ?2 ", 1, true, new String[]{GemfireDataCommandsDUnitTest.DATA_REGION_NAME_VM1_PATH, GemfireDataCommandsDUnitTest.DATA_REGION_NAME_PATH});
                GemfireDataCommandsDUnitTest.this.doQueryRegionsAssociatedMembers("select * from ?1, ?2 ", 1, false, new String[]{GemfireDataCommandsDUnitTest.DATA_REGION_NAME_VM1_PATH, GemfireDataCommandsDUnitTest.DATA_REGION_NAME_PATH});
                GemfireDataCommandsDUnitTest.this.doQueryRegionsAssociatedMembers("select * from ?1, ?2 ", 1, true, new String[]{GemfireDataCommandsDUnitTest.DATA_REGION_NAME_VM2_PATH, GemfireDataCommandsDUnitTest.DATA_REGION_NAME_PATH});
                GemfireDataCommandsDUnitTest.this.doQueryRegionsAssociatedMembers("select * from ?1, ?2 ", 1, false, new String[]{GemfireDataCommandsDUnitTest.DATA_REGION_NAME_VM2_PATH, GemfireDataCommandsDUnitTest.DATA_REGION_NAME_PATH});
                GemfireDataCommandsDUnitTest.this.doQueryRegionsAssociatedMembers("select * from ?1, ?2 ", 0, true, new String[]{GemfireDataCommandsDUnitTest.DATA_PAR_REGION_NAME_VM2_PATH, GemfireDataCommandsDUnitTest.DATA_PAR_REGION_NAME_VM1_PATH});
                GemfireDataCommandsDUnitTest.this.doQueryRegionsAssociatedMembers("select * from ?1, ?2 ", 0, false, new String[]{GemfireDataCommandsDUnitTest.DATA_PAR_REGION_NAME_VM2_PATH, GemfireDataCommandsDUnitTest.DATA_PAR_REGION_NAME_VM1_PATH});
                GemfireDataCommandsDUnitTest.this.doQueryRegionsAssociatedMembers("select * from ?1, ?2 ", -1, true, new String[]{GemfireDataCommandsDUnitTest.DATA_PAR_REGION_NAME_VM2_PATH, "/jfgkdfjgkd"});
                GemfireDataCommandsDUnitTest.this.doQueryRegionsAssociatedMembers("select * from ?1, ?2 ", -1, false, new String[]{GemfireDataCommandsDUnitTest.DATA_PAR_REGION_NAME_VM2_PATH, "/jfgkdfjgkd"});
                GemfireDataCommandsDUnitTest.this.doQueryRegionsAssociatedMembers("select * from ?1, ?2 ", -1, true, new String[]{"/dhgfdhgf", "/dhgddhd"});
                GemfireDataCommandsDUnitTest.this.doQueryRegionsAssociatedMembers("select * from ?1, ?2 ", -1, false, new String[]{"/dhgfdhgf", "/dhgddhd"});
            }
        });
    }

    public void doTestSelectProjection() {
        Random random = new Random(System.nanoTime());
        int randomInteger = random.nextInt(10);
        String query = "query --query=\"select ID , status , createTime , pk, floatMinValue from /GemfireDataCommandsTestParRegion where ID <= " + randomInteger + "\" --interactive=false";
        CommandResult cmdResult = this.executeCommand(query);
        GemfireDataCommandsDUnitTest.printCommandOutput(cmdResult);
        this.validateSelectResult(cmdResult, true, randomInteger + 1, new String[]{"ID", "status", "createTime", "pk", "floatMinValue"});
    }

    public void doTestSelectProjectionProcessCommand() {
        VM manager = Host.getHost(0).getVM(0);
        manager.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Random random = new Random(System.nanoTime());
                int randomInteger = random.nextInt(10);
                String query = "query --query=\"select ID , status , createTime , pk, floatMinValue from /GemfireDataCommandsTestParRegion where ID <= " + randomInteger + "\" --interactive=false";
                ManagementService service = ManagementService.getExistingManagementService((Cache)GemfireDataCommandsDUnitTest.this.getCache());
                MemberMXBean member = service.getMemberMXBean();
                String cmdResult = member.processCommand(query);
                TestCase.assertNotNull((Object)cmdResult);
                Log.getLogWriter().info("Text Command Output : " + cmdResult);
            }
        });
    }

    public void doTestSelectProjectionWithNestedField() {
        Random random = new Random(System.nanoTime());
        int randomInteger = random.nextInt(10);
        String query = "query --query=\"select employeeId, name, department, value2 from /GemfireDataCommandsTestRegion_Vm1 where employeeId <= " + randomInteger + "\" --interactive=false";
        CommandResult cmdResult = this.executeCommand(query);
        GemfireDataCommandsDUnitTest.printCommandOutput(cmdResult);
        String[] expectedCols = new String[]{"employeeId", "name", "department", "value2"};
        this.validateSelectResult(cmdResult, true, randomInteger + 1, expectedCols);
        query = "query --query=\"select ID , status , createTime , pk, floatMinValue, collectionHolderMap from /GemfireDataCommandsTestParRegion where ID <= " + randomInteger + "\" --interactive=false";
        cmdResult = this.executeCommand(query);
        GemfireDataCommandsDUnitTest.printCommandOutput(cmdResult);
        expectedCols = new String[]{"ID", "status", "createTime", "pk", "floatMinValue", "collectionHolderMap"};
        this.validateSelectResult(cmdResult, true, randomInteger + 1, expectedCols);
    }

    public void doTestSelectBeansAsResult() {
        Random random = new Random(System.nanoTime());
        int randomInteger = random.nextInt(10);
        String query = "query --query=\"select * from /GemfireDataCommandsTestRegion where employeeId <= " + randomInteger + "\" --interactive=false";
        CommandResult cmdResult = this.executeCommand(query);
        GemfireDataCommandsDUnitTest.printCommandOutput(cmdResult);
        String[] expectedCols = new String[]{"name", "lastName", "department", "age", "employeeId"};
        this.validateSelectResult(cmdResult, true, randomInteger + 1, expectedCols);
    }

    public void doTestSelectBeansWithNestedFieldAsResult() {
        Random random = new Random(System.nanoTime());
        int randomInteger = random.nextInt(10);
        String query = "query --query=\"select employeeId, name, department, value2 from /GemfireDataCommandsTestRegion_Vm1 where employeeId <= " + randomInteger + "\" --interactive=false";
        CommandResult cmdResult = this.executeCommand(query);
        GemfireDataCommandsDUnitTest.printCommandOutput(cmdResult);
        String[] expectedCols = new String[]{"employeeId", "name", "department", "value2"};
        this.validateSelectResult(cmdResult, true, randomInteger + 1, expectedCols);
    }

    public void doTestSelectWithGfshEnvVariables() {
        Random random = new Random(System.nanoTime());
        int randomInteger = random.nextInt(10);
        String query = "query --query=\"select ID , status , createTime , pk, floatMinValue from ${DATA_REGION} where ID <= ${PORTFOLIO_ID} and status='${STATUS}'\" --interactive=false";
        this.executeCommand("set variable --name=DATA_REGION --value=/GemfireDataCommandsTestRegion");
        this.executeCommand("set variable --name=PORTFOLIO_ID --value=" + randomInteger);
        this.executeCommand("set variable --name=STATUS --value=" + (new GsRandom().nextBoolean() ? "active" : "inactive"));
        CommandResult cmdResult = this.executeCommand(query);
        GemfireDataCommandsDUnitTest.printCommandOutput(cmdResult);
        this.validateSelectResult(cmdResult, true, -1, null);
        query = "query --query=\"select ID , status , createTime , pk, floatMinValue from ${DATA_REGION2} where ID <= ${PORTFOLIO_ID2} and status='${STATUS2}'\" --interactive=false";
        cmdResult = this.executeCommand(query);
        GemfireDataCommandsDUnitTest.printCommandOutput(cmdResult);
        this.validateSelectResult(cmdResult, false, 0, null);
    }

    public void testSelectCommand() {
        this.setupForSelect();
        this.doTestGetRegionAssociatedMembersForSelect();
        this.doTestSelectWithGfshEnvVariables();
        this.doTestSelectProjection();
        this.doTestSelectProjectionProcessCommand();
        this.doTestSelectProjectionWithNestedField();
        this.doTestSelectBeansAsResult();
        this.doTestSelectBeansWithNestedFieldAsResult();
    }

    public void testPrimitivesWithDataCommands() {
        this.setupForGetPutRemoveLocateEntry("testPrimitives");
        Byte byteKey = Byte.parseByte("41");
        Byte byteValue = Byte.parseByte("31");
        Short shortKey = Short.parseShort("123");
        Short shortValue = Short.parseShort("121");
        Integer integerKey = Integer.parseInt("123456");
        Integer integerValue = Integer.parseInt("12345678");
        Float floatKey = Float.valueOf("12432.2325");
        Float flaotValue = Float.valueOf("111111.1111");
        Double doubleKey = Double.valueOf("12432.235425");
        Double doubleValue = Double.valueOf("111111.111111");
        Log.getLogWriter().info("Testing Byte Wrappers");
        this.testGetPutLocateEntryFromShellAndGemfire(byteKey, byteValue, Byte.class, true, true);
        Log.getLogWriter().info("Testing Short Wrappers");
        this.testGetPutLocateEntryFromShellAndGemfire(shortKey, shortValue, Short.class, true, true);
        Log.getLogWriter().info("Testing Integer Wrappers");
        this.testGetPutLocateEntryFromShellAndGemfire(integerKey, integerValue, Integer.class, true, true);
        Log.getLogWriter().info("Testing Float Wrappers");
        this.testGetPutLocateEntryFromShellAndGemfire(floatKey, flaotValue, Float.class, true, true);
        Log.getLogWriter().info("Testing Double Wrappers");
        this.testGetPutLocateEntryFromShellAndGemfire(doubleKey, doubleValue, Double.class, true, true);
    }

    private void testGetPutLocateEntryFromShellAndGemfire(final Object key, final Object value, Class klass, boolean addRegionPath, boolean expResult) {
        VM vm1 = Host.getHost(0).getVM(1);
        SerializableRunnable putTask = new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = GemfireDataCommandsDUnitTest.this.getCache();
                Region region = cache.getRegion(GemfireDataCommandsDUnitTest.DATA_REGION_NAME_PATH);
                TestCase.assertNotNull((Object)region);
                region.clear();
                region.put(key, value);
            }
        };
        SerializableRunnable getTask = new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = GemfireDataCommandsDUnitTest.this.getCache();
                Region region = cache.getRegion(GemfireDataCommandsDUnitTest.DATA_REGION_NAME_PATH);
                TestCase.assertNotNull((Object)region);
                TestCase.assertEquals((boolean)true, (boolean)region.containsKey(key));
                TestCase.assertEquals((Object)value, (Object)region.get(key));
            }
        };
        SerializableRunnable removeTask = new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = GemfireDataCommandsDUnitTest.this.getCache();
                Region region = cache.getRegion(GemfireDataCommandsDUnitTest.DATA_REGION_NAME_PATH);
                TestCase.assertNotNull((Object)region);
                TestCase.assertEquals((boolean)true, (boolean)region.containsKey(key));
                region.remove(key);
            }
        };
        SerializableRunnable clearTask = new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = GemfireDataCommandsDUnitTest.this.getCache();
                Region region = cache.getRegion(GemfireDataCommandsDUnitTest.DATA_REGION_NAME_PATH);
                TestCase.assertNotNull((Object)region);
                region.clear();
            }
        };
        String getCommand = "get --key=" + key + " --key-class=" + klass.getCanonicalName() + " --value-class=" + klass.getCanonicalName();
        if (addRegionPath) {
            getCommand = getCommand + " --region=/GemfireDataCommandsTestRegion";
        }
        String locateEntryCommand = "locate entry --key=" + key + " --key-class=" + klass.getCanonicalName() + " --value-class=" + klass.getCanonicalName();
        if (addRegionPath) {
            locateEntryCommand = locateEntryCommand + " --region=/GemfireDataCommandsTestRegion";
        }
        String removeCommand = "remove --key=" + key + " --key-class=" + klass.getCanonicalName();
        if (addRegionPath) {
            removeCommand = removeCommand + " --region=/GemfireDataCommandsTestRegion";
        }
        String putCommand = "put --key=" + key + " --key-class=" + klass.getCanonicalName() + " --value=" + value + " --value-class=" + klass.getCanonicalName();
        if (addRegionPath) {
            putCommand = putCommand + " --region=/GemfireDataCommandsTestRegion";
        }
        if (expResult) {
            CommandResult cmdResult = this.executeCommand(putCommand);
            GemfireDataCommandsDUnitTest.printCommandOutput(cmdResult);
            this.validateResult(cmdResult, true);
            vm1.invoke(getTask);
            vm1.invoke(removeTask);
            vm1.invoke(clearTask);
            vm1.invoke(putTask);
            cmdResult = this.executeCommand(getCommand);
            GemfireDataCommandsDUnitTest.printCommandOutput(cmdResult);
            this.validateResult(cmdResult, true);
            cmdResult = this.executeCommand(locateEntryCommand);
            GemfireDataCommandsDUnitTest.printCommandOutput(cmdResult);
            this.validateResult(cmdResult, true);
            vm1.invoke(removeTask);
            vm1.invoke(clearTask);
            cmdResult = this.executeCommand(putCommand);
            GemfireDataCommandsDUnitTest.printCommandOutput(cmdResult);
            this.validateResult(cmdResult, true);
            vm1.invoke(getTask);
            cmdResult = this.executeCommand(removeCommand);
            GemfireDataCommandsDUnitTest.printCommandOutput(cmdResult);
            this.validateResult(cmdResult, true);
            cmdResult = this.executeCommand(getCommand);
            GemfireDataCommandsDUnitTest.printCommandOutput(cmdResult);
            this.validateResult(cmdResult, false);
            cmdResult = this.executeCommand(locateEntryCommand);
            GemfireDataCommandsDUnitTest.printCommandOutput(cmdResult);
            this.validateResult(cmdResult, false);
        } else {
            CommandResult cmdResult = this.executeCommand(putCommand);
            GemfireDataCommandsDUnitTest.printCommandOutput(cmdResult);
            this.validateResult(cmdResult, false);
            vm1.invoke(clearTask);
            vm1.invoke(putTask);
            cmdResult = this.executeCommand(getCommand);
            GemfireDataCommandsDUnitTest.printCommandOutput(cmdResult);
            this.validateResult(cmdResult, false);
            cmdResult = this.executeCommand(locateEntryCommand);
            GemfireDataCommandsDUnitTest.printCommandOutput(cmdResult);
            this.validateResult(cmdResult, false);
            vm1.invoke(removeTask);
            vm1.invoke(clearTask);
            cmdResult = this.executeCommand(putCommand);
            GemfireDataCommandsDUnitTest.printCommandOutput(cmdResult);
            this.validateResult(cmdResult, false);
        }
    }

    public void testSimplePutCommand() {
        String keyPrefix = "testKey";
        String valuePrefix = "testValue";
        this.setupForGetPutRemoveLocateEntry("tesSimplePut");
        VM vm1 = Host.getHost(0).getVM(1);
        VM vm2 = Host.getHost(0).getVM(2);
        for (int i = 0; i < 50; ++i) {
            String command = "put";
            String key = "testKey" + i;
            String value = "testValue" + i;
            command = command + " --key=" + key + " --value=" + value + " --region=" + DATA_REGION_NAME_PATH;
            CommandResult cmdResult = this.executeCommand(command);
            GemfireDataCommandsDUnitTest.printCommandOutput(cmdResult);
            this.validateResult(cmdResult, true);
            GemfireDataCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        }
        SerializableRunnable checkPutKeys = new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = GemfireDataCommandsDUnitTest.this.getCache();
                Region region = cache.getRegion(GemfireDataCommandsDUnitTest.DATA_REGION_NAME_PATH);
                TestCase.assertNotNull((Object)region);
                for (int i = 0; i < 50; ++i) {
                    String key = "testKey" + i;
                    TestCase.assertEquals((boolean)true, (boolean)region.containsKey((Object)key));
                }
            }
        };
        vm1.invoke(checkPutKeys);
        vm2.invoke(checkPutKeys);
    }

    private void validateResult(CommandResult cmdResult, boolean expected) {
        if ("composite".equals(cmdResult.getType())) {
            CompositeResultData rd = (CompositeResultData)cmdResult.getResultData();
            CompositeResultData.SectionResultData section = rd.retrieveSectionByIndex(0);
            boolean result = (Boolean)section.retrieveObject("Result");
            GemfireDataCommandsDUnitTest.assertEquals((boolean)expected, (boolean)result);
        } else {
            GemfireDataCommandsDUnitTest.fail((String)("Expected CompositeResult Returned Result Type " + cmdResult.getType()));
        }
    }

    private void validateLocationsResult(CommandResult cmdResult, int expected) {
        if ("composite".equals(cmdResult.getType())) {
            CompositeResultData rd = (CompositeResultData)cmdResult.getResultData();
            CompositeResultData.SectionResultData section = rd.retrieveSectionByIndex(0);
            int result = (Integer)section.retrieveObject("Locations Found");
            GemfireDataCommandsDUnitTest.assertEquals((int)expected, (int)result);
        } else {
            GemfireDataCommandsDUnitTest.fail((String)("Expected CompositeResult Returned Result Type " + cmdResult.getType()));
        }
    }

    private void validateSelectResult(CommandResult cmdResult, boolean expectedFlag, int expectedRows, String[] cols) {
        if ("composite".equals(cmdResult.getType())) {
            CompositeResultData rd = (CompositeResultData)cmdResult.getResultData();
            CompositeResultData.SectionResultData section = rd.retrieveSectionByIndex(0);
            boolean result = (Boolean)section.retrieveObject("Result");
            GemfireDataCommandsDUnitTest.assertEquals((boolean)expectedFlag, (boolean)result);
            if (expectedFlag && expectedRows != -1) {
                int rowsReturned = (Integer)section.retrieveObject("Rows");
                GemfireDataCommandsDUnitTest.assertEquals((int)expectedRows, (int)rowsReturned);
                if (rowsReturned > 0 && cols != null) {
                    try {
                        TabularResultData table = section.retrieveTableByIndex(0);
                        GfJsonArray array = table.getHeaders();
                        GemfireDataCommandsDUnitTest.assertEquals((int)cols.length, (int)array.size());
                        for (String col : cols) {
                            boolean found = false;
                            Log.getLogWriter().info("Validating column " + col);
                            for (int i = 0; i < array.size(); ++i) {
                                String header = (String)array.get(i);
                                if (!col.equals(header)) continue;
                                found = true;
                            }
                            GemfireDataCommandsDUnitTest.assertEquals((boolean)true, (boolean)found);
                        }
                    }
                    catch (GfJsonException e) {
                        GemfireDataCommandsDUnitTest.fail("Error accessing table data", e);
                    }
                }
            }
        } else {
            GemfireDataCommandsDUnitTest.fail((String)("Expected CompositeResult Returned Result Type " + cmdResult.getType()));
        }
    }

    public void testSimplePutIfAbsentCommand() {
        String keyPrefix = "testKey";
        String valuePrefix = "testValue";
        this.setupForGetPutRemoveLocateEntry("testSimplePutIfAbsent");
        VM vm1 = Host.getHost(0).getVM(1);
        VM vm2 = Host.getHost(0).getVM(2);
        SerializableRunnable putKeys = new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = GemfireDataCommandsDUnitTest.this.getCache();
                Region region = cache.getRegion(GemfireDataCommandsDUnitTest.DATA_REGION_NAME_PATH);
                TestCase.assertNotNull((Object)region);
                region.clear();
                for (int i = 0; i < 50; ++i) {
                    String key = "testKey" + i;
                    String value = "testValue" + i;
                    region.put((Object)key, (Object)value);
                }
                TestCase.assertEquals((int)50, (int)region.size());
            }
        };
        vm1.invoke(putKeys);
        for (int i = 0; i < 50; ++i) {
            String command = "put";
            String key = "testKey" + i;
            String value = "testValue" + i + i;
            command = command + " --key=" + key + " --value=" + value + " --region=" + DATA_REGION_NAME_PATH + " --skip-if-exists=true";
            CommandResult cmdResult = this.executeCommand(command);
            GemfireDataCommandsDUnitTest.printCommandOutput(cmdResult);
            GemfireDataCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            this.validateResult(cmdResult, true);
        }
        SerializableRunnable checkPutIfAbsentKeys = new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = GemfireDataCommandsDUnitTest.this.getCache();
                Region region = cache.getRegion(GemfireDataCommandsDUnitTest.DATA_REGION_NAME_PATH);
                TestCase.assertNotNull((Object)region);
                for (int i = 51; i < 50; ++i) {
                    String key = "testKey" + i;
                    String notExpectedvalue = "testValue" + i + i;
                    String expectedvalue = "testValue" + i;
                    String value = (String)region.get((Object)key);
                    TestCase.assertNotNull((Object)value);
                    TestCase.assertEquals((String)value, (String)expectedvalue);
                    if (!value.equals(notExpectedvalue)) continue;
                    TestCase.fail((String)"Value is overriden even if put-If-absent was true");
                }
            }
        };
        vm1.invoke(checkPutIfAbsentKeys);
        vm2.invoke(checkPutIfAbsentKeys);
    }

    public void testSimpleRemoveCommand() {
        String keyPrefix = "testKey";
        String valuePrefix = "testValue";
        this.setupForGetPutRemoveLocateEntry("testSimpleRemove");
        VM vm1 = Host.getHost(0).getVM(1);
        VM vm2 = Host.getHost(0).getVM(2);
        SerializableRunnable putKeys = new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = GemfireDataCommandsDUnitTest.this.getCache();
                Region region = cache.getRegion(GemfireDataCommandsDUnitTest.DATA_REGION_NAME_PATH);
                TestCase.assertNotNull((Object)region);
                region.clear();
                for (int i = 0; i < 50; ++i) {
                    String key = "testKey" + i;
                    String value = "testValue" + i;
                    region.put((Object)key, (Object)value);
                }
                TestCase.assertEquals((int)50, (int)region.size());
            }
        };
        vm1.invoke(putKeys);
        for (int i = 0; i < 50; ++i) {
            String command = "remove";
            String key = "testKey" + i;
            String value = "testValue" + i;
            command = command + " --key=" + key + " --region=" + DATA_REGION_NAME_PATH;
            CommandResult cmdResult = this.executeCommand(command);
            GemfireDataCommandsDUnitTest.printCommandOutput(cmdResult);
            GemfireDataCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            this.validateResult(cmdResult, true);
        }
        SerializableRunnable checkRemoveKeys = new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = GemfireDataCommandsDUnitTest.this.getCache();
                Region region = cache.getRegion(GemfireDataCommandsDUnitTest.DATA_REGION_NAME_PATH);
                TestCase.assertNotNull((Object)region);
                for (int i = 0; i < 50; ++i) {
                    String key = "testKey" + i;
                    TestCase.assertEquals((boolean)false, (boolean)region.containsKey((Object)key));
                }
                TestCase.assertEquals((int)0, (int)region.size());
            }
        };
        vm1.invoke(checkRemoveKeys);
        vm2.invoke(checkRemoveKeys);
    }

    public void testSimpleGetLocateEntryCommand() {
        String keyPrefix = "testKey";
        String valuePrefix = "testValue";
        this.setupForGetPutRemoveLocateEntry("testSimpleGetLocateEntry");
        VM vm1 = Host.getHost(0).getVM(1);
        VM vm2 = Host.getHost(0).getVM(2);
        SerializableRunnable putKeys = new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = GemfireDataCommandsDUnitTest.this.getCache();
                Region region = cache.getRegion(GemfireDataCommandsDUnitTest.DATA_REGION_NAME_PATH);
                TestCase.assertNotNull((Object)region);
                region.clear();
                for (int i = 0; i < 50; ++i) {
                    String key = "testKey" + i;
                    String value = "testValue" + i;
                    region.put((Object)key, (Object)value);
                }
            }
        };
        vm1.invoke(putKeys);
        for (int i = 0; i < 50; ++i) {
            String command = "get";
            String key = "testKey" + i;
            String value = "testValue" + i;
            command = command + " --key=" + key + " --region=" + DATA_REGION_NAME_PATH;
            CommandResult cmdResult = this.executeCommand(command);
            GemfireDataCommandsDUnitTest.printCommandOutput(cmdResult);
            GemfireDataCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            this.validateResult(cmdResult, true);
            command = "locate entry";
            command = command + " --key=" + key + " --region=" + DATA_REGION_NAME_PATH;
            cmdResult = this.executeCommand(command);
            GemfireDataCommandsDUnitTest.printCommandOutput(cmdResult);
            GemfireDataCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            this.validateResult(cmdResult, true);
        }
    }

    public void testRecursiveLocateEntryCommand() {
        String keyPrefix = "testKey";
        String valuePrefix = "testValue";
        this.setupForGetPutRemoveLocateEntry("testRecursiveLocateEntry");
        VM vm1 = Host.getHost(0).getVM(1);
        VM vm2 = Host.getHost(0).getVM(2);
        SerializableRunnable putKeys = new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = GemfireDataCommandsDUnitTest.this.getCache();
                Region region = cache.getRegion(GemfireDataCommandsDUnitTest.DATA_REGION_NAME_PATH);
                Region region2 = cache.getRegion(GemfireDataCommandsDUnitTest.DATA_REGION_NAME_CHILD_1_PATH);
                Region region3 = cache.getRegion(GemfireDataCommandsDUnitTest.DATA_REGION_NAME_CHILD_1_2_PATH);
                TestCase.assertNotNull((Object)region);
                region.clear();
                for (int i = 0; i < 50; ++i) {
                    String key = "testKey" + i;
                    String value = "testValue" + i;
                    region.put((Object)key, (Object)value);
                    region2.put((Object)key, (Object)value);
                    region3.put((Object)key, (Object)value);
                }
            }
        };
        vm1.invoke(putKeys);
        for (int i = 0; i < 50; ++i) {
            String key = "testKey" + i;
            String command = "locate entry";
            command = command + " --key=" + key + " --region=" + DATA_REGION_NAME_PATH + " --recursive=true";
            CommandResult cmdResult = this.executeCommand(command);
            GemfireDataCommandsDUnitTest.printCommandOutput(cmdResult);
            GemfireDataCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            this.validateResult(cmdResult, true);
            this.validateLocationsResult(cmdResult, 6);
        }
    }

    public void testGetLocateEntryFromRegionOnDifferentVM() {
        String keyPrefix = "testKey";
        String valuePrefix = "testValue";
        this.setupForGetPutRemoveLocateEntry("testGetLocateEntryFromRegionOnDifferentVM");
        VM vm1 = Host.getHost(0).getVM(1);
        VM vm2 = Host.getHost(0).getVM(2);
        SerializableRunnable putKeys1 = new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = GemfireDataCommandsDUnitTest.this.getCache();
                Region region = cache.getRegion(GemfireDataCommandsDUnitTest.DATA_REGION_NAME_VM1_PATH);
                Region parRegion = cache.getRegion(GemfireDataCommandsDUnitTest.DATA_PAR_REGION_NAME_VM1_PATH);
                TestCase.assertNotNull((Object)region);
                region.clear();
                for (int i = 0; i < 50; ++i) {
                    if (i % 2 != 0) continue;
                    String key = "testKey" + i;
                    String value = "testValue" + i;
                    region.put((Object)key, (Object)value);
                    parRegion.put((Object)key, (Object)value);
                }
            }
        };
        SerializableRunnable putKeys2 = new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = GemfireDataCommandsDUnitTest.this.getCache();
                Region region = cache.getRegion(GemfireDataCommandsDUnitTest.DATA_REGION_NAME_VM2_PATH);
                Region parRegion = cache.getRegion(GemfireDataCommandsDUnitTest.DATA_PAR_REGION_NAME_VM2_PATH);
                TestCase.assertNotNull((Object)region);
                region.clear();
                for (int i = 0; i < 50; ++i) {
                    if (i % 2 == 0) continue;
                    String key = "testKey" + i;
                    String value = "testValue" + i;
                    region.put((Object)key, (Object)value);
                    parRegion.put((Object)key, (Object)value);
                }
            }
        };
        vm1.invoke(putKeys1);
        vm2.invoke(putKeys2);
        for (int i = 0; i < 50; ++i) {
            String command = "get";
            String key = "testKey" + i;
            String value = "testValue" + i;
            if (i % 2 == 0) {
                command = command + " --key=" + key + " --region=" + DATA_REGION_NAME_VM1_PATH;
            } else if (i % 2 == 1) {
                command = command + " --key=" + key + " --region=" + DATA_REGION_NAME_VM2_PATH;
            }
            CommandResult cmdResult = this.executeCommand(command);
            GemfireDataCommandsDUnitTest.printCommandOutput(cmdResult);
            GemfireDataCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            this.validateResult(cmdResult, true);
            command = "locate entry";
            if (i % 2 == 0) {
                command = command + " --key=" + key + " --region=" + DATA_REGION_NAME_VM1_PATH;
            } else if (i % 2 == 1) {
                command = command + " --key=" + key + " --region=" + DATA_REGION_NAME_VM2_PATH;
            }
            cmdResult = this.executeCommand(command);
            GemfireDataCommandsDUnitTest.printCommandOutput(cmdResult);
            GemfireDataCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            this.validateResult(cmdResult, true);
            command = "locate entry";
            if (i % 2 == 0) {
                command = command + " --key=" + key + " --region=" + DATA_PAR_REGION_NAME_VM1_PATH;
            } else if (i % 2 == 1) {
                command = command + " --key=" + key + " --region=" + DATA_PAR_REGION_NAME_VM2_PATH;
            }
            cmdResult = this.executeCommand(command);
            GemfireDataCommandsDUnitTest.printCommandOutput(cmdResult);
            GemfireDataCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            this.validateResult(cmdResult, true);
            this.validateLocationsResult(cmdResult, 1);
        }
    }

    public void testGetLocateEntryLocationsForPR() {
        String keyPrefix = "testKey";
        String valuePrefix = "testValue";
        this.setupForGetPutRemoveLocateEntry("testGetLocateEntryLocationsForPR");
        VM vm1 = Host.getHost(0).getVM(1);
        SerializableRunnable putKeys1 = new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = GemfireDataCommandsDUnitTest.this.getCache();
                Region region = cache.getRegion(GemfireDataCommandsDUnitTest.DATA_PAR_REGION_NAME_PATH);
                TestCase.assertNotNull((Object)region);
                for (int i = 0; i < 50; ++i) {
                    String key = "testKey" + i;
                    String value = "testValue" + i;
                    region.put((Object)key, (Object)value);
                }
            }
        };
        vm1.invoke(putKeys1);
        for (int i = 0; i < 50; ++i) {
            String key = "testKey" + i;
            String command = "locate entry";
            command = command + " --key=" + key + " --region=" + DATA_PAR_REGION_NAME_PATH;
            CommandResult cmdResult = this.executeCommand(command);
            GemfireDataCommandsDUnitTest.printCommandOutput(cmdResult);
            GemfireDataCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            this.validateResult(cmdResult, true);
            this.validateLocationsResult(cmdResult, 2);
        }
    }

    public void testPutFromRegionOnDifferentVM() {
        String keyPrefix = "testKey";
        String valuePrefix = "testValue";
        this.setupForGetPutRemoveLocateEntry("testPutFromRegionOnDifferentVM");
        VM vm1 = Host.getHost(0).getVM(1);
        VM vm2 = Host.getHost(0).getVM(2);
        for (int i = 0; i < 50; ++i) {
            String command = "put";
            String key = "testKey" + i;
            String value = "testValue" + i;
            command = i % 2 == 0 ? command + " --key=" + key + " --value=" + value + " --region=" + DATA_REGION_NAME_VM1_PATH : command + " --key=" + key + " --value=" + value + " --region=" + DATA_REGION_NAME_VM2_PATH;
            CommandResult cmdResult = this.executeCommand(command);
            GemfireDataCommandsDUnitTest.printCommandOutput(cmdResult);
            GemfireDataCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            this.validateResult(cmdResult, true);
        }
        SerializableRunnable checkPutKeysInVM1 = new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = GemfireDataCommandsDUnitTest.this.getCache();
                Region region = cache.getRegion(GemfireDataCommandsDUnitTest.DATA_REGION_NAME_VM1_PATH);
                TestCase.assertNotNull((Object)region);
                for (int i = 0; i < 50; ++i) {
                    if (i % 2 != 0) continue;
                    String key = "testKey" + i;
                    TestCase.assertEquals((boolean)true, (boolean)region.containsKey((Object)key));
                }
            }
        };
        SerializableRunnable checkPutKeysInVM2 = new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = GemfireDataCommandsDUnitTest.this.getCache();
                Region region = cache.getRegion(GemfireDataCommandsDUnitTest.DATA_REGION_NAME_VM2_PATH);
                TestCase.assertNotNull((Object)region);
                for (int i = 0; i < 50; ++i) {
                    if (i % 2 == 0) continue;
                    String key = "testKey" + i;
                    TestCase.assertEquals((boolean)true, (boolean)region.containsKey((Object)key));
                }
            }
        };
        vm1.invoke(checkPutKeysInVM1);
        vm2.invoke(checkPutKeysInVM2);
    }

    public void testGetLocateEntryJsonKeys() {
        String keyPrefix = "testKey";
        this.setupForGetPutRemoveLocateEntry("testGetLocateEntryJsonKeys");
        VM vm1 = Host.getHost(0).getVM(1);
        VM vm2 = Host.getHost(0).getVM(2);
        SerializableRunnable putKeys = new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = GemfireDataCommandsDUnitTest.this.getCache();
                Region region = cache.getRegion(GemfireDataCommandsDUnitTest.DATA_REGION_NAME_PATH);
                TestCase.assertNotNull((Object)region);
                region.clear();
                for (int i = 0; i < 50; ++i) {
                    String keyString = "testKey" + i;
                    Key1 key = new Key1();
                    key.setId(keyString);
                    key.setName("name" + keyString);
                    Value2 value2 = new Value2();
                    value2.setStateName("State" + keyString);
                    value2.setCapitalCity("capital" + keyString);
                    value2.setPopulation(i * 100);
                    value2.setAreaInSqKm((double)i * 100.4365);
                    region.put((Object)key, (Object)value2);
                }
            }
        };
        vm1.invoke(putKeys);
        for (int i = 0; i < 50; ++i) {
            String command = "get";
            String keyString = "testKey" + i;
            String population = "" + i * 100;
            String area = "" + (double)i * 100.4365;
            String keyJson = keyTemplate.replaceAll("\\?", keyString);
            String valueJson = valueTemplate.replaceAll("\\?1", population);
            valueJson = valueJson.replaceAll("\\?2", area);
            valueJson = valueJson.replaceAll("\\?", keyString);
            Log.getLogWriter().info("Getting key with json key : " + keyJson);
            command = command + " --key=" + keyJson + " --region=" + DATA_REGION_NAME_PATH + " --key-class=" + Key1.class.getCanonicalName();
            command = command + " --value-class=" + Value2.class.getCanonicalName();
            CommandResult cmdResult = this.executeCommand(command);
            GemfireDataCommandsDUnitTest.printCommandOutput(cmdResult);
            GemfireDataCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            this.validateResult(cmdResult, true);
            command = "locate entry";
            command = command + " --key=" + keyJson + " --region=" + DATA_REGION_NAME_PATH + " --key-class=" + Key1.class.getCanonicalName();
            command = command + " --value-class=" + Value2.class.getCanonicalName();
            cmdResult = this.executeCommand(command);
            GemfireDataCommandsDUnitTest.printCommandOutput(cmdResult);
            GemfireDataCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            this.validateResult(cmdResult, true);
        }
    }

    public void testPutJsonKeys() {
        String keyPrefix = "testKey";
        this.setupForGetPutRemoveLocateEntry("testPutJsonKeys");
        VM vm1 = Host.getHost(0).getVM(1);
        VM vm2 = Host.getHost(0).getVM(2);
        for (int i = 0; i < 50; ++i) {
            String command = "put";
            String keyString = "testKey" + i;
            String population = "" + i * 100;
            String area = "" + (double)i * 100.4365;
            String keyJson = keyTemplate.replaceAll("\\?", keyString);
            String valueJson = valueTemplate.replaceAll("\\?1", population);
            valueJson = valueJson.replaceAll("\\?2", area);
            valueJson = valueJson.replaceAll("\\?", keyString);
            Log.getLogWriter().info("Putting key with json key : " + keyJson);
            Log.getLogWriter().info("Putting key with json valye : " + valueJson);
            command = command + " --key=" + keyJson + " --value=" + valueJson + " --region=" + DATA_REGION_NAME_PATH;
            command = command + " --key-class=" + Key1.class.getCanonicalName() + " --value-class=" + Value2.class.getCanonicalName();
            CommandResult cmdResult = this.executeCommand(command);
            GemfireDataCommandsDUnitTest.printCommandOutput(cmdResult);
            GemfireDataCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            this.validateResult(cmdResult, true);
        }
        SerializableRunnable checkPutKeys = new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = GemfireDataCommandsDUnitTest.this.getCache();
                Region region = cache.getRegion(GemfireDataCommandsDUnitTest.DATA_REGION_NAME_PATH);
                TestCase.assertNotNull((Object)region);
                for (int i = 0; i < 50; ++i) {
                    String keyString = "testKey" + i;
                    Key1 key = new Key1();
                    key.setId(keyString);
                    key.setName("name" + keyString);
                    TestCase.assertEquals((boolean)true, (boolean)region.containsKey((Object)key));
                }
            }
        };
        vm1.invoke(checkPutKeys);
        vm2.invoke(checkPutKeys);
    }

    public void testRemoveJsonCommand() {
        String keyPrefix = "testKey";
        this.setupForGetPutRemoveLocateEntry("testRemoveJsonCommand");
        VM vm1 = Host.getHost(0).getVM(1);
        VM vm2 = Host.getHost(0).getVM(2);
        SerializableRunnable putKeys = new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = GemfireDataCommandsDUnitTest.this.getCache();
                Region region = cache.getRegion(GemfireDataCommandsDUnitTest.DATA_REGION_NAME_PATH);
                TestCase.assertNotNull((Object)region);
                region.clear();
                for (int i = 0; i < 50; ++i) {
                    String keyString = "testKey" + i;
                    Key1 key = new Key1();
                    key.setId(keyString);
                    key.setName("name" + keyString);
                    Value2 value2 = new Value2();
                    value2.setStateName("State" + keyString);
                    value2.setCapitalCity("capital" + keyString);
                    value2.setPopulation(i * 100);
                    value2.setAreaInSqKm((double)i * 100.4365);
                    region.put((Object)key, (Object)value2);
                }
            }
        };
        vm1.invoke(putKeys);
        for (int i = 0; i < 50; ++i) {
            String command = "remove";
            String keyString = "testKey" + i;
            String keyJson = keyTemplate.replaceAll("\\?", keyString);
            Log.getLogWriter().info("Removing key with json key : " + keyJson);
            command = command + " --key=" + keyJson + " --region=" + DATA_REGION_NAME_PATH + " --key-class=" + Key1.class.getCanonicalName();
            CommandResult cmdResult = this.executeCommand(command);
            GemfireDataCommandsDUnitTest.printCommandOutput(cmdResult);
            GemfireDataCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            this.validateResult(cmdResult, true);
        }
        SerializableRunnable checkRemoveKeys = new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = GemfireDataCommandsDUnitTest.this.getCache();
                Region region = cache.getRegion(GemfireDataCommandsDUnitTest.DATA_REGION_NAME_PATH);
                TestCase.assertNotNull((Object)region);
                for (int i = 0; i < 50; ++i) {
                    String keyString = "testKey" + i;
                    Key1 key = new Key1();
                    key.setId(keyString);
                    key.setName("name" + keyString);
                    TestCase.assertEquals((boolean)false, (boolean)region.containsKey((Object)key));
                }
                TestCase.assertEquals((int)0, (int)region.size());
            }
        };
        vm1.invoke(checkRemoveKeys);
        vm2.invoke(checkRemoveKeys);
    }

    private Region<?, ?> createParReg(String regionName, Cache cache) {
        RegionFactory regionFactory = cache.createRegionFactory();
        regionFactory.setDataPolicy(DataPolicy.PARTITION);
        return regionFactory.create(regionName);
    }

    private Region<?, ?> createReplicatedRegion(String regionName, Cache cache) {
        RegionFactory regionFactory = cache.createRegionFactory();
        regionFactory.setDataPolicy(DataPolicy.REPLICATE);
        return regionFactory.create(regionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testImportExportData() throws InterruptedException, IOException {
        String regionName = "Region1";
        String exportFileName = "export.gfd";
        VM manager = Host.getHost(0).getVM(0);
        VM vm1 = Host.getHost(0).getVM(1);
        File exportFile = new File("export.gfd");
        String filePath = exportFile.getCanonicalPath();
        try {
            if (!exportFile.exists()) {
                exportFile.createNewFile();
            }
            exportFile.deleteOnExit();
            this.createDefaultSetup(null);
            manager.invoke(new SerializableCallable(){

                public Object call() {
                    Region region = GemfireDataCommandsDUnitTest.this.createParReg("Region1", GemfireDataCommandsDUnitTest.this.getCache());
                    return region.put((Object)"Manager", (Object)"ASD");
                }
            });
            vm1.invoke(new SerializableCallable(){

                public Object call() throws Exception {
                    Region region = GemfireDataCommandsDUnitTest.this.createParReg("Region1", GemfireDataCommandsDUnitTest.this.getCache());
                    return region.put((Object)"VM1", (Object)"QWE");
                }
            });
            CommandStringBuilder csb = new CommandStringBuilder("export data");
            csb.addOption("region", "Region1");
            csb.addOption("member", "Manager");
            csb.addOption("file", filePath);
            String commandString = csb.toString();
            CommandResult cmdResult = this.executeCommand(commandString);
            String resultAsString = this.commandResultToString(cmdResult);
            GemfireDataCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            GemfireDataCommandsDUnitTest.getLogWriter().info("Command Output");
            GemfireDataCommandsDUnitTest.getLogWriter().info(resultAsString);
            vm1.invoke(new SerializableRunnable(){

                @Override
                public void run() {
                    Region region = GemfireDataCommandsDUnitTest.this.getCache().getRegion("Region1");
                    region.destroy((Object)"Manager");
                    region.destroy((Object)"VM1");
                }
            });
            csb = new CommandStringBuilder("import data");
            csb.addOption("region", "Region1");
            csb.addOption("file", filePath);
            csb.addOption("member", "Manager");
            commandString = csb.toString();
            cmdResult = this.executeCommand(commandString);
            resultAsString = this.commandResultToString(cmdResult);
            GemfireDataCommandsDUnitTest.getLogWriter().info("Result of import data");
            GemfireDataCommandsDUnitTest.getLogWriter().info(resultAsString);
            GemfireDataCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            manager.invoke(new SerializableRunnable(){

                @Override
                public void run() {
                    Region region = GemfireDataCommandsDUnitTest.this.getCache().getRegion("Region1");
                    TestCase.assertEquals((Object)region.get((Object)"Manager"), (Object)"ASD");
                    TestCase.assertEquals((Object)region.get((Object)"VM1"), (Object)"QWE");
                }
            });
            csb = new CommandStringBuilder("export data");
            csb.addOption("region", "FDSERW");
            csb.addOption("file", filePath);
            csb.addOption("member", "Manager");
            commandString = csb.getCommandString();
            cmdResult = this.executeCommand(commandString);
            resultAsString = this.commandResultToString(cmdResult);
            GemfireDataCommandsDUnitTest.getLogWriter().info("Result of import data with wrong region name");
            GemfireDataCommandsDUnitTest.getLogWriter().info(resultAsString);
            GemfireDataCommandsDUnitTest.assertEquals((Object)Result.Status.ERROR, (Object)cmdResult.getStatus());
            csb = new CommandStringBuilder("import data");
            csb.addOption("region", "Region1");
            csb.addOption("file", "#WEQW");
            csb.addOption("member", "Manager");
            commandString = csb.getCommandString();
            cmdResult = this.executeCommand(commandString);
            resultAsString = this.commandResultToString(cmdResult);
            GemfireDataCommandsDUnitTest.getLogWriter().info("Result of import data with wrong file");
            GemfireDataCommandsDUnitTest.getLogWriter().info(resultAsString);
            GemfireDataCommandsDUnitTest.assertEquals((Object)Result.Status.ERROR, (Object)cmdResult.getStatus());
        }
        finally {
            exportFile.delete();
        }
    }

    void setupWith2Regions() {
        VM vm1 = Host.getHost(0).getVM(1);
        VM vm2 = Host.getHost(0).getVM(2);
        this.createDefaultSetup(null);
        vm1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                int i;
                Cache cache = GemfireDataCommandsDUnitTest.this.getCache();
                RegionFactory dataRegionFactory = cache.createRegionFactory(RegionShortcut.PARTITION);
                Region region = dataRegionFactory.create(GemfireDataCommandsDUnitTest.REBALANCE_REGION_NAME);
                for (i = 0; i < 10; ++i) {
                    region.put((Object)("key" + (i + 200)), (Object)("value" + (i + 200)));
                }
                region = dataRegionFactory.create(GemfireDataCommandsDUnitTest.REBALANCE_REGION2_NAME);
                for (i = 0; i < 50; ++i) {
                    region.put((Object)("key" + (i + 200)), (Object)("value" + (i + 200)));
                }
            }
        });
        vm2.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                int i;
                Cache cache = GemfireDataCommandsDUnitTest.this.getCache();
                RegionFactory dataRegionFactory = cache.createRegionFactory(RegionShortcut.PARTITION);
                Region region = dataRegionFactory.create(GemfireDataCommandsDUnitTest.REBALANCE_REGION_NAME);
                for (i = 0; i < 150; ++i) {
                    region.put((Object)("key" + (i + 400)), (Object)("value" + (i + 400)));
                }
                region = dataRegionFactory.create(GemfireDataCommandsDUnitTest.REBALANCE_REGION2_NAME);
                for (i = 0; i < 100; ++i) {
                    region.put((Object)("key" + (i + 200)), (Object)("value" + (i + 200)));
                }
            }
        });
    }

    public void testRebalanceCommandForTimeOut() {
        this.setupTestRebalanceForEntireDS();
        VM manager = Host.getHost(0).getVM(0);
        manager.invoke(this.checkRegionMBeans);
        Log.getLogWriter().info("testRebalanceCommandForTimeOut verified Mbean and executin command");
        String command = "rebalance --time-out=1";
        CommandResult cmdResult = this.executeCommand(command);
        Log.getLogWriter().info("testRebalanceCommandForTimeOut just after executing " + cmdResult);
        if (cmdResult != null) {
            String stringResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testRebalanceCommandForTimeOut stringResult : " + stringResult);
            GemfireDataCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        } else {
            GemfireDataCommandsDUnitTest.fail((String)"testRebalanceCommandForTimeOut failed as did not get CommandResult");
        }
    }

    public void testRebalanceCommandForTimeOutForRegion() {
        this.setupTestRebalanceForEntireDS();
        VM manager = Host.getHost(0).getVM(0);
        manager.invoke(this.checkRegionMBeans);
        Log.getLogWriter().info("testRebalanceCommandForTimeOutForRegion verified Mbean and executin command");
        String command = "rebalance --time-out=1 --include-region=/GemfireDataCommandsDUnitTestRegion";
        CommandResult cmdResult = this.executeCommand(command);
        Log.getLogWriter().info("testRebalanceCommandForTimeOutForRegion just after executing " + cmdResult);
        if (cmdResult != null) {
            String stringResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testRebalanceCommandForTimeOutForRegion stringResult : " + stringResult);
            GemfireDataCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        } else {
            GemfireDataCommandsDUnitTest.fail((String)"testRebalanceCommandForTimeOut failed as did not get CommandResult");
        }
    }

    public void testRebalanceCommandForSimulate() {
        this.setupTestRebalanceForEntireDS();
        VM manager = Host.getHost(0).getVM(0);
        manager.invoke(this.checkRegionMBeans);
        Log.getLogWriter().info("testRebalanceCommandForSimulate verified Mbean and executin command");
        String command = "rebalance --simulate=true --include-region=/GemfireDataCommandsDUnitTestRegion";
        CommandResult cmdResult = this.executeCommand(command);
        Log.getLogWriter().info("testRebalanceCommandForSimulate just after executing " + cmdResult);
        if (cmdResult != null) {
            String stringResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testRebalanceCommandForSimulate stringResult : " + stringResult);
            GemfireDataCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        } else {
            GemfireDataCommandsDUnitTest.fail((String)"testRebalanceCommandForSimulate failed as did not get CommandResult");
        }
    }

    public void testRebalanceCommandForSimulateWithNoMember() {
        this.setupTestRebalanceForEntireDS();
        VM manager = Host.getHost(0).getVM(0);
        manager.invoke(this.checkRegionMBeans);
        Log.getLogWriter().info("testRebalanceCommandForSimulateWithNoMember verified Mbean and executin command");
        String command = "rebalance --simulate=true";
        CommandResult cmdResult = this.executeCommand(command);
        Log.getLogWriter().info("testRebalanceCommandForSimulateWithNoMember just after executing " + cmdResult);
        if (cmdResult != null) {
            String stringResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testRebalanceCommandForSimulateWithNoMember stringResult : " + stringResult);
            GemfireDataCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        } else {
            GemfireDataCommandsDUnitTest.fail((String)"testRebalanceCommandForSimulateWithNoMember failed as did not get CommandResult");
        }
    }

    public void testRebalanceForIncludeRegionFunction() {
        this.setupWith2Regions();
        VM manager = Host.getHost(0).getVM(0);
        manager.invoke(this.checkRegionMBeans);
        Log.getLogWriter().info("testRebalanceForIncludeRegionFunction verified Mbean and executin command");
        String command = "rebalance --include-region=/GemfireDataCommandsDUnitTestRegion,/GemfireDataCommandsDUnitTestRegion2";
        try {
            Thread.sleep(2500L);
        }
        catch (InterruptedException e) {
            GemfireDataCommandsDUnitTest.fail((String)"testRebalanceForIncludeRegionFunction failed exception in sleep");
        }
        CommandResult cmdResult = this.executeCommand(command);
        Log.getLogWriter().info("testRebalanceForIncludeRegionFunction just after executing " + cmdResult);
        if (cmdResult != null) {
            String stringResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testRebalanceForIncludeRegionFunction stringResult : " + stringResult);
            GemfireDataCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        } else {
            GemfireDataCommandsDUnitTest.fail((String)"testRebalanceForIncludeRegionFunction failed as did not get CommandResult");
        }
    }

    public void testSimulateForEntireDS() {
        this.setupTestRebalanceForEntireDS();
        VM manager = Host.getHost(0).getVM(0);
        manager.invoke(this.checkRegionMBeans);
        Log.getLogWriter().info("testSimulateForEntireDS verified Mbean and executin command");
        String command = "rebalance --simulate=true";
        CommandResult cmdResult = this.executeCommand(command);
        Log.getLogWriter().info("testSimulateForEntireDS just after executing " + cmdResult);
        if (cmdResult != null) {
            String stringResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testSimulateForEntireDS stringResult : " + stringResult);
            GemfireDataCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        } else {
            GemfireDataCommandsDUnitTest.fail((String)"testRebalanceForIncludeRegionFunction failed as did not get CommandResult");
        }
    }

    public void testRebalanceForEntireDS() {
        this.setupTestRebalanceForEntireDS();
        VM manager = Host.getHost(0).getVM(0);
        manager.invoke(this.checkRegionMBeans);
        Log.getLogWriter().info("testRebalanceForEntireDS verified Mbean and executin command");
        String command = "rebalance";
        try {
            Thread.sleep(2500L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        CommandResult cmdResult = this.executeCommand(command);
        Log.getLogWriter().info("testRebalanceForEntireDS just after executing " + cmdResult);
        if (cmdResult != null) {
            String stringResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testRebalanceForEntireDS stringResult : " + stringResult);
            GemfireDataCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        } else {
            GemfireDataCommandsDUnitTest.fail((String)"testRebalanceForIncludeRegionFunction failed as did not get CommandResult");
        }
    }

    void setupTestRebalanceForEntireDS() {
        VM vm1 = Host.getHost(0).getVM(1);
        VM vm2 = Host.getHost(0).getVM(2);
        this.createDefaultSetup(null);
        vm1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                int i;
                Cache cache = GemfireDataCommandsDUnitTest.this.getCache();
                RegionFactory dataRegionFactory = cache.createRegionFactory(RegionShortcut.PARTITION);
                Region region = dataRegionFactory.create(GemfireDataCommandsDUnitTest.REBALANCE_REGION_NAME);
                for (i = 0; i < 10; ++i) {
                    region.put((Object)("key" + (i + 200)), (Object)("value" + (i + 200)));
                }
                region = dataRegionFactory.create("GemfireDataCommandsDUnitTestRegionAnother1");
                for (i = 0; i < 100; ++i) {
                    region.put((Object)("key" + (i + 200)), (Object)("value" + (i + 200)));
                }
            }
        });
        vm2.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                int i;
                Cache cache = GemfireDataCommandsDUnitTest.this.getCache();
                RegionFactory dataRegionFactory = cache.createRegionFactory(RegionShortcut.PARTITION);
                Region region = dataRegionFactory.create(GemfireDataCommandsDUnitTest.REBALANCE_REGION_NAME);
                for (i = 0; i < 100; ++i) {
                    region.put((Object)("key" + (i + 400)), (Object)("value" + (i + 400)));
                }
                region = dataRegionFactory.create("GemfireDataCommandsDUnitTestRegionAnother2");
                for (i = 0; i < 10; ++i) {
                    region.put((Object)("key" + (i + 200)), (Object)("value" + (i + 200)));
                }
            }
        });
    }

    private static void printCommandOutput(CommandResult cmdResult) {
        GemfireDataCommandsDUnitTest.assertNotNull((Object)cmdResult);
        Log.getLogWriter().info("Command Output : ");
        StringBuilder sb = new StringBuilder();
        cmdResult.resetToFirstLine();
        while (cmdResult.hasNextLine()) {
            sb.append(cmdResult.nextLine()).append(DataCommandRequest.NEW_LINE);
        }
        Log.getLogWriter().info(sb.toString());
        Log.getLogWriter().info("");
    }

    public void testRebalanceForExcludeRegionFunction() {
        this.setupWith2Regions();
        VM manager = Host.getHost(0).getVM(0);
        manager.invoke(this.checkRegionMBeans);
        Log.getLogWriter().info("testRebalanceForExcludeRegionFunction verified Mbean and executin command");
        String command = "rebalance --exclude-region=/GemfireDataCommandsDUnitTestRegion";
        Log.getLogWriter().info("testRebalanceForExcludeRegionFunction command : " + command);
        try {
            Thread.sleep(2500L);
        }
        catch (InterruptedException e) {
            GemfireDataCommandsDUnitTest.fail((String)"testRebalanceForIncludeRegionFunction failed exception in sleep");
        }
        CommandResult cmdResult = this.executeCommand(command);
        Log.getLogWriter().info("testRebalanceForExcludeRegionFunction just after executing " + cmdResult);
        if (cmdResult != null) {
            String stringResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testRebalanceForExcludeRegionFunction stringResult : " + stringResult);
            GemfireDataCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        } else {
            GemfireDataCommandsDUnitTest.fail((String)"testRebalanceForIncludeRegionFunction failed as did not get CommandResult");
        }
    }

    public static class Value1WithValue2
    extends Value1 {
        private Value2 value2 = null;

        public Value1WithValue2(int i) {
            super(i);
            this.value2 = new Value2(i);
        }

        public Value2 getValue2() {
            return this.value2;
        }

        public void setValue2(Value2 value2) {
            this.value2 = value2;
        }
    }
}

