/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management;

import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.management.AsyncEventQueueMXBean;
import com.gemstone.gemfire.management.CacheServerMXBean;
import com.gemstone.gemfire.management.DistributedLockServiceMXBean;
import com.gemstone.gemfire.management.DistributedRegionMXBean;
import com.gemstone.gemfire.management.GatewayReceiverMXBean;
import com.gemstone.gemfire.management.GatewaySenderMXBean;
import com.gemstone.gemfire.management.LocatorMXBean;
import com.gemstone.gemfire.management.LockServiceMXBean;
import com.gemstone.gemfire.management.ManagementException;
import com.gemstone.gemfire.management.ManagementService;
import com.gemstone.gemfire.management.ManagementTestBase;
import com.gemstone.gemfire.management.MemberMXBean;
import com.gemstone.gemfire.management.RegionMXBean;
import com.gemstone.gemfire.management.internal.MBeanJMXAdapter;
import com.gemstone.gemfire.management.internal.SystemManagementService;
import dunit.DistributedTestCase;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class MBeanUtil {
    private static final int MAX_WAIT = 32000;
    public static MBeanServer mbeanServer = MBeanJMXAdapter.mbeanServer;

    public static MemberMXBean getMemberMbeanProxy(DistributedMember member) throws Exception {
        MemberMXBean bean;
        block2: {
            bean = null;
            final SystemManagementService service = (SystemManagementService)ManagementTestBase.getManagementService();
            final ObjectName memberMBeanName = service.getMemberMBeanName(member);
            DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){
                MemberMXBean bean = null;

                @Override
                public String description() {
                    return "Waiting for the proxy to get reflected at managing node";
                }

                @Override
                public boolean done() {
                    this.bean = (MemberMXBean)service.getMBeanProxy(memberMBeanName, MemberMXBean.class);
                    boolean done = this.bean != null;
                    return done;
                }
            }, 32000L, 500L, true);
            try {
                bean = (MemberMXBean)service.getMBeanProxy(memberMBeanName, MemberMXBean.class);
            }
            catch (ManagementException mgz) {
                if (bean != null) break block2;
                InternalDistributedSystem.getLoggerI18n().fine("Undesired Result :MemberMBean Proxy Should Not be Empty for : " + memberMBeanName.getCanonicalName());
            }
        }
        return bean;
    }

    public static CacheServerMXBean getCacheServerMbeanProxy(DistributedMember member, int port) throws Exception {
        CacheServerMXBean bean;
        block2: {
            bean = null;
            final SystemManagementService service = (SystemManagementService)ManagementTestBase.getManagementService();
            final ObjectName cacheServerMBeanName = service.getCacheServerMBeanName(port, member);
            DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){
                CacheServerMXBean bean = null;

                @Override
                public String description() {
                    return "Waiting for the proxy to get reflected at managing node";
                }

                @Override
                public boolean done() {
                    GemFireCacheImpl cache;
                    GemFireCacheImpl cacheImpl = cache = GemFireCacheImpl.getInstance();
                    this.bean = (CacheServerMXBean)service.getMBeanProxy(cacheServerMBeanName, CacheServerMXBean.class);
                    boolean done = this.bean != null;
                    return done;
                }
            }, 32000L, 500L, true);
            try {
                bean = (CacheServerMXBean)service.getMBeanProxy(cacheServerMBeanName, CacheServerMXBean.class);
            }
            catch (ManagementException mgz) {
                if (bean != null) break block2;
                InternalDistributedSystem.getLoggerI18n().fine("Undesired Result :CacheServer Proxy Should Not be Empty for : " + cacheServerMBeanName.getCanonicalName());
            }
        }
        return bean;
    }

    public static LockServiceMXBean getLockServiceMbeanProxy(DistributedMember member, String lockServiceName) throws Exception {
        LockServiceMXBean bean;
        block2: {
            bean = null;
            final SystemManagementService service = (SystemManagementService)ManagementTestBase.getManagementService();
            final ObjectName lockServiceMBeanName = service.getLockServiceMBeanName(member, lockServiceName);
            DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){
                LockServiceMXBean bean = null;

                @Override
                public String description() {
                    return "Waiting for the proxy to get reflected at managing node";
                }

                @Override
                public boolean done() {
                    GemFireCacheImpl cache;
                    GemFireCacheImpl cacheImpl = cache = GemFireCacheImpl.getInstance();
                    this.bean = (LockServiceMXBean)service.getMBeanProxy(lockServiceMBeanName, LockServiceMXBean.class);
                    boolean done = this.bean != null;
                    return done;
                }
            }, 32000L, 500L, true);
            try {
                bean = (LockServiceMXBean)service.getMBeanProxy(lockServiceMBeanName, LockServiceMXBean.class);
            }
            catch (ManagementException mgz) {
                if (bean != null) break block2;
                InternalDistributedSystem.getLoggerI18n().fine("Undesired Result :LockService Proxy Should Not be Empty for : " + lockServiceMBeanName.getCanonicalName());
            }
        }
        return bean;
    }

    public static RegionMXBean getRegionMbeanProxy(DistributedMember member, String regionPath) throws Exception {
        RegionMXBean bean;
        block2: {
            final SystemManagementService service = (SystemManagementService)ManagementTestBase.getManagementService();
            final ObjectName regionMBeanName = service.getRegionMBeanName(member, regionPath);
            DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){
                RegionMXBean bean = null;

                @Override
                public String description() {
                    return "Waiting for the proxy to get reflected at managing node";
                }

                @Override
                public boolean done() {
                    GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                    this.bean = (RegionMXBean)service.getMBeanProxy(regionMBeanName, RegionMXBean.class);
                    boolean done = this.bean != null;
                    return done;
                }
            }, 32000L, 500L, true);
            bean = null;
            try {
                bean = (RegionMXBean)service.getMBeanProxy(regionMBeanName, RegionMXBean.class);
            }
            catch (ManagementException mgz) {
                if (bean != null) break block2;
                InternalDistributedSystem.getLoggerI18n().fine("Undesired Result :RegionMBean Proxy Should Not be Empty for : " + regionMBeanName.getCanonicalName());
            }
        }
        return bean;
    }

    public static GatewaySenderMXBean getGatewaySenderMbeanProxy(DistributedMember member, String gatwaySenderId) throws Exception {
        GatewaySenderMXBean bean;
        block2: {
            final SystemManagementService service = (SystemManagementService)ManagementTestBase.getManagementService();
            final ObjectName senderMBeanName = service.getGatewaySenderMBeanName(member, gatwaySenderId);
            DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){
                GatewaySenderMXBean bean = null;

                @Override
                public String description() {
                    return "Waiting for the proxy to get reflected at managing node";
                }

                @Override
                public boolean done() {
                    GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                    this.bean = (GatewaySenderMXBean)service.getMBeanProxy(senderMBeanName, GatewaySenderMXBean.class);
                    boolean done = this.bean != null;
                    return done;
                }
            }, 32000L, 500L, true);
            bean = null;
            try {
                bean = (GatewaySenderMXBean)service.getMBeanProxy(senderMBeanName, GatewaySenderMXBean.class);
            }
            catch (ManagementException mgz) {
                if (bean != null) break block2;
                InternalDistributedSystem.getLoggerI18n().fine("Undesired Result :GatewaySender MBean Proxy Should Not be Empty for : " + senderMBeanName.getCanonicalName());
            }
        }
        return bean;
    }

    public static AsyncEventQueueMXBean getAsyncEventQueueMBeanProxy(DistributedMember member, String queueId) throws Exception {
        AsyncEventQueueMXBean bean;
        block2: {
            final SystemManagementService service = (SystemManagementService)ManagementTestBase.getManagementService();
            final ObjectName queueMBeanName = service.getAsyncEventQueueMBeanName(member, queueId);
            DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){
                AsyncEventQueueMXBean bean = null;

                @Override
                public String description() {
                    return "Waiting for the proxy to get reflected at managing node";
                }

                @Override
                public boolean done() {
                    GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                    this.bean = (AsyncEventQueueMXBean)service.getMBeanProxy(queueMBeanName, AsyncEventQueueMXBean.class);
                    boolean done = this.bean != null;
                    return done;
                }
            }, 32000L, 500L, true);
            bean = null;
            try {
                bean = (AsyncEventQueueMXBean)service.getMBeanProxy(queueMBeanName, AsyncEventQueueMXBean.class);
            }
            catch (ManagementException mgz) {
                if (bean != null) break block2;
                InternalDistributedSystem.getLoggerI18n().fine("Undesired Result :Async Event Queue MBean Proxy Should Not be Empty for : " + queueMBeanName.getCanonicalName());
            }
        }
        return bean;
    }

    public static GatewayReceiverMXBean getGatewayReceiverMbeanProxy(DistributedMember member) throws Exception {
        GatewayReceiverMXBean bean;
        block2: {
            final SystemManagementService service = (SystemManagementService)ManagementTestBase.getManagementService();
            final ObjectName receiverMBeanName = service.getGatewayReceiverMBeanName(member);
            DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){
                GatewayReceiverMXBean bean = null;

                @Override
                public String description() {
                    return "Waiting for the proxy to get reflected at managing node";
                }

                @Override
                public boolean done() {
                    GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                    this.bean = (GatewayReceiverMXBean)service.getMBeanProxy(receiverMBeanName, GatewayReceiverMXBean.class);
                    boolean done = this.bean != null;
                    return done;
                }
            }, 32000L, 500L, true);
            bean = null;
            try {
                bean = (GatewayReceiverMXBean)service.getMBeanProxy(receiverMBeanName, GatewayReceiverMXBean.class);
            }
            catch (ManagementException mgz) {
                if (bean != null) break block2;
                InternalDistributedSystem.getLoggerI18n().fine("Undesired Result :GatewaySender MBean Proxy Should Not be Empty for : " + receiverMBeanName.getCanonicalName());
            }
        }
        return bean;
    }

    public static DistributedRegionMXBean getDistributedRegionMbean(final String regionName, final int expectedMembers) throws Exception {
        DistributedRegionMXBean bean = null;
        final ManagementService service = ManagementTestBase.getManagementService();
        DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){
            DistributedRegionMXBean bean = null;

            @Override
            public String description() {
                return "Waiting for " + regionName + " With " + expectedMembers + " proxies to get reflected at managing node";
            }

            @Override
            public boolean done() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                this.bean = service.getDistributedRegionMXBean(regionName);
                boolean done = this.bean != null && this.bean.getMemberCount() == expectedMembers;
                return done;
            }
        }, 32000L, 1000L, true);
        bean = service.getDistributedRegionMXBean(regionName);
        return bean;
    }

    public static DistributedLockServiceMXBean getDistributedLockMbean(final String lockServiceName, final int expectedMembers) throws Exception {
        DistributedLockServiceMXBean bean = null;
        final ManagementService service = ManagementTestBase.getManagementService();
        DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){
            DistributedLockServiceMXBean bean = null;

            @Override
            public String description() {
                return "Waiting for " + expectedMembers + " proxies to get reflected at managing node";
            }

            @Override
            public boolean done() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                this.bean = service.getDistributedLockServiceMXBean(lockServiceName);
                boolean done = this.bean != null && this.bean.getMemberCount() == expectedMembers;
                return done;
            }
        }, 32000L, 500L, true);
        bean = service.getDistributedLockServiceMXBean(lockServiceName);
        return bean;
    }

    public static LocatorMXBean getLocatorMbeanProxy(DistributedMember member) throws Exception {
        LocatorMXBean bean;
        block2: {
            final SystemManagementService service = (SystemManagementService)ManagementTestBase.getManagementService();
            final ObjectName locatorMBeanName = service.getLocatorMBeanName(member);
            DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){
                LocatorMXBean bean = null;

                @Override
                public String description() {
                    return "Waiting for the proxy to get reflected at managing node";
                }

                @Override
                public boolean done() {
                    GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                    this.bean = (LocatorMXBean)service.getMBeanProxy(locatorMBeanName, LocatorMXBean.class);
                    boolean done = this.bean != null;
                    return done;
                }
            }, 32000L, 500L, true);
            bean = null;
            try {
                bean = (LocatorMXBean)service.getMBeanProxy(locatorMBeanName, LocatorMXBean.class);
            }
            catch (ManagementException mgz) {
                if (bean != null) break block2;
                InternalDistributedSystem.getLoggerI18n().fine("Undesired Result :Locator MBean Proxy Should Not be Empty for : " + locatorMBeanName.getCanonicalName());
            }
        }
        return bean;
    }

    public static void printBeanDetails(ObjectName objName) throws Exception {
        MBeanAttributeInfo[] attributeInfos;
        MBeanInfo info = null;
        try {
            info = mbeanServer.getMBeanInfo(objName);
        }
        catch (IntrospectionException e1) {
            DistributedTestCase.fail((String)"Could not obtain Sender Proxy Details");
        }
        catch (InstanceNotFoundException e1) {
            DistributedTestCase.fail((String)"Could not obtain Sender Proxy Details");
        }
        catch (ReflectionException e1) {
            DistributedTestCase.fail((String)"Could not obtain Sender Proxy Details");
        }
        for (MBeanAttributeInfo attributeInfo : attributeInfos = info.getAttributes()) {
            Object propertyValue = null;
            String propertyName = null;
            try {
                propertyName = attributeInfo.getName();
                propertyValue = mbeanServer.getAttribute(objName, propertyName);
                DistributedTestCase.getLogWriter().info("<ExpectedString> " + propertyName + " = " + propertyValue + "</ExpectedString> ");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

