/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.DiskStoreFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.FileUtil;
import com.gemstone.gemfire.internal.cache.DiskRegion;
import com.gemstone.gemfire.internal.cache.DiskRegionStats;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.persistence.PersistentMemberManager;
import com.gemstone.gemfire.management.DiskBackupStatus;
import com.gemstone.gemfire.management.DiskStoreMXBean;
import com.gemstone.gemfire.management.DistributedSystemMXBean;
import com.gemstone.gemfire.management.MBeanUtil;
import com.gemstone.gemfire.management.ManagementService;
import com.gemstone.gemfire.management.ManagementTestBase;
import com.gemstone.gemfire.management.MemberMXBean;
import com.gemstone.gemfire.management.PersistentMemberDetails;
import com.gemstone.gemfire.management.internal.MBeanJMXAdapter;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import junit.framework.TestCase;

public class DiskManagementDUnitTest
extends ManagementTestBase {
    private static final long serialVersionUID = 1L;
    private static final int MAX_WAIT = 70000;
    boolean testFailed = false;
    String failureCause = "";
    static final String REGION_NAME = "region";
    private File diskDir = new File("diskDir-" + this.getName()).getAbsoluteFile();
    protected static LogWriter logWriter;

    public DiskManagementDUnitTest(String name) throws Exception {
        super(name);
        FileUtil.delete((File)this.diskDir);
        this.diskDir.mkdir();
        this.diskDir.deleteOnExit();
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.failureCause = "";
        this.testFailed = false;
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        FileUtil.delete((File)this.diskDir);
    }

    public void testDiskCompact() throws Throwable {
        this.initManagement(false);
        for (VM vm : DiskManagementDUnitTest.getManagedNodeList()) {
            this.createPersistentRegion(vm);
            this.makeDiskCompactable(vm);
        }
        for (VM vm : DiskManagementDUnitTest.getManagedNodeList()) {
            this.compactAllDiskStores(vm);
        }
    }

    public void testDiskCompactRemote() throws Throwable {
        this.initManagement(false);
        for (VM vm : DiskManagementDUnitTest.getManagedNodeList()) {
            this.createPersistentRegion(vm);
            this.makeDiskCompactable(vm);
        }
        this.compactDiskStoresRemote(managingNode);
    }

    public void testDiskOps() throws Throwable {
        this.initManagement(false);
        for (VM vm : DiskManagementDUnitTest.getManagedNodeList()) {
            this.createPersistentRegion(vm);
            this.makeDiskCompactable(vm);
            this.invokeFlush(vm);
            this.invokeForceRoll(vm);
            this.invokeForceCompaction(vm);
        }
    }

    public void testDiskBackupAllMembers() throws Throwable {
        this.initManagement(false);
        for (VM vm : DiskManagementDUnitTest.getManagedNodeList()) {
            this.createPersistentRegion(vm);
            this.makeDiskCompactable(vm);
        }
        this.backupAllMembers(managingNode);
    }

    public void testMissingMembers() throws Throwable {
        this.initManagement(false);
        VM vm0 = DiskManagementDUnitTest.getManagedNodeList().get(0);
        VM vm1 = DiskManagementDUnitTest.getManagedNodeList().get(1);
        VM vm2 = DiskManagementDUnitTest.getManagedNodeList().get(2);
        DiskManagementDUnitTest.getLogWriter().info("Creating region in VM0");
        this.createPersistentRegion(vm0);
        DiskManagementDUnitTest.getLogWriter().info("Creating region in VM1");
        this.createPersistentRegion(vm1);
        this.putAnEntry(vm0);
        managingNode.invoke(new SerializableRunnable("Check for waiting regions"){

            @Override
            public void run() {
                Cache cache = DiskManagementDUnitTest.this.getCache();
                ManagementService service = ManagementTestBase.getManagementService();
                DistributedSystemMXBean bean = service.getDistributedSystemMXBean();
                PersistentMemberDetails[] missingDiskStores = bean.listMissingDiskStores();
                TestCase.assertNull((Object)missingDiskStores);
            }
        });
        DiskManagementDUnitTest.getLogWriter().info("closing region in vm0");
        this.closeRegion(vm0);
        this.updateTheEntry(vm1);
        DiskManagementDUnitTest.getLogWriter().info("closing region in vm1");
        this.closeRegion(vm1);
        AsyncInvocation future = this.createPersistentRegionAsync(vm0);
        this.waitForBlockedInitialization(vm0);
        DiskManagementDUnitTest.assertTrue((boolean)future.isAlive());
        managingNode.invoke(new SerializableRunnable("Revoke the member"){

            @Override
            public void run() {
                Cache cache = DiskManagementDUnitTest.this.getCache();
                GemFireCacheImpl cacheImpl = (GemFireCacheImpl)cache;
                ManagementService service = ManagementTestBase.getManagementService();
                DistributedSystemMXBean bean = service.getDistributedSystemMXBean();
                PersistentMemberDetails[] missingDiskStores = bean.listMissingDiskStores();
                DistributedTestCase.getLogWriter().info("waiting members=" + missingDiskStores);
                TestCase.assertNotNull((Object)missingDiskStores);
                TestCase.assertEquals((int)1, (int)missingDiskStores.length);
                for (PersistentMemberDetails id : missingDiskStores) {
                    DistributedTestCase.getLogWriter().info("Missing DiskStoreID is =" + id.getDiskStoreId());
                    DistributedTestCase.getLogWriter().info("Missing Host is =" + id.getHost());
                    DistributedTestCase.getLogWriter().info("Missing Directory is =" + id.getDirectory());
                    try {
                        bean.revokeMissingDiskStores(id.getDiskStoreId());
                    }
                    catch (Exception e) {
                        TestCase.fail((String)("revokeMissingDiskStores failed with exception " + e));
                    }
                }
            }
        });
        future.join(70000L);
        if (future.isAlive()) {
            DiskManagementDUnitTest.fail((String)"Region not created within70000");
        }
        if (future.exceptionOccurred()) {
            throw new Exception(future.getException());
        }
        this.checkForRecoveryStat(vm0, true);
        SerializableRunnable checkForEntry = new SerializableRunnable("check for the entry"){

            @Override
            public void run() {
                Cache cache = DiskManagementDUnitTest.this.getCache();
                Region region = cache.getRegion(DiskManagementDUnitTest.REGION_NAME);
                TestCase.assertEquals((Object)"B", (Object)region.get((Object)"A"));
            }
        };
        vm0.invoke(checkForEntry);
    }

    protected void checkNavigation(VM vm, final DistributedMember diskMember, final String diskStoreName) {
        SerializableRunnable checkNavigation = new SerializableRunnable("Check Navigation"){

            @Override
            public void run() {
                ManagementService service = ManagementTestBase.getManagementService();
                DistributedSystemMXBean disMBean = service.getDistributedSystemMXBean();
                try {
                    ObjectName expected = MBeanJMXAdapter.getDiskStoreMBeanName((String)diskMember.getId(), (String)diskStoreName);
                    ObjectName actual = disMBean.fetchDiskStoreObjectName(diskMember.getId(), diskStoreName);
                    TestCase.assertEquals((Object)expected, (Object)actual);
                }
                catch (Exception e) {
                    TestCase.fail((String)("Disk Store Navigation Failed " + e));
                }
            }
        };
        vm.invoke(checkNavigation);
    }

    protected static DistributedMember getMember() throws Exception {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        return cache.getDistributedSystem().getDistributedMember();
    }

    public void invokeFlush(final VM vm) {
        SerializableRunnable invokeFlush = new SerializableRunnable("Invoke Flush On Disk"){

            @Override
            public void run() {
                Cache cache = DiskManagementDUnitTest.this.getCache();
                DiskStoreFactory dsf = cache.createDiskStoreFactory();
                String name = "testFlush_" + vm.getPid();
                DiskStore ds = dsf.create(name);
                ManagementService service = ManagementTestBase.getManagementService();
                DiskStoreMXBean bean = service.getLocalDiskStoreMBean(name);
                TestCase.assertNotNull((Object)bean);
                bean.flush();
            }
        };
        vm.invoke(invokeFlush);
    }

    public void invokeForceRoll(final VM vm) {
        SerializableRunnable invokeForceRoll = new SerializableRunnable("Invoke Force Roll"){

            @Override
            public void run() {
                Cache cache = DiskManagementDUnitTest.this.getCache();
                DiskStoreFactory dsf = cache.createDiskStoreFactory();
                String name = "testForceRoll_" + vm.getPid();
                DiskStore ds = dsf.create(name);
                ManagementService service = ManagementTestBase.getManagementService();
                DiskStoreMXBean bean = service.getLocalDiskStoreMBean(name);
                TestCase.assertNotNull((Object)bean);
                bean.forceRoll();
            }
        };
        vm.invoke(invokeForceRoll);
    }

    public void invokeForceCompaction(final VM vm) {
        SerializableRunnable invokeForceCompaction = new SerializableRunnable("Invoke Force Compaction"){

            @Override
            public void run() {
                Cache cache = DiskManagementDUnitTest.this.getCache();
                DiskStoreFactory dsf = cache.createDiskStoreFactory();
                dsf.setAllowForceCompaction(true);
                String name = "testForceCompaction_" + vm.getPid();
                DiskStore ds = dsf.create(name);
                ManagementService service = ManagementTestBase.getManagementService();
                DiskStoreMXBean bean = service.getLocalDiskStoreMBean(name);
                TestCase.assertNotNull((Object)bean);
                TestCase.assertEquals((boolean)false, (boolean)bean.forceCompaction());
            }
        };
        vm.invoke(invokeForceCompaction);
    }

    public void makeDiskCompactable(VM vm1) throws Exception {
        vm1.invoke(new SerializableRunnable("Make The Disk Compactable"){

            @Override
            public void run() {
                Cache cache = DiskManagementDUnitTest.this.getCache();
                Region region = cache.getRegion(DiskManagementDUnitTest.REGION_NAME);
                DiskRegion dr = ((LocalRegion)region).getDiskRegion();
                DistributedTestCase.getLogWriter().info("putting key1");
                region.put((Object)"key1", (Object)"value1");
                DistributedTestCase.getLogWriter().info("putting key2");
                region.put((Object)"key2", (Object)"value2");
                DistributedTestCase.getLogWriter().info("removing key2");
                region.remove((Object)"key2");
            }
        });
    }

    public void compactAllDiskStores(VM vm1) throws Exception {
        vm1.invoke(new SerializableCallable("Compact All Disk Stores"){

            public Object call() throws Exception {
                ManagementService service = ManagementTestBase.getManagementService();
                MemberMXBean memberBean = service.getMemberMXBean();
                String[] compactedDiskStores = memberBean.compactAllDiskStores();
                TestCase.assertTrue((compactedDiskStores.length > 0 ? 1 : 0) != 0);
                for (int i = 0; i < compactedDiskStores.length; ++i) {
                    DistributedTestCase.getLogWriter().info("<ExpectedString> Compacted Store " + i + " " + compactedDiskStores[i] + "</ExpectedString> ");
                }
                return null;
            }
        });
    }

    public void backupAllMembers(VM managingVM) throws Exception {
        managingVM.invoke(new SerializableCallable("Backup All Disk Stores"){

            public Object call() throws Exception {
                ManagementService service = ManagementTestBase.getManagementService();
                DistributedSystemMXBean bean = service.getDistributedSystemMXBean();
                DiskBackupStatus status = bean.backupAllMembers(DiskManagementDUnitTest.getBackupDir("test_backupAllMembers").getAbsolutePath());
                return null;
            }
        });
    }

    public void compactDiskStoresRemote(VM managingVM) throws Exception {
        managingVM.invoke(new SerializableCallable("Compact All Disk Stores Remote"){

            public Object call() throws Exception {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                Set otherMemberSet = cache.getDistributionManager().getOtherNormalDistributionManagerIds();
                for (DistributedMember member : otherMemberSet) {
                    MemberMXBean bean = MBeanUtil.getMemberMbeanProxy(member);
                    String[] allDisks = bean.listDiskStores(true);
                    TestCase.assertNotNull((Object)allDisks);
                    List<String> listString = Arrays.asList(allDisks);
                    DistributedTestCase.getLogWriter().info("<ExpectedString> Remote All Disk Stores Are  " + listString.toString() + "</ExpectedString> ");
                    String[] compactedDiskStores = bean.compactAllDiskStores();
                    TestCase.assertTrue((compactedDiskStores.length > 0 ? 1 : 0) != 0);
                    for (int i = 0; i < compactedDiskStores.length; ++i) {
                        DistributedTestCase.getLogWriter().info("<ExpectedString> Remote Compacted Store " + i + " " + compactedDiskStores[i] + "</ExpectedString> ");
                    }
                }
                return null;
            }
        });
    }

    protected void checkIfContainsFileWithExt(String fileExtension) throws Exception {
        File[] files = this.diskDir.listFiles();
        for (int j = 0; j < files.length; ++j) {
            if (!files[j].getAbsolutePath().endsWith(fileExtension)) continue;
            DiskManagementDUnitTest.fail((String)("file \"" + files[j].getAbsolutePath() + "\" still exists"));
        }
    }

    protected void updateTheEntry(VM vm1) {
        this.updateTheEntry(vm1, "C");
    }

    protected void updateTheEntry(VM vm1, final String value) {
        vm1.invoke(new SerializableRunnable("change the entry"){

            @Override
            public void run() {
                Cache cache = DiskManagementDUnitTest.this.getCache();
                Region region = cache.getRegion(DiskManagementDUnitTest.REGION_NAME);
                region.put((Object)"A", (Object)value);
            }
        });
    }

    protected void putAnEntry(VM vm0) {
        vm0.invoke(new SerializableRunnable("Put an entry"){

            @Override
            public void run() {
                Cache cache = DiskManagementDUnitTest.this.getCache();
                Region region = cache.getRegion(DiskManagementDUnitTest.REGION_NAME);
                region.put((Object)"A", (Object)"B");
            }
        });
    }

    protected void closeRegion(VM vm) {
        SerializableRunnable closeRegion = new SerializableRunnable("Close persistent region"){

            @Override
            public void run() {
                Cache cache = DiskManagementDUnitTest.this.getCache();
                Region region = cache.getRegion(DiskManagementDUnitTest.REGION_NAME);
                region.close();
            }
        };
        vm.invoke(closeRegion);
    }

    private void waitForBlockedInitialization(VM vm) {
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

                    @Override
                    public String description() {
                        return "Waiting to blocked waiting for another persistent member to come online";
                    }

                    @Override
                    public boolean done() {
                        Cache cache = DiskManagementDUnitTest.this.getCache();
                        GemFireCacheImpl cacheImpl = (GemFireCacheImpl)cache;
                        PersistentMemberManager mm = cacheImpl.getPersistentMemberManager();
                        Map regions = mm.getWaitingRegions();
                        boolean done = !regions.isEmpty();
                        return done;
                    }
                }, 70000L, 100L, true);
            }
        });
    }

    protected void createPersistentRegion(VM vm) throws Throwable {
        AsyncInvocation future = this.createPersistentRegionAsync(vm);
        future.join(70000L);
        if (future.isAlive()) {
            DiskManagementDUnitTest.fail((String)"Region not created within70000");
        }
        if (future.exceptionOccurred()) {
            throw new RuntimeException(future.getException());
        }
    }

    protected AsyncInvocation createPersistentRegionAsync(final VM vm) {
        SerializableRunnable createRegion = new SerializableRunnable("Create persistent region"){

            @Override
            public void run() {
                Cache cache = DiskManagementDUnitTest.this.getCache();
                DiskStoreFactory dsf = cache.createDiskStoreFactory();
                File dir = DiskManagementDUnitTest.this.getDiskDirForVM(vm);
                dir.mkdirs();
                dsf.setDiskDirs(new File[]{dir});
                dsf.setMaxOplogSize(1L);
                dsf.setAllowForceCompaction(true);
                dsf.setAutoCompact(false);
                DiskStore ds = dsf.create(DiskManagementDUnitTest.REGION_NAME);
                RegionFactory rf = cache.createRegionFactory();
                rf.setDiskStoreName(ds.getName());
                rf.setDiskSynchronous(true);
                rf.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                rf.setScope(Scope.DISTRIBUTED_ACK);
                rf.create(DiskManagementDUnitTest.REGION_NAME);
            }
        };
        return vm.invokeAsync(createRegion);
    }

    protected void validatePersistentRegion(VM vm) {
        SerializableRunnable validateDisk = new SerializableRunnable("Validate persistent region"){

            @Override
            public void run() {
                Cache cache = DiskManagementDUnitTest.this.getCache();
                ManagementService service = ManagementTestBase.getManagementService();
                DiskStoreMXBean bean = service.getLocalDiskStoreMBean(DiskManagementDUnitTest.REGION_NAME);
                TestCase.assertNotNull((Object)bean);
            }
        };
        vm.invoke(validateDisk);
    }

    protected File getDiskDirForVM(VM vm) {
        File dir = new File(this.diskDir, String.valueOf(vm.getPid()));
        return dir;
    }

    private void checkForRecoveryStat(VM vm, final boolean localRecovery) {
        vm.invoke(new SerializableRunnable("check disk region stat"){

            @Override
            public void run() {
                Cache cache = DiskManagementDUnitTest.this.getCache();
                Region region = cache.getRegion(DiskManagementDUnitTest.REGION_NAME);
                DistributedRegion distributedRegion = (DistributedRegion)region;
                DiskRegionStats stats = distributedRegion.getDiskRegion().getStats();
                if (localRecovery) {
                    TestCase.assertEquals((int)1, (int)stats.getLocalInitializations());
                    TestCase.assertEquals((int)0, (int)stats.getRemoteInitializations());
                } else {
                    TestCase.assertEquals((int)0, (int)stats.getLocalInitializations());
                    TestCase.assertEquals((int)1, (int)stats.getRemoteInitializations());
                }
            }
        });
    }

    protected static File getBackupDir(String name) throws Exception {
        File backUpDir = new File("BackupDir-" + name).getAbsoluteFile();
        FileUtil.delete((File)backUpDir);
        backUpDir.mkdir();
        backUpDir.deleteOnExit();
        return backUpDir;
    }
}

