/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management;

import com.gemstone.gemfire.distributed.DistributedLockService;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.locks.DLockService;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.management.DistributedLockServiceMXBean;
import com.gemstone.gemfire.management.DistributedSystemMXBean;
import com.gemstone.gemfire.management.LockServiceMXBean;
import com.gemstone.gemfire.management.MBeanUtil;
import com.gemstone.gemfire.management.ManagementException;
import com.gemstone.gemfire.management.ManagementService;
import com.gemstone.gemfire.management.ManagementTestBase;
import com.gemstone.gemfire.management.internal.MBeanJMXAdapter;
import com.gemstone.gemfire.management.internal.SystemManagementService;
import dunit.DistributedTestCase;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import junit.framework.TestCase;

public class DLockManagementDUnitTest
extends ManagementTestBase {
    private static final long serialVersionUID = 1L;
    private static final String LOCK_SERVICE_NAME = "testLockService";
    private static final int MAX_WAIT = 70000;

    public DLockManagementDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
    }

    public void testDLockMBean() throws Throwable {
        this.initManagement(false);
        VM[] managedNodes = new VM[DLockManagementDUnitTest.getManagedNodeList().size()];
        VM managingNode = DLockManagementDUnitTest.getManagingNode();
        DLockManagementDUnitTest.getManagedNodeList().toArray(managedNodes);
        this.createGrantorLockService(managedNodes[0]);
        this.createLockService(managedNodes[1]);
        this.createLockService(managedNodes[2]);
        for (VM vm : DLockManagementDUnitTest.getManagedNodeList()) {
            this.verifyLockData(vm);
        }
        this.verifyLockDataRemote(managingNode);
        for (VM vm : DLockManagementDUnitTest.getManagedNodeList()) {
            this.closeLockService(vm);
        }
    }

    public void testDLockAggregate() throws Throwable {
        this.initManagement(false);
        VM[] managedNodes = new VM[DLockManagementDUnitTest.getManagedNodeList().size()];
        VM managingNode = DLockManagementDUnitTest.getManagingNode();
        DLockManagementDUnitTest.getManagedNodeList().toArray(managedNodes);
        this.createGrantorLockService(managedNodes[0]);
        this.createLockService(managedNodes[1]);
        this.createLockService(managedNodes[2]);
        this.checkAggregate(managingNode, 3);
        DistributedMember member = this.getMember(managedNodes[2]);
        this.checkNavigation(managingNode, member);
        this.createLockService(managingNode);
        this.checkAggregate(managingNode, 4);
        for (VM vm : DLockManagementDUnitTest.getManagedNodeList()) {
            this.closeLockService(vm);
        }
        this.ensureProxyCleanup(managingNode);
        this.checkAggregate(managingNode, 1);
        this.closeLockService(managingNode);
        this.checkAggregate(managingNode, 0);
    }

    public void ensureProxyCleanup(VM vm) {
        SerializableRunnable ensureProxyCleanup = new SerializableRunnable("Ensure Proxy cleanup"){

            @Override
            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                Set otherMemberSet = cache.getDistributionManager().getOtherNormalDistributionManagerIds();
                final SystemManagementService service = (SystemManagementService)ManagementTestBase.getManagementService();
                for (final DistributedMember member : otherMemberSet) {
                    Object bean = null;
                    try {
                        DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){
                            LockServiceMXBean bean = null;

                            @Override
                            public String description() {
                                return "Waiting for the proxy to get deleted at managing node";
                            }

                            @Override
                            public boolean done() {
                                ObjectName objectName = service.getRegionMBeanName(member, DLockManagementDUnitTest.LOCK_SERVICE_NAME);
                                this.bean = (LockServiceMXBean)service.getMBeanProxy(objectName, LockServiceMXBean.class);
                                boolean done = this.bean == null;
                                return done;
                            }
                        }, 70000L, 500L, true);
                    }
                    catch (Exception e) {
                        TestCase.fail((String)"could not remove proxies in required time");
                    }
                    TestCase.assertNull(bean);
                }
            }
        };
        vm.invoke(ensureProxyCleanup);
    }

    protected void createGrantorLockService(VM vm) {
        SerializableRunnable createGrantorLockService = new SerializableRunnable("Create Grantor LockService"){

            @Override
            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                TestCase.assertNull((Object)DistributedLockService.getServiceNamed((String)DLockManagementDUnitTest.LOCK_SERVICE_NAME));
                DLockService service = (DLockService)DistributedLockService.create((String)DLockManagementDUnitTest.LOCK_SERVICE_NAME, (DistributedSystem)cache.getDistributedSystem());
                TestCase.assertSame((Object)service, (Object)DistributedLockService.getServiceNamed((String)DLockManagementDUnitTest.LOCK_SERVICE_NAME));
                InternalDistributedMember grantor = service.getLockGrantorId().getLockGrantorMember();
                TestCase.assertNotNull((Object)grantor);
                DistributedTestCase.getLogWriter().info("In identifyLockGrantor - grantor is " + grantor);
                ManagementService mgmtService = ManagementTestBase.getManagementService();
                LockServiceMXBean bean = mgmtService.getLocalLockServiceMBean(DLockManagementDUnitTest.LOCK_SERVICE_NAME);
                TestCase.assertNotNull((Object)bean);
                TestCase.assertTrue((boolean)bean.isDistributed());
                TestCase.assertEquals((String)bean.getName(), (String)DLockManagementDUnitTest.LOCK_SERVICE_NAME);
                TestCase.assertTrue((boolean)bean.isLockGrantor());
                TestCase.assertEquals((String)cache.getDistributedSystem().getMemberId(), (String)bean.fetchGrantorMember());
            }
        };
        vm.invoke(createGrantorLockService);
    }

    protected void createLockService(VM vm) {
        SerializableRunnable createLockService = new SerializableRunnable("Create LockService"){

            @Override
            public void run() {
                TestCase.assertNull((Object)DistributedLockService.getServiceNamed((String)DLockManagementDUnitTest.LOCK_SERVICE_NAME));
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                DistributedLockService service = DistributedLockService.create((String)DLockManagementDUnitTest.LOCK_SERVICE_NAME, (DistributedSystem)cache.getDistributedSystem());
                TestCase.assertSame((Object)service, (Object)DistributedLockService.getServiceNamed((String)DLockManagementDUnitTest.LOCK_SERVICE_NAME));
                ManagementService mgmtService = ManagementTestBase.getManagementService();
                LockServiceMXBean bean = mgmtService.getLocalLockServiceMBean(DLockManagementDUnitTest.LOCK_SERVICE_NAME);
                TestCase.assertNotNull((Object)bean);
                TestCase.assertTrue((boolean)bean.isDistributed());
                TestCase.assertFalse((boolean)bean.isLockGrantor());
            }
        };
        vm.invoke(createLockService);
    }

    protected void closeLockService(VM vm) {
        SerializableRunnable closeLockService = new SerializableRunnable("Close LockService"){

            @Override
            public void run() {
                DistributedLockService service = DistributedLockService.getServiceNamed((String)DLockManagementDUnitTest.LOCK_SERVICE_NAME);
                DistributedLockService.destroy((String)DLockManagementDUnitTest.LOCK_SERVICE_NAME);
                ManagementService mgmtService = ManagementTestBase.getManagementService();
                LockServiceMXBean bean = null;
                try {
                    bean = mgmtService.getLocalLockServiceMBean(DLockManagementDUnitTest.LOCK_SERVICE_NAME);
                }
                catch (ManagementException managementException) {
                    // empty catch block
                }
                TestCase.assertNull((Object)bean);
            }
        };
        vm.invoke(closeLockService);
    }

    protected void verifyLockData(final VM vm) {
        SerializableRunnable verifyLockData = new SerializableRunnable("Verify LockService"){

            @Override
            public void run() {
                DistributedLockService service = DistributedLockService.getServiceNamed((String)DLockManagementDUnitTest.LOCK_SERVICE_NAME);
                String LOCK_OBJECT = "lockObject_" + vm.getPid();
                DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){
                    DistributedLockService service = null;

                    @Override
                    public String description() {
                        return "Waiting for the lock service to be initialised";
                    }

                    @Override
                    public boolean done() {
                        DistributedLockService service = DistributedLockService.getServiceNamed((String)DLockManagementDUnitTest.LOCK_SERVICE_NAME);
                        boolean done = service != null;
                        return done;
                    }
                }, 70000L, 500L, true);
                service.lock((Object)LOCK_OBJECT, 1000L, -1L);
                ManagementService mgmtService = ManagementTestBase.getManagementService();
                LockServiceMXBean bean = null;
                try {
                    bean = mgmtService.getLocalLockServiceMBean(DLockManagementDUnitTest.LOCK_SERVICE_NAME);
                }
                catch (ManagementException managementException) {
                    // empty catch block
                }
                TestCase.assertNotNull((Object)bean);
                String[] listHeldLock = bean.listHeldLocks();
                TestCase.assertEquals((int)listHeldLock.length, (int)1);
                DistributedTestCase.getLogWriter().info("List Of Lock Object is  " + listHeldLock[0]);
                Map lockThreadMap = bean.listThreadsHoldingLock();
                TestCase.assertEquals((int)lockThreadMap.size(), (int)1);
                DistributedTestCase.getLogWriter().info("List Of Lock Thread is  " + lockThreadMap.toString());
            }
        };
        vm.invoke(verifyLockData);
    }

    protected void verifyLockDataRemote(VM vm) {
        SerializableRunnable verifyLockDataRemote = new SerializableRunnable("Verify LockService Remote"){

            @Override
            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                Set otherMemberSet = cache.getDistributionManager().getOtherNormalDistributionManagerIds();
                for (DistributedMember member : otherMemberSet) {
                    LockServiceMXBean bean = null;
                    try {
                        bean = MBeanUtil.getLockServiceMbeanProxy(member, DLockManagementDUnitTest.LOCK_SERVICE_NAME);
                    }
                    catch (Exception e) {
                        InternalDistributedSystem.getLoggerI18n().fine("Undesired Result , LockServiceMBean Should not be null" + e);
                    }
                    TestCase.assertNotNull((Object)bean);
                    String[] listHeldLock = bean.listHeldLocks();
                    TestCase.assertEquals((int)listHeldLock.length, (int)1);
                    DistributedTestCase.getLogWriter().info("List Of Lock Object is  " + listHeldLock[0]);
                    Map lockThreadMap = bean.listThreadsHoldingLock();
                    TestCase.assertEquals((int)lockThreadMap.size(), (int)1);
                    DistributedTestCase.getLogWriter().info("List Of Lock Thread is  " + lockThreadMap.toString());
                }
            }
        };
        vm.invoke(verifyLockDataRemote);
    }

    protected void checkNavigation(VM vm, final DistributedMember lockServiceMember) {
        SerializableRunnable checkNavigation = new SerializableRunnable("Check Navigation"){

            @Override
            public void run() {
                ObjectName actual;
                ObjectName expected;
                ManagementService service = ManagementTestBase.getManagementService();
                DistributedSystemMXBean disMBean = service.getDistributedSystemMXBean();
                try {
                    expected = MBeanJMXAdapter.getDistributedLockServiceName((String)DLockManagementDUnitTest.LOCK_SERVICE_NAME);
                    actual = disMBean.fetchDistributedLockServiceObjectName(DLockManagementDUnitTest.LOCK_SERVICE_NAME);
                    TestCase.assertEquals((Object)expected, (Object)actual);
                }
                catch (Exception e) {
                    TestCase.fail((String)("Lock Service Navigation Failed " + e));
                }
                try {
                    expected = MBeanJMXAdapter.getLockServiceMBeanName((String)lockServiceMember.getId(), (String)DLockManagementDUnitTest.LOCK_SERVICE_NAME);
                    actual = disMBean.fetchLockServiceObjectName(lockServiceMember.getId(), DLockManagementDUnitTest.LOCK_SERVICE_NAME);
                    TestCase.assertEquals((Object)expected, (Object)actual);
                }
                catch (Exception e) {
                    TestCase.fail((String)("Lock Service Navigation Failed " + e));
                }
            }
        };
        vm.invoke(checkNavigation);
    }

    protected void checkAggregate(VM vm, final int expectedMembers) {
        SerializableRunnable checkAggregate = new SerializableRunnable("Verify Aggregate MBean"){

            @Override
            public void run() {
                final ManagementService service = ManagementTestBase.getManagementService();
                if (expectedMembers == 0) {
                    try {
                        DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){
                            DistributedLockServiceMXBean bean = null;

                            @Override
                            public String description() {
                                return "Waiting for the proxy to get deleted at managing node";
                            }

                            @Override
                            public boolean done() {
                                this.bean = service.getDistributedLockServiceMXBean(DLockManagementDUnitTest.LOCK_SERVICE_NAME);
                                boolean done = this.bean == null;
                                return done;
                            }
                        }, 70000L, 500L, true);
                    }
                    catch (Exception e) {
                        TestCase.fail((String)"could not remove Aggregate Bean in required time");
                    }
                    return;
                }
                DistributedLockServiceMXBean bean = null;
                try {
                    bean = MBeanUtil.getDistributedLockMbean(DLockManagementDUnitTest.LOCK_SERVICE_NAME, expectedMembers);
                }
                catch (Exception e) {
                    InternalDistributedSystem.getLoggerI18n().fine("Undesired Result , LockServiceMBean Should not be null" + e);
                }
                TestCase.assertNotNull((Object)bean);
                TestCase.assertEquals((String)bean.getName(), (String)DLockManagementDUnitTest.LOCK_SERVICE_NAME);
            }
        };
        vm.invoke(checkAggregate);
    }
}

