/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.jta.dunit;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.jta.CacheUtils;
import com.gemstone.gemfire.internal.jta.JTAUtils;
import com.gemstone.gemfire.internal.jta.dunit.CommitThread;
import com.gemstone.gemfire.internal.jta.dunit.RollbackThread;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import hydra.ProcessMgr;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class TxnManagerMultiThreadDUnitTest
extends DistributedTestCase {
    public static DistributedSystem ds;
    public static Cache cache;

    public TxnManagerMultiThreadDUnitTest(String name) {
        super(name);
    }

    private static String readFile(String filename) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(filename));
        String nextLine = "";
        StringBuffer sb = new StringBuffer();
        while ((nextLine = br.readLine()) != null) {
            sb.append(nextLine);
        }
        return sb.toString();
    }

    private static String modifyFile(String str) throws IOException {
        String search = "<jndi-binding type=\"XAPooledDataSource\"";
        String last_search = "</jndi-binding>";
        String newDB = "newDB1_" + ProcessMgr.getProcessId();
        String jndi_str = "<jndi-binding type=\"XAPooledDataSource\" jndi-name=\"XAPooledDataSource\" jdbc-driver-class=\"org.apache.derby.jdbc.EmbeddedDriver\" init-pool-size=\"5\" max-pool-size=\"30\" idle-timeout-seconds=\"300\" blocking-timeout-seconds=\"15\" login-timeout-seconds=\"30\" conn-pooled-datasource-class=\"org.apache.derby.jdbc.EmbeddedConnectionPoolDataSource\" xa-datasource-class=\"org.apache.derby.jdbc.EmbeddedXADataSource\" user-name=\"mitul\" password=\"83f0069202c571faf1ae6c42b4ad46030e4e31c17409e19a\" connection-url=\"jdbc:derby:" + newDB + ";create=true\" >";
        String config_prop = "<config-property><config-property-name>description</config-property-name><config-property-type>java.lang.String</config-property-type><config-property-value>hi</config-property-value></config-property><config-property><config-property-name>user</config-property-name><config-property-type>java.lang.String</config-property-type><config-property-value>mitul</config-property-value></config-property><config-property><config-property-name>password</config-property-name><config-property-type>java.lang.String</config-property-type><config-property-value>83f0069202c571faf1ae6c42b4ad46030e4e31c17409e19a</config-property-value>        </config-property><config-property><config-property-name>databaseName</config-property-name><config-property-type>java.lang.String</config-property-type><config-property-value>" + newDB + "</config-property-value></config-property>\n";
        String new_str = jndi_str + config_prop;
        int n1 = str.indexOf(search);
        int n2 = str.indexOf(last_search, n1);
        StringBuffer sbuff = new StringBuffer(str);
        String modified_str = sbuff.replace(n1, n2, new_str).toString();
        return modified_str;
    }

    private static String modifyFile1(String str) throws IOException {
        String search = "<jndi-binding type=\"SimpleDataSource\"";
        String last_search = "</jndi-binding>";
        String newDB = "newDB1_" + ProcessMgr.getProcessId();
        String jndi_str = "<jndi-binding type=\"SimpleDataSource\" jndi-name=\"SimpleDataSource\" jdbc-driver-class=\"org.apache.derby.jdbc.EmbeddedDriver\" init-pool-size=\"5\" max-pool-size=\"30\" idle-timeout-seconds=\"300\" blocking-timeout-seconds=\"15\" login-timeout-seconds=\"30\" conn-pooled-datasource-class=\"org.apache.derby.jdbc.EmbeddedConnectionPoolDataSource\" xa-datasource-class=\"org.apache.derby.jdbc.EmbeddedXADataSource\" user-name=\"mitul\" password=\"83f0069202c571faf1ae6c42b4ad46030e4e31c17409e19a\" connection-url=\"jdbc:derby:" + newDB + ";create=true\" >";
        String config_prop = "<config-property><config-property-name>description</config-property-name><config-property-type>java.lang.String</config-property-type><config-property-value>hi</config-property-value></config-property><config-property><config-property-name>user</config-property-name><config-property-type>java.lang.String</config-property-type><config-property-value>mitul</config-property-value></config-property><config-property><config-property-name>password</config-property-name><config-property-type>java.lang.String</config-property-type><config-property-value>83f0069202c571faf1ae6c42b4ad46030e4e31c17409e19a</config-property-value>        </config-property><config-property><config-property-name>databaseName</config-property-name><config-property-type>java.lang.String</config-property-type><config-property-value>" + newDB + "</config-property-value></config-property>\n";
        String new_str = jndi_str + config_prop;
        int n1 = str.indexOf(search);
        int n2 = str.indexOf(last_search, n1);
        StringBuffer sbuff = new StringBuffer(str);
        String modified_str = sbuff.replace(n1, n2, new_str).toString();
        return modified_str;
    }

    public static String init(String className) throws Exception {
        Properties props = new Properties();
        String jtest = System.getProperty("JTESTS");
        int pid = ProcessMgr.getProcessId();
        String path = System.getProperty("JTESTS") + "/lib/dunit-cachejta_" + pid + ".xml";
        TxnManagerMultiThreadDUnitTest.getLogWriter().fine("PATH " + path);
        String file_as_str = TxnManagerMultiThreadDUnitTest.readFile(jtest + "/lib/cachejta.xml");
        file_as_str = file_as_str.replaceAll("newDB", "newDB_" + pid);
        String modified_file_str = TxnManagerMultiThreadDUnitTest.modifyFile(file_as_str);
        String modified_file_str1 = TxnManagerMultiThreadDUnitTest.modifyFile1(modified_file_str);
        FileOutputStream fos = new FileOutputStream(path);
        BufferedWriter wr = new BufferedWriter(new OutputStreamWriter(fos));
        wr.write(modified_file_str1);
        wr.flush();
        wr.close();
        props.setProperty("cache-xml-file", path);
        String tableName = "";
        try {
            InternalDistributedSystem ds = new TxnManagerMultiThreadDUnitTest("temp").getSystem(props);
            CacheUtils.ds = ds;
            cache = CacheFactory.create((DistributedSystem)ds);
            if (className != null && !className.equals("")) {
                String time = new Long(System.currentTimeMillis()).toString();
                tableName = className + time;
                TxnManagerMultiThreadDUnitTest.createTable(tableName);
            }
        }
        catch (Exception e) {
            TxnManagerMultiThreadDUnitTest.getLogWriter().info("", (Throwable)e);
            throw new Exception("" + e);
        }
        return tableName;
    }

    public static void createTable(String tblName) throws NamingException, SQLException {
        String tableName = tblName;
        cache = TxnManagerMultiThreadDUnitTest.getCache();
        Context ctx = cache.getJNDIContext();
        DataSource ds = (DataSource)ctx.lookup("java:/SimpleDataSource");
        String sql = "create table " + tableName + " (id integer NOT NULL, name varchar(50), CONSTRAINT the_key PRIMARY KEY(id))";
        TxnManagerMultiThreadDUnitTest.getLogWriter().fine(sql);
        Connection conn = ds.getConnection();
        Statement sm = conn.createStatement();
        sm.execute(sql);
        sm.close();
        sm = conn.createStatement();
        for (int i = 1; i <= 10; ++i) {
            sql = "insert into " + tableName + " values (" + i + ",'name" + i + "')";
            sm.addBatch(sql);
            TxnManagerMultiThreadDUnitTest.getLogWriter().fine(sql);
        }
        sm.executeBatch();
        conn.close();
    }

    public static void destroyTable(String tblName) throws NamingException, SQLException {
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException ie) {
            TxnManagerMultiThreadDUnitTest.fail((String)"interrupted");
        }
        try {
            String tableName = tblName;
            TxnManagerMultiThreadDUnitTest.getLogWriter().fine("Destroying table: " + tableName);
            cache = TxnManagerMultiThreadDUnitTest.getCache();
            Context ctx = cache.getJNDIContext();
            DataSource ds = (DataSource)ctx.lookup("java:/SimpleDataSource");
            Connection conn = ds.getConnection();
            TxnManagerMultiThreadDUnitTest.getLogWriter().fine(" trying to drop table: " + tableName);
            String sql = "drop table " + tableName;
            Statement sm = conn.createStatement();
            sm.execute(sql);
            conn.close();
            TxnManagerMultiThreadDUnitTest.getLogWriter().fine("destroyTable is Successful!");
        }
        catch (NamingException ne) {
            TxnManagerMultiThreadDUnitTest.getLogWriter().fine("destroy table naming exception: " + ne);
            throw ne;
        }
        catch (SQLException se) {
            TxnManagerMultiThreadDUnitTest.getLogWriter().fine("destroy table sql exception: " + se);
            throw se;
        }
        finally {
            TxnManagerMultiThreadDUnitTest.getLogWriter().fine("Closing cache...");
            TxnManagerMultiThreadDUnitTest.closeCache();
        }
    }

    public static Cache getCache() {
        return cache;
    }

    public static void startCache() {
        try {
            if (cache.isClosed()) {
                cache = CacheFactory.create((DistributedSystem)ds);
            }
        }
        catch (Exception e) {
            TxnManagerMultiThreadDUnitTest.getLogWriter().warning("exception while creating cache", (Throwable)e);
        }
    }

    public static void closeCache() {
        try {
            if (!cache.isClosed()) {
                cache.close();
                TxnManagerMultiThreadDUnitTest.getLogWriter().fine("Cache closed");
            }
        }
        catch (Exception e) {
            TxnManagerMultiThreadDUnitTest.getLogWriter().warning("exception while closing cache", (Throwable)e);
        }
        try {
            CacheUtils.ds.disconnect();
            TxnManagerMultiThreadDUnitTest.getLogWriter().fine("Disconnected from Distribuited System");
        }
        catch (Exception e) {
            TxnManagerMultiThreadDUnitTest.getLogWriter().fine("Error in disconnecting from Distributed System");
        }
    }

    @Override
    public void setUp() throws Exception {
        VM vm0 = Host.getHost(0).getVM(0);
        Object[] o = new Object[]{"TxnManagerMultiThreadDUnitTest"};
        Object tableName = vm0.invoke(TxnManagerMultiThreadDUnitTest.class, "init", o);
        CacheUtils.setTableName((String)tableName.toString());
        o[0] = tableName;
        vm0.invoke(CacheUtils.class, "setTableName", o);
        vm0.invoke(TxnManagerMultiThreadDUnitTest.class, "delRows");
    }

    public static void delRows() {
        Region currRegion = null;
        Cache cache = TxnManagerMultiThreadDUnitTest.getCache();
        currRegion = cache.getRegion("/root");
        JTAUtils jtaObj = new JTAUtils(cache, currRegion);
        try {
            String tblName_delRows = CacheUtils.getTableName();
            jtaObj.deleteRows(tblName_delRows);
        }
        catch (Exception e) {
            TxnManagerMultiThreadDUnitTest.getLogWriter().warning("Error: while deleting rows from database using JTAUtils", (Throwable)e);
        }
    }

    @Override
    public void tearDown2() throws Exception {
        VM vm0 = Host.getHost(0).getVM(0);
        String tableName = CacheUtils.getTableName();
        Object[] o = new Object[]{tableName};
        vm0.invoke(TxnManagerMultiThreadDUnitTest.class, "destroyTable", o);
    }

    public static void getNumberOfRows() {
        try {
            Thread.sleep(7000L);
        }
        catch (InterruptedException ie) {
            TxnManagerMultiThreadDUnitTest.fail((String)"interrupted");
        }
        Region currRegion = null;
        Cache cache = TxnManagerMultiThreadDUnitTest.getCache();
        String tblName = CacheUtils.getTableName();
        currRegion = cache.getRegion("/root");
        JTAUtils jtaObj = new JTAUtils(cache, currRegion);
        try {
            int rows = jtaObj.getRows(tblName);
            TxnManagerMultiThreadDUnitTest.getLogWriter().fine("Number of rows committed current test method  are: " + rows);
        }
        catch (Exception e) {
            TxnManagerMultiThreadDUnitTest.getLogWriter().warning("Error: while getting rows from database using JTAUtils", (Throwable)e);
        }
    }

    public static void _testAllCommit() throws Throwable {
        VM vm0 = Host.getHost(0).getVM(0);
        AsyncInvocation asyncObj1 = vm0.invokeAsync(TxnManagerMultiThreadDUnitTest.class, "callCommitThreads");
        DistributedTestCase.join(asyncObj1, 30000L, TxnManagerMultiThreadDUnitTest.getLogWriter());
        if (asyncObj1.exceptionOccurred()) {
            TxnManagerMultiThreadDUnitTest.fail("asyncObj1 failed", asyncObj1.getException());
        }
        vm0.invoke(TxnManagerMultiThreadDUnitTest.class, "getNumberOfRows");
    }

    public static void callCommitThreads() {
        TxnManagerMultiThreadDUnitTest.getLogWriter().fine("This is callCommitThreads method");
        try {
            new CommitThread("ct1", TxnManagerMultiThreadDUnitTest.getLogWriter());
            new CommitThread("ct2", TxnManagerMultiThreadDUnitTest.getLogWriter());
            new CommitThread("ct3", TxnManagerMultiThreadDUnitTest.getLogWriter());
            new CommitThread("ct4", TxnManagerMultiThreadDUnitTest.getLogWriter());
        }
        catch (Exception e) {
            TxnManagerMultiThreadDUnitTest.getLogWriter().warning("Failed in Commit Threads", (Throwable)e);
            TxnManagerMultiThreadDUnitTest.fail((String)("Failed in Commit Threads" + e));
        }
    }

    public static void _test3Commit2Rollback() throws Throwable {
        VM vm0 = Host.getHost(0).getVM(0);
        AsyncInvocation asyncObj1 = vm0.invokeAsync(TxnManagerMultiThreadDUnitTest.class, "callCommitandRollbackThreads");
        DistributedTestCase.join(asyncObj1, 30000L, TxnManagerMultiThreadDUnitTest.getLogWriter());
        if (asyncObj1.exceptionOccurred()) {
            TxnManagerMultiThreadDUnitTest.fail("asyncObj1 failed", asyncObj1.getException());
        }
        vm0.invoke(TxnManagerMultiThreadDUnitTest.class, "getNumberOfRows");
    }

    public static void callCommitandRollbackThreads() {
        TxnManagerMultiThreadDUnitTest.getLogWriter().fine("This is callCommitandRollbackThreads method");
        try {
            new CommitThread("ct1", TxnManagerMultiThreadDUnitTest.getLogWriter());
            new CommitThread("ct2", TxnManagerMultiThreadDUnitTest.getLogWriter());
            new CommitThread("ct3", TxnManagerMultiThreadDUnitTest.getLogWriter());
            new RollbackThread("rt1", TxnManagerMultiThreadDUnitTest.getLogWriter());
            new RollbackThread("rt2", TxnManagerMultiThreadDUnitTest.getLogWriter());
        }
        catch (Exception e) {
            TxnManagerMultiThreadDUnitTest.getLogWriter().info("Failed in Commit and Rollback threads", (Throwable)e);
            TxnManagerMultiThreadDUnitTest.fail((String)("Failed in Commit and Rollback Threads" + e));
        }
    }

    public void testFoo() {
    }
}

