/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.jta.dunit;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.distributed.DistributedSystem;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import hydra.ProcessMgr;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.transaction.UserTransaction;

public class ExceptionsDUnitTest
extends DistributedTestCase {
    static DistributedSystem ds;
    static Cache cache;

    private static String readFile(String filename) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(filename));
        String nextLine = "";
        StringBuffer sb = new StringBuffer();
        while ((nextLine = br.readLine()) != null) {
            sb.append(nextLine);
        }
        ExceptionsDUnitTest.getLogWriter().fine("***********\n " + sb);
        return sb.toString();
    }

    public ExceptionsDUnitTest(String name) {
        super(name);
    }

    private static String modifyFile(String str) throws IOException {
        String search = "<jndi-binding type=\"XAPooledDataSource\"";
        String last_search = "</jndi-binding>";
        String newDB = "newDB_" + ProcessMgr.getProcessId();
        String jndi_str = "<jndi-binding type=\"XAPooledDataSource\" jndi-name=\"XAPooledDataSource\"          jdbc-driver-class=\"org.apache.derby.jdbc.EmbeddedDriver\" init-pool-size=\"5\" max-pool-size=\"5\" idle-timeout-seconds=\"600\" blocking-timeout-seconds=\"6\" login-timeout-seconds=\"2\" conn-pooled-datasource-class=\"org.apache.derby.jdbc.EmbeddedConnectionPoolDataSource\" xa-datasource-class=\"org.apache.derby.jdbc.EmbeddedXADataSource\" user-name=\"mitul\" password=\"83f0069202c571faf1ae6c42b4ad46030e4e31c17409e19a\" connection-url=\"jdbc:derby:" + newDB + ";create=true\" >";
        String config_prop = "<config-property><config-property-name>description</config-property-name><config-property-type>java.lang.String</config-property-type><config-property-value>hi</config-property-value></config-property><config-property><config-property-name>user</config-property-name><config-property-type>java.lang.String</config-property-type><config-property-value>mitul</config-property-value></config-property><config-property><config-property-name>password</config-property-name><config-property-type>java.lang.String</config-property-type><config-property-value>83f0069202c571faf1ae6c42b4ad46030e4e31c17409e19a</config-property-value>        </config-property><config-property><config-property-name>databaseName</config-property-name><config-property-type>java.lang.String</config-property-type><config-property-value>" + newDB + "</config-property-value></config-property>\n";
        String new_str = jndi_str + config_prop;
        int n1 = str.indexOf(search);
        ExceptionsDUnitTest.getLogWriter().fine("Start Index = " + n1);
        int n2 = str.indexOf(last_search, n1);
        StringBuffer sbuff = new StringBuffer(str);
        ExceptionsDUnitTest.getLogWriter().fine("END Index = " + n2);
        String modified_str = sbuff.replace(n1, n2, new_str).toString();
        return modified_str;
    }

    public static void init() throws Exception {
        Properties props = new Properties();
        String jtest = System.getProperty("JTESTS");
        int pid = ProcessMgr.getProcessId();
        String path = System.getProperty("JTESTS") + "/lib/dunit-cachejta_" + pid + ".xml";
        String file_as_str = ExceptionsDUnitTest.readFile(jtest + "/lib/cachejta.xml");
        file_as_str = file_as_str.replaceAll("newDB", "newDB_" + pid);
        String modified_file_str = ExceptionsDUnitTest.modifyFile(file_as_str);
        FileOutputStream fos = new FileOutputStream(path);
        BufferedWriter wr = new BufferedWriter(new OutputStreamWriter(fos));
        wr.write(modified_file_str);
        wr.flush();
        wr.close();
        props.setProperty("cache-xml-file", path);
        try {
            ds = new ExceptionsDUnitTest("temp").getSystem(props);
            cache = CacheFactory.create((DistributedSystem)ds);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new Exception("" + e);
        }
    }

    public static Cache getCache() {
        return cache;
    }

    public static void startCache() {
        try {
            if (cache == null || cache.isClosed()) {
                cache = CacheFactory.create((DistributedSystem)ds);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void closeCache() {
        try {
            if (cache != null && !cache.isClosed()) {
                cache.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (ds != null) {
                ds.disconnect();
            }
        }
        catch (Exception e) {
            ExceptionsDUnitTest.getLogWriter().fine("Error in disconnecting from Distributed System");
        }
    }

    @Override
    public void setUp() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        vm0.invoke(ExceptionsDUnitTest.class, "init");
    }

    @Override
    public void tearDown2() throws NamingException, SQLException {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        vm0.invoke(ExceptionsDUnitTest.class, "closeCache");
    }

    public static void testBlockingTimeOut() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        vm0.invoke(ExceptionsDUnitTest.class, "runTest1");
    }

    public static void testLoginTimeOut() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        vm0.invoke(ExceptionsDUnitTest.class, "runTest2");
    }

    public static void testTransactionTimeOut() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        vm0.invoke(ExceptionsDUnitTest.class, "runTest3");
    }

    public static void runTest1() throws Exception {
        boolean exceptionOccured = false;
        try {
            Context ctx = cache.getJNDIContext();
            DataSource ds1 = null;
            DataSource ds2 = null;
            ds1 = (DataSource)ctx.lookup("java:/XAPooledDataSource");
            ds2 = (DataSource)ctx.lookup("java:/SimpleDataSource");
            ds2.getConnection();
            ds1 = (DataSource)ctx.lookup("java:/XAPooledDataSource");
            UserTransaction utx = (UserTransaction)ctx.lookup("java:/UserTransaction");
            utx.begin();
            ds1.getConnection();
            Thread.sleep(8000L);
            try {
                utx.commit();
            }
            catch (Exception e) {
                exceptionOccured = true;
            }
            if (!exceptionOccured) {
                ExceptionsDUnitTest.fail((String)"Exception did not occur on commit although was supposedoccur");
            }
        }
        catch (Exception e) {
            ExceptionsDUnitTest.getLogWriter().fine("Exception caught in runTest1 due to : " + e);
            ExceptionsDUnitTest.fail((String)("failed in runTest1 due to " + e));
        }
    }

    public static void runTest2() throws Exception {
        boolean exceptionOccured1 = false;
        boolean exceptionOccured2 = false;
        try {
            Context ctx = cache.getJNDIContext();
            DataSource ds1 = null;
            DataSource ds2 = null;
            ds1 = (DataSource)ctx.lookup("java:/XAPooledDataSource");
            ds2 = (DataSource)ctx.lookup("java:/SimpleDataSource");
            ds2.getConnection();
            ds1.getConnection();
            ds1.getConnection();
            ds1.getConnection();
            ds1.getConnection();
            ds1.getConnection();
            UserTransaction utx = (UserTransaction)ctx.lookup("java:/UserTransaction");
            utx.begin();
            try {
                ds1.getConnection();
                Thread.sleep(8000L);
            }
            catch (SQLException e) {
                exceptionOccured1 = true;
            }
            try {
                utx.commit();
            }
            catch (Exception e) {
                exceptionOccured2 = true;
            }
            if (!exceptionOccured1) {
                ExceptionsDUnitTest.fail((String)"Exception (Login-Time-Out)did not occur although was supposedto occur");
            }
            if (exceptionOccured2) {
                ExceptionsDUnitTest.fail((String)"Exception did occur on commit, although was not supposedto occur");
            }
        }
        catch (Exception e) {
            ExceptionsDUnitTest.fail((String)("failed in runTest2 due to " + e));
        }
    }

    public static void runTest3() throws Exception {
        boolean exceptionOccured = false;
        try {
            Context ctx = cache.getJNDIContext();
            DataSource ds1 = null;
            DataSource ds2 = null;
            ds1 = (DataSource)ctx.lookup("java:/XAPooledDataSource");
            ds2 = (DataSource)ctx.lookup("java:/SimpleDataSource");
            ds2.getConnection();
            UserTransaction utx = (UserTransaction)ctx.lookup("java:/UserTransaction");
            utx.begin();
            utx.setTransactionTimeout(2);
            ds1.getConnection();
            Thread.sleep(4000L);
            try {
                utx.commit();
            }
            catch (Exception e) {
                exceptionOccured = true;
            }
            if (!exceptionOccured) {
                ExceptionsDUnitTest.fail((String)"Exception (Transaction-Time-Out)did not occur although was supposedto occur");
            }
        }
        catch (Exception e) {
            ExceptionsDUnitTest.fail((String)("failed in runTest3 due to " + e));
        }
    }
}

