/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan.wancommand;

import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderException;
import com.gemstone.gemfire.internal.cache.wan.wancommand.WANCommandTestBase;
import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.cli.result.CommandResult;
import com.gemstone.gemfire.management.internal.cli.result.TabularResultData;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import hydra.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class WanCommandCreateGatewaySenderDUnitTest
extends WANCommandTestBase {
    private static final long serialVersionUID = 1L;

    public WanCommandCreateGatewaySenderDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommandResult executeCommandWithIgnoredExceptions(String command) {
        DistributedTestCase.ExpectedException exln = WanCommandCreateGatewaySenderDUnitTest.addExpectedException("Could not connect");
        try {
            CommandResult commandResult;
            CommandResult commandResult2 = commandResult = this.executeCommand(command);
            return commandResult2;
        }
        finally {
            exln.remove();
        }
    }

    public void testCreateGatewaySenderWithDefault() {
        VM puneLocator = Host.getLocator();
        int punePort = (Integer)puneLocator.invoke(WANCommandTestBase.class, "getLocatorPort");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + punePort + "]");
        this.createDefaultSetup(props);
        Integer nyPort = (Integer)vm2.invoke(WANCommandTestBase.class, "createFirstRemoteLocator", new Object[]{2, punePort});
        vm3.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        vm4.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        vm5.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        String command = "create gateway-sender --id=ln --remote-distributed-system-id=2";
        CommandResult cmdResult = this.executeCommandWithIgnoredExceptions(command);
        if (cmdResult != null) {
            String strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testCreateGatewaySender stringResult : " + strCmdResult + ">>>>");
            WanCommandCreateGatewaySenderDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            TabularResultData resultData = (TabularResultData)cmdResult.getResultData();
            List status = resultData.retrieveAllValues("Status");
            WanCommandCreateGatewaySenderDUnitTest.assertEquals((int)4, (int)status.size());
            for (int i = 0; i < status.size(); ++i) {
                WanCommandCreateGatewaySenderDUnitTest.assertTrue((String)("GatewaySender creation failed with: " + (String)status.get(i)), (((String)status.get(i)).indexOf("ERROR:") == -1 ? 1 : 0) != 0);
            }
        } else {
            WanCommandCreateGatewaySenderDUnitTest.fail((String)"testCreateGatewaySender failed as did not get CommandResult");
        }
        vm3.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", true, false});
        vm4.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", true, false});
        vm5.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", true, false});
    }

    public void testCreateGatewaySender() {
        VM puneLocator = Host.getLocator();
        int punePort = (Integer)puneLocator.invoke(WANCommandTestBase.class, "getLocatorPort");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + punePort + "]");
        this.createDefaultSetup(props);
        Integer nyPort = (Integer)vm2.invoke(WANCommandTestBase.class, "createFirstRemoteLocator", new Object[]{2, punePort});
        vm3.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        vm4.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        vm5.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        String command = "create gateway-sender --id=ln --remote-distributed-system-id=2 --parallel=false --manual-start=true --socket-buffer-size=1000 --socket-read-timeout=2000 --enable-batch-conflation=true --batch-size=1000 --batch-time-interval=5000 --enable-persistence=true --disk-synchronous=false --maximum-queue-memory=1000 --alert-threshold=100 --dispatcher-threads=2 --order-policy=THREAD";
        CommandResult cmdResult = this.executeCommandWithIgnoredExceptions(command);
        if (cmdResult != null) {
            String strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testCreateGatewaySender stringResult : " + strCmdResult + ">>>>");
            WanCommandCreateGatewaySenderDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            TabularResultData resultData = (TabularResultData)cmdResult.getResultData();
            List status = resultData.retrieveAllValues("Status");
            WanCommandCreateGatewaySenderDUnitTest.assertEquals((int)4, (int)status.size());
            for (int i = 0; i < status.size(); ++i) {
                WanCommandCreateGatewaySenderDUnitTest.assertTrue((String)("GatewaySender creation failed with: " + (String)status.get(i)), (((String)status.get(i)).indexOf("ERROR:") == -1 ? 1 : 0) != 0);
            }
        } else {
            WanCommandCreateGatewaySenderDUnitTest.fail((String)"testCreateGatewaySender failed as did not get CommandResult");
        }
        vm3.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", false, false});
        vm4.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", false, false});
        vm5.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", false, false});
        vm3.invoke(WANCommandTestBase.class, "verifySenderAttributes", new Object[]{"ln", 2, false, true, 1000, 2000, true, 1000, 5000, true, false, 1000, 100, 2, Gateway.OrderPolicy.THREAD, null, null});
        vm4.invoke(WANCommandTestBase.class, "verifySenderAttributes", new Object[]{"ln", 2, false, true, 1000, 2000, true, 1000, 5000, true, false, 1000, 100, 2, Gateway.OrderPolicy.THREAD, null, null});
        vm5.invoke(WANCommandTestBase.class, "verifySenderAttributes", new Object[]{"ln", 2, false, true, 1000, 2000, true, 1000, 5000, true, false, 1000, 100, 2, Gateway.OrderPolicy.THREAD, null, null});
    }

    public void testCreateGatewaySender_Error() {
        VM puneLocator = Host.getLocator();
        int punePort = (Integer)puneLocator.invoke(WANCommandTestBase.class, "getLocatorPort");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + punePort + "]");
        this.createDefaultSetup(props);
        Integer nyPort = (Integer)vm2.invoke(WANCommandTestBase.class, "createFirstRemoteLocator", new Object[]{2, punePort});
        vm3.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        vm4.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        vm5.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        String command = "create gateway-sender --id=ln --remote-distributed-system-id=2 --parallel=false --manual-start=true --socket-buffer-size=1000 --socket-read-timeout=2000 --enable-batch-conflation=true --batch-size=1000 --batch-time-interval=5000 --enable-persistence=true --disk-synchronous=false --maximum-queue-memory=1000 --alert-threshold=100 --dispatcher-threads=2";
        CommandResult cmdResult = this.executeCommandWithIgnoredExceptions(command);
        if (cmdResult != null) {
            String strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testCreateGatewaySender stringResult : " + strCmdResult + ">>>>");
            WanCommandCreateGatewaySenderDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            TabularResultData resultData = (TabularResultData)cmdResult.getResultData();
            List status = resultData.retrieveAllValues("Status");
            WanCommandCreateGatewaySenderDUnitTest.assertEquals((int)4, (int)status.size());
            for (int i = 0; i < status.size(); ++i) {
                WanCommandCreateGatewaySenderDUnitTest.assertTrue((String)"GatewaySender creation should fail", (((String)status.get(i)).indexOf("ERROR:") != -1 ? 1 : 0) != 0);
            }
        } else {
            WanCommandCreateGatewaySenderDUnitTest.fail((String)"testCreateGatewaySender failed as did not get CommandResult");
        }
    }

    public void testCreateGatewaySenderWithGatewayEventFilters() {
        VM puneLocator = Host.getLocator();
        int punePort = (Integer)puneLocator.invoke(WANCommandTestBase.class, "getLocatorPort");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + punePort + "]");
        this.createDefaultSetup(props);
        Integer nyPort = (Integer)vm2.invoke(WANCommandTestBase.class, "createFirstRemoteLocator", new Object[]{2, punePort});
        vm3.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        vm4.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        vm5.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        String command = "create gateway-sender --id=ln --remote-distributed-system-id=2 --parallel=false --manual-start=true --socket-buffer-size=1000 --socket-read-timeout=2000 --enable-batch-conflation=true --batch-size=1000 --batch-time-interval=5000 --enable-persistence=true --disk-synchronous=false --maximum-queue-memory=1000 --alert-threshold=100 --dispatcher-threads=2 --order-policy=THREAD --gateway-event-filter=com.gemstone.gemfire.cache30.MyGatewayEventFilter1,com.gemstone.gemfire.cache30.MyGatewayEventFilter2";
        CommandResult cmdResult = this.executeCommandWithIgnoredExceptions(command);
        if (cmdResult != null) {
            String strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testCreateGatewaySender stringResult : " + strCmdResult + ">>>>");
            WanCommandCreateGatewaySenderDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            TabularResultData resultData = (TabularResultData)cmdResult.getResultData();
            List status = resultData.retrieveAllValues("Status");
            WanCommandCreateGatewaySenderDUnitTest.assertEquals((int)4, (int)status.size());
            for (int i = 0; i < status.size(); ++i) {
                WanCommandCreateGatewaySenderDUnitTest.assertTrue((String)("GatewaySender creation failed with: " + (String)status.get(i)), (((String)status.get(i)).indexOf("ERROR:") == -1 ? 1 : 0) != 0);
            }
        } else {
            WanCommandCreateGatewaySenderDUnitTest.fail((String)"testCreateGatewaySender failed as did not get CommandResult");
        }
        vm3.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", false, false});
        vm4.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", false, false});
        vm5.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", false, false});
        ArrayList<String> eventFilters = new ArrayList<String>();
        eventFilters.add("com.gemstone.gemfire.cache30.MyGatewayEventFilter1");
        eventFilters.add("com.gemstone.gemfire.cache30.MyGatewayEventFilter2");
        vm3.invoke(WANCommandTestBase.class, "verifySenderAttributes", new Object[]{"ln", 2, false, true, 1000, 2000, true, 1000, 5000, true, false, 1000, 100, 2, Gateway.OrderPolicy.THREAD, eventFilters, null});
        vm4.invoke(WANCommandTestBase.class, "verifySenderAttributes", new Object[]{"ln", 2, false, true, 1000, 2000, true, 1000, 5000, true, false, 1000, 100, 2, Gateway.OrderPolicy.THREAD, eventFilters, null});
        vm5.invoke(WANCommandTestBase.class, "verifySenderAttributes", new Object[]{"ln", 2, false, true, 1000, 2000, true, 1000, 5000, true, false, 1000, 100, 2, Gateway.OrderPolicy.THREAD, eventFilters, null});
    }

    public void testCreateGatewaySenderWithGatewayTransportFilters() {
        VM puneLocator = Host.getLocator();
        int punePort = (Integer)puneLocator.invoke(WANCommandTestBase.class, "getLocatorPort");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + punePort + "]");
        this.createDefaultSetup(props);
        Integer nyPort = (Integer)vm2.invoke(WANCommandTestBase.class, "createFirstRemoteLocator", new Object[]{2, punePort});
        vm3.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        vm4.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        vm5.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        String command = "create gateway-sender --id=ln --remote-distributed-system-id=2 --parallel=false --manual-start=true --socket-buffer-size=1000 --socket-read-timeout=2000 --enable-batch-conflation=true --batch-size=1000 --batch-time-interval=5000 --enable-persistence=true --disk-synchronous=false --maximum-queue-memory=1000 --alert-threshold=100 --dispatcher-threads=2 --order-policy=THREAD --gateway-transport-filter=com.gemstone.gemfire.cache30.MyGatewayTransportFilter1";
        CommandResult cmdResult = this.executeCommandWithIgnoredExceptions(command);
        if (cmdResult != null) {
            String strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testCreateGatewaySender stringResult : " + strCmdResult + ">>>>");
            WanCommandCreateGatewaySenderDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            TabularResultData resultData = (TabularResultData)cmdResult.getResultData();
            List status = resultData.retrieveAllValues("Status");
            WanCommandCreateGatewaySenderDUnitTest.assertEquals((int)4, (int)status.size());
            for (int i = 0; i < status.size(); ++i) {
                WanCommandCreateGatewaySenderDUnitTest.assertTrue((String)("GatewaySender creation failed with: " + (String)status.get(i)), (((String)status.get(i)).indexOf("ERROR:") == -1 ? 1 : 0) != 0);
            }
        } else {
            WanCommandCreateGatewaySenderDUnitTest.fail((String)"testCreateGatewaySender failed as did not get CommandResult");
        }
        vm3.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", false, false});
        vm4.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", false, false});
        vm5.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", false, false});
        ArrayList<String> transportFilters = new ArrayList<String>();
        transportFilters.add("com.gemstone.gemfire.cache30.MyGatewayTransportFilter1");
        vm3.invoke(WANCommandTestBase.class, "verifySenderAttributes", new Object[]{"ln", 2, false, true, 1000, 2000, true, 1000, 5000, true, false, 1000, 100, 2, Gateway.OrderPolicy.THREAD, null, transportFilters});
        vm4.invoke(WANCommandTestBase.class, "verifySenderAttributes", new Object[]{"ln", 2, false, true, 1000, 2000, true, 1000, 5000, true, false, 1000, 100, 2, Gateway.OrderPolicy.THREAD, null, transportFilters});
        vm5.invoke(WANCommandTestBase.class, "verifySenderAttributes", new Object[]{"ln", 2, false, true, 1000, 2000, true, 1000, 5000, true, false, 1000, 100, 2, Gateway.OrderPolicy.THREAD, null, transportFilters});
    }

    public void testCreateGatewaySender_OnMember() {
        VM puneLocator = Host.getLocator();
        int punePort = (Integer)puneLocator.invoke(WANCommandTestBase.class, "getLocatorPort");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + punePort + "]");
        this.createDefaultSetup(props);
        Integer nyPort = (Integer)vm2.invoke(WANCommandTestBase.class, "createFirstRemoteLocator", new Object[]{2, punePort});
        vm3.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        vm4.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        vm5.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        DistributedMember vm3Member = (DistributedMember)vm3.invoke(WANCommandTestBase.class, "getMember");
        String command = "create gateway-sender --id=ln --member=" + vm3Member.getId() + " --" + "remote-distributed-system-id" + "=2 --" + "parallel" + "=false --" + "manual-start" + "=true --" + "socket-buffer-size" + "=1000 --" + "socket-read-timeout" + "=2000 --" + "enable-batch-conflation" + "=true --" + "batch-size" + "=1000 --" + "batch-time-interval" + "=5000 --" + "enable-persistence" + "=true --" + "disk-synchronous" + "=false --" + "maximum-queue-memory" + "=1000 --" + "alert-threshold" + "=100 --" + "dispatcher-threads" + "=2 --" + "order-policy" + "=THREAD";
        CommandResult cmdResult = this.executeCommandWithIgnoredExceptions(command);
        if (cmdResult != null) {
            String strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testCreateGatewaySender stringResult : " + strCmdResult + ">>>>");
            WanCommandCreateGatewaySenderDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            TabularResultData resultData = (TabularResultData)cmdResult.getResultData();
            List status = resultData.retrieveAllValues("Status");
            WanCommandCreateGatewaySenderDUnitTest.assertEquals((int)1, (int)status.size());
            for (int i = 0; i < status.size(); ++i) {
                WanCommandCreateGatewaySenderDUnitTest.assertTrue((String)("GatewaySender creation failed with: " + (String)status.get(i)), (((String)status.get(i)).indexOf("ERROR:") == -1 ? 1 : 0) != 0);
            }
        } else {
            WanCommandCreateGatewaySenderDUnitTest.fail((String)"testCreateGatewaySender failed as did not get CommandResult");
        }
        vm3.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", false, false});
        vm3.invoke(WANCommandTestBase.class, "verifySenderAttributes", new Object[]{"ln", 2, false, true, 1000, 2000, true, 1000, 5000, true, false, 1000, 100, 2, Gateway.OrderPolicy.THREAD, null, null});
    }

    public void testCreateGatewaySender_Group() {
        VM puneLocator = Host.getLocator();
        int punePort = (Integer)puneLocator.invoke(WANCommandTestBase.class, "getLocatorPort");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + punePort + "]");
        this.createDefaultSetup(props);
        Integer nyPort = (Integer)vm2.invoke(WANCommandTestBase.class, "createFirstRemoteLocator", new Object[]{2, punePort});
        vm3.invoke(WANCommandTestBase.class, "createCacheWithGroups", new Object[]{punePort, "SenderGroup1"});
        vm4.invoke(WANCommandTestBase.class, "createCacheWithGroups", new Object[]{punePort, "SenderGroup1"});
        vm5.invoke(WANCommandTestBase.class, "createCacheWithGroups", new Object[]{punePort, "SenderGroup1"});
        String command = "create gateway-sender --id=ln --group=SenderGroup1 --remote-distributed-system-id=2 --parallel=false --manual-start=false --socket-buffer-size=1000 --socket-read-timeout=1000 --enable-batch-conflation=true --batch-size=1000 --batch-time-interval=5000 --enable-persistence=true --disk-synchronous=false --maximum-queue-memory=1000 --alert-threshold=100 --dispatcher-threads=2 --order-policy=THREAD";
        CommandResult cmdResult = this.executeCommandWithIgnoredExceptions(command);
        if (cmdResult != null) {
            String strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testCreateGatewaySender stringResult : " + strCmdResult + ">>>>");
            WanCommandCreateGatewaySenderDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            TabularResultData resultData = (TabularResultData)cmdResult.getResultData();
            List status = resultData.retrieveAllValues("Status");
            WanCommandCreateGatewaySenderDUnitTest.assertEquals((int)3, (int)status.size());
            for (int i = 0; i < status.size(); ++i) {
                WanCommandCreateGatewaySenderDUnitTest.assertTrue((String)("GatewaySender creation failed with: " + (String)status.get(i)), (((String)status.get(i)).indexOf("ERROR:") == -1 ? 1 : 0) != 0);
            }
        } else {
            WanCommandCreateGatewaySenderDUnitTest.fail((String)"testCreateGatewaySender failed as did not get CommandResult");
        }
        vm3.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", true, false});
        vm4.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", true, false});
        vm5.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", true, false});
    }

    public void testCreateGatewaySender_Group_Scenario2() {
        VM puneLocator = Host.getLocator();
        int punePort = (Integer)puneLocator.invoke(WANCommandTestBase.class, "getLocatorPort");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + punePort + "]");
        this.createDefaultSetup(props);
        Integer nyPort = (Integer)vm2.invoke(WANCommandTestBase.class, "createFirstRemoteLocator", new Object[]{2, punePort});
        vm3.invoke(WANCommandTestBase.class, "createCacheWithGroups", new Object[]{punePort, "SenderGroup1"});
        vm4.invoke(WANCommandTestBase.class, "createCacheWithGroups", new Object[]{punePort, "SenderGroup1"});
        vm5.invoke(WANCommandTestBase.class, "createCacheWithGroups", new Object[]{punePort, "SenderGroup2"});
        String command = "create gateway-sender --id=ln --group=SenderGroup1 --remote-distributed-system-id=2 --parallel=false --manual-start=false --socket-buffer-size=1000 --socket-read-timeout=1000 --enable-batch-conflation=true --batch-size=1000 --batch-time-interval=5000 --enable-persistence=true --disk-synchronous=false --maximum-queue-memory=1000 --alert-threshold=100 --dispatcher-threads=2 --order-policy=THREAD";
        CommandResult cmdResult = this.executeCommandWithIgnoredExceptions(command);
        if (cmdResult != null) {
            String strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testCreateGatewaySender stringResult : " + strCmdResult + ">>>>");
            WanCommandCreateGatewaySenderDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            TabularResultData resultData = (TabularResultData)cmdResult.getResultData();
            List status = resultData.retrieveAllValues("Status");
            WanCommandCreateGatewaySenderDUnitTest.assertEquals((int)2, (int)status.size());
            for (int i = 0; i < status.size(); ++i) {
                WanCommandCreateGatewaySenderDUnitTest.assertTrue((String)("GatewaySender creation failed with: " + (String)status.get(i)), (((String)status.get(i)).indexOf("ERROR:") == -1 ? 1 : 0) != 0);
            }
        } else {
            WanCommandCreateGatewaySenderDUnitTest.fail((String)"testCreateGatewaySender failed as did not get CommandResult");
        }
        vm3.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", true, false});
        vm4.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", true, false});
    }

    public void testCreateParallelGatewaySender() {
        VM puneLocator = Host.getLocator();
        int punePort = (Integer)puneLocator.invoke(WANCommandTestBase.class, "getLocatorPort");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + punePort + "]");
        this.createDefaultSetup(props);
        Integer nyPort = (Integer)vm2.invoke(WANCommandTestBase.class, "createFirstRemoteLocator", new Object[]{2, punePort});
        vm3.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        vm4.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        vm5.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        String command = "create gateway-sender --id=ln --remote-distributed-system-id=2 --parallel=true --manual-start=true --socket-buffer-size=1000 --socket-read-timeout=2000 --enable-batch-conflation=true --batch-size=1000 --batch-time-interval=5000 --enable-persistence=true --disk-synchronous=false --maximum-queue-memory=1000 --alert-threshold=100";
        CommandResult cmdResult = this.executeCommandWithIgnoredExceptions(command);
        if (cmdResult != null) {
            String strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testCreateGatewaySender stringResult : " + strCmdResult + ">>>>");
            WanCommandCreateGatewaySenderDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            TabularResultData resultData = (TabularResultData)cmdResult.getResultData();
            List status = resultData.retrieveAllValues("Status");
            WanCommandCreateGatewaySenderDUnitTest.assertEquals((int)4, (int)status.size());
            for (int i = 0; i < status.size(); ++i) {
                WanCommandCreateGatewaySenderDUnitTest.assertTrue((String)("GatewaySender creation failed with: " + (String)status.get(i)), (((String)status.get(i)).indexOf("ERROR:") == -1 ? 1 : 0) != 0);
            }
        } else {
            WanCommandCreateGatewaySenderDUnitTest.fail((String)"testCreateGatewaySender failed as did not get CommandResult");
        }
        vm3.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", false, false});
        vm4.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", false, false});
        vm5.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", false, false});
        vm3.invoke(WANCommandTestBase.class, "verifySenderAttributes", new Object[]{"ln", 2, true, true, 1000, 2000, true, 1000, 5000, true, false, 1000, 100, 1, null, null, null});
        vm4.invoke(WANCommandTestBase.class, "verifySenderAttributes", new Object[]{"ln", 2, true, true, 1000, 2000, true, 1000, 5000, true, false, 1000, 100, 1, null, null, null});
        vm5.invoke(WANCommandTestBase.class, "verifySenderAttributes", new Object[]{"ln", 2, true, true, 1000, 2000, true, 1000, 5000, true, false, 1000, 100, 1, null, null, null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateParallelGatewaySender_Error() {
        VM puneLocator = Host.getLocator();
        int punePort = (Integer)puneLocator.invoke(WANCommandTestBase.class, "getLocatorPort");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + punePort + "]");
        this.createDefaultSetup(props);
        Integer nyPort = (Integer)vm2.invoke(WANCommandTestBase.class, "createFirstRemoteLocator", new Object[]{2, punePort});
        vm3.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        vm4.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        vm5.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        String command = "create gateway-sender --id=ln --remote-distributed-system-id=2 --parallel=true --manual-start=true --socket-buffer-size=1000 --socket-read-timeout=2000 --enable-batch-conflation=true --batch-size=1000 --batch-time-interval=5000 --enable-persistence=true --disk-synchronous=false --maximum-queue-memory=1000 --alert-threshold=100 --dispatcher-threads=2 --order-policy=THREAD";
        DistributedTestCase.ExpectedException exp = WanCommandCreateGatewaySenderDUnitTest.addExpectedException(GatewaySenderException.class.getName());
        try {
            CommandResult cmdResult = this.executeCommandWithIgnoredExceptions(command);
            if (cmdResult != null) {
                String strCmdResult = this.commandResultToString(cmdResult);
                Log.getLogWriter().info("testCreateGatewaySender stringResult : " + strCmdResult + ">>>>");
                WanCommandCreateGatewaySenderDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
                TabularResultData resultData = (TabularResultData)cmdResult.getResultData();
                List status = resultData.retrieveAllValues("Status");
                WanCommandCreateGatewaySenderDUnitTest.assertEquals((int)4, (int)status.size());
                for (int i = 0; i < status.size(); ++i) {
                    WanCommandCreateGatewaySenderDUnitTest.assertTrue((String)"GatewaySender creation should have failed", (((String)status.get(i)).indexOf("ERROR:") != -1 ? 1 : 0) != 0);
                }
            } else {
                WanCommandCreateGatewaySenderDUnitTest.fail((String)"testCreateGatewaySender failed as did not get CommandResult");
            }
        }
        finally {
            exp.remove();
        }
    }
}

