/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan.wancommand;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.DiskStoreFactory;
import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.cache.wan.GatewayEventFilter;
import com.gemstone.gemfire.cache.wan.GatewayReceiver;
import com.gemstone.gemfire.cache.wan.GatewayReceiverFactory;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.cache.wan.GatewaySenderFactory;
import com.gemstone.gemfire.cache.wan.GatewayTransportFilter;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySender;
import com.gemstone.gemfire.management.ManagementService;
import com.gemstone.gemfire.management.internal.cli.commands.CliCommandTestBase;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.management.remote.JMXConnectorServer;
import management.cli.TestableGfsh;

public class WANCommandTestBase
extends CliCommandTestBase {
    static Cache cache;
    private transient TestableGfsh shell;
    private JMXConnectorServer jmxConnectorServer;
    private ManagementService managementService;
    static VM vm0;
    static VM vm1;
    static VM vm2;
    static VM vm3;
    static VM vm4;
    static VM vm5;
    static VM vm6;
    static VM vm7;

    public WANCommandTestBase(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        vm0 = host.getVM(0);
        vm1 = host.getVM(1);
        vm2 = host.getVM(2);
        vm3 = host.getVM(3);
        vm4 = host.getVM(4);
        vm5 = host.getVM(5);
        vm6 = host.getVM(6);
        vm7 = host.getVM(7);
        this.enableManagement();
    }

    public static Integer createFirstLocatorWithDSId(int dsId) {
        WANCommandTestBase test = new WANCommandTestBase(testName);
        int port = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "" + dsId);
        props.setProperty("locators", "localhost[" + port + "]");
        props.setProperty("start-locator", "localhost[" + port + "],server=true,peer=true,hostname-for-clients=localhost");
        InternalDistributedSystem ds = test.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        return port;
    }

    public static Integer createFirstRemoteLocator(int dsId, int remoteLocPort) {
        WANCommandTestBase test = new WANCommandTestBase(testName);
        int port = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "" + dsId);
        props.setProperty("locators", "localhost[" + port + "]");
        props.setProperty("start-locator", "localhost[" + port + "],server=true,peer=true,hostname-for-clients=localhost");
        props.setProperty("remote-locators", "localhost[" + remoteLocPort + "]");
        test.getSystem(props);
        return port;
    }

    public static void createCache(Integer locPort) {
        WANCommandTestBase test = new WANCommandTestBase(testName);
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + locPort + "]");
        InternalDistributedSystem ds = test.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
    }

    public static void createCacheWithGroups(Integer locPort, String groups) {
        WANCommandTestBase test = new WANCommandTestBase(testName);
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + locPort + "]");
        props.setProperty("groups", groups);
        InternalDistributedSystem ds = test.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
    }

    public static void createSender(String dsName, int remoteDsId, boolean isParallel, Integer maxMemory, Integer batchSize, boolean isConflation, boolean isPersistent, GatewayEventFilter filter, boolean isManulaStart) {
        File persistentDirectory = new File(dsName + "_disk_" + System.currentTimeMillis() + "_" + VM.getCurrentVMNum());
        persistentDirectory.mkdir();
        DiskStoreFactory dsf = cache.createDiskStoreFactory();
        File[] dirs1 = new File[]{persistentDirectory};
        if (isParallel) {
            GatewaySenderFactory gateway = cache.createGatewaySenderFactory();
            gateway.setParallel(true);
            gateway.setMaximumQueueMemory(maxMemory.intValue());
            gateway.setBatchSize(batchSize.intValue());
            gateway.setManualStart(isManulaStart);
            if (filter != null) {
                gateway.addGatewayEventFilter(filter);
            }
            if (isPersistent) {
                gateway.setPersistenceEnabled(true);
                gateway.setDiskStoreName(dsf.setDiskDirs(dirs1).create(dsName).getName());
            } else {
                DiskStore store = dsf.setDiskDirs(dirs1).create(dsName);
                gateway.setDiskStoreName(store.getName());
            }
            gateway.setBatchConflationEnabled(isConflation);
            gateway.create(dsName, remoteDsId);
        } else {
            GatewaySenderFactory gateway = cache.createGatewaySenderFactory();
            gateway.setMaximumQueueMemory(maxMemory.intValue());
            gateway.setBatchSize(batchSize.intValue());
            gateway.setManualStart(isManulaStart);
            if (filter != null) {
                gateway.addGatewayEventFilter(filter);
            }
            gateway.setBatchConflationEnabled(isConflation);
            if (isPersistent) {
                gateway.setPersistenceEnabled(true);
                gateway.setDiskStoreName(dsf.setDiskDirs(dirs1).create(dsName).getName());
            } else {
                DiskStore store = dsf.setDiskDirs(dirs1).create(dsName);
                gateway.setDiskStoreName(store.getName());
            }
            gateway.create(dsName, remoteDsId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startSender(String senderId) {
        DistributedTestCase.ExpectedException exln = WANCommandTestBase.addExpectedException("Could not connect");
        try {
            Set senders = cache.getGatewaySenders();
            GatewaySender sender = null;
            for (GatewaySender s : senders) {
                if (!s.getId().equals(senderId)) continue;
                sender = s;
                break;
            }
            sender.start();
        }
        finally {
            exln.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pauseSender(String senderId) {
        DistributedTestCase.ExpectedException exln = WANCommandTestBase.addExpectedException("Could not connect");
        try {
            Set senders = cache.getGatewaySenders();
            GatewaySender sender = null;
            for (GatewaySender s : senders) {
                if (!s.getId().equals(senderId)) continue;
                sender = s;
                break;
            }
            sender.pause();
        }
        finally {
            exln.remove();
        }
    }

    public static int createAndStartReceiver(int locPort) {
        WANCommandTestBase test = new WANCommandTestBase(testName);
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + locPort + "]");
        InternalDistributedSystem ds = test.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        GatewayReceiverFactory fact = cache.createGatewayReceiverFactory();
        int port = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        fact.setStartPort(port);
        fact.setEndPort(port);
        GatewayReceiver receiver = fact.create();
        try {
            receiver.start();
        }
        catch (IOException e) {
            e.printStackTrace();
            WANCommandTestBase.fail((String)("Test " + test.getName() + " failed to start GatewayRecevier"));
        }
        return port;
    }

    public static int createReceiver(int locPort) {
        WANCommandTestBase test = new WANCommandTestBase(testName);
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + locPort + "]");
        InternalDistributedSystem ds = test.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        GatewayReceiverFactory fact = cache.createGatewayReceiverFactory();
        int port = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        fact.setStartPort(port);
        fact.setEndPort(port);
        GatewayReceiver receiver = fact.create();
        return port;
    }

    public static int createReceiverWithGroup(int locPort, String groups) {
        WANCommandTestBase test = new WANCommandTestBase(testName);
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + locPort + "]");
        props.setProperty("groups", groups);
        InternalDistributedSystem ds = test.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        GatewayReceiverFactory fact = cache.createGatewayReceiverFactory();
        int port = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        fact.setStartPort(port);
        fact.setEndPort(port);
        GatewayReceiver receiver = fact.create();
        return port;
    }

    public static void startReceiver() {
        WANCommandTestBase test = new WANCommandTestBase(testName);
        try {
            Set receivers = cache.getGatewayReceivers();
            for (GatewayReceiver receiver : receivers) {
                receiver.start();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            WANCommandTestBase.fail((String)("Test " + test.getName() + " failed to start GatewayRecevier"));
        }
    }

    public static void stopReceiver() {
        WANCommandTestBase test = new WANCommandTestBase(testName);
        Set receivers = cache.getGatewayReceivers();
        for (GatewayReceiver receiver : receivers) {
            receiver.stop();
        }
    }

    public static int createAndStartReceiverWithGroup(int locPort, String groups) {
        WANCommandTestBase test = new WANCommandTestBase(testName);
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + locPort + "]");
        props.setProperty("groups", groups);
        InternalDistributedSystem ds = test.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        GatewayReceiverFactory fact = cache.createGatewayReceiverFactory();
        int port = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        fact.setStartPort(port);
        fact.setEndPort(port);
        GatewayReceiver receiver = fact.create();
        try {
            receiver.start();
        }
        catch (IOException e) {
            e.printStackTrace();
            WANCommandTestBase.fail((String)("Test " + test.getName() + " failed to start GatewayRecevier on port " + port));
        }
        return port;
    }

    public static DistributedMember getMember() {
        return cache.getDistributedSystem().getDistributedMember();
    }

    public static int getLocatorPort() {
        return ((Locator)Locator.getLocators().get(0)).getPort();
    }

    public void enableManagement() {
        WANCommandTestBase.invokeInEveryVM(new SerializableRunnable("Enable Management"){

            @Override
            public void run() {
                System.setProperty("gemfire.disableManagement", "false");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void verifySenderState(String senderId, boolean isRunning, boolean isPaused) {
        DistributedTestCase.ExpectedException exln = WANCommandTestBase.addExpectedException("Could not connect");
        try {
            Set senders = cache.getGatewaySenders();
            AbstractGatewaySender sender = null;
            for (GatewaySender s : senders) {
                if (!s.getId().equals(senderId)) continue;
                sender = (AbstractGatewaySender)s;
                break;
            }
            WANCommandTestBase.assertEquals((boolean)isRunning, (boolean)sender.isRunning());
            WANCommandTestBase.assertEquals((boolean)isPaused, (boolean)sender.isPaused());
        }
        finally {
            exln.remove();
        }
    }

    public static void verifySenderAttributes(String senderId, int remoteDsID, boolean isParallel, boolean manualStart, int socketBufferSize, int socketReadTimeout, boolean enableBatchConflation, int batchSize, int batchTimeInterval, boolean enablePersistence, boolean diskSynchronous, int maxQueueMemory, int alertThreshold, int dispatcherThreads, Gateway.OrderPolicy orderPolicy, List<String> expectedGatewayEventFilters, List<String> expectedGatewayTransportFilters) {
        Set senders = cache.getGatewaySenders();
        AbstractGatewaySender sender = null;
        for (GatewaySender s : senders) {
            if (!s.getId().equals(senderId)) continue;
            sender = (AbstractGatewaySender)s;
            break;
        }
        WANCommandTestBase.assertEquals((String)"remoteDistributedSystemId", (int)remoteDsID, (int)sender.getRemoteDSId());
        WANCommandTestBase.assertEquals((String)"isParallel", (boolean)isParallel, (boolean)sender.isParallel());
        WANCommandTestBase.assertEquals((String)"manualStart", (boolean)manualStart, (boolean)sender.isManualStart());
        WANCommandTestBase.assertEquals((String)"socketBufferSize", (int)socketBufferSize, (int)sender.getSocketBufferSize());
        WANCommandTestBase.assertEquals((String)"socketReadTimeout", (int)socketReadTimeout, (int)sender.getSocketReadTimeout());
        WANCommandTestBase.assertEquals((String)"enableBatchConflation", (boolean)enableBatchConflation, (boolean)sender.isBatchConflationEnabled());
        WANCommandTestBase.assertEquals((String)"batchSize", (int)batchSize, (int)sender.getBatchSize());
        WANCommandTestBase.assertEquals((String)"batchTimeInterval", (int)batchTimeInterval, (int)sender.getBatchTimeInterval());
        WANCommandTestBase.assertEquals((String)"enablePersistence", (boolean)enablePersistence, (boolean)sender.isPersistenceEnabled());
        WANCommandTestBase.assertEquals((String)"diskSynchronous", (boolean)diskSynchronous, (boolean)sender.isDiskSynchronous());
        WANCommandTestBase.assertEquals((String)"maxQueueMemory", (int)maxQueueMemory, (int)sender.getMaximumQueueMemory());
        WANCommandTestBase.assertEquals((String)"alertThreshold", (int)alertThreshold, (int)sender.getAlertThreshold());
        WANCommandTestBase.assertEquals((String)"dispatcherThreads", (int)dispatcherThreads, (int)sender.getDispatcherThreads());
        WANCommandTestBase.assertEquals((String)"orderPolicy", (Object)orderPolicy, (Object)sender.getOrderPolicy());
        if (expectedGatewayEventFilters != null) {
            WANCommandTestBase.assertEquals((String)"gatewayEventFilters", (int)expectedGatewayEventFilters.size(), (int)sender.getGatewayEventFilters().size());
            List actualGatewayEventFilters = sender.getGatewayEventFilters();
            ArrayList<String> actualEventFilterClassnames = new ArrayList<String>(actualGatewayEventFilters.size());
            for (GatewayEventFilter filter : actualGatewayEventFilters) {
                actualEventFilterClassnames.add(filter.getClass().getName());
            }
            for (String expectedGatewayEventFilter : expectedGatewayEventFilters) {
                if (actualEventFilterClassnames.contains(expectedGatewayEventFilter)) continue;
                WANCommandTestBase.fail((String)("GatewayEventFilter " + expectedGatewayEventFilter + " is not added to the GatewaySender"));
            }
        }
        if (expectedGatewayTransportFilters != null) {
            WANCommandTestBase.assertEquals((String)"gatewayTransportFilters", (int)expectedGatewayTransportFilters.size(), (int)sender.getGatewayTransportFilters().size());
            List actualGatewayTransportFilters = sender.getGatewayTransportFilters();
            ArrayList<String> actualTransportFilterClassnames = new ArrayList<String>(actualGatewayTransportFilters.size());
            for (GatewayEventFilter filter : actualGatewayTransportFilters) {
                actualTransportFilterClassnames.add(filter.getClass().getName());
            }
            for (String expectedGatewayTransportFilter : expectedGatewayTransportFilters) {
                if (actualTransportFilterClassnames.contains(expectedGatewayTransportFilter)) continue;
                WANCommandTestBase.fail((String)("GatewayTransportFilter " + expectedGatewayTransportFilter + " is not added to the GatewaySender."));
            }
        }
    }

    public static void verifyReceiverState(boolean isRunning) {
        WANCommandTestBase test = new WANCommandTestBase(testName);
        Set receivers = cache.getGatewayReceivers();
        for (GatewayReceiver receiver : receivers) {
            WANCommandTestBase.assertEquals((boolean)isRunning, (boolean)receiver.isRunning());
        }
    }

    public static void verifyReceiverCreationWithAttributes(boolean isRunning, int startPort, int endPort, String bindAddress, int maxTimeBetweenPings, int socketBufferSize, List<String> expectedGatewayTransportFilters) {
        WANCommandTestBase test = new WANCommandTestBase(testName);
        Set receivers = cache.getGatewayReceivers();
        WANCommandTestBase.assertEquals((String)"Number of receivers is incorrect", (int)1, (int)receivers.size());
        for (GatewayReceiver receiver : receivers) {
            WANCommandTestBase.assertEquals((String)"isRunning", (boolean)isRunning, (boolean)receiver.isRunning());
            WANCommandTestBase.assertEquals((String)"startPort", (int)startPort, (int)receiver.getStartPort());
            WANCommandTestBase.assertEquals((String)"endPort", (int)endPort, (int)receiver.getEndPort());
            WANCommandTestBase.assertEquals((String)"bindAddress", (String)bindAddress, (String)receiver.getBindAddress());
            WANCommandTestBase.assertEquals((String)"maximumTimeBetweenPings", (int)maxTimeBetweenPings, (int)receiver.getMaximumTimeBetweenPings());
            WANCommandTestBase.assertEquals((String)"socketBufferSize", (int)socketBufferSize, (int)receiver.getSocketBufferSize());
            if (expectedGatewayTransportFilters == null) continue;
            WANCommandTestBase.assertEquals((String)"gatewayTransportFilters", (int)expectedGatewayTransportFilters.size(), (int)receiver.getGatewayTransportFilters().size());
            List actualGatewayTransportFilters = receiver.getGatewayTransportFilters();
            ArrayList<String> actualTransportFilterClassnames = new ArrayList<String>(actualGatewayTransportFilters.size());
            for (GatewayTransportFilter filter : actualGatewayTransportFilters) {
                actualTransportFilterClassnames.add(filter.getClass().getName());
            }
            for (String expectedGatewayTransportFilter : expectedGatewayTransportFilters) {
                if (actualTransportFilterClassnames.contains(expectedGatewayTransportFilter)) continue;
                WANCommandTestBase.fail((String)("GatewayTransportFilter " + expectedGatewayTransportFilter + " is not added to the GatewayReceiver."));
            }
        }
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        WANCommandTestBase.closeCache();
        vm0.invoke(WANCommandTestBase.class, "closeCache");
        vm1.invoke(WANCommandTestBase.class, "closeCache");
        vm2.invoke(WANCommandTestBase.class, "closeCache");
        vm3.invoke(WANCommandTestBase.class, "closeCache");
        vm4.invoke(WANCommandTestBase.class, "closeCache");
        vm5.invoke(WANCommandTestBase.class, "closeCache");
        vm6.invoke(WANCommandTestBase.class, "closeCache");
        vm7.invoke(WANCommandTestBase.class, "closeCache");
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }
}

