/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan.parallel;

import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.ServerOperationException;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.RegionQueue;
import com.gemstone.gemfire.internal.cache.wan.BatchException70;
import com.gemstone.gemfire.internal.cache.wan.WANTestBase;
import com.gemstone.gemfire.internal.cache.wan.parallel.ParallelGatewaySenderImpl;
import dunit.AsyncInvocation;
import java.util.HashMap;
import java.util.Set;

public class ParallelWANPropogationDUnitTest
extends WANTestBase {
    private static final long serialVersionUID = 1L;

    public ParallelWANPropogationDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public void test_ParallelGatewaySenderMetaRegionNotExposedToUser_Bug44216() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        ParallelWANPropogationDUnitTest.createCache(lnPort);
        ParallelWANPropogationDUnitTest.createSender("ln", 2, true, 100, 300, false, false, null, true);
        ParallelWANPropogationDUnitTest.createPartitionedRegion(testName + "_PR", "ln", 1, 100, this.isOffHeap());
        Set senders = cache.getGatewaySenders();
        GatewaySender sender = null;
        for (GatewaySender s : senders) {
            if (!s.getId().equals("ln")) continue;
            sender = s;
            break;
        }
        try {
            sender.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            ParallelWANPropogationDUnitTest.fail((String)"Failed with IOException");
        }
        GemFireCacheImpl gemCache = (GemFireCacheImpl)cache;
        Set regionSet = gemCache.rootRegions();
        for (Object r : regionSet) {
            if (!((Region)r).getName().equals(((ParallelGatewaySenderImpl)sender).getQueues().toArray(new RegionQueue[1])[0].getRegion().getName())) continue;
            ParallelWANPropogationDUnitTest.fail((String)"The shadowPR is exposed to the user");
        }
    }

    public void testParallelPropagation_withoutRemoteSite() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 300, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 300, false, false, null, true});
        vm6.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 300, false, false, null, true});
        vm7.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 300, false, false, null, true});
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "setRemoveFromQueueOnException", new Object[]{"ln", false});
        vm5.invoke(WANTestBase.class, "setRemoveFromQueueOnException", new Object[]{"ln", false});
        vm6.invoke(WANTestBase.class, "setRemoveFromQueueOnException", new Object[]{"ln", false});
        vm7.invoke(WANTestBase.class, "setRemoveFromQueueOnException", new Object[]{"ln", false});
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 1000});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 1000});
    }

    public void testParallelPropagation() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm6.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm7.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 1000});
        vm4.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 1000});
    }

    public void testParallelPropagation_ManualStart() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, false});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, false});
        vm6.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, false});
        vm7.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, false});
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 1000});
        vm4.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 1000});
    }

    public void testParallelPropagationPutBeforeSenderStart() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm6.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm7.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 1000});
        AsyncInvocation inv1 = vm4.invokeAsync(WANTestBase.class, "startSender", new Object[]{"ln"});
        AsyncInvocation inv2 = vm5.invokeAsync(WANTestBase.class, "startSender", new Object[]{"ln"});
        AsyncInvocation inv3 = vm6.invokeAsync(WANTestBase.class, "startSender", new Object[]{"ln"});
        AsyncInvocation inv4 = vm7.invokeAsync(WANTestBase.class, "startSender", new Object[]{"ln"});
        try {
            inv1.join();
            inv2.join();
            inv3.join();
            inv4.join();
        }
        catch (InterruptedException ie) {
            ParallelWANPropogationDUnitTest.fail((String)"Caught interrupted exception");
        }
        vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 1000});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 1000});
    }

    public void testParallelPropagationWithLocalCacheClosedAndRebuilt() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm6.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm7.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 1000});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 1000});
        vm4.invoke(WANTestBase.class, "killSender", new Object[0]);
        vm5.invoke(WANTestBase.class, "killSender", new Object[0]);
        vm6.invoke(WANTestBase.class, "killSender", new Object[0]);
        vm7.invoke(WANTestBase.class, "killSender", new Object[0]);
        Integer regionSize = (Integer)vm2.invoke(WANTestBase.class, "getRegionSize", new Object[]{testName + "_PR"});
        ParallelWANPropogationDUnitTest.getLogWriter().info("Region size on remote is: " + regionSize);
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm6.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm7.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm4.invoke(WANTestBase.class, "setRemoveFromQueueOnException", new Object[]{"ln", true});
        vm5.invoke(WANTestBase.class, "setRemoveFromQueueOnException", new Object[]{"ln", true});
        vm6.invoke(WANTestBase.class, "setRemoveFromQueueOnException", new Object[]{"ln", true});
        vm7.invoke(WANTestBase.class, "setRemoveFromQueueOnException", new Object[]{"ln", true});
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        ParallelWANPropogationDUnitTest.addExpectedException(EntryExistsException.class.getName());
        ParallelWANPropogationDUnitTest.addExpectedException(BatchException70.class.getName());
        ParallelWANPropogationDUnitTest.addExpectedException(ServerOperationException.class.getName());
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 1000});
        vm4.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 1000});
        vm3.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 1000});
    }

    public void testParallelColocatedPropagation() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm6.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm7.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm4.invoke(WANTestBase.class, "createColocatedPartitionedRegions", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createColocatedPartitionedRegions", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createColocatedPartitionedRegions", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createColocatedPartitionedRegions", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "createColocatedPartitionedRegions", new Object[]{testName, null, 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createColocatedPartitionedRegions", new Object[]{testName, null, 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName, 1000});
        vm4.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName, 1000});
    }

    public void testParallelColocatedPropagation2() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm6.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm7.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm4.invoke(WANTestBase.class, "createColocatedPartitionedRegions2", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createColocatedPartitionedRegions2", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createColocatedPartitionedRegions2", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createColocatedPartitionedRegions2", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "createColocatedPartitionedRegions2", new Object[]{testName, null, 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createColocatedPartitionedRegions2", new Object[]{testName, null, 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName, 1000});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_child1", 1000});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_child2", 1000});
        vm4.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName, 1000});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_child1", 0});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_child2", 0});
    }

    public void testParallelPropagationWihtOverflow() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm6.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm7.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, null, 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, null, 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "doHeavyPuts", new Object[]{testName, 150});
        vm4.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName, 150});
    }

    public void testSerialReplicatedAndParallePartitionedPropagation() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"lnSerial", 2, false, 100, 10, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"lnSerial", 2, false, 100, 10, false, false, null, true});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"lnParallel", 2, true, 100, 10, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"lnParallel", 2, true, 100, 10, false, false, null, true});
        vm6.invoke(WANTestBase.class, "createSender", new Object[]{"lnParallel", 2, true, 100, 10, false, false, null, true});
        vm7.invoke(WANTestBase.class, "createSender", new Object[]{"lnParallel", 2, true, 100, 10, false, false, null, true});
        vm2.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", null, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", null, this.isOffHeap()});
        vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "lnSerial", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "lnSerial", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "lnSerial", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "lnSerial", this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "lnParallel", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "lnParallel", 1, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "lnParallel", 1, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "lnParallel", 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"lnSerial"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"lnSerial"});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"lnParallel"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"lnParallel"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"lnParallel"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"lnParallel"});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_RR", 1000});
        vm5.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 1000});
        vm4.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"lnParallel"});
        vm5.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"lnParallel"});
        vm6.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"lnParallel"});
        vm7.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"lnParallel"});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 1000});
        vm3.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 1000});
    }

    public void testPartitionedParallelPropagationToTwoWanSites() throws Exception {
        Integer lnPort = ParallelWANPropogationDUnitTest.createFirstLocatorWithDSId(1);
        Integer nyPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        Integer tkPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{3, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{tkPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"lnParallel1", 2, true, 100, 10, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"lnParallel1", 2, true, 100, 10, false, false, null, true});
        vm6.invoke(WANTestBase.class, "createSender", new Object[]{"lnParallel1", 2, true, 100, 10, false, false, null, true});
        vm7.invoke(WANTestBase.class, "createSender", new Object[]{"lnParallel1", 2, true, 100, 10, false, false, null, true});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"lnParallel2", 3, true, 100, 10, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"lnParallel2", 3, true, 100, 10, false, false, null, true});
        vm6.invoke(WANTestBase.class, "createSender", new Object[]{"lnParallel2", 3, true, 100, 10, false, false, null, true});
        vm7.invoke(WANTestBase.class, "createSender", new Object[]{"lnParallel2", 3, true, 100, 10, false, false, null, true});
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "lnParallel1,lnParallel2", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "lnParallel1,lnParallel2", 1, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "lnParallel1,lnParallel2", 1, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "lnParallel1,lnParallel2", 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"lnParallel1"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"lnParallel1"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"lnParallel1"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"lnParallel1"});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"lnParallel2"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"lnParallel2"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"lnParallel2"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"lnParallel2"});
        vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"lnParallel1"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"lnParallel1"});
        vm6.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"lnParallel1"});
        vm7.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"lnParallel1"});
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"lnParallel2"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"lnParallel2"});
        vm6.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"lnParallel2"});
        vm7.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"lnParallel2"});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 1000});
        vm4.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"lnParallel1"});
        vm5.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"lnParallel1"});
        vm6.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"lnParallel1"});
        vm7.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"lnParallel1"});
        vm4.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"lnParallel2"});
        vm5.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"lnParallel2"});
        vm6.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"lnParallel2"});
        vm7.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"lnParallel2"});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 1000});
        vm3.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 1000});
    }

    public void testPartitionedParallelPropagationHA() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm6.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm7.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm4.invoke(WANTestBase.class, "setRemoveFromQueueOnException", new Object[]{"ln", true});
        vm5.invoke(WANTestBase.class, "setRemoveFromQueueOnException", new Object[]{"ln", true});
        vm6.invoke(WANTestBase.class, "setRemoveFromQueueOnException", new Object[]{"ln", true});
        vm7.invoke(WANTestBase.class, "setRemoveFromQueueOnException", new Object[]{"ln", true});
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 2, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 2, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 2, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 2, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        AsyncInvocation inv1 = vm7.invokeAsync(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 5000});
        ParallelWANPropogationDUnitTest.pause(500);
        AsyncInvocation inv2 = vm4.invokeAsync(WANTestBase.class, "killSender");
        AsyncInvocation inv3 = vm6.invokeAsync(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 10000});
        ParallelWANPropogationDUnitTest.pause(1500);
        AsyncInvocation inv4 = vm5.invokeAsync(WANTestBase.class, "killSender");
        inv1.join();
        inv2.join();
        inv3.join();
        inv4.join();
        vm6.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 10000});
        vm7.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 10000});
        vm6.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 10000});
        vm3.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 10000});
    }

    public void testParallelPropagationWithFilter() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, new WANTestBase.MyGatewayEventFilter(), true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, new WANTestBase.MyGatewayEventFilter(), true});
        vm6.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, new WANTestBase.MyGatewayEventFilter(), true});
        vm7.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, new WANTestBase.MyGatewayEventFilter(), true});
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, null, 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName, null, 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName, 1000});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName, 800});
    }

    public void testParallelPropagationWithPutAll() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm6.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm7.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "doPutAll", new Object[]{testName + "_PR", 100, 50});
        vm4.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 5000});
    }

    public void testParallelPropagationWithDestroy() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 100, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 100, false, false, null, true});
        vm6.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 100, false, false, null, true});
        vm7.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 100, false, false, null, true});
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        ParallelWANPropogationDUnitTest.pause(2000);
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 1000});
        vm4.invoke(WANTestBase.class, "doDestroys", new Object[]{testName + "_PR", 500});
        vm4.invoke(WANTestBase.class, "validateParallelSenderQueueBucketSize", new Object[]{"ln", 15});
        vm5.invoke(WANTestBase.class, "validateParallelSenderQueueBucketSize", new Object[]{"ln", 15});
        vm6.invoke(WANTestBase.class, "validateParallelSenderQueueBucketSize", new Object[]{"ln", 15});
        vm7.invoke(WANTestBase.class, "validateParallelSenderQueueBucketSize", new Object[]{"ln", 15});
        vm4.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
        ParallelWANPropogationDUnitTest.pause(5000);
        vm4.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 500});
        vm3.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 500});
    }

    public void testParallelPropagationForMixedWANConfiguration() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        Integer tkPort = (Integer)vm2.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{3, lnPort});
        ParallelWANPropogationDUnitTest.getLogWriter().info("Created the locators");
        Integer vm3ReceiverPort = (Integer)vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{lnPort});
        Integer vm4ReceiverPort = (Integer)vm4.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        Integer vm5ReceiverPort = (Integer)vm5.invoke(WANTestBase.class, "createReceiver", new Object[]{tkPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{nyPort});
        ParallelWANPropogationDUnitTest.getLogWriter().info("Created the cache and receivers");
        HashMap<String, Integer> gatewayInfo = new HashMap<String, Integer>();
        gatewayInfo.put("ny", vm4ReceiverPort);
        gatewayInfo.put("tk", vm5ReceiverPort);
        vm3.invoke(WANTestBase.class, "createGatewayHub", new Object[]{"GatewayHubln", gatewayInfo});
        ParallelWANPropogationDUnitTest.getLogWriter().info("Created GatewayHub on site1");
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ny1", 1, true, 100, 10, false, false, null, true});
        vm7.invoke(WANTestBase.class, "createSender", new Object[]{"ny1", 1, true, 100, 10, false, false, null, true});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ny2", 3, true, 100, 10, false, false, null, true});
        vm7.invoke(WANTestBase.class, "createSender", new Object[]{"ny2", 3, true, 100, 10, false, false, null, true});
        ParallelWANPropogationDUnitTest.getLogWriter().info("Created senders on site2");
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"tk1", 1, true, 100, 10, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"tk2", 2, true, 100, 10, false, false, null, true});
        ParallelWANPropogationDUnitTest.getLogWriter().info("Created senders on site3");
        vm3.invoke(WANTestBase.class, "createPartitionedRegion_WithGatewayEnabled", new Object[]{testName + "_PR", 0, 1, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegion_WithGatewayEnabled", new Object[]{testName + "_PR", 0, 1, this.isOffHeap()});
        ParallelWANPropogationDUnitTest.getLogWriter().info("Created PR on site1");
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ny1,ny2", 0, 1, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ny1,ny2", 0, 1, this.isOffHeap()});
        ParallelWANPropogationDUnitTest.getLogWriter().info("Created PR on site2");
        vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "tk1,tk2", 0, 1, this.isOffHeap()});
        ParallelWANPropogationDUnitTest.getLogWriter().info("Created PR on site3");
        vm3.invoke(WANTestBase.class, "startGatewayHub", new Object[]{"GatewayHubln"});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ny1"});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ny2"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ny1"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ny2"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"tk1"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"tk2"});
        ParallelWANPropogationDUnitTest.getLogWriter().info("Started senders on site2 and site3");
        ParallelWANPropogationDUnitTest.pause(2000);
        vm3.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 300});
        vm4.invoke(WANTestBase.class, "doNextPuts", new Object[]{testName + "_PR", 300, 600});
        vm5.invoke(WANTestBase.class, "doNextPuts", new Object[]{testName + "_PR", 600, 1000});
        ParallelWANPropogationDUnitTest.getLogWriter().info("Done puts on site1, site2 and site3");
        vm6.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 1000});
        vm7.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 1000});
        vm5.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 1000});
    }

    public void testParallelPropagationTxOperations() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "doTxPuts", new Object[]{testName + "_PR", 1000});
        vm4.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 3});
    }

    public void testParallelGatewaySenderQueueLocalSize() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        ParallelWANPropogationDUnitTest.pause(1000);
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 10});
        vm4.invoke(WANTestBase.class, "checkPRQLocalSize", new Object[]{"ln", 5});
        vm5.invoke(WANTestBase.class, "checkPRQLocalSize", new Object[]{"ln", 5});
    }

    public void testParallelGatewaySenderQueueLocalSizeWithHA() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        ParallelWANPropogationDUnitTest.pause(1000);
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 10});
        vm4.invoke(WANTestBase.class, "checkPRQLocalSize", new Object[]{"ln", 5});
        vm5.invoke(WANTestBase.class, "checkPRQLocalSize", new Object[]{"ln", 5});
        vm5.invoke(WANTestBase.class, "killSender", new Object[0]);
        ParallelWANPropogationDUnitTest.pause(1000);
        vm4.invoke(WANTestBase.class, "checkPRQLocalSize", new Object[]{"ln", 10});
    }

    public void testParallelSenderAttachedToChildRegionButNotToParentRegion() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm3.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true});
        vm3.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm3.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "PARENT_PR", null, 0, 100, this.isOffHeap()});
        String parentRegionFullPath = (String)vm3.invoke(WANTestBase.class, "getRegionFullPath", new Object[]{testName + "PARENT_PR"});
        vm3.invoke(WANTestBase.class, "createColocatedPartitionedRegion", new Object[]{testName + "CHILD_PR", "ln", 0, 100, parentRegionFullPath, this.isOffHeap()});
        vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "PARENT_PR", null, 0, 100, this.isOffHeap()});
        vm2.invoke(WANTestBase.class, "createColocatedPartitionedRegion", new Object[]{testName + "CHILD_PR", null, 0, 100, parentRegionFullPath, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "CHILD_PR", 1000});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "CHILD_PR", 1000});
    }
}

