/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan.concurrent;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySender;
import com.gemstone.gemfire.internal.cache.wan.WANTestBase;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;

public class ConcurrentParallelGatewaySenderOperation_2_DUnitTest
extends WANTestBase {
    private static final long serialVersionUID = 1L;

    public ConcurrentParallelGatewaySenderOperation_2_DUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public void testParallelGatewaySender_SingleNode_UserPR_localDestroy_RecreateRegion() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        try {
            vm4.invoke(ConcurrentParallelGatewaySenderOperation_2_DUnitTest.class, "createCache_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME", new Object[]{lnPort});
            vm4.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, false, 5, Gateway.OrderPolicy.KEY});
            vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
            vm4.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
            vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 10, this.isOffHeap()});
            ConcurrentParallelGatewaySenderOperation_2_DUnitTest.getLogWriter().info("Created PRs on local site");
            vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 10, this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 10});
            vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 10});
            vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 0});
            vm4.invoke(WANTestBase.class, "localDestroyRegion", new Object[]{testName + "_PR"});
            vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 0});
            vm4.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
            vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 10, this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "doPutsFrom", new Object[]{testName + "_PR", 10, 20});
            vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 10});
            vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 10});
        }
        finally {
            vm4.invoke(ConcurrentParallelGatewaySenderOperation_2_DUnitTest.class, "clear_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME");
        }
    }

    public void testParallelGatewaySender_SingleNode_UserPR_Destroy_RecreateRegion() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        try {
            vm4.invoke(ConcurrentParallelGatewaySenderOperation_2_DUnitTest.class, "createCache_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME", new Object[]{lnPort});
            vm4.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, false, 4, Gateway.OrderPolicy.KEY});
            vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
            vm4.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
            vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 10, this.isOffHeap()});
            ConcurrentParallelGatewaySenderOperation_2_DUnitTest.getLogWriter().info("Created PRs on local site");
            vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 10, this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 10});
            vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 10});
            vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 0});
            vm4.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
            vm4.invoke(WANTestBase.class, "destroyRegion", new Object[]{testName + "_PR"});
            vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 10});
            vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 10, this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "doPutsFrom", new Object[]{testName + "_PR", 10, 20});
            vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 10});
            vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 20});
        }
        finally {
            vm4.invoke(ConcurrentParallelGatewaySenderOperation_2_DUnitTest.class, "clear_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME");
        }
    }

    public void testParallelGatewaySender_SingleNode_UserPR_Close_RecreateRegion() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(ConcurrentParallelGatewaySenderOperation_2_DUnitTest.class, "createCache_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME", new Object[]{lnPort});
        ConcurrentParallelGatewaySenderOperation_2_DUnitTest.getLogWriter().info("Created cache on local site");
        ConcurrentParallelGatewaySenderOperation_2_DUnitTest.getLogWriter().info("Created senders on local site");
        vm4.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, false, 7, Gateway.OrderPolicy.KEY});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 10, this.isOffHeap()});
        ConcurrentParallelGatewaySenderOperation_2_DUnitTest.getLogWriter().info("Created PRs on local site");
        vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 10, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 10});
        vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 10});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 0});
        vm4.invoke(ConcurrentParallelGatewaySenderOperation_2_DUnitTest.class, "closeRegion", new Object[]{testName + "_PR"});
        vm4.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
        ConcurrentParallelGatewaySenderOperation_2_DUnitTest.pause(500);
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 0});
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 10, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "doPutsFrom", new Object[]{testName + "_PR", 10, 20});
        vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 10});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 10});
        vm4.invoke(ConcurrentParallelGatewaySenderOperation_2_DUnitTest.class, "clear_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParallelGatewaySender_SingleNode_UserPR_localDestroy_SimultenuousPut_RecreateRegion() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        try {
            vm4.invoke(ConcurrentParallelGatewaySenderOperation_2_DUnitTest.class, "createCache_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME", new Object[]{lnPort});
            ConcurrentParallelGatewaySenderOperation_2_DUnitTest.getLogWriter().info("Created cache on local site");
            ConcurrentParallelGatewaySenderOperation_2_DUnitTest.getLogWriter().info("Created senders on local site");
            vm4.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, false, 5, Gateway.OrderPolicy.KEY});
            vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
            vm4.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
            vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 10, this.isOffHeap()});
            ConcurrentParallelGatewaySenderOperation_2_DUnitTest.getLogWriter().info("Created PRs on local site");
            vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 10, this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 10});
            vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 10});
            vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 0});
            AsyncInvocation putAsync = vm4.invokeAsync(WANTestBase.class, "doPutsFrom", new Object[]{testName + "_PR", 100, 2000});
            AsyncInvocation localDestroyAsync = vm4.invokeAsync(WANTestBase.class, "localDestroyRegion", new Object[]{testName + "_PR"});
            try {
                putAsync.join();
                localDestroyAsync.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                ConcurrentParallelGatewaySenderOperation_2_DUnitTest.fail((String)"Interrupted the async invocation.");
            }
            if (localDestroyAsync.getException() != null) {
                ConcurrentParallelGatewaySenderOperation_2_DUnitTest.fail("Not Expected Exception got", putAsync.getException());
            }
            if (putAsync.getException() != null && !(putAsync.getException() instanceof RegionDestroyedException)) {
                ConcurrentParallelGatewaySenderOperation_2_DUnitTest.fail("Expected RegionDestroyedException but got", putAsync.getException());
            }
            vm4.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
            ConcurrentParallelGatewaySenderOperation_2_DUnitTest.pause(500);
            vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 0});
            vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 10, this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "doPutsFrom", new Object[]{testName + "_PR", 10, 20});
            vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 10});
            vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 10});
        }
        finally {
            vm4.invoke(ConcurrentParallelGatewaySenderOperation_2_DUnitTest.class, "clear_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParallelGatewaySender_SingleNode_UserPR_Destroy_SimultenuousPut_RecreateRegion() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        try {
            vm4.invoke(ConcurrentParallelGatewaySenderOperation_2_DUnitTest.class, "createCache_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME", new Object[]{lnPort});
            vm4.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, false, 6, Gateway.OrderPolicy.KEY});
            vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
            vm4.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
            vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 10, true});
            vm4.invoke(WANTestBase.class, "addCacheListenerAndDestroyRegion", new Object[]{testName + "_PR"});
            ConcurrentParallelGatewaySenderOperation_2_DUnitTest.getLogWriter().info("Created PRs on local site");
            vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 10, this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 10});
            vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 10});
            vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 0});
            vm4.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
            AsyncInvocation putAsync = vm4.invokeAsync(WANTestBase.class, "doPutsFrom", new Object[]{testName + "_PR", 10, 101});
            try {
                putAsync.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                ConcurrentParallelGatewaySenderOperation_2_DUnitTest.fail((String)"Interrupted the async invocation.");
            }
            if (putAsync.getException() != null && !(putAsync.getException() instanceof RegionDestroyedException)) {
                ConcurrentParallelGatewaySenderOperation_2_DUnitTest.fail("Expected RegionDestroyedException but got", putAsync.getException());
            }
            vm2.invoke(ConcurrentParallelGatewaySenderOperation_2_DUnitTest.class, "validateRegionSizeWithinRange", new Object[]{testName + "_PR", 10, 101});
            vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 10, this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "doPutsFrom", new Object[]{testName + "_PR", 10, 20});
            vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 10});
            vm2.invoke(ConcurrentParallelGatewaySenderOperation_2_DUnitTest.class, "validateRegionSizeWithinRange", new Object[]{testName + "_PR", 20, 101});
        }
        finally {
            vm4.invoke(ConcurrentParallelGatewaySenderOperation_2_DUnitTest.class, "clear_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParallelGatewaySender_SingleNode_UserPR_Destroy_NodeDown() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        try {
            vm4.invoke(ConcurrentParallelGatewaySenderOperation_2_DUnitTest.class, "createCache_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME", new Object[]{lnPort});
            vm5.invoke(ConcurrentParallelGatewaySenderOperation_2_DUnitTest.class, "createCache_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME", new Object[]{lnPort});
            vm6.invoke(ConcurrentParallelGatewaySenderOperation_2_DUnitTest.class, "createCache_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME", new Object[]{lnPort});
            vm4.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, false, 5, Gateway.OrderPolicy.KEY});
            vm5.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, false, 5, Gateway.OrderPolicy.KEY});
            vm6.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, false, 5, Gateway.OrderPolicy.KEY});
            vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
            vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
            vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
            vm4.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
            vm5.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
            vm6.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
            vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 10, this.isOffHeap()});
            vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 10, this.isOffHeap()});
            vm6.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 10, this.isOffHeap()});
            ConcurrentParallelGatewaySenderOperation_2_DUnitTest.getLogWriter().info("Created PRs on local site");
            vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 10, this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 10000});
            vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 10000});
            vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 0});
            vm4.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
            vm5.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
            vm6.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
            ConcurrentParallelGatewaySenderOperation_2_DUnitTest.pause(200);
            AsyncInvocation localDestroyAsync = vm4.invokeAsync(WANTestBase.class, "destroyRegion", new Object[]{testName + "_PR"});
            AsyncInvocation closeAsync = vm4.invokeAsync(WANTestBase.class, "closeCache");
            try {
                localDestroyAsync.join();
                closeAsync.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                ConcurrentParallelGatewaySenderOperation_2_DUnitTest.fail((String)"Interrupted the async invocation.");
            }
            vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 10000});
        }
        finally {
            vm4.invoke(ConcurrentParallelGatewaySenderOperation_2_DUnitTest.class, "clear_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME");
            vm5.invoke(ConcurrentParallelGatewaySenderOperation_2_DUnitTest.class, "clear_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME");
            vm6.invoke(ConcurrentParallelGatewaySenderOperation_2_DUnitTest.class, "clear_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParallelGatewaySender_SingleNode_UserPR_Close_SimultenuousPut_RecreateRegion() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        try {
            vm4.invoke(ConcurrentParallelGatewaySenderOperation_2_DUnitTest.class, "createCache_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME", new Object[]{lnPort});
            ConcurrentParallelGatewaySenderOperation_2_DUnitTest.getLogWriter().info("Created cache on local site");
            ConcurrentParallelGatewaySenderOperation_2_DUnitTest.getLogWriter().info("Created senders on local site");
            vm4.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, false, 5, Gateway.OrderPolicy.KEY});
            vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
            vm4.invoke(WANTestBase.class, "pauseSender", new Object[]{"ln"});
            vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 10, this.isOffHeap()});
            ConcurrentParallelGatewaySenderOperation_2_DUnitTest.getLogWriter().info("Created PRs on local site");
            vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 10, this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 10});
            vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 10});
            vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 0});
            AsyncInvocation putAsync = vm4.invokeAsync(WANTestBase.class, "doPutsFrom", new Object[]{testName + "_PR", 10, 2000});
            AsyncInvocation localDestroyAsync = vm4.invokeAsync(ConcurrentParallelGatewaySenderOperation_2_DUnitTest.class, "closeRegion", new Object[]{testName + "_PR"});
            try {
                putAsync.join();
                localDestroyAsync.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                ConcurrentParallelGatewaySenderOperation_2_DUnitTest.fail((String)"Interrupted the async invocation.");
            }
            vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 0});
            vm4.invoke(WANTestBase.class, "resumeSender", new Object[]{"ln"});
            vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 10, this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "doPutsFrom", new Object[]{testName + "_PR", 10, 20});
            vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 10});
            vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 10});
        }
        finally {
            vm4.invoke(ConcurrentParallelGatewaySenderOperation_2_DUnitTest.class, "clear_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParallelGatewaySenders_SingleNode_UserPR_localDestroy_RecreateRegion() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        Integer tkPort = (Integer)vm2.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{3, lnPort});
        Integer pnPort = (Integer)vm3.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{4, lnPort});
        vm4.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm5.invoke(WANTestBase.class, "createReceiver", new Object[]{tkPort});
        vm6.invoke(WANTestBase.class, "createReceiver", new Object[]{pnPort});
        try {
            vm7.invoke(ConcurrentParallelGatewaySenderOperation_2_DUnitTest.class, "createCache_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME", new Object[]{lnPort});
            ConcurrentParallelGatewaySenderOperation_2_DUnitTest.getLogWriter().info("Created cache on local site");
            vm7.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln1", 2, true, 100, 10, false, false, null, true, 5, Gateway.OrderPolicy.KEY});
            vm7.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln2", 3, true, 100, 10, false, false, null, true, 5, Gateway.OrderPolicy.KEY});
            vm7.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln3", 4, true, 100, 10, false, false, null, true, 5, Gateway.OrderPolicy.KEY});
            vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln1"});
            vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln2"});
            vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln3"});
            vm7.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln1,ln2,ln3", 1, 10, this.isOffHeap()});
            ConcurrentParallelGatewaySenderOperation_2_DUnitTest.getLogWriter().info("Created PRs on local site");
            vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 10, this.isOffHeap()});
            vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 10, this.isOffHeap()});
            vm6.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 10, this.isOffHeap()});
            vm7.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 10});
            ConcurrentParallelGatewaySenderOperation_2_DUnitTest.pause(1000);
            vm7.invoke(WANTestBase.class, "localDestroyRegion", new Object[]{testName + "_PR"});
            vm7.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln1,ln2,ln3", 1, 10, this.isOffHeap()});
            vm7.invoke(WANTestBase.class, "doPutsFrom", new Object[]{testName + "_PR", 10, 20});
            vm7.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 10});
            vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 20});
            vm5.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 20});
            vm6.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 20});
        }
        finally {
            vm7.invoke(ConcurrentParallelGatewaySenderOperation_2_DUnitTest.class, "clear_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParallelGatewaySender_MultipleNode_UserPR_localDestroy_Recreate() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        try {
            vm4.invoke(ConcurrentParallelGatewaySenderOperation_2_DUnitTest.class, "createCache_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME", new Object[]{lnPort});
            vm5.invoke(ConcurrentParallelGatewaySenderOperation_2_DUnitTest.class, "createCache_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME", new Object[]{lnPort});
            vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
            vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true, 5, Gateway.OrderPolicy.KEY});
            vm5.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true, 5, Gateway.OrderPolicy.KEY});
            vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
            vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
            ConcurrentParallelGatewaySenderOperation_2_DUnitTest.getLogWriter().info("Created PRs on local site");
            vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
            AsyncInvocation inv1 = vm4.invokeAsync(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 1000});
            ConcurrentParallelGatewaySenderOperation_2_DUnitTest.pause(1000);
            vm5.invoke(WANTestBase.class, "localDestroyRegion", new Object[]{testName + "_PR"});
            try {
                inv1.join();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
                ConcurrentParallelGatewaySenderOperation_2_DUnitTest.fail((String)"Interrupted the async invocation.");
            }
            vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 1000});
            vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 1000});
            vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "doPutsFrom", new Object[]{testName + "_PR", 1000, 2000});
            vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 2000});
            vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 2000});
        }
        finally {
            vm4.invoke(ConcurrentParallelGatewaySenderOperation_2_DUnitTest.class, "clear_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME");
            vm5.invoke(ConcurrentParallelGatewaySenderOperation_2_DUnitTest.class, "clear_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParallelGatewaySenders_MultiplNode_UserPR_localDestroy_Recreate() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        Integer tkPort = (Integer)vm2.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{3, lnPort});
        vm6.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm7.invoke(WANTestBase.class, "createReceiver", new Object[]{tkPort});
        try {
            vm4.invoke(ConcurrentParallelGatewaySenderOperation_2_DUnitTest.class, "createCache_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME", new Object[]{lnPort});
            vm5.invoke(ConcurrentParallelGatewaySenderOperation_2_DUnitTest.class, "createCache_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME", new Object[]{lnPort});
            vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln1,ln2", 1, 100, this.isOffHeap()});
            vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln1,ln2", 1, 100, this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln1", 2, true, 100, 10, false, false, null, true, 4, Gateway.OrderPolicy.KEY});
            vm4.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln2", 3, true, 100, 10, false, false, null, true, 4, Gateway.OrderPolicy.KEY});
            vm5.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln1", 2, true, 100, 10, false, false, null, true, 4, Gateway.OrderPolicy.KEY});
            vm5.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln2", 3, true, 100, 10, false, false, null, true, 4, Gateway.OrderPolicy.KEY});
            vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln1"});
            vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln2"});
            vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln1"});
            vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln2"});
            vm6.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
            vm7.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
            AsyncInvocation inv1 = vm4.invokeAsync(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 1000});
            ConcurrentParallelGatewaySenderOperation_2_DUnitTest.pause(1000);
            vm5.invoke(WANTestBase.class, "localDestroyRegion", new Object[]{testName + "_PR"});
            try {
                inv1.join();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
                ConcurrentParallelGatewaySenderOperation_2_DUnitTest.fail((String)"Interrupted the async invocation.");
            }
            vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 1000});
            vm6.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 1000});
            vm7.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 1000});
            vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln1,ln2", 1, 100, this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "doPutsFrom", new Object[]{testName + "_PR", 1000, 2000});
            vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 2000});
            vm6.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 2000});
            vm7.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 2000});
        }
        finally {
            vm4.invoke(ConcurrentParallelGatewaySenderOperation_2_DUnitTest.class, "clear_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME");
            vm5.invoke(ConcurrentParallelGatewaySenderOperation_2_DUnitTest.class, "clear_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParallelGatewaySender_ColocatedPartitionedRegions_localDestroy() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        try {
            vm4.invoke(ConcurrentParallelGatewaySenderOperation_2_DUnitTest.class, "createCache_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME", new Object[]{lnPort});
            vm5.invoke(ConcurrentParallelGatewaySenderOperation_2_DUnitTest.class, "createCache_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME", new Object[]{lnPort});
            vm4.invoke(WANTestBase.class, "createCustomerOrderShipmentPartitionedRegion", new Object[]{null, "ln", 1, 100, this.isOffHeap()});
            vm5.invoke(WANTestBase.class, "createCustomerOrderShipmentPartitionedRegion", new Object[]{null, "ln", 1, 100, this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true, 5, Gateway.OrderPolicy.KEY});
            vm5.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true, 5, Gateway.OrderPolicy.KEY});
            vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
            vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
            ConcurrentParallelGatewaySenderOperation_2_DUnitTest.getLogWriter().info("Created PRs on local site");
            vm2.invoke(WANTestBase.class, "createCustomerOrderShipmentPartitionedRegion", new Object[]{null, null, 1, 100, this.isOffHeap()});
            AsyncInvocation inv1 = vm4.invokeAsync(WANTestBase.class, "putcolocatedPartitionedRegion", new Object[]{2000});
            ConcurrentParallelGatewaySenderOperation_2_DUnitTest.pause(1000);
            try {
                vm5.invoke(WANTestBase.class, "localDestroyRegion", new Object[]{"CUSTOMER"});
            }
            catch (Exception ex) {
                ConcurrentParallelGatewaySenderOperation_2_DUnitTest.assertTrue((boolean)(ex.getCause() instanceof UnsupportedOperationException));
            }
            try {
                inv1.join();
            }
            catch (Exception e) {
                ConcurrentParallelGatewaySenderOperation_2_DUnitTest.fail("Unexpected exception", e);
            }
            vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{"CUSTOMER", 2000});
            vm5.invoke(WANTestBase.class, "validateRegionSize", new Object[]{"CUSTOMER", 2000});
            vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{"CUSTOMER", 2000});
        }
        finally {
            vm4.invoke(ConcurrentParallelGatewaySenderOperation_2_DUnitTest.class, "clear_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME");
            vm5.invoke(ConcurrentParallelGatewaySenderOperation_2_DUnitTest.class, "clear_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParallelGatewaySender_ColocatedPartitionedRegions_destroy() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        try {
            vm4.invoke(ConcurrentParallelGatewaySenderOperation_2_DUnitTest.class, "createCache_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME", new Object[]{lnPort});
            vm5.invoke(ConcurrentParallelGatewaySenderOperation_2_DUnitTest.class, "createCache_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME", new Object[]{lnPort});
            vm4.invoke(WANTestBase.class, "createCustomerOrderShipmentPartitionedRegion", new Object[]{null, "ln", 1, 100, this.isOffHeap()});
            vm5.invoke(WANTestBase.class, "createCustomerOrderShipmentPartitionedRegion", new Object[]{null, "ln", 1, 100, this.isOffHeap()});
            vm4.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true, 6, Gateway.OrderPolicy.KEY});
            vm5.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true, 6, Gateway.OrderPolicy.KEY});
            vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
            vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
            ConcurrentParallelGatewaySenderOperation_2_DUnitTest.getLogWriter().info("Created PRs on local site");
            vm2.invoke(WANTestBase.class, "createCustomerOrderShipmentPartitionedRegion", new Object[]{null, null, 1, 100, this.isOffHeap()});
            AsyncInvocation inv1 = vm4.invokeAsync(WANTestBase.class, "putcolocatedPartitionedRegion", new Object[]{2000});
            ConcurrentParallelGatewaySenderOperation_2_DUnitTest.pause(1000);
            try {
                vm5.invoke(WANTestBase.class, "destroyRegion", new Object[]{"CUSTOMER"});
            }
            catch (Exception ex) {
                ConcurrentParallelGatewaySenderOperation_2_DUnitTest.assertTrue((boolean)(ex.getCause() instanceof IllegalStateException));
                vm4.invoke(ConcurrentParallelGatewaySenderOperation_2_DUnitTest.class, "clear_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME");
                vm5.invoke(ConcurrentParallelGatewaySenderOperation_2_DUnitTest.class, "clear_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME");
                return;
            }
            ConcurrentParallelGatewaySenderOperation_2_DUnitTest.fail((String)"Excpeted UnsupportedOperationException");
        }
        finally {
            vm4.invoke(ConcurrentParallelGatewaySenderOperation_2_DUnitTest.class, "clear_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME");
            vm5.invoke(ConcurrentParallelGatewaySenderOperation_2_DUnitTest.class, "clear_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME");
        }
    }

    public static void createCache_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME(Integer locPort) {
        ConcurrentParallelGatewaySenderOperation_2_DUnitTest.createCache(false, locPort);
        AbstractGatewaySender.MAXIMUM_SHUTDOWN_WAIT_TIME = -1;
    }

    public static void clear_INFINITE_MAXIMUM_SHUTDOWN_WAIT_TIME() {
        AbstractGatewaySender.MAXIMUM_SHUTDOWN_WAIT_TIME = 0;
    }

    public static void closeRegion(String regionName) {
        Region r = cache.getRegion("/" + regionName);
        ConcurrentParallelGatewaySenderOperation_2_DUnitTest.assertNotNull((Object)r);
        r.close();
    }

    public static void validateRegionSizeWithinRange(String regionName, final int min, final int max) {
        final Region r = cache.getRegion("/" + regionName);
        ConcurrentParallelGatewaySenderOperation_2_DUnitTest.assertNotNull((Object)r);
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return r.keySet().size() > min && r.keySet().size() <= max;
            }

            @Override
            public String description() {
                return "Expected region entries to be within range : " + min + " " + max + " but actual entries: " + r.keySet().size();
            }
        };
        DistributedTestCase.waitForCriterion(wc, 120000L, 500L, true);
    }
}

