/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan.asyncqueue;

import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueueFactory;
import com.gemstone.gemfire.cache.asyncqueue.internal.AsyncEventQueueImpl;
import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.cache.wan.WANTestBase;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;

public class AsyncEventListenerDUnitTest
extends WANTestBase {
    private static final long serialVersionUID = 1L;

    public AsyncEventListenerDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public void testCreateAsyncEventQueueWithNullListener() {
        WANTestBase test = new WANTestBase(testName);
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        InternalDistributedSystem ds = test.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        AsyncEventQueueFactory asyncQueueFactory = cache.createAsyncEventQueueFactory();
        try {
            asyncQueueFactory.create("testId", null);
            AsyncEventListenerDUnitTest.fail((String)"AsyncQueueFactory should not allow to create AsyncEventQueue with null listener");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSerialAsyncEventQueueAttributes() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", false, 100, 150, true, true, "testDS", true});
        vm4.invoke(WANTestBase.class, "validateAsyncEventQueueAttributes", new Object[]{"ln", 100, 150, 5, true, "testDS", true, true});
    }

    public void testSerialAsyncEventQueueSize() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", false, 100, 100, false, false, null, false});
        vm5.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", false, 100, 100, false, false, null, false});
        vm6.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", false, 100, 100, false, false, null, false});
        vm7.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", false, 100, 100, false, false, null, false});
        vm4.invoke(WANTestBase.class, "createReplicatedRegionWithAsyncEventQueue", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createReplicatedRegionWithAsyncEventQueue", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createReplicatedRegionWithAsyncEventQueue", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createReplicatedRegionWithAsyncEventQueue", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "pauseAsyncEventQueue", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "pauseAsyncEventQueue", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "pauseAsyncEventQueue", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "pauseAsyncEventQueue", new Object[]{"ln"});
        AsyncEventListenerDUnitTest.pause(1000);
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_RR", 1000});
        int vm4size = (Integer)vm4.invoke(WANTestBase.class, "getAsyncEventQueueSize", new Object[]{"ln"});
        int vm5size = (Integer)vm5.invoke(WANTestBase.class, "getAsyncEventQueueSize", new Object[]{"ln"});
        AsyncEventListenerDUnitTest.assertEquals((String)"Size of AsyncEventQueue is incorrect", (int)1000, (int)vm4size);
        AsyncEventListenerDUnitTest.assertEquals((String)"Size of AsyncEventQueue is incorrect", (int)1000, (int)vm5size);
    }

    public void testReplicatedSerialAsyncEventQueue() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", false, 100, 100, false, false, null, false});
        vm5.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", false, 100, 100, false, false, null, false});
        vm6.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", false, 100, 100, false, false, null, false});
        vm7.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", false, 100, 100, false, false, null, false});
        vm4.invoke(WANTestBase.class, "createReplicatedRegionWithAsyncEventQueue", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createReplicatedRegionWithAsyncEventQueue", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createReplicatedRegionWithAsyncEventQueue", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createReplicatedRegionWithAsyncEventQueue", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_RR", 1000});
        vm4.invoke(WANTestBase.class, "validateAsyncEventListener", new Object[]{"ln", 1000});
        vm5.invoke(WANTestBase.class, "validateAsyncEventListener", new Object[]{"ln", 0});
        vm6.invoke(WANTestBase.class, "validateAsyncEventListener", new Object[]{"ln", 0});
        vm7.invoke(WANTestBase.class, "validateAsyncEventListener", new Object[]{"ln", 0});
    }

    public void testReplicatedSerialAsyncEventQueue_ExceptionScenario() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createAsyncEventQueueWithCustomListener", new Object[]{"ln", false, 100, 100, false, false, null, false});
        vm5.invoke(WANTestBase.class, "createAsyncEventQueueWithCustomListener", new Object[]{"ln", false, 100, 100, false, false, null, false});
        vm6.invoke(WANTestBase.class, "createAsyncEventQueueWithCustomListener", new Object[]{"ln", false, 100, 100, false, false, null, false});
        vm7.invoke(WANTestBase.class, "createAsyncEventQueueWithCustomListener", new Object[]{"ln", false, 100, 100, false, false, null, false});
        vm4.invoke(WANTestBase.class, "createReplicatedRegionWithAsyncEventQueue", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createReplicatedRegionWithAsyncEventQueue", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createReplicatedRegionWithAsyncEventQueue", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createReplicatedRegionWithAsyncEventQueue", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "pauseAsyncEventQueue", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "pauseAsyncEventQueue", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "pauseAsyncEventQueue", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "pauseAsyncEventQueue", new Object[]{"ln"});
        AsyncEventListenerDUnitTest.pause(2000);
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_RR", 100});
        vm4.invoke(WANTestBase.class, "resumeAsyncEventQueue", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "resumeAsyncEventQueue", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "resumeAsyncEventQueue", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "resumeAsyncEventQueue", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "validateCustomAsyncEventListener", new Object[]{"ln", 100});
        vm5.invoke(WANTestBase.class, "validateCustomAsyncEventListener", new Object[]{"ln", 0});
        vm6.invoke(WANTestBase.class, "validateCustomAsyncEventListener", new Object[]{"ln", 0});
        vm7.invoke(WANTestBase.class, "validateCustomAsyncEventListener", new Object[]{"ln", 0});
    }

    public void testReplicatedSerialAsyncEventQueueWithConflationEnabled() {
        int i;
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", false, 100, 100, true, false, null, false});
        vm5.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", false, 100, 100, true, false, null, false});
        vm6.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", false, 100, 100, true, false, null, false});
        vm7.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", false, 100, 100, true, false, null, false});
        vm4.invoke(WANTestBase.class, "createReplicatedRegionWithAsyncEventQueue", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createReplicatedRegionWithAsyncEventQueue", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createReplicatedRegionWithAsyncEventQueue", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createReplicatedRegionWithAsyncEventQueue", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "pauseAsyncEventQueue", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "pauseAsyncEventQueue", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "pauseAsyncEventQueue", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "pauseAsyncEventQueue", new Object[]{"ln"});
        AsyncEventListenerDUnitTest.pause(1000);
        HashMap<Integer, Integer> keyValues = new HashMap<Integer, Integer>();
        HashMap<Integer, String> updateKeyValues = new HashMap<Integer, String>();
        for (i = 0; i < 1000; ++i) {
            keyValues.put(i, i);
        }
        vm4.invoke(WANTestBase.class, "putGivenKeyValue", new Object[]{testName + "_RR", keyValues});
        AsyncEventListenerDUnitTest.pause(1000);
        vm4.invoke(WANTestBase.class, "checkAsyncEventQueueSize", new Object[]{"ln", keyValues.size()});
        for (i = 0; i < 500; ++i) {
            updateKeyValues.put(i, i + "_updated");
        }
        vm4.invoke(WANTestBase.class, "putGivenKeyValue", new Object[]{testName + "_RR", updateKeyValues});
        vm4.invoke(WANTestBase.class, "checkAsyncEventQueueSize", new Object[]{"ln", keyValues.size() + updateKeyValues.size()});
        vm4.invoke(WANTestBase.class, "putGivenKeyValue", new Object[]{testName + "_RR", updateKeyValues});
        vm4.invoke(WANTestBase.class, "checkAsyncEventQueueSize", new Object[]{"ln", keyValues.size() + updateKeyValues.size()});
        vm4.invoke(WANTestBase.class, "resumeAsyncEventQueue", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "resumeAsyncEventQueue", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "resumeAsyncEventQueue", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "resumeAsyncEventQueue", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "validateAsyncEventListener", new Object[]{"ln", 1000});
        vm5.invoke(WANTestBase.class, "validateAsyncEventListener", new Object[]{"ln", 0});
        vm6.invoke(WANTestBase.class, "validateAsyncEventListener", new Object[]{"ln", 0});
        vm7.invoke(WANTestBase.class, "validateAsyncEventListener", new Object[]{"ln", 0});
    }

    public void testReplicatedSerialAsyncEventQueueWith2WANSites() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 10, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 10, false, false, null, true});
        vm4.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"lnAsync", false, 100, 100, false, false, null, false});
        vm5.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"lnAsync", false, 100, 100, false, false, null, false});
        vm6.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"lnAsync", false, 100, 100, false, false, null, false});
        vm7.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"lnAsync", false, 100, 100, false, false, null, false});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "createReplicatedRegionWithSenderAndAsyncEventQueue", new Object[]{testName + "_RR", "ln", "lnAsync", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createReplicatedRegionWithSenderAndAsyncEventQueue", new Object[]{testName + "_RR", "ln", "lnAsync", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createReplicatedRegionWithSenderAndAsyncEventQueue", new Object[]{testName + "_RR", "ln", "lnAsync", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createReplicatedRegionWithSenderAndAsyncEventQueue", new Object[]{testName + "_RR", "ln", "lnAsync", this.isOffHeap()});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm2.invoke(WANTestBase.class, "createSender", new Object[]{"ny", 1, false, 100, 10, false, false, null, true});
        vm3.invoke(WANTestBase.class, "createSender", new Object[]{"ny", 1, false, 100, 10, false, false, null, true});
        vm2.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"nyAsync", false, 100, 100, false, false, null, false});
        vm3.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"nyAsync", false, 100, 100, false, false, null, false});
        vm2.invoke(WANTestBase.class, "startSender", new Object[]{"ny"});
        vm3.invoke(WANTestBase.class, "startSender", new Object[]{"ny"});
        vm2.invoke(WANTestBase.class, "createReplicatedRegionWithSenderAndAsyncEventQueue", new Object[]{testName + "_RR", "ny", "nyAsync", this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createReplicatedRegionWithSenderAndAsyncEventQueue", new Object[]{testName + "_RR", "ny", "nyAsync", this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_RR", 1000});
        vm4.invoke(WANTestBase.class, "validateAsyncEventListener", new Object[]{"lnAsync", 1000});
        vm5.invoke(WANTestBase.class, "validateAsyncEventListener", new Object[]{"lnAsync", 0});
        vm6.invoke(WANTestBase.class, "validateAsyncEventListener", new Object[]{"lnAsync", 0});
        vm7.invoke(WANTestBase.class, "validateAsyncEventListener", new Object[]{"lnAsync", 0});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 1000});
        vm3.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 1000});
        vm2.invoke(WANTestBase.class, "validateAsyncEventListener", new Object[]{"nyAsync", 1000});
        vm3.invoke(WANTestBase.class, "validateAsyncEventListener", new Object[]{"nyAsync", 0});
    }

    public void DISABLED_testReplicatedSerialAsyncEventQueueWithoutLocator() {
        int mPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        vm4.invoke(WANTestBase.class, "createCacheWithoutLocator", new Object[]{mPort});
        vm5.invoke(WANTestBase.class, "createCacheWithoutLocator", new Object[]{mPort});
        vm6.invoke(WANTestBase.class, "createCacheWithoutLocator", new Object[]{mPort});
        vm7.invoke(WANTestBase.class, "createCacheWithoutLocator", new Object[]{mPort});
        vm4.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", false, 100, 100, false, false, null, false});
        vm5.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", false, 100, 100, false, false, null, false});
        vm6.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", false, 100, 100, false, false, null, false});
        vm7.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", false, 100, 100, false, false, null, false});
        vm4.invoke(WANTestBase.class, "createReplicatedRegionWithAsyncEventQueue", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createReplicatedRegionWithAsyncEventQueue", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createReplicatedRegionWithAsyncEventQueue", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createReplicatedRegionWithAsyncEventQueue", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_RR", 1000});
        vm4.invoke(WANTestBase.class, "validateAsyncEventListener", new Object[]{"ln", 1000});
        vm5.invoke(WANTestBase.class, "validateAsyncEventListener", new Object[]{"ln", 0});
        vm6.invoke(WANTestBase.class, "validateAsyncEventListener", new Object[]{"ln", 0});
        vm7.invoke(WANTestBase.class, "validateAsyncEventListener", new Object[]{"ln", 0});
    }

    public void testReplicatedSerialAsyncEventQueueWithPeristenceEnabled() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", false, 100, 100, true, false, null, false});
        vm5.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", false, 100, 100, true, false, null, false});
        vm6.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", false, 100, 100, true, false, null, false});
        vm7.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", false, 100, 100, true, false, null, false});
        vm4.invoke(WANTestBase.class, "createReplicatedRegionWithAsyncEventQueue", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createReplicatedRegionWithAsyncEventQueue", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createReplicatedRegionWithAsyncEventQueue", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createReplicatedRegionWithAsyncEventQueue", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_RR", 1000});
        vm4.invoke(WANTestBase.class, "validateAsyncEventListener", new Object[]{"ln", 1000});
        vm5.invoke(WANTestBase.class, "validateAsyncEventListener", new Object[]{"ln", 0});
        vm6.invoke(WANTestBase.class, "validateAsyncEventListener", new Object[]{"ln", 0});
        vm7.invoke(WANTestBase.class, "validateAsyncEventListener", new Object[]{"ln", 0});
    }

    public void testReplicatedSerialAsyncEventQueueWithPeristenceEnabled_Restart() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        String firstDStore = (String)vm4.invoke(WANTestBase.class, "createAsyncEventQueueWithDiskStore", new Object[]{"ln", false, 100, 100, true, null});
        vm4.invoke(WANTestBase.class, "createReplicatedRegionWithAsyncEventQueue", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "pauseAsyncEventQueue", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_RR", 1000});
        vm4.invoke(WANTestBase.class, "killSender", new Object[0]);
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createAsyncEventQueueWithDiskStore", new Object[]{"ln", false, 100, 100, true, firstDStore});
        vm4.invoke(WANTestBase.class, "createReplicatedRegionWithAsyncEventQueue", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "validateAsyncEventListener", new Object[]{"ln", 1000});
    }

    public void testReplicatedSerialAsyncEventQueueWithPeristenceEnabled_Restart2() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createAsyncEventQueueWithDiskStore", new Object[]{"ln", false, 100, 100, true, null});
        vm5.invoke(WANTestBase.class, "createAsyncEventQueueWithDiskStore", new Object[]{"ln", false, 100, 100, true, null});
        vm6.invoke(WANTestBase.class, "createAsyncEventQueueWithDiskStore", new Object[]{"ln", false, 100, 100, true, null});
        vm4.invoke(WANTestBase.class, "createReplicatedRegionWithAsyncEventQueue", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "addCacheListenerAndCloseCache", new Object[]{testName + "_RR"});
        vm5.invoke(WANTestBase.class, "createReplicatedRegionWithAsyncEventQueue", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createReplicatedRegionWithAsyncEventQueue", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_RR", 2000});
        vm5.invoke(WANTestBase.class, "waitForSenderToBecomePrimary", new Object[]{AsyncEventQueueImpl.getSenderIdFromAsyncEventQueueId((String)"ln")});
        vm5.invoke(WANTestBase.class, "waitForAsyncQueueToGetEmpty", new Object[]{"ln"});
        int vm4size = (Integer)vm4.invoke(WANTestBase.class, "getAsyncEventListenerMapSize", new Object[]{"ln"});
        int vm5size = (Integer)vm5.invoke(WANTestBase.class, "getAsyncEventListenerMapSize", new Object[]{"ln"});
        AsyncEventListenerDUnitTest.getLogWriter().info("vm4 size is: " + vm4size);
        AsyncEventListenerDUnitTest.getLogWriter().info("vm5 size is: " + vm5size);
        AsyncEventListenerDUnitTest.assertTrue((String)"Total number of entries in events map on vm4 and vm5 should be at least 2000", (vm4size + vm5size >= 2000 ? 1 : 0) != 0);
    }

    public void testReplicatedSerialAsyncEventQueueWithMultipleDispatcherThreads() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createConcurrentAsyncEventQueue", new Object[]{"ln", false, 100, 100, true, false, null, false, 3, Gateway.OrderPolicy.KEY});
        vm5.invoke(WANTestBase.class, "createConcurrentAsyncEventQueue", new Object[]{"ln", false, 100, 100, true, false, null, false, 3, Gateway.OrderPolicy.KEY});
        vm6.invoke(WANTestBase.class, "createConcurrentAsyncEventQueue", new Object[]{"ln", false, 100, 100, true, false, null, false, 3, Gateway.OrderPolicy.KEY});
        vm7.invoke(WANTestBase.class, "createConcurrentAsyncEventQueue", new Object[]{"ln", false, 100, 100, true, false, null, false, 3, Gateway.OrderPolicy.KEY});
        vm4.invoke(WANTestBase.class, "createReplicatedRegionWithAsyncEventQueue", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createReplicatedRegionWithAsyncEventQueue", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createReplicatedRegionWithAsyncEventQueue", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createReplicatedRegionWithAsyncEventQueue", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_RR", 1000});
        vm4.invoke(WANTestBase.class, "validateAsyncEventListener", new Object[]{"ln", 1000});
        vm5.invoke(WANTestBase.class, "validateAsyncEventListener", new Object[]{"ln", 0});
        vm6.invoke(WANTestBase.class, "validateAsyncEventListener", new Object[]{"ln", 0});
        vm7.invoke(WANTestBase.class, "validateAsyncEventListener", new Object[]{"ln", 0});
    }

    public void testReplicatedSerialAsyncEventQueueWithMultipleDispatcherThreads_2() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createConcurrentAsyncEventQueue", new Object[]{"ln", false, 100, 100, true, false, null, false, 3, Gateway.OrderPolicy.THREAD});
        vm5.invoke(WANTestBase.class, "createConcurrentAsyncEventQueue", new Object[]{"ln", false, 100, 100, true, false, null, false, 3, Gateway.OrderPolicy.THREAD});
        vm6.invoke(WANTestBase.class, "createConcurrentAsyncEventQueue", new Object[]{"ln", false, 100, 100, true, false, null, false, 3, Gateway.OrderPolicy.THREAD});
        vm7.invoke(WANTestBase.class, "createConcurrentAsyncEventQueue", new Object[]{"ln", false, 100, 100, true, false, null, false, 3, Gateway.OrderPolicy.THREAD});
        vm4.invoke(WANTestBase.class, "createReplicatedRegionWithAsyncEventQueue", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createReplicatedRegionWithAsyncEventQueue", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createReplicatedRegionWithAsyncEventQueue", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createReplicatedRegionWithAsyncEventQueue", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm4.invokeAsync(WANTestBase.class, "doPuts", new Object[]{testName + "_RR", 500});
        vm4.invokeAsync(WANTestBase.class, "doNextPuts", new Object[]{testName + "_RR", 500, 1000});
        vm4.invokeAsync(WANTestBase.class, "doPuts", new Object[]{testName + "_RR", 1000, 1500});
        vm4.invoke(WANTestBase.class, "validateAsyncEventListener", new Object[]{"ln", 1000});
        vm5.invoke(WANTestBase.class, "validateAsyncEventListener", new Object[]{"ln", 0});
        vm6.invoke(WANTestBase.class, "validateAsyncEventListener", new Object[]{"ln", 0});
        vm7.invoke(WANTestBase.class, "validateAsyncEventListener", new Object[]{"ln", 0});
    }

    public void testPartitionedSerialAsyncEventQueue() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", false, 100, 100, false, false, null, false});
        vm5.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", false, 100, 100, false, false, null, false});
        vm6.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", false, 100, 100, false, false, null, false});
        vm7.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", false, 100, 100, false, false, null, false});
        vm4.invoke(WANTestBase.class, "createPartitionedRegionWithAsyncEventQueue", new Object[]{testName + "_PR", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegionWithAsyncEventQueue", new Object[]{testName + "_PR", "ln", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegionWithAsyncEventQueue", new Object[]{testName + "_PR", "ln", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegionWithAsyncEventQueue", new Object[]{testName + "_PR", "ln", this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 500});
        vm5.invoke(WANTestBase.class, "doPutsFrom", new Object[]{testName + "_PR", 500, 1000});
        vm4.invoke(WANTestBase.class, "validateAsyncEventListener", new Object[]{"ln", 1000});
        vm5.invoke(WANTestBase.class, "validateAsyncEventListener", new Object[]{"ln", 0});
        vm6.invoke(WANTestBase.class, "validateAsyncEventListener", new Object[]{"ln", 0});
        vm7.invoke(WANTestBase.class, "validateAsyncEventListener", new Object[]{"ln", 0});
    }

    public void testPartitionedSerialAsyncEventQueueWithConflationEnabled() {
        int i;
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", false, 100, 100, true, false, null, false});
        vm5.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", false, 100, 100, true, false, null, false});
        vm6.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", false, 100, 100, true, false, null, false});
        vm7.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", false, 100, 100, true, false, null, false});
        vm4.invoke(WANTestBase.class, "createPartitionedRegionWithAsyncEventQueue", new Object[]{testName + "_PR", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegionWithAsyncEventQueue", new Object[]{testName + "_PR", "ln", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegionWithAsyncEventQueue", new Object[]{testName + "_PR", "ln", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegionWithAsyncEventQueue", new Object[]{testName + "_PR", "ln", this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "pauseAsyncEventQueue", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "pauseAsyncEventQueue", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "pauseAsyncEventQueue", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "pauseAsyncEventQueue", new Object[]{"ln"});
        AsyncEventListenerDUnitTest.pause(2000);
        HashMap<Integer, Integer> keyValues = new HashMap<Integer, Integer>();
        HashMap<Integer, String> updateKeyValues = new HashMap<Integer, String>();
        for (i = 0; i < 1000; ++i) {
            keyValues.put(i, i);
        }
        vm4.invoke(WANTestBase.class, "putGivenKeyValue", new Object[]{testName + "_PR", keyValues});
        vm4.invoke(WANTestBase.class, "checkAsyncEventQueueSize", new Object[]{"ln", keyValues.size()});
        for (i = 0; i < 500; ++i) {
            updateKeyValues.put(i, i + "_updated");
        }
        vm5.invoke(WANTestBase.class, "putGivenKeyValue", new Object[]{testName + "_PR", updateKeyValues});
        vm5.invoke(WANTestBase.class, "checkAsyncEventQueueSize", new Object[]{"ln", keyValues.size() + updateKeyValues.size()});
        vm5.invoke(WANTestBase.class, "putGivenKeyValue", new Object[]{testName + "_PR", updateKeyValues});
        vm5.invoke(WANTestBase.class, "checkAsyncEventQueueSize", new Object[]{"ln", keyValues.size() + updateKeyValues.size()});
        vm4.invoke(WANTestBase.class, "resumeAsyncEventQueue", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "resumeAsyncEventQueue", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "resumeAsyncEventQueue", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "resumeAsyncEventQueue", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "validateAsyncEventListener", new Object[]{"ln", 1000});
        vm5.invoke(WANTestBase.class, "validateAsyncEventListener", new Object[]{"ln", 0});
        vm6.invoke(WANTestBase.class, "validateAsyncEventListener", new Object[]{"ln", 0});
        vm7.invoke(WANTestBase.class, "validateAsyncEventListener", new Object[]{"ln", 0});
    }

    public void testPartitionedSerialAsyncEventQueueWithPeristenceEnabled() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", false, 100, 100, false, true, null, false});
        vm5.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", false, 100, 100, false, true, null, false});
        vm6.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", false, 100, 100, false, true, null, false});
        vm7.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", false, 100, 100, false, true, null, false});
        vm4.invoke(WANTestBase.class, "createPartitionedRegionWithAsyncEventQueue", new Object[]{testName + "_PR", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegionWithAsyncEventQueue", new Object[]{testName + "_PR", "ln", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegionWithAsyncEventQueue", new Object[]{testName + "_PR", "ln", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegionWithAsyncEventQueue", new Object[]{testName + "_PR", "ln", this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 500});
        vm5.invoke(WANTestBase.class, "doPutsFrom", new Object[]{testName + "_PR", 500, 1000});
        vm4.invoke(WANTestBase.class, "validateAsyncEventListener", new Object[]{"ln", 1000});
        vm5.invoke(WANTestBase.class, "validateAsyncEventListener", new Object[]{"ln", 0});
        vm6.invoke(WANTestBase.class, "validateAsyncEventListener", new Object[]{"ln", 0});
        vm7.invoke(WANTestBase.class, "validateAsyncEventListener", new Object[]{"ln", 0});
    }

    public void testPartitionedSerialAsyncEventQueueWithPeristenceEnabled_Restart() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        String firstDStore = (String)vm4.invoke(WANTestBase.class, "createAsyncEventQueueWithDiskStore", new Object[]{"ln", false, 100, 100, true, null});
        vm4.invoke(WANTestBase.class, "createPartitionedRegionWithAsyncEventQueue", new Object[]{testName + "_PR", "ln", this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "pauseAsyncEventQueueAndWaitForDispatcherToPause", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 1000});
        vm4.invoke(WANTestBase.class, "killSender", new Object[0]);
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createAsyncEventQueueWithDiskStore", new Object[]{"ln", false, 100, 100, true, firstDStore});
        vm4.invoke(WANTestBase.class, "createPartitionedRegionWithAsyncEventQueue", new Object[]{testName + "_PR", "ln", this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "validateAsyncEventListener", new Object[]{"ln", 1000});
    }

    public void testParallelAsyncEventQueue() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", true, 100, 100, false, false, null, false});
        vm5.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", true, 100, 100, false, false, null, false});
        vm6.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", true, 100, 100, false, false, null, false});
        vm7.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", true, 100, 100, false, false, null, false});
        vm4.invoke(WANTestBase.class, "createPartitionedRegionWithAsyncEventQueue", new Object[]{testName + "_PR", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegionWithAsyncEventQueue", new Object[]{testName + "_PR", "ln", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegionWithAsyncEventQueue", new Object[]{testName + "_PR", "ln", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegionWithAsyncEventQueue", new Object[]{testName + "_PR", "ln", this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 256});
        vm4.invoke(WANTestBase.class, "waitForAsyncQueueToGetEmpty", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForAsyncQueueToGetEmpty", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForAsyncQueueToGetEmpty", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForAsyncQueueToGetEmpty", new Object[]{"ln"});
        int vm4size = (Integer)vm4.invoke(WANTestBase.class, "getAsyncEventListenerMapSize", new Object[]{"ln"});
        int vm5size = (Integer)vm5.invoke(WANTestBase.class, "getAsyncEventListenerMapSize", new Object[]{"ln"});
        int vm6size = (Integer)vm6.invoke(WANTestBase.class, "getAsyncEventListenerMapSize", new Object[]{"ln"});
        int vm7size = (Integer)vm7.invoke(WANTestBase.class, "getAsyncEventListenerMapSize", new Object[]{"ln"});
        AsyncEventListenerDUnitTest.assertEquals((int)(vm4size + vm5size + vm6size + vm7size), (int)256);
    }

    public void testParallelAsyncEventQueueSize() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", true, 100, 100, false, false, null, false});
        vm5.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", true, 100, 100, false, false, null, false});
        vm6.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", true, 100, 100, false, false, null, false});
        vm7.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", true, 100, 100, false, false, null, false});
        vm4.invoke(WANTestBase.class, "createPartitionedRegionWithAsyncEventQueue", new Object[]{testName + "_PR", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegionWithAsyncEventQueue", new Object[]{testName + "_PR", "ln", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegionWithAsyncEventQueue", new Object[]{testName + "_PR", "ln", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegionWithAsyncEventQueue", new Object[]{testName + "_PR", "ln", this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "pauseAsyncEventQueue", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "pauseAsyncEventQueue", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "pauseAsyncEventQueue", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "pauseAsyncEventQueue", new Object[]{"ln"});
        AsyncEventListenerDUnitTest.pause(1000);
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 1000});
        int vm4size = (Integer)vm4.invoke(WANTestBase.class, "getAsyncEventQueueSize", new Object[]{"ln"});
        int vm5size = (Integer)vm5.invoke(WANTestBase.class, "getAsyncEventQueueSize", new Object[]{"ln"});
        AsyncEventListenerDUnitTest.assertEquals((String)"Size of AsyncEventQueue is incorrect", (int)1000, (int)vm4size);
        AsyncEventListenerDUnitTest.assertEquals((String)"Size of AsyncEventQueue is incorrect", (int)1000, (int)vm5size);
    }

    public void testParallelAsyncEventQueueWithConflationEnabled() {
        int i;
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", true, 100, 100, true, false, null, false});
        vm5.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", true, 100, 100, true, false, null, false});
        vm6.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", true, 100, 100, true, false, null, false});
        vm7.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", true, 100, 100, true, false, null, false});
        vm4.invoke(WANTestBase.class, "createPartitionedRegionWithAsyncEventQueue", new Object[]{testName + "_PR", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegionWithAsyncEventQueue", new Object[]{testName + "_PR", "ln", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegionWithAsyncEventQueue", new Object[]{testName + "_PR", "ln", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegionWithAsyncEventQueue", new Object[]{testName + "_PR", "ln", this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "pauseAsyncEventQueue", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "pauseAsyncEventQueue", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "pauseAsyncEventQueue", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "pauseAsyncEventQueue", new Object[]{"ln"});
        AsyncEventListenerDUnitTest.pause(2000);
        HashMap<Integer, Integer> keyValues = new HashMap<Integer, Integer>();
        HashMap<Integer, String> updateKeyValues = new HashMap<Integer, String>();
        for (i = 0; i < 1000; ++i) {
            keyValues.put(i, i);
        }
        vm4.invoke(WANTestBase.class, "putGivenKeyValue", new Object[]{testName + "_PR", keyValues});
        vm4.invoke(WANTestBase.class, "checkAsyncEventQueueSize", new Object[]{"ln", keyValues.size()});
        for (i = 0; i < 500; ++i) {
            updateKeyValues.put(i, i + "_updated");
        }
        vm4.invoke(WANTestBase.class, "putGivenKeyValue", new Object[]{testName + "_PR", updateKeyValues});
        vm4.invoke(WANTestBase.class, "waitForAsyncEventQueueSize", new Object[]{"ln", keyValues.size()});
        vm4.invoke(WANTestBase.class, "resumeAsyncEventQueue", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "resumeAsyncEventQueue", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "resumeAsyncEventQueue", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "resumeAsyncEventQueue", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "waitForAsyncQueueToGetEmpty", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForAsyncQueueToGetEmpty", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForAsyncQueueToGetEmpty", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForAsyncQueueToGetEmpty", new Object[]{"ln"});
        int vm4size = (Integer)vm4.invoke(WANTestBase.class, "getAsyncEventListenerMapSize", new Object[]{"ln"});
        int vm5size = (Integer)vm5.invoke(WANTestBase.class, "getAsyncEventListenerMapSize", new Object[]{"ln"});
        int vm6size = (Integer)vm6.invoke(WANTestBase.class, "getAsyncEventListenerMapSize", new Object[]{"ln"});
        int vm7size = (Integer)vm7.invoke(WANTestBase.class, "getAsyncEventListenerMapSize", new Object[]{"ln"});
        AsyncEventListenerDUnitTest.assertEquals((int)(vm4size + vm5size + vm6size + vm7size), (int)keyValues.size());
    }

    public void testParallelAsyncEventQueueWithConflationEnabled_bug47213() {
        int i;
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", true, 100, 100, true, false, null, false});
        vm5.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", true, 100, 100, true, false, null, false});
        vm6.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", true, 100, 100, true, false, null, false});
        vm7.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", true, 100, 100, true, false, null, false});
        vm4.invoke(WANTestBase.class, "createPRWithRedundantCopyWithAsyncEventQueue", new Object[]{testName + "_PR", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPRWithRedundantCopyWithAsyncEventQueue", new Object[]{testName + "_PR", "ln", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPRWithRedundantCopyWithAsyncEventQueue", new Object[]{testName + "_PR", "ln", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPRWithRedundantCopyWithAsyncEventQueue", new Object[]{testName + "_PR", "ln", this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "pauseAsyncEventQueue", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "pauseAsyncEventQueue", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "pauseAsyncEventQueue", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "pauseAsyncEventQueue", new Object[]{"ln"});
        AsyncEventListenerDUnitTest.pause(2000);
        HashMap<Integer, Integer> keyValues = new HashMap<Integer, Integer>();
        HashMap<Integer, String> updateKeyValues = new HashMap<Integer, String>();
        for (i = 0; i < 1000; ++i) {
            keyValues.put(i, i);
        }
        vm4.invoke(WANTestBase.class, "putGivenKeyValue", new Object[]{testName + "_PR", keyValues});
        AsyncEventListenerDUnitTest.pause(2000);
        vm4.invoke(WANTestBase.class, "checkAsyncEventQueueSize", new Object[]{"ln", keyValues.size()});
        for (i = 0; i < 500; ++i) {
            updateKeyValues.put(i, i + "_updated");
        }
        vm4.invoke(WANTestBase.class, "putGivenKeyValue", new Object[]{testName + "_PR", updateKeyValues});
        AsyncEventListenerDUnitTest.pause(2000);
        vm4.invoke(WANTestBase.class, "checkAsyncEventQueueSize", new Object[]{"ln", keyValues.size()});
        vm4.invoke(WANTestBase.class, "resumeAsyncEventQueue", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "resumeAsyncEventQueue", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "resumeAsyncEventQueue", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "resumeAsyncEventQueue", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "waitForAsyncQueueToGetEmpty", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForAsyncQueueToGetEmpty", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForAsyncQueueToGetEmpty", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForAsyncQueueToGetEmpty", new Object[]{"ln"});
        int vm4size = (Integer)vm4.invoke(WANTestBase.class, "getAsyncEventListenerMapSize", new Object[]{"ln"});
        int vm5size = (Integer)vm5.invoke(WANTestBase.class, "getAsyncEventListenerMapSize", new Object[]{"ln"});
        int vm6size = (Integer)vm6.invoke(WANTestBase.class, "getAsyncEventListenerMapSize", new Object[]{"ln"});
        int vm7size = (Integer)vm7.invoke(WANTestBase.class, "getAsyncEventListenerMapSize", new Object[]{"ln"});
        AsyncEventListenerDUnitTest.assertEquals((int)(vm4size + vm5size + vm6size + vm7size), (int)keyValues.size());
    }

    public void testParallelAsyncEventQueueWithOneAccessor() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        vm3.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm3.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", true, 100, 100, false, false, null, false});
        vm4.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", true, 100, 100, false, false, null, false});
        vm5.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", true, 100, 100, false, false, null, false});
        vm6.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", true, 100, 100, false, false, null, false});
        vm7.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", true, 100, 100, false, false, null, false});
        vm3.invoke(WANTestBase.class, "createPartitionedRegionAccessorWithAsyncEventQueue", new Object[]{testName + "_PR", "ln"});
        vm4.invoke(WANTestBase.class, "createPartitionedRegionWithAsyncEventQueue", new Object[]{testName + "_PR", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegionWithAsyncEventQueue", new Object[]{testName + "_PR", "ln", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegionWithAsyncEventQueue", new Object[]{testName + "_PR", "ln", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegionWithAsyncEventQueue", new Object[]{testName + "_PR", "ln", this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 256});
        vm4.invoke(WANTestBase.class, "waitForAsyncQueueToGetEmpty", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForAsyncQueueToGetEmpty", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForAsyncQueueToGetEmpty", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForAsyncQueueToGetEmpty", new Object[]{"ln"});
        vm3.invoke(WANTestBase.class, "validateAsyncEventListener", new Object[]{"ln", 0});
        int vm4size = (Integer)vm4.invoke(WANTestBase.class, "getAsyncEventListenerMapSize", new Object[]{"ln"});
        int vm5size = (Integer)vm5.invoke(WANTestBase.class, "getAsyncEventListenerMapSize", new Object[]{"ln"});
        int vm6size = (Integer)vm6.invoke(WANTestBase.class, "getAsyncEventListenerMapSize", new Object[]{"ln"});
        int vm7size = (Integer)vm7.invoke(WANTestBase.class, "getAsyncEventListenerMapSize", new Object[]{"ln"});
        AsyncEventListenerDUnitTest.assertEquals((int)(vm4size + vm5size + vm6size + vm7size), (int)256);
    }

    public void testParallelAsyncEventQueueWithPersistence() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", true, 100, 100, false, true, null, false});
        vm5.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", true, 100, 100, false, true, null, false});
        vm6.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", true, 100, 100, false, true, null, false});
        vm7.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", true, 100, 100, false, true, null, false});
        vm4.invoke(WANTestBase.class, "createPartitionedRegionWithAsyncEventQueue", new Object[]{testName + "_PR", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegionWithAsyncEventQueue", new Object[]{testName + "_PR", "ln", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegionWithAsyncEventQueue", new Object[]{testName + "_PR", "ln", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegionWithAsyncEventQueue", new Object[]{testName + "_PR", "ln", this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 256});
        vm4.invoke(WANTestBase.class, "waitForAsyncQueueToGetEmpty", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForAsyncQueueToGetEmpty", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForAsyncQueueToGetEmpty", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForAsyncQueueToGetEmpty", new Object[]{"ln"});
        int vm4size = (Integer)vm4.invoke(WANTestBase.class, "getAsyncEventListenerMapSize", new Object[]{"ln"});
        int vm5size = (Integer)vm5.invoke(WANTestBase.class, "getAsyncEventListenerMapSize", new Object[]{"ln"});
        int vm6size = (Integer)vm6.invoke(WANTestBase.class, "getAsyncEventListenerMapSize", new Object[]{"ln"});
        int vm7size = (Integer)vm7.invoke(WANTestBase.class, "getAsyncEventListenerMapSize", new Object[]{"ln"});
        AsyncEventListenerDUnitTest.assertEquals((int)(vm4size + vm5size + vm6size + vm7size), (int)256);
    }

    public void testReplicatedParallelAsyncEventQueue() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", true, 100, 100, false, false, null, false});
        vm5.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", true, 100, 100, false, false, null, false});
        vm6.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", true, 100, 100, false, false, null, false});
        vm7.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", true, 100, 100, false, false, null, false});
        vm4.invoke(WANTestBase.class, "createReplicatedRegionWithAsyncEventQueue", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createReplicatedRegionWithAsyncEventQueue", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createReplicatedRegionWithAsyncEventQueue", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createReplicatedRegionWithAsyncEventQueue", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_RR", 1000});
        vm4.invoke(WANTestBase.class, "waitForAsyncQueueToGetEmpty", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForAsyncQueueToGetEmpty", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForAsyncQueueToGetEmpty", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForAsyncQueueToGetEmpty", new Object[]{"ln"});
        int vm4size = (Integer)vm4.invoke(WANTestBase.class, "getAsyncEventListenerMapSize", new Object[]{"ln"});
        int vm5size = (Integer)vm5.invoke(WANTestBase.class, "getAsyncEventListenerMapSize", new Object[]{"ln"});
        int vm6size = (Integer)vm6.invoke(WANTestBase.class, "getAsyncEventListenerMapSize", new Object[]{"ln"});
        int vm7size = (Integer)vm7.invoke(WANTestBase.class, "getAsyncEventListenerMapSize", new Object[]{"ln"});
        AsyncEventListenerDUnitTest.assertEquals((int)(vm4size + vm5size + vm6size + vm7size), (int)1000);
    }

    public void testParallelAsyncEventQueueHA_Scenario1() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        AsyncEventListenerDUnitTest.getLogWriter().info("Created the cache");
        vm4.invoke(WANTestBase.class, "createAsyncEventQueueWithListener2", new Object[]{"ln", true, 100, 5, false, null});
        vm5.invoke(WANTestBase.class, "createAsyncEventQueueWithListener2", new Object[]{"ln", true, 100, 5, false, null});
        AsyncEventListenerDUnitTest.getLogWriter().info("Created the AsyncEventQueue");
        vm4.invoke(WANTestBase.class, "createPRWithRedundantCopyWithAsyncEventQueue", new Object[]{testName + "_PR", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPRWithRedundantCopyWithAsyncEventQueue", new Object[]{testName + "_PR", "ln", this.isOffHeap()});
        AsyncEventListenerDUnitTest.getLogWriter().info("Created PR with AsyncEventQueue");
        vm4.invoke(WANTestBase.class, "pauseAsyncEventQueue", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "pauseAsyncEventQueue", new Object[]{"ln"});
        AsyncEventListenerDUnitTest.pause(1000);
        AsyncEventListenerDUnitTest.getLogWriter().info("Paused the AsyncEventQueue");
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 80});
        AsyncEventListenerDUnitTest.getLogWriter().info("Done puts");
        Set primaryBucketsVm5 = (Set)vm5.invoke(WANTestBase.class, "getAllPrimaryBucketsOnTheNode", new Object[]{testName + "_PR"});
        AsyncEventListenerDUnitTest.getLogWriter().info("Primary buckets on vm5: " + primaryBucketsVm5);
        vm5.invoke(WANTestBase.class, "killSender", new Object[0]);
        AsyncEventListenerDUnitTest.pause(1000);
        vm4.invoke(WANTestBase.class, "resumeAsyncEventQueue", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "waitForAsyncQueueToGetEmpty", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "verifyAsyncEventListenerForPossibleDuplicates", new Object[]{"ln", primaryBucketsVm5, 5});
    }

    public void testParallelAsyncEventQueueHA_Scenario2() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        AsyncEventListenerDUnitTest.getLogWriter().info("Created the cache");
        vm4.invoke(WANTestBase.class, "createAsyncEventQueueWithListener2", new Object[]{"ln", true, 100, 5, false, null});
        vm5.invoke(WANTestBase.class, "createAsyncEventQueueWithListener2", new Object[]{"ln", true, 100, 5, false, null});
        AsyncEventListenerDUnitTest.getLogWriter().info("Created the AsyncEventQueue");
        vm4.invoke(WANTestBase.class, "createPRWithRedundantCopyWithAsyncEventQueue", new Object[]{testName + "_PR", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPRWithRedundantCopyWithAsyncEventQueue", new Object[]{testName + "_PR", "ln", this.isOffHeap()});
        AsyncEventListenerDUnitTest.getLogWriter().info("Created PR with AsyncEventQueue");
        vm4.invoke(WANTestBase.class, "pauseAsyncEventQueue", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "pauseAsyncEventQueue", new Object[]{"ln"});
        AsyncEventListenerDUnitTest.pause(1000);
        AsyncEventListenerDUnitTest.getLogWriter().info("Paused the AsyncEventQueue");
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 80});
        AsyncEventListenerDUnitTest.getLogWriter().info("Done puts");
        Set primaryBucketsVm5 = (Set)vm5.invoke(WANTestBase.class, "getAllPrimaryBucketsOnTheNode", new Object[]{testName + "_PR"});
        AsyncEventListenerDUnitTest.getLogWriter().info("Primary buckets on vm5: " + primaryBucketsVm5);
        vm5.invoke(WANTestBase.class, "killSender", new Object[0]);
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createAsyncEventQueueWithListener2", new Object[]{"ln", true, 100, 5, false, null});
        vm6.invoke(WANTestBase.class, "createPRWithRedundantCopyWithAsyncEventQueue", new Object[]{testName + "_PR", "ln", this.isOffHeap()});
        AsyncEventListenerDUnitTest.pause(1000);
        Set primaryBucketsVm6 = (Set)vm6.invoke(WANTestBase.class, "getAllPrimaryBucketsOnTheNode", new Object[]{testName + "_PR"});
        vm4.invoke(WANTestBase.class, "resumeAsyncEventQueue", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "waitForAsyncQueueToGetEmpty", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForAsyncQueueToGetEmpty", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "verifyAsyncEventListenerForPossibleDuplicates", new Object[]{"ln", primaryBucketsVm6, 5});
    }

    public void testParallelAsyncEventQueueHA_Scenario3() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        AsyncEventListenerDUnitTest.getLogWriter().info("Created the cache");
        vm4.invoke(WANTestBase.class, "createAsyncEventQueueWithListener2", new Object[]{"ln", true, 100, 5, false, null});
        vm5.invoke(WANTestBase.class, "createAsyncEventQueueWithListener2", new Object[]{"ln", true, 100, 5, false, null});
        AsyncEventListenerDUnitTest.getLogWriter().info("Created the AsyncEventQueue");
        vm4.invoke(WANTestBase.class, "createPRWithRedundantCopyWithAsyncEventQueue", new Object[]{testName + "_PR", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPRWithRedundantCopyWithAsyncEventQueue", new Object[]{testName + "_PR", "ln", this.isOffHeap()});
        AsyncEventListenerDUnitTest.getLogWriter().info("Created PR with AsyncEventQueue");
        vm4.invoke(WANTestBase.class, "pauseAsyncEventQueue", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "pauseAsyncEventQueue", new Object[]{"ln"});
        AsyncEventListenerDUnitTest.pause(1000);
        AsyncEventListenerDUnitTest.getLogWriter().info("Paused the AsyncEventQueue");
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 80});
        AsyncEventListenerDUnitTest.getLogWriter().info("Done puts");
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createAsyncEventQueueWithListener2", new Object[]{"ln", true, 100, 5, false, null});
        vm6.invoke(WANTestBase.class, "createPRWithRedundantCopyWithAsyncEventQueue", new Object[]{testName + "_PR", "ln", this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "doRebalance", new Object[0]);
        AsyncEventListenerDUnitTest.pause(2000);
        Set primaryBucketsVm6 = (Set)vm6.invoke(WANTestBase.class, "getAllPrimaryBucketsOnTheNode", new Object[]{testName + "_PR"});
        AsyncEventListenerDUnitTest.getLogWriter().info("Primary buckets on vm6: " + primaryBucketsVm6);
        vm4.invoke(WANTestBase.class, "resumeAsyncEventQueue", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "resumeAsyncEventQueue", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "waitForAsyncQueueToGetEmpty", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForAsyncQueueToGetEmpty", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForAsyncQueueToGetEmpty", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "verifyAsyncEventListenerForPossibleDuplicates", new Object[]{"ln", primaryBucketsVm6, 5});
    }

    public void testParallelAsyncEventQueueAttachedToChildRegionButNotToParentRegion() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm3.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm3.invoke(WANTestBase.class, "createAsyncEventQueue", new Object[]{"ln", true, 100, 10, false, false, null, true});
        vm3.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "PARENT_PR", null, 0, 100, this.isOffHeap()});
        String parentRegionFullPath = (String)vm3.invoke(WANTestBase.class, "getRegionFullPath", new Object[]{testName + "PARENT_PR"});
        vm3.invoke(WANTestBase.class, "createColocatedPartitionedRegionWithAsyncEventQueue", new Object[]{testName + "CHILD_PR", "ln", 100, parentRegionFullPath, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "CHILD_PR", 1000});
        vm3.invoke(WANTestBase.class, "waitForAsyncQueueToGetEmpty", new Object[]{"ln"});
        int vm3size = (Integer)vm3.invoke(WANTestBase.class, "getAsyncEventListenerMapSize", new Object[]{"ln"});
        AsyncEventListenerDUnitTest.assertEquals((int)vm3size, (int)1000);
    }
}

