/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.cache.util.CacheWriterAdapter;
import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.cache.util.GatewayHub;
import com.gemstone.gemfire.cache.util.GatewayQueueAttributes;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.PRHARedundancyProvider;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerTestUtil;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.Properties;
import junit.framework.TestCase;

public class WanDUnitTest
extends DistributedTestCase {
    private static Cache cache = null;
    VM vm0 = null;
    VM vm1 = null;
    VM vm2 = null;
    VM vm3 = null;
    private static final String REGION_NAME = "WanDUnitTest_region";
    static WanDUnitTest impl;
    static boolean setWriter;

    public static void createImpl() {
        impl = new WanDUnitTest("temp");
    }

    public WanDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        WanDUnitTest.disconnectAllFromDS();
        WanDUnitTest.pause(5000);
        Host host = Host.getHost(0);
        this.vm0 = host.getVM(0);
        this.vm1 = host.getVM(1);
        this.vm2 = host.getVM(2);
        this.vm3 = host.getVM(3);
        this.vm0.invoke(this.getClass(), "createImpl", null);
        this.vm1.invoke(this.getClass(), "createImpl", null);
        this.vm2.invoke(this.getClass(), "createImpl", null);
        this.vm3.invoke(this.getClass(), "createImpl", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOneServerNotResponding() {
        this.vm1.invoke(this.getClass(), "setWriter");
        Object[] ports1 = (Object[])this.vm1.invoke(this.getClass(), "createServerCache1", new Object[]{null});
        this.vm2.invoke(this.getClass(), "setWriter");
        this.vm2.invoke(this.getClass(), "createServerCache2", ports1);
        Object[] clientParams = new Object[]{WanDUnitTest.getServerHostName(this.vm1.getHost()), ports1[0], ports1[1]};
        this.vm0.invoke(this.getClass(), "createClientCache", clientParams);
        DistributedTestCase.ExpectedException expectedEx = WanDUnitTest.addExpectedException("Unexpected Error on server", this.vm1);
        try {
            this.vm0.invoke(this.getClass(), "doPutsOnClientExpectingException");
        }
        finally {
            expectedEx.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testServerOverWanNotResponding() {
        Object[] ports3 = (Object[])this.vm3.invoke(this.getClass(), "createServerCache3");
        Object[] ports1 = (Object[])this.vm1.invoke(this.getClass(), "createServerCache1", ports3);
        this.vm2.invoke(this.getClass(), "createServerCache2", ports1);
        this.vm3.invoke(this.getClass(), "setWriter");
        Object[] clientParams = new Object[]{WanDUnitTest.getServerHostName(this.vm1.getHost()), ports1[0], ports1[1]};
        this.vm0.invoke(this.getClass(), "createClientCache", clientParams);
        DistributedTestCase.ExpectedException expectedEx = WanDUnitTest.addExpectedException("interrupted", this.vm3);
        try {
            this.vm0.invoke(this.getClass(), "doPutsOnClientNotExpectingException");
        }
        finally {
            expectedEx.remove();
        }
    }

    private Cache createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        Cache cache = null;
        cache = CacheFactory.create((DistributedSystem)ds);
        if (cache == null) {
            throw new Exception("CacheFactory.create() returned null ");
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createClientCache(String host, Integer mcast_port, Integer server_port) throws Exception {
        Pool p;
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        cache = impl.createCache(props);
        CacheServerTestUtil.disableShufflingOfEndpoints();
        try {
            p = PoolManager.createFactory().addServer(host, server_port.intValue()).setSubscriptionEnabled(true).setSubscriptionRedundancy(-1).setMinConnections(2).setSocketBufferSize(32768).setReadTimeout(250).setPingInterval(1000L).setRetryAttempts(1).create("WanDUnitTestPool");
        }
        finally {
            CacheServerTestUtil.enableShufflingOfEndpoints();
        }
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setPoolName(p.getName());
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
    }

    public static Object createServerCache1(Object end_port) throws Exception {
        Properties props = new Properties();
        int mcast_port = AvailablePort.getRandomAvailablePort((int)1);
        props.setProperty("mcast-port", Integer.toString(mcast_port));
        props.setProperty("locators", "");
        cache = impl.createCache(props);
        AttributesFactory factory = impl.getServerCacheAttributesFactory();
        factory.setEnableGateway(true);
        if (setWriter) {
            factory.setCacheWriter((CacheWriter)new CacheWriterAdapter(){

                public void beforeCreate(EntryEvent event) throws CacheWriterException {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException e) {
                        TestCase.fail((String)"interrupted");
                    }
                }

                public void beforeUpdate(EntryEvent event) throws CacheWriterException {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException e) {
                        TestCase.fail((String)"interrupted");
                    }
                }
            });
            setWriter = false;
        }
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
        int hub_port = AvailablePort.getRandomAvailablePort((int)0);
        GatewayHub hub1 = cache.setGatewayHub("getwayhub1", hub_port);
        Gateway gateway1 = hub1.addGateway("gw1-" + mcast_port + hub_port);
        if (end_port != null) {
            Integer port = (Integer)end_port;
            gateway1.addEndpoint("ep1", DistributedTestCase.getIPLiteral(), port.intValue());
        } else {
            gateway1.addEndpoint("ep1", DistributedTestCase.getIPLiteral(), AvailablePort.getRandomAvailablePort((int)0));
        }
        GatewayQueueAttributes queueAttributes = gateway1.getQueueAttributes();
        queueAttributes.setMaximumQueueMemory(1);
        queueAttributes.setBatchSize(1);
        WanDUnitTest.setDiskStoreForGateway(cache, gateway1.getId(), queueAttributes);
        hub1.start();
        gateway1.start();
        BridgeServer server1 = cache.addBridgeServer();
        int serverPort = AvailablePort.getRandomAvailablePort((int)0);
        server1.setPort(serverPort);
        server1.setNotifyBySubscription(true);
        server1.start();
        Object[] ports = new Object[]{new Integer(mcast_port), new Integer(server1.getPort())};
        return ports;
    }

    public static void createServerCache2(Integer mcast_port, Integer server_port) throws Exception {
        RegionAttributes attrs;
        Region region;
        Properties props = new Properties();
        props.setProperty("mcast-port", Integer.toString(mcast_port));
        props.setProperty("locators", "");
        cache = impl.createCache(props);
        AttributesFactory factory = impl.getServerCacheAttributesFactory();
        factory.setEnableGateway(true);
        if (setWriter) {
            factory.setCacheWriter((CacheWriter)new CacheWriterAdapter(){

                public void beforeCreate(EntryEvent event) throws CacheWriterException {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException e) {
                        TestCase.fail((String)"interrupted");
                    }
                }

                public void beforeUpdate(EntryEvent event) throws CacheWriterException {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException e) {
                        TestCase.fail((String)"interrupted");
                    }
                }
            });
            setWriter = false;
        }
        if ((region = cache.createRegion(REGION_NAME, attrs = factory.create())) instanceof PartitionedRegion) {
            PRHARedundancyProvider.setForceLocalPrimaries((boolean)true);
            PartitionRegionHelper.assignBucketsToPartitions((Region)region);
        }
        BridgeServer server1 = cache.addBridgeServer();
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server1.setPort(port);
        server1.setNotifyBySubscription(true);
        server1.start();
    }

    public static Object createServerCache3() throws Exception {
        Properties props = new Properties();
        int mcast_port = AvailablePort.getRandomAvailablePort((int)1);
        props.setProperty("mcast-port", Integer.toString(mcast_port));
        props.setProperty("locators", "");
        cache = impl.createCache(props);
        AttributesFactory factory = impl.getServerCacheAttributesFactory();
        factory.setEnableWAN(true);
        if (setWriter) {
            factory.setCacheWriter((CacheWriter)new CacheWriterAdapter(){

                public void beforeCreate(EntryEvent event) throws CacheWriterException {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException e) {
                        TestCase.fail((String)"interrupted");
                    }
                }

                public void beforeUpdate(EntryEvent event) throws CacheWriterException {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException e) {
                        TestCase.fail((String)"interrupted");
                    }
                }
            });
            setWriter = false;
        }
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
        int hub_port = AvailablePort.getRandomAvailablePort((int)0);
        GatewayHub hub1 = cache.setGatewayHub("getwayhub3", hub_port);
        Gateway gateway1 = hub1.addGateway("gw3-" + mcast_port + hub_port);
        GatewayQueueAttributes queueAttributes = gateway1.getQueueAttributes();
        queueAttributes.setMaximumQueueMemory(1);
        queueAttributes.setBatchSize(1);
        WanDUnitTest.setDiskStoreForGateway(cache, gateway1.getId(), queueAttributes);
        hub1.start();
        gateway1.start();
        BridgeServer server1 = cache.addBridgeServer();
        int server_port = AvailablePort.getRandomAvailablePort((int)0);
        server1.setPort(server_port);
        server1.setNotifyBySubscription(true);
        server1.start();
        Object[] ports = new Object[]{new Integer(hub_port)};
        return ports;
    }

    protected AttributesFactory getServerCacheAttributesFactory() {
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        return factory;
    }

    @Override
    public void tearDown2() throws Exception {
        this.vm0.invoke(this.getClass(), "unsetForceLocalPrimary");
        this.vm1.invoke(this.getClass(), "unsetForceLocalPrimary");
        this.vm2.invoke(this.getClass(), "unsetForceLocalPrimary");
        this.vm3.invoke(this.getClass(), "unsetForceLocalPrimary");
        this.vm0.invoke(this.getClass(), "closeCache");
        this.vm1.invoke(this.getClass(), "closeCache");
        this.vm2.invoke(this.getClass(), "closeCache");
        this.vm3.invoke(this.getClass(), "closeCache");
    }

    public static void unsetForceLocalPrimary() {
        Region region;
        if (cache != null && !cache.isClosed() && (region = cache.getRegion(REGION_NAME)) != null && region instanceof PartitionedRegion) {
            PRHARedundancyProvider.setForceLocalPrimaries((boolean)false);
        }
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    public static void setWriter() {
        setWriter = true;
    }

    public static void doPutsOnClientExpectingException() throws Exception {
        Region region1 = cache.getRegion("/WanDUnitTest_region");
        try {
            region1.put((Object)"newKey", (Object)"newValue");
            WanDUnitTest.fail((String)"Exception did not occur although was supposed to occur");
        }
        catch (Exception exception) {
            // empty catch block
        }
        WanDUnitTest.assertEquals(null, (Object)region1.getEntry((Object)"newKey"));
    }

    public static void doPutsOnClientNotExpectingException() throws Exception {
        Region region1 = cache.getRegion("/WanDUnitTest_region");
        region1.put((Object)"newKey", (Object)"newValue");
        WanDUnitTest.assertTrue((boolean)"newValue".equals(region1.getEntry((Object)"newKey").getValue()));
    }

    static {
        setWriter = false;
    }
}

