/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerTestUtil;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.ArrayList;
import java.util.Properties;

public class RegisterInterestKeysDUnitTest
extends DistributedTestCase {
    VM server1 = null;
    VM server2 = null;
    VM client1 = null;
    VM client2 = null;
    private static int PORT1;
    private static int PORT2;
    private static final String REGION_NAME = "RegisterInterestKeysDUnitTest_region";
    private static Cache cache;
    static RegisterInterestKeysDUnitTest impl;

    public RegisterInterestKeysDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        RegisterInterestKeysDUnitTest.disconnectAllFromDS();
        RegisterInterestKeysDUnitTest.pause(5000);
        Host host = Host.getHost(0);
        this.server1 = host.getVM(0);
        this.server2 = host.getVM(1);
        this.client1 = host.getVM(2);
        this.client2 = host.getVM(3);
        RegisterInterestKeysDUnitTest.createImpl();
        for (int i = 0; i < 4; ++i) {
            host.getVM(i).invoke(this.getClass(), "createImpl", null);
        }
        RegisterInterestKeysDUnitTest.getLogWriter().info("implementation class is " + impl.getClass());
        PORT1 = (Integer)this.server1.invoke(impl.getClass(), "createServerCache");
        PORT2 = (Integer)this.server2.invoke(impl.getClass(), "createServerCache");
        this.client1.invoke(impl.getClass(), "createClientCache", new Object[]{RegisterInterestKeysDUnitTest.getServerHostName(this.server1.getHost()), new Integer(PORT1), new Integer(PORT2)});
        this.client2.invoke(impl.getClass(), "createClientCache", new Object[]{RegisterInterestKeysDUnitTest.getServerHostName(this.server1.getHost()), new Integer(PORT1), new Integer(PORT2)});
    }

    public static void createImpl() {
        impl = new RegisterInterestKeysDUnitTest("temp");
    }

    private void createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        RegisterInterestKeysDUnitTest.assertNotNull((Object)cache);
    }

    public void testRegisterCreatesInvalidEntry() {
        this.client1.invoke(impl.getClass(), "createEntriesK1");
        this.client2.invoke(impl.getClass(), "registerKeysK1");
    }

    public static void createEntriesK1() {
        try {
            Region r1 = cache.getRegion("/RegisterInterestKeysDUnitTest_region");
            RegisterInterestKeysDUnitTest.assertNotNull((Object)r1);
            r1.create((Object)"key1", (Object)"key-1");
            RegisterInterestKeysDUnitTest.assertEquals((Object)r1.getEntry((Object)"key1").getValue(), (Object)"key-1");
        }
        catch (Exception ex) {
            RegisterInterestKeysDUnitTest.fail("failed while createEntriesK1()", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createClientCache(String host, Integer port1, Integer port2) throws Exception {
        Pool p;
        PORT1 = port1;
        PORT2 = port2;
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new RegisterInterestKeysDUnitTest("temp").createCache(props);
        CacheServerTestUtil.disableShufflingOfEndpoints();
        try {
            p = PoolManager.createFactory().addServer(host, PORT1).addServer(host, PORT2).setSubscriptionEnabled(true).setSubscriptionRedundancy(-1).setReadTimeout(2000).setSocketBufferSize(1000).setMinConnections(4).create("RegisterInterestKeysDUnitTestPool");
        }
        finally {
            CacheServerTestUtil.enableShufflingOfEndpoints();
        }
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setPoolName(p.getName());
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
    }

    public static Integer createServerCache() throws Exception {
        new RegisterInterestKeysDUnitTest("temp").createCache(new Properties());
        RegionAttributes attrs = impl.createServerCacheAttributes();
        cache.createRegion(REGION_NAME, attrs);
        BridgeServer server = cache.addBridgeServer();
        RegisterInterestKeysDUnitTest.assertNotNull((Object)server);
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server.setPort(port);
        server.setNotifyBySubscription(true);
        server.start();
        return new Integer(server.getPort());
    }

    protected RegionAttributes createServerCacheAttributes() {
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        return factory.create();
    }

    public static void registerKeysK1() {
        try {
            Region r = cache.getRegion("/RegisterInterestKeysDUnitTest_region");
            RegisterInterestKeysDUnitTest.assertNotNull((Object)r);
            RegisterInterestKeysDUnitTest.assertEquals((boolean)false, (boolean)r.containsKey((Object)"key1"));
            ArrayList<String> list = new ArrayList<String>();
            list.add("key1");
            r.registerInterest(list, InterestResultPolicy.KEYS);
            RegisterInterestKeysDUnitTest.assertEquals((boolean)true, (boolean)r.containsKey((Object)"key1"));
            RegisterInterestKeysDUnitTest.assertEquals((boolean)false, (boolean)r.containsValueForKey((Object)"key1"));
            Region.Entry re = r.getEntry((Object)"key1");
            RegisterInterestKeysDUnitTest.assertNotNull((Object)re);
            RegisterInterestKeysDUnitTest.assertNull((Object)re.getValue());
        }
        catch (Exception ex) {
            RegisterInterestKeysDUnitTest.fail("failed while registering interest", ex);
        }
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    @Override
    public void tearDown2() throws Exception {
        this.client1.invoke(impl.getClass(), "closeCache");
        this.client2.invoke(impl.getClass(), "closeCache");
        this.server1.invoke(impl.getClass(), "closeCache");
        this.server2.invoke(impl.getClass(), "closeCache");
    }

    static {
        cache = null;
    }
}

