/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.MirrorType;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.BridgeObserver;
import com.gemstone.gemfire.internal.cache.BridgeObserverAdapter;
import com.gemstone.gemfire.internal.cache.BridgeObserverHolder;
import com.gemstone.gemfire.internal.cache.BridgeServerImpl;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientNotifier;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientProxy;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerTestUtil;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class RedundancyLevelTestBase
extends DistributedTestCase {
    static Cache cache = null;
    VM server0 = null;
    VM server1 = null;
    VM server2 = null;
    VM server3 = null;
    static int PORT1;
    static int PORT2;
    static int PORT3;
    static int PORT4;
    static String SERVER1;
    static String SERVER2;
    static String SERVER3;
    static String SERVER4;
    static final String k1 = "k1";
    static final String k2 = "k2";
    static final String REGION_NAME = "RedundancyLevelTestBase_region";
    static PoolImpl pool;
    static BridgeObserver oldBo;
    static boolean FailOverDetectionByCCU;
    protected static volatile boolean registerInterestCalled;
    protected static volatile boolean makePrimaryCalled;

    public RedundancyLevelTestBase(String name) {
        super(name);
    }

    public static void caseSetUp() throws Exception {
        DistributedTestCase.disconnectAllFromDS();
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        this.server0 = host.getVM(0);
        this.server1 = host.getVM(1);
        this.server2 = host.getVM(2);
        this.server3 = host.getVM(3);
        PORT1 = (Integer)this.server0.invoke(RedundancyLevelTestBase.class, "createServerCache");
        PORT2 = (Integer)this.server1.invoke(RedundancyLevelTestBase.class, "createServerCache");
        PORT3 = (Integer)this.server2.invoke(RedundancyLevelTestBase.class, "createServerCache");
        PORT4 = (Integer)this.server3.invoke(RedundancyLevelTestBase.class, "createServerCache");
        String hostName = RedundancyLevelTestBase.getServerHostName(Host.getHost(0));
        SERVER1 = hostName + PORT1;
        SERVER2 = hostName + PORT2;
        SERVER3 = hostName + PORT3;
        SERVER4 = hostName + PORT4;
        CacheServerTestUtil.disableShufflingOfEndpoints();
    }

    public static void doPuts() {
        RedundancyLevelTestBase.putEntriesK1andK2();
        RedundancyLevelTestBase.putEntriesK1andK2();
        RedundancyLevelTestBase.putEntriesK1andK2();
        RedundancyLevelTestBase.putEntriesK1andK2();
    }

    public static void putEntriesK1andK2() {
        try {
            Region r1 = cache.getRegion("/RedundancyLevelTestBase_region");
            RedundancyLevelTestBase.assertNotNull((Object)r1);
            r1.put((Object)k1, (Object)k1);
            r1.put((Object)k2, (Object)k2);
            RedundancyLevelTestBase.assertEquals((Object)r1.getEntry((Object)k1).getValue(), (Object)k1);
            RedundancyLevelTestBase.assertEquals((Object)r1.getEntry((Object)k2).getValue(), (Object)k2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void verifyDispatcherIsAlive() {
        try {
            DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
                String excuse;

                @Override
                public boolean done() {
                    return cache.getBridgeServers().size() == 1;
                }

                @Override
                public String description() {
                    return this.excuse;
                }
            };
            DistributedTestCase.waitForCriterion(wc, 180000L, 1000L, true);
            BridgeServerImpl bs = (BridgeServerImpl)cache.getBridgeServers().iterator().next();
            RedundancyLevelTestBase.assertNotNull((Object)bs);
            RedundancyLevelTestBase.assertNotNull((Object)bs.getAcceptor());
            RedundancyLevelTestBase.assertNotNull((Object)bs.getAcceptor().getCacheClientNotifier());
            final CacheClientNotifier ccn = bs.getAcceptor().getCacheClientNotifier();
            wc = new DistributedTestCase.WaitCriterion(){
                String excuse;

                @Override
                public boolean done() {
                    return ccn.getClientProxies().size() > 0;
                }

                @Override
                public String description() {
                    return this.excuse;
                }
            };
            DistributedTestCase.waitForCriterion(wc, 60000L, 1000L, true);
            Iterator iter_prox = ccn.getClientProxies().iterator();
            if (iter_prox.hasNext()) {
                final CacheClientProxy proxy = (CacheClientProxy)iter_prox.next();
                wc = new DistributedTestCase.WaitCriterion(){
                    String excuse;

                    @Override
                    public boolean done() {
                        if (proxy._messageDispatcher == null) {
                            return false;
                        }
                        return proxy._messageDispatcher.isAlive();
                    }

                    @Override
                    public String description() {
                        return this.excuse;
                    }
                };
                DistributedTestCase.waitForCriterion(wc, 60000L, 1000L, true);
            }
        }
        catch (Exception ex) {
            RedundancyLevelTestBase.fail("while setting verifyDispatcherIsAlive  ", ex);
        }
    }

    public static void verifyDispatcherIsNotAlive() {
        try {
            DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
                String excuse;

                @Override
                public boolean done() {
                    return cache.getBridgeServers().size() == 1;
                }

                @Override
                public String description() {
                    return this.excuse;
                }
            };
            DistributedTestCase.waitForCriterion(wc, 180000L, 1000L, true);
            BridgeServerImpl bs = (BridgeServerImpl)cache.getBridgeServers().iterator().next();
            RedundancyLevelTestBase.assertNotNull((Object)bs);
            RedundancyLevelTestBase.assertNotNull((Object)bs.getAcceptor());
            RedundancyLevelTestBase.assertNotNull((Object)bs.getAcceptor().getCacheClientNotifier());
            final CacheClientNotifier ccn = bs.getAcceptor().getCacheClientNotifier();
            wc = new DistributedTestCase.WaitCriterion(){
                String excuse;

                @Override
                public boolean done() {
                    return ccn.getClientProxies().size() > 0;
                }

                @Override
                public String description() {
                    return this.excuse;
                }
            };
            DistributedTestCase.waitForCriterion(wc, 180000L, 1000L, true);
            Iterator iter_prox = ccn.getClientProxies().iterator();
            if (iter_prox.hasNext()) {
                CacheClientProxy proxy = (CacheClientProxy)iter_prox.next();
                RedundancyLevelTestBase.assertFalse((String)"Dispatcher on secondary should not be alive", (boolean)proxy._messageDispatcher.isAlive());
            }
        }
        catch (Exception ex) {
            RedundancyLevelTestBase.fail("while setting verifyDispatcherIsNotAlive  ", ex);
        }
    }

    public static void verifyRedundantServersContain(final String server) {
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return pool.getRedundantNames().contains(server);
            }

            @Override
            public String description() {
                return "Redundant servers (" + pool.getRedundantNames() + ") does not contain " + server;
            }
        };
        DistributedTestCase.waitForCriterion(wc, 60000L, 2000L, true);
    }

    public static void verifyLiveAndRedundantServers(final int liveServers, final int redundantServers) {
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return pool.getConnectedServerCount() == liveServers && pool.getRedundantNames().size() == redundantServers;
            }

            @Override
            public String description() {
                return "Expected connected server count (" + pool.getConnectedServerCount() + ") to become " + liveServers + "and redundant count (" + pool.getRedundantNames().size() + ") to become " + redundantServers;
            }
        };
        DistributedTestCase.waitForCriterion(wc, 120000L, 2000L, true);
    }

    public static void verifyDeadServers(int deadServers) {
    }

    public static void createEntriesK1andK2() {
        try {
            Region r1 = cache.getRegion("/RedundancyLevelTestBase_region");
            RedundancyLevelTestBase.assertNotNull((Object)r1);
            if (!r1.containsKey((Object)k1)) {
                r1.create((Object)k1, (Object)k1);
            }
            if (!r1.containsKey((Object)k2)) {
                r1.create((Object)k2, (Object)k2);
            }
            RedundancyLevelTestBase.assertEquals((Object)r1.getEntry((Object)k1).getValue(), (Object)k1);
            RedundancyLevelTestBase.assertEquals((Object)r1.getEntry((Object)k2).getValue(), (Object)k2);
        }
        catch (Exception ex) {
            RedundancyLevelTestBase.fail("failed while createEntries()", ex);
        }
    }

    public static void registerK1AndK2() {
        try {
            Region r = cache.getRegion("/RedundancyLevelTestBase_region");
            RedundancyLevelTestBase.assertNotNull((Object)r);
            ArrayList<String> list = new ArrayList<String>();
            list.add(k1);
            list.add(k2);
            r.registerInterest(list, InterestResultPolicy.KEYS_VALUES);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            RedundancyLevelTestBase.fail("failed while region.registerK1AndK2()", ex);
        }
    }

    public static void unregisterInterest() {
        try {
            Region r = cache.getRegion("/RedundancyLevelTestBase_region");
            r.unregisterInterest((Object)k1);
        }
        catch (Exception e) {
            RedundancyLevelTestBase.fail("test failed due to ", e);
        }
    }

    public static void verifyNoCCP() {
        RedundancyLevelTestBase.assertEquals((String)"More than one BridgeServer", (int)1, (int)cache.getBridgeServers().size());
        BridgeServerImpl bs = (BridgeServerImpl)cache.getBridgeServers().iterator().next();
        RedundancyLevelTestBase.assertNotNull((Object)bs);
        RedundancyLevelTestBase.assertNotNull((Object)bs.getAcceptor());
        RedundancyLevelTestBase.assertNotNull((Object)bs.getAcceptor().getCacheClientNotifier());
        RedundancyLevelTestBase.assertTrue((0 == bs.getAcceptor().getCacheClientNotifier().getClientProxies().size() ? 1 : 0) != 0);
    }

    public static void verifyCCP() {
        try {
            DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
                String excuse;

                @Override
                public boolean done() {
                    return cache.getBridgeServers().size() == 1;
                }

                @Override
                public String description() {
                    return this.excuse;
                }
            };
            DistributedTestCase.waitForCriterion(wc, 180000L, 1000L, true);
            BridgeServerImpl bs = (BridgeServerImpl)cache.getBridgeServers().iterator().next();
            RedundancyLevelTestBase.assertNotNull((Object)bs);
            RedundancyLevelTestBase.assertNotNull((Object)bs.getAcceptor());
            RedundancyLevelTestBase.assertNotNull((Object)bs.getAcceptor().getCacheClientNotifier());
            final CacheClientNotifier ccn = bs.getAcceptor().getCacheClientNotifier();
            wc = new DistributedTestCase.WaitCriterion(){
                String excuse;

                @Override
                public boolean done() {
                    return ccn.getClientProxies().size() == 1;
                }

                @Override
                public String description() {
                    return this.excuse;
                }
            };
            DistributedTestCase.waitForCriterion(wc, 180000L, 1000L, true);
        }
        catch (Exception ex) {
            RedundancyLevelTestBase.fail("exception in verifyCCP()", ex);
        }
    }

    public static void verifyInterestRegistration() {
        try {
            DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    return cache.getBridgeServers().size() == 1;
                }

                @Override
                public String description() {
                    return "Number of bridge servers (" + cache.getBridgeServers().size() + ") never became 1";
                }
            };
            DistributedTestCase.waitForCriterion(wc, 180000L, 2000L, true);
            BridgeServerImpl bs = (BridgeServerImpl)cache.getBridgeServers().iterator().next();
            RedundancyLevelTestBase.assertNotNull((Object)bs);
            RedundancyLevelTestBase.assertNotNull((Object)bs.getAcceptor());
            RedundancyLevelTestBase.assertNotNull((Object)bs.getAcceptor().getCacheClientNotifier());
            final CacheClientNotifier ccn = bs.getAcceptor().getCacheClientNotifier();
            wc = new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    return ccn.getClientProxies().size() > 0;
                }

                @Override
                public String description() {
                    return "Notifier's proxies is empty";
                }
            };
            DistributedTestCase.waitForCriterion(wc, 180000L, 2000L, true);
            Iterator iter_prox = ccn.getClientProxies().iterator();
            if (iter_prox.hasNext()) {
                final CacheClientProxy ccp = (CacheClientProxy)iter_prox.next();
                wc = new DistributedTestCase.WaitCriterion(){
                    String excuse;

                    @Override
                    public boolean done() {
                        Set keysMap = ccp.cils[0].getProfile("/RedundancyLevelTestBase_region").getKeysOfInterestFor((Object)ccp.getProxyID());
                        if (keysMap == null) {
                            this.excuse = "keys of interest is null";
                            return false;
                        }
                        if (keysMap.size() != 2) {
                            this.excuse = "keys of interest size (" + keysMap.size() + ") not 2";
                            return false;
                        }
                        return true;
                    }

                    @Override
                    public String description() {
                        return this.excuse;
                    }
                };
                DistributedTestCase.waitForCriterion(wc, 180000L, 2000L, true);
                Set keysMap = ccp.cils[0].getProfile("/RedundancyLevelTestBase_region").getKeysOfInterestFor((Object)ccp.getProxyID());
                RedundancyLevelTestBase.assertTrue((boolean)keysMap.contains(k1));
                RedundancyLevelTestBase.assertTrue((boolean)keysMap.contains(k2));
            } else {
                RedundancyLevelTestBase.fail((String)"A CCP was expected . Wasn't it?");
            }
        }
        catch (Exception ex) {
            RedundancyLevelTestBase.fail((String)("while setting verifyInterestRegistration  " + ex));
        }
    }

    public static void stopServer() {
        try {
            Iterator iter = cache.getBridgeServers().iterator();
            if (iter.hasNext()) {
                BridgeServer server = (BridgeServer)iter.next();
                server.stop();
            }
        }
        catch (Exception e) {
            RedundancyLevelTestBase.fail("failed while stopServer()", e);
        }
    }

    public static void startServer() {
        try {
            Cache c = CacheFactory.getAnyInstance();
            BridgeServerImpl bs = (BridgeServerImpl)c.getBridgeServers().iterator().next();
            RedundancyLevelTestBase.assertNotNull((Object)bs);
            bs.start();
        }
        catch (Exception ex) {
            RedundancyLevelTestBase.fail("while startServer()  ", ex);
        }
    }

    private void createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        RedundancyLevelTestBase.assertNotNull((Object)ds);
        ds.disconnect();
        ds = this.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        RedundancyLevelTestBase.assertNotNull((Object)cache);
    }

    public static void createClientCache(String host, int port1, int port2, int port3, int port4, int redundancy) throws Exception {
        RedundancyLevelTestBase.createClientCache(host, port1, port2, port3, port4, redundancy, 3000, 10);
    }

    public static void createClientCache(String host, int port1, int port2, int port3, int port4, int redundancy, int socketReadTimeout, int retryInterval) throws Exception {
        if (!FailOverDetectionByCCU) {
            oldBo = BridgeObserverHolder.setInstance((BridgeObserver)new BridgeObserverAdapter(){

                public void beforeFailoverByCacheClientUpdater(ServerLocation epFailed) {
                    try {
                        Thread.sleep(300000L);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                }
            });
        }
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new RedundancyLevelTestBase("temp").createCache(props);
        PoolImpl p = (PoolImpl)PoolManager.createFactory().addServer(host, PORT1).addServer(host, PORT2).addServer(host, PORT3).addServer(host, PORT4).setSubscriptionEnabled(true).setReadTimeout(socketReadTimeout).setSocketBufferSize(32768).setMinConnections(8).setSubscriptionRedundancy(redundancy).setRetryAttempts(5).setPingInterval((long)retryInterval).create("DurableClientReconnectDUnitTestPool");
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setPoolName(p.getName());
        RegionAttributes attrs = factory.createRegionAttributes();
        cache.createRegion(REGION_NAME, attrs);
        pool = p;
        RedundancyLevelTestBase.createEntriesK1andK2();
        RedundancyLevelTestBase.registerK1AndK2();
    }

    public static Integer createServerCache() throws Exception {
        new RedundancyLevelTestBase("temp").createCache(new Properties());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setEnableConflation(true);
        factory.setMirrorType(MirrorType.KEYS_VALUES);
        RegionAttributes attrs = factory.createRegionAttributes();
        cache.createVMRegion(REGION_NAME, attrs);
        BridgeServer server1 = cache.addBridgeServer();
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server1.setMaximumTimeBetweenPings(180000);
        server1.setPort(port);
        server1.setNotifyBySubscription(true);
        server1.start();
        return new Integer(server1.getPort());
    }

    public static void verifyOrderOfEndpoints() {
    }

    @Override
    public void tearDown2() throws Exception {
        try {
            super.tearDown2();
            if (!FailOverDetectionByCCU) {
                BridgeObserverHolder.setInstance((BridgeObserver)oldBo);
            }
            FailOverDetectionByCCU = false;
            RedundancyLevelTestBase.closeCache();
            this.server0.invoke(RedundancyLevelTestBase.class, "closeCache");
            this.server1.invoke(RedundancyLevelTestBase.class, "closeCache");
            this.server2.invoke(RedundancyLevelTestBase.class, "closeCache");
            this.server3.invoke(RedundancyLevelTestBase.class, "closeCache");
        }
        finally {
            CacheServerTestUtil.enableShufflingOfEndpoints();
        }
        CacheServerTestUtil.resetDisableShufflingOfEndpointsFlag();
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    static {
        pool = null;
        oldBo = null;
        FailOverDetectionByCCU = false;
        registerInterestCalled = false;
        makePrimaryCalled = false;
    }
}

